/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StereographicFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.SCALE_FACTOR, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new Stereographic(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("epsg", "9809"));
        result.add(new Code("mapinfo", "projection20"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class Stereographic
    extends Projection
    implements Serializable {
        private double m_e;
        private double m_lambda0;
        private double m_two_a_k0_m1;
        private double m_chi1;
        private double m_sinchi1;
        private double m_coschi1;
        private double m_rho_over_t;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;
        private double m_Dprime;
        private boolean m_bPolar;
        private boolean m_bSouthPolar;

        public Stereographic(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Stereographic", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            this.m_e = projectionParams.getEllipsoid().getEccentricity();
            double phi1 = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            double cosphi1 = Math.cos(phi1);
            this.m_bSouthPolar = false;
            this.m_bPolar = false;
            if (cosphi1 == 0.0 || Math.abs(projectionParams.getOriginLatitude().getValue(AngularUnit.DEGREE)) == 90.0) {
                cosphi1 = 0.0;
                this.m_bPolar = true;
                if (projectionParams.getOriginLatitude().getValue(AngularUnit.DEGREE) < 0.0) {
                    this.m_bSouthPolar = true;
                    this.m_lambda0 = -this.m_lambda0;
                    phi1 = -phi1;
                }
            }
            double esinphi1 = this.m_e * Math.sin(phi1);
            double k0 = projectionParams.getScaleFactor();
            if (k0 == 0.0) {
                k0 = 1.0;
            }
            double m1 = cosphi1 / Math.sqrt(1.0 - esinphi1 * esinphi1);
            this.m_two_a_k0_m1 = 2.0 * projectionParams.getEllipsoid().getSemiMajorAxis() * k0 * m1;
            double temp = Math.tan(0.7853981633974483 + phi1 / 2.0) * Math.pow((1.0 - esinphi1) / (1.0 + esinphi1), this.m_e / 2.0);
            this.m_chi1 = 2.0 * Math.atan(temp) - 1.5707963267948966;
            this.m_sinchi1 = Math.sin(this.m_chi1);
            this.m_coschi1 = Math.cos(this.m_chi1);
            temp = Math.sqrt(Math.pow(1.0 + this.m_e, 1.0 + this.m_e) * Math.pow(1.0 - this.m_e, 1.0 - this.m_e));
            this.m_rho_over_t = 2.0 * projectionParams.getEllipsoid().getSemiMajorAxis() * k0 / temp;
            double e4 = projectionParams.getEllipsoid().getEccentricitySquared() * projectionParams.getEllipsoid().getEccentricitySquared();
            double e6 = projectionParams.getEllipsoid().getEccentricitySquared() * e4;
            double e8 = e4 * e4;
            double A = projectionParams.getEllipsoid().getEccentricitySquared() / 2.0 + 5.0 * e4 / 24.0 + e6 / 12.0 + 13.0 * e8 / 360.0;
            double B = 7.0 * e4 / 48.0 + 29.0 * e6 / 240.0 + 811.0 * e8 / 11520.0;
            double C = 7.0 * e6 / 120.0 + 81.0 * e8 / 1120.0;
            double D = 4279.0 * e8 / 161280.0;
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B - 4.0 * D;
            this.m_Cprime = 4.0 * C;
            this.m_Dprime = 8.0 * D;
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double lambda = x;
            double phi = y;
            if (this.m_bSouthPolar) {
                lambda = -lambda;
                phi = -phi;
            }
            double sinphi = Math.sin(phi);
            double esinphi = this.m_e * sinphi;
            double dlambda = lambda - this.m_lambda0;
            double sindlambda = Math.sin(dlambda);
            double cosdlambda = Math.cos(dlambda);
            if (this.m_bPolar) {
                double temp = Math.pow((1.0 - esinphi) / (1.0 + esinphi), this.m_e / 2.0);
                double t = Math.tan(0.7853981633974483 - phi / 2.0) / temp;
                double rho = this.m_rho_over_t * t;
                x = rho * sindlambda;
                y = -rho * cosdlambda;
                if (this.m_bSouthPolar) {
                    x = -x;
                    y = -y;
                }
            } else {
                double coschi;
                double temp = Math.tan(0.7853981633974483 + phi / 2.0) * Math.pow((1.0 - esinphi) / (1.0 + esinphi), this.m_e / 2.0);
                double chi = 2.0 * Math.atan(temp) - 1.5707963267948966;
                double sinchi = Math.sin(chi);
                double A = (temp = this.m_coschi1 * (1.0 + this.m_sinchi1 * sinchi + this.m_coschi1 * (coschi = Math.cos(chi)) * cosdlambda)) != 0.0 ? this.m_two_a_k0_m1 / temp : 1.0E9;
                x = A * coschi * sindlambda;
                y = A * (this.m_coschi1 * sinchi - this.m_sinchi1 * coschi * cosdlambda);
            }
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            double chi;
            double rho;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = LinearUnit.convert((double)(source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)(source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            if (this.m_bSouthPolar) {
                x = -x;
                y = -y;
            }
            if ((rho = Math.sqrt(x * x + y * y)) == 0.0) {
                chi = this.m_chi1;
                x = this.m_lambda0;
            } else if (this.m_bPolar) {
                double t = rho / this.m_rho_over_t;
                chi = 1.5707963267948966 - 2.0 * Math.atan(t);
                x = this.m_lambda0 + Math.atan2(x, -y);
            } else {
                double ce = 2.0 * Math.atan2(rho * this.m_coschi1, this.m_two_a_k0_m1);
                double since = Math.sin(ce);
                double cosce = Math.cos(ce);
                double temp = cosce * this.m_sinchi1 + y * since * this.m_coschi1 / rho;
                chi = Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0));
                temp = x * since;
                double temp2 = rho * this.m_coschi1 * cosce - y * this.m_sinchi1 * since;
                x = temp == 0.0 && temp2 == 0.0 ? this.m_lambda0 : this.m_lambda0 + Math.atan2(temp, temp2);
            }
            double chi2 = 2.0 * chi;
            double coschi2 = Math.cos(chi2);
            y = chi + Math.sin(chi2) * (this.m_Aprime + coschi2 * (this.m_Bprime + coschi2 * (this.m_Cprime + coschi2 * this.m_Dprime)));
            if (this.m_bSouthPolar) {
                x = -x;
                y = -y;
            }
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

