/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.transform;

import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.GeodeticDatumOperation;
import com.mapinfo.midev.coordsys.transform.IGeographicTransform;
import com.mapinfo.midev.coordsys.transform.IGeographicTransformFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.MathUtil;

public class BursaWolfe_MolodenskyTransformFactory
implements IGeographicTransformFactory {
    @Override
    public void dispose() {
    }

    @Override
    public boolean isSuitable(GeodeticDatumOperation geodeticDatumOperation1, GeodeticDatumOperation geodeticDatumOperation2) {
        return true;
    }

    @Override
    public IGeographicTransform newInstance(GeodeticDatumOperation source, GeodeticDatumOperation destination) {
        return new BursaWolfe_MolodenskyTransform(source, destination);
    }

    private static class BursaWolfe_MolodenskyTransform
    implements IGeographicTransform {
        private final GeodeticDatumOperation m_srcGCS;
        private final GeodeticDatumOperation m_destGCS;
        private final double m_srcPrimeMeridian;
        private final double m_destPrimeMeridian;
        private final double m_a;
        private final double m_e2;
        private final double m_da;
        private final double m_df;
        private final double m_u;
        private final double m_v;
        private final double m_w;
        private final double m_m;
        private final boolean m_bThreeParms;
        private final double m_a_dest;
        private final double m_e2_dest;
        private final double m_f;
        private final double m_dx;
        private final double m_dy;
        private final double m_dz;
        private final double m_rx;
        private final double m_ry;
        private final double m_rz;

        private BursaWolfe_MolodenskyTransform(GeodeticDatumOperation srcDatum, GeodeticDatumOperation destDatum) {
            this.m_srcGCS = srcDatum;
            this.m_destGCS = destDatum;
            this.m_srcPrimeMeridian = AngularUnit.convert((double)srcDatum.getGeodeticDatum().getPrimeMeridian().getLongitude(), (AngularUnit)srcDatum.getGeodeticDatum().getPrimeMeridian().getAngularUnit(), (AngularUnit)AngularUnit.DEGREE);
            this.m_destPrimeMeridian = AngularUnit.convert((double)destDatum.getGeodeticDatum().getPrimeMeridian().getLongitude(), (AngularUnit)destDatum.getGeodeticDatum().getPrimeMeridian().getAngularUnit(), (AngularUnit)AngularUnit.DEGREE);
            Ellipsoid srcEllipsoid = srcDatum.getGeodeticDatum().getEllipsoid();
            Ellipsoid destEllipsoid = destDatum.getGeodeticDatum().getEllipsoid();
            this.m_a = LinearUnit.convert((double)srcEllipsoid.getSemiMajorAxis(), (LinearUnit)srcEllipsoid.getAxisUnit(), (LinearUnit)LinearUnit.METER);
            this.m_e2 = srcEllipsoid.getEccentricitySquared();
            this.m_da = LinearUnit.convert((double)destEllipsoid.getSemiMajorAxis(), (LinearUnit)destEllipsoid.getAxisUnit(), (LinearUnit)LinearUnit.METER) - this.m_a;
            this.m_df = destEllipsoid.getFlattening() - srcEllipsoid.getFlattening();
            this.m_u = srcDatum.getShiftX() - destDatum.getShiftX();
            this.m_v = srcDatum.getShiftY() - destDatum.getShiftY();
            this.m_w = srcDatum.getShiftZ() - destDatum.getShiftZ();
            this.m_m = (srcDatum.getScaleAdjust() - destDatum.getScaleAdjust()) * 1.0E-6;
            this.m_a_dest = LinearUnit.convert((double)destEllipsoid.getSemiMajorAxis(), (LinearUnit)destEllipsoid.getAxisUnit(), (LinearUnit)LinearUnit.METER);
            this.m_e2_dest = destEllipsoid.getEccentricitySquared();
            this.m_f = srcEllipsoid.getFlattening();
            this.m_dx = srcDatum.getShiftX() - destDatum.getShiftX();
            this.m_dy = srcDatum.getShiftY() - destDatum.getShiftY();
            this.m_dz = srcDatum.getShiftZ() - destDatum.getShiftZ();
            this.m_rx = AngularUnit.convert((double)(srcDatum.getRotateX() - destDatum.getRotateX()), (AngularUnit)AngularUnit.SECOND, (AngularUnit)AngularUnit.RADIAN);
            this.m_ry = AngularUnit.convert((double)(srcDatum.getRotateY() - destDatum.getRotateY()), (AngularUnit)AngularUnit.SECOND, (AngularUnit)AngularUnit.RADIAN);
            this.m_rz = AngularUnit.convert((double)(srcDatum.getRotateZ() - destDatum.getRotateZ()), (AngularUnit)AngularUnit.SECOND, (AngularUnit)AngularUnit.RADIAN);
            this.m_bThreeParms = this.m_rx == 0.0 && this.m_ry == 0.0 && this.m_rz == 0.0 && this.m_m == 0.0;
        }

        @Override
        public GeodeticDatumOperation getSource() {
            return this.m_srcGCS;
        }

        @Override
        public GeodeticDatumOperation getDestination() {
            return this.m_destGCS;
        }

        @Override
        public boolean transform(DirectPosition source, DirectPosition destination) {
            double x = source.getX();
            double y = source.getY();
            double lambda = Math.toRadians(x + this.m_srcPrimeMeridian);
            double phi = Math.toRadians(MathUtil.clip((double)y, (double)-89.9, (double)89.9));
            double sinPhi = Math.sin(phi);
            double cosPhi = Math.cos(phi);
            double sinLambda = Math.sin(lambda);
            double cosLambda = Math.cos(lambda);
            if (this.m_bThreeParms) {
                if (x <= -360.0 || x >= 360.0 || y <= -90.0 || y >= 90.0) {
                    x = MathUtil.clip((double)x, (double)-360.0, (double)360.0);
                    y = MathUtil.clip((double)y, (double)-90.0, (double)90.0);
                } else {
                    double b = this.m_a * (1.0 - this.m_f);
                    double temp = Math.sqrt(1.0 - this.m_e2 * sinPhi * sinPhi);
                    double Rn = this.m_a / temp;
                    double Rm = this.m_a * (1.0 - this.m_e2) / (temp * temp * temp);
                    double dB = (-(this.m_u * sinPhi * cosLambda) - this.m_v * sinPhi * sinLambda + this.m_w * cosPhi + this.m_da * (Rn * this.m_e2 * sinPhi * cosPhi) / this.m_a + this.m_df * (Rm * this.m_a / b + Rn * b / this.m_a) * sinPhi * cosPhi) / Rm;
                    double dL = (-this.m_u * sinLambda + this.m_v * cosLambda) / (Rn * cosPhi);
                    x = Math.toDegrees(lambda + dL);
                    y = Math.toDegrees(phi + dB);
                    x = MathUtil.clip((double)x, (double)-360.0, (double)360.0);
                    y = MathUtil.clip((double)y, (double)-90.0, (double)90.0);
                    x -= this.m_destPrimeMeridian;
                }
            } else {
                boolean bAdd360 = false;
                boolean bSubtract360 = false;
                if (x <= -360.0 || x >= 360.0 || y <= -90.0 || y >= 90.0) {
                    x = MathUtil.clip((double)x, (double)-360.0, (double)360.0);
                    y = MathUtil.clip((double)y, (double)-90.0, (double)90.0);
                } else if (x >= 179.0) {
                    bAdd360 = true;
                } else if (x <= -179.0) {
                    bSubtract360 = true;
                }
                double nu = this.m_a / Math.sqrt(1.0 - this.m_e2 * sinPhi * sinPhi);
                double h = 0.0;
                x = (nu + h) * cosPhi * cosLambda;
                y = (nu + h) * cosPhi * sinLambda;
                double z = ((1.0 - this.m_e2) * nu + h) * sinPhi;
                double x1 = x + this.m_dx + this.m_m * x + this.m_rz * y - this.m_ry * z;
                double y1 = y + this.m_dy + this.m_m * y - this.m_rz * x + this.m_rx * z;
                double z1 = z + this.m_dz + this.m_m * z + this.m_ry * x - this.m_rx * y;
                double phiDest = phi;
                for (int i = 0; i < 10; ++i) {
                    double sinPhiDest = Math.sin(phiDest);
                    double nuDest = this.m_a_dest / Math.sqrt(1.0 - this.m_e2_dest * sinPhiDest * sinPhiDest);
                    double phiTemp = Math.atan2(z1 + this.m_e2_dest * nuDest * sinPhiDest, Math.sqrt(x1 * x1 + y1 * y1));
                    if (Math.abs(phiDest - phiTemp) < 1.0E-9) {
                        phiDest = phiTemp;
                        break;
                    }
                    phiDest = phiTemp;
                }
                double lambdaDest = Math.atan2(y1, x1);
                x = Math.toDegrees(lambdaDest) - this.m_destPrimeMeridian;
                y = Math.toDegrees(phiDest);
                if (x < 0.0 && bAdd360) {
                    x += 360.0;
                }
                if (x > 0.0 && bSubtract360) {
                    x -= 360.0;
                }
                x = MathUtil.clip((double)x, (double)-360.0, (double)360.0);
                y = MathUtil.clip((double)y, (double)-90.0, (double)90.0);
            }
            destination.setXY(x, y);
            return true;
        }
    }
}

