/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.transform;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysType;
import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.EngineeringCoordSys;
import com.mapinfo.midev.coordsys.GeodeticDatumOperation;
import com.mapinfo.midev.coordsys.GeographicCoordSys;
import com.mapinfo.midev.coordsys.InvalidCoordSysTypeException;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.transform.BursaWolfe_MolodenskyTransformFactory;
import com.mapinfo.midev.coordsys.transform.IGeographicTransform;
import com.mapinfo.midev.coordsys.transform.IGeographicTransformFactory;
import com.mapinfo.midev.coordsys.transform.config.DefaultDatumTransformConfiguration;
import com.mapinfo.midev.coordsys.transform.config.IDatumTransformConfiguration;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.DoubleRect;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.util.List;

@PublicAPI
public final class CoordTransform
implements IDirectPositionMutator {
    private static final IDatumTransformConfiguration DEFAULT_DATUM_TRANSFORM_CONFIGURATION = new DefaultDatumTransformConfiguration();
    private static final double GREAT_CIRCLE_METERS_PER_RADIAN = 6370997.0;
    private static final Ellipsoid ELLIPSOID_WGS84_SPHERE = CoordSysFactory.getDefaultCoordSysFactory().getEllipsoid("mapinfo", "ellipsoid54");
    private static final GeodeticDatumOperation DATUM_OPERATION_WGS84 = CoordSysFactory.getDefaultCoordSysFactory().getGeodeticDatumOperation("mapinfo", "geodeticdatumoperation104");
    private static final IGeographicTransformFactory DEFAULT_GEOGRAPHIC_TRANSFORM_FACTORY = new BursaWolfe_MolodenskyTransformFactory();
    private final CoordSys m_srcCoordSys;
    private final CoordSys m_destCoordSys;
    private final boolean m_isAffine;
    private final boolean m_isLinear;
    private final boolean m_isIdentity;
    private final AffineTransform m_directTransform;
    private final IGeographicTransform m_datumTransform;
    private final boolean m_defaultDatumTransform;

    public CoordTransform(CoordSys srcCoordSys, CoordSys destCoordSys) {
        this(srcCoordSys, destCoordSys, DEFAULT_DATUM_TRANSFORM_CONFIGURATION.getTransforms());
    }

    @PrivateAPI
    public CoordTransform(CoordSys srcCoordSys, CoordSys destCoordSys, List<? extends IGeographicTransformFactory> datumTransformFactoryList) {
        boolean isIdentity;
        boolean isLinear;
        AffineTransform directTransform;
        boolean isAffine;
        this.m_srcCoordSys = srcCoordSys;
        this.m_destCoordSys = destCoordSys;
        boolean bDirectTransform = srcCoordSys.getType() == CoordSysType.ENGINEERING || destCoordSys.getType() == CoordSysType.ENGINEERING || srcCoordSys.equivalent(destCoordSys);
        IGeographicTransform datumTransform = null;
        boolean defaultDatumTransform = false;
        if (bDirectTransform) {
            isAffine = true;
            datumTransform = null;
            AffineTransform srcAffine = srcCoordSys.getAffineTransform();
            AffineTransform destAffine = destCoordSys.getAffineTransform();
            AffineTransform unitAffine = CoordTransform.getUnitAffine(srcCoordSys, destCoordSys);
            if (unitAffine != null) {
                destAffine = AffineTransform.getInstance((AffineTransform)unitAffine, (AffineTransform)destAffine);
            }
            if (srcAffine.equals((Object)destAffine)) {
                directTransform = AffineTransform.IDENTITY;
                isLinear = true;
                isIdentity = true;
            } else {
                directTransform = AffineTransform.getInstance((AffineTransform)srcAffine.createInverse(), (AffineTransform)destAffine);
                isLinear = directTransform.isLinear();
                isIdentity = directTransform.isIdentity();
            }
        } else {
            isAffine = false;
            isLinear = false;
            isIdentity = false;
            directTransform = null;
            GeodeticDatumOperation srcDatumOp = ((GeographicCoordSys)srcCoordSys).getGeodeticDatumOperation();
            GeodeticDatumOperation destDatumOp = ((GeographicCoordSys)destCoordSys).getGeodeticDatumOperation();
            if (CoordTransform.isDatumWGS84Sphere(srcDatumOp)) {
                srcDatumOp = DATUM_OPERATION_WGS84;
            }
            if (CoordTransform.isDatumWGS84Sphere(destDatumOp)) {
                destDatumOp = DATUM_OPERATION_WGS84;
            }
            if (!(srcDatumOp.equivalent(destDatumOp) || srcDatumOp.getCodes().contains("mapinfo", "geodeticdatumoperation0") || destDatumOp.getCodes().contains("mapinfo", "geodeticdatumoperation0"))) {
                for (int n = 0; n < datumTransformFactoryList.size() && datumTransform == null; ++n) {
                    if (!datumTransformFactoryList.get(n).isSuitable(srcDatumOp, destDatumOp)) continue;
                    datumTransform = datumTransformFactoryList.get(n).newInstance(srcDatumOp, destDatumOp);
                }
                if (datumTransform == null) {
                    datumTransform = DEFAULT_GEOGRAPHIC_TRANSFORM_FACTORY.newInstance(srcDatumOp, destDatumOp);
                    defaultDatumTransform = true;
                }
            }
        }
        this.m_isAffine = isAffine;
        this.m_isLinear = isLinear;
        this.m_isIdentity = isIdentity;
        this.m_directTransform = directTransform;
        this.m_datumTransform = datumTransform;
        this.m_defaultDatumTransform = defaultDatumTransform;
    }

    private static boolean isDatumWGS84Sphere(GeodeticDatumOperation datumOperation) {
        return datumOperation.getGeodeticDatum().getEllipsoid().equivalent(ELLIPSOID_WGS84_SPHERE) && datumOperation.getShiftX() == 0.0 && datumOperation.getShiftX() == 0.0 && datumOperation.getShiftY() == 0.0 && datumOperation.getShiftY() == 0.0 && datumOperation.getShiftZ() == 0.0 && datumOperation.getShiftZ() == 0.0;
    }

    private static AffineTransform getUnitAffine(CoordSys srcCoordSys, CoordSys destCoordSys) {
        double temp;
        CoordSysType srcType = srcCoordSys.getType();
        CoordSysType destType = destCoordSys.getType();
        block0 : switch (srcType) {
            case ENGINEERING: {
                EngineeringCoordSys src = (EngineeringCoordSys)srcCoordSys;
                switch (destType) {
                    case ENGINEERING: {
                        EngineeringCoordSys dest = (EngineeringCoordSys)destCoordSys;
                        temp = LinearUnit.convert((double)1.0, (LinearUnit)src.getLinearUnit(), (LinearUnit)dest.getLinearUnit());
                        break block0;
                    }
                    case GEOGRAPHIC: {
                        GeographicCoordSys dest = (GeographicCoordSys)destCoordSys;
                        Projection destProjection = dest.getProjection();
                        if (destProjection == null) {
                            temp = CoordTransform.linearToAngular(1.0, src.getLinearUnit(), dest.getAngularUnit());
                            break block0;
                        }
                        temp = LinearUnit.convert((double)1.0, (LinearUnit)src.getLinearUnit(), (LinearUnit)destProjection.getProjectionParams().getLinearUnit());
                        break block0;
                    }
                }
                throw new InvalidCoordSysTypeException(srcType);
            }
            case GEOGRAPHIC: {
                GeographicCoordSys src = (GeographicCoordSys)srcCoordSys;
                Projection srcProjection = src.getProjection();
                if (srcProjection == null) {
                    switch (destType) {
                        case ENGINEERING: {
                            EngineeringCoordSys dest = (EngineeringCoordSys)destCoordSys;
                            temp = CoordTransform.angularToLinear(1.0, src.getAngularUnit(), dest.getLinearUnit());
                            break block0;
                        }
                        case GEOGRAPHIC: {
                            GeographicCoordSys dest = (GeographicCoordSys)destCoordSys;
                            Projection destProjection = dest.getProjection();
                            if (destProjection == null) {
                                temp = AngularUnit.convert((double)1.0, (AngularUnit)src.getAngularUnit(), (AngularUnit)dest.getAngularUnit());
                                break block0;
                            }
                            temp = CoordTransform.angularToLinear(1.0, src.getAngularUnit(), destProjection.getProjectionParams().getLinearUnit());
                            break block0;
                        }
                    }
                    throw new InvalidCoordSysTypeException(srcType);
                }
                switch (destType) {
                    case ENGINEERING: {
                        EngineeringCoordSys dest = (EngineeringCoordSys)destCoordSys;
                        temp = LinearUnit.convert((double)1.0, (LinearUnit)src.getProjection().getProjectionParams().getLinearUnit(), (LinearUnit)dest.getLinearUnit());
                        break block0;
                    }
                    case GEOGRAPHIC: {
                        GeographicCoordSys dest = (GeographicCoordSys)destCoordSys;
                        Projection destProjection = dest.getProjection();
                        if (destProjection == null) {
                            temp = CoordTransform.linearToAngular(1.0, src.getProjection().getProjectionParams().getLinearUnit(), dest.getAngularUnit());
                            break block0;
                        }
                        temp = LinearUnit.convert((double)1.0, (LinearUnit)srcProjection.getProjectionParams().getLinearUnit(), (LinearUnit)destProjection.getProjectionParams().getLinearUnit());
                        break block0;
                    }
                }
                throw new InvalidCoordSysTypeException(srcType);
            }
            default: {
                throw new InvalidCoordSysTypeException(srcType);
            }
        }
        return AffineTransform.getRowFirstInstance((double)temp, (double)0.0, (double)temp, (double)0.0);
    }

    public boolean isAffine() {
        return this.m_isAffine;
    }

    public boolean isLinear() {
        return this.m_isLinear;
    }

    public boolean isIdentity() {
        return this.m_isIdentity;
    }

    public DirectPosition transform(DirectPosition source, DirectPosition destination) {
        if (source != destination) {
            destination.set(source);
        }
        if (this.m_directTransform != null) {
            this.m_directTransform.transform(destination, destination);
        } else {
            this.m_srcCoordSys.getAffineTransform().createInverse().transform(destination, destination);
            Projection projection = null;
            if (CoordSysType.GEOGRAPHIC.equals((Object)this.m_srcCoordSys.getType())) {
                projection = ((GeographicCoordSys)this.m_srcCoordSys).getProjection();
            }
            if (projection != null) {
                projection.toLongLat(destination, destination);
            }
            if (this.m_datumTransform != null) {
                AngularUnit fromUnit = ((GeographicCoordSys)this.m_srcCoordSys).getAngularUnit();
                if (fromUnit != AngularUnit.DEGREE) {
                    destination.setXY(AngularUnit.convert((double)destination.getX(), (AngularUnit)fromUnit, (AngularUnit)AngularUnit.DEGREE), AngularUnit.convert((double)destination.getY(), (AngularUnit)fromUnit, (AngularUnit)AngularUnit.DEGREE));
                }
                if (this.m_defaultDatumTransform) {
                    this.m_datumTransform.transform(destination, destination);
                } else {
                    boolean success;
                    DirectPosition sourceCopy = new DirectPosition(destination);
                    DirectPosition newDestination = new DirectPosition(destination);
                    try {
                        success = this.m_datumTransform.transform(sourceCopy, newDestination);
                    }
                    catch (Exception e) {
                        success = false;
                    }
                    if (success) {
                        destination.set(newDestination);
                    } else {
                        DEFAULT_GEOGRAPHIC_TRANSFORM_FACTORY.newInstance(((GeographicCoordSys)this.m_srcCoordSys).getGeodeticDatumOperation(), ((GeographicCoordSys)this.m_destCoordSys).getGeodeticDatumOperation()).transform(destination, destination);
                    }
                }
                AngularUnit toUnit = ((GeographicCoordSys)this.m_destCoordSys).getAngularUnit();
                if (toUnit != AngularUnit.DEGREE) {
                    destination.setXY(AngularUnit.convert((double)destination.getX(), (AngularUnit)AngularUnit.DEGREE, (AngularUnit)toUnit), AngularUnit.convert((double)destination.getY(), (AngularUnit)AngularUnit.DEGREE, (AngularUnit)toUnit));
                }
            }
            if (CoordSysType.GEOGRAPHIC.equals((Object)this.m_destCoordSys.getType())) {
                projection = ((GeographicCoordSys)this.m_destCoordSys).getProjection();
            }
            if (projection != null) {
                projection.fromLongLat(destination, destination);
            }
            this.m_destCoordSys.getAffineTransform().transform(destination, destination);
        }
        return destination;
    }

    private static double linearToAngular(double len, LinearUnit lu, AngularUnit au) {
        len = LinearUnit.convert((double)len, (LinearUnit)lu, (LinearUnit)LinearUnit.METER);
        double alpha = len / 6370997.0;
        return AngularUnit.convert((double)alpha, (AngularUnit)AngularUnit.RADIAN, (AngularUnit)au);
    }

    private static double angularToLinear(double alpha, AngularUnit au, LinearUnit lu) {
        alpha = AngularUnit.convert((double)alpha, (AngularUnit)au, (AngularUnit)AngularUnit.RADIAN);
        double len = alpha * 6370997.0;
        return LinearUnit.convert((double)len, (LinearUnit)LinearUnit.METER, (LinearUnit)lu);
    }

    @PrivateAPI
    public DoubleRect transform(DoubleRect srcRect) {
        DoubleRect result;
        if (this.m_directTransform != null) {
            result = srcRect.getCopy(this.m_directTransform);
        } else {
            result = new DoubleRect();
            result.initBounds();
            int numPoints = 400;
            int steps = numPoints / 4;
            this.sampleLine(srcRect.getMinX(), srcRect.getMinY(), srcRect.getMaxX(), srcRect.getMinY(), steps, result);
            this.sampleLine(srcRect.getMaxX(), srcRect.getMinY(), srcRect.getMaxX(), srcRect.getMaxY(), steps, result);
            this.sampleLine(srcRect.getMaxX(), srcRect.getMaxY(), srcRect.getMinX(), srcRect.getMaxY(), steps, result);
            this.sampleLine(srcRect.getMinX(), srcRect.getMaxY(), srcRect.getMinX(), srcRect.getMinY(), steps, result);
            DirectPosition dp = new DirectPosition(0.0, 90.0);
            this.transform(dp, dp);
            if (srcRect.contains(dp.getX(), dp.getY())) {
                result.merge(dp);
            }
            dp.setXY(0.0, -90.0);
            this.transform(dp, dp);
            if (srcRect.contains(dp.getX(), dp.getY())) {
                result.merge(dp);
            }
        }
        return result;
    }

    private void sampleLine(double x1, double y1, double x2, double y2, int numPoints, DoubleRect result) {
        DirectPosition tmp = new DirectPosition();
        double dx = (x2 - x1) / (double)numPoints;
        double dy = (y2 - y1) / (double)numPoints;
        for (int i = 0; i < numPoints; ++i) {
            tmp.setXY(x1 + dx * (double)i, y1 + dy * (double)i);
            this.transform(tmp, tmp);
            result.merge(tmp);
        }
    }

    @PrivateAPI
    public CoordTransform withTransformFactories(List<? extends IGeographicTransformFactory> factories) {
        return new CoordTransform(this.m_srcCoordSys, this.m_destCoordSys, factories);
    }
}

