/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.util;

import java.io.Serializable;

public class ComplexNumber
implements Serializable {
    private double m_real;
    private double m_imaginary;

    public ComplexNumber(double real, double imaginary) {
        this.m_real = real;
        this.m_imaginary = imaginary;
    }

    public ComplexNumber() {
        this(0.0, 0.0);
    }

    public void set(double real, double imaginary) {
        this.m_real = real;
        this.m_imaginary = imaginary;
    }

    public void set(ComplexNumber cn) {
        this.m_real = cn.m_real;
        this.m_imaginary = cn.m_imaginary;
    }

    public double getReal() {
        return this.m_real;
    }

    public double getImaginary() {
        return this.m_imaginary;
    }

    public boolean isReal() {
        return this.m_imaginary == 0.0;
    }

    public ComplexNumber add(double scalar) {
        this.m_real += scalar;
        return this;
    }

    public ComplexNumber add(ComplexNumber cn) {
        this.m_real += cn.m_real;
        this.m_imaginary += cn.m_imaginary;
        return this;
    }

    public ComplexNumber mult(double scalar) {
        this.m_real *= scalar;
        this.m_imaginary *= scalar;
        return this;
    }

    public ComplexNumber mult(ComplexNumber cn) {
        double tempReal = this.m_real;
        this.m_real = this.m_real * cn.m_real - this.m_imaginary * cn.m_imaginary;
        this.m_imaginary = tempReal * cn.m_imaginary + this.m_imaginary * cn.m_real;
        return this;
    }

    public ComplexNumber div(ComplexNumber cn) {
        double tempReal = this.m_real;
        if (Math.abs(cn.m_imaginary) < Math.abs(cn.m_real)) {
            double cdratio = cn.m_imaginary / cn.m_real;
            double denom = cn.m_real + cn.m_imaginary * cdratio;
            this.m_real = (this.m_real + this.m_imaginary * cdratio) / denom;
            this.m_imaginary = (this.m_imaginary - tempReal * cdratio) / denom;
        } else {
            double cdratio = cn.m_real / cn.m_imaginary;
            double denom = cn.m_imaginary + cn.m_real * cdratio;
            this.m_real = (this.m_real * cdratio + this.m_imaginary) / denom;
            this.m_imaginary = (this.m_imaginary * cdratio - tempReal) / denom;
        }
        return this;
    }

    public double norm() {
        return Math.sqrt(this.m_real * this.m_real + this.m_imaginary * this.m_imaginary);
    }
}

