/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.util;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.EngineeringCoordSys;
import com.mapinfo.midev.coordsys.GeodeticDatum;
import com.mapinfo.midev.coordsys.GeodeticDatumOperation;
import com.mapinfo.midev.coordsys.GeographicCoordSys;
import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.util.Code;
import java.util.HashSet;

public class CoordSysHashUtilities {
    private CoordSysHashUtilities() {
    }

    public static int calcHash(Ellipsoid e) {
        return CoordSysHashUtilities.calcEllipsoidHash(e.getDisplayName(null), e.getSemiMajorAxis(), e.getInverseFlattening());
    }

    public static int calcEllipsoidHash(String displayName, double semiMajorAxis, double inverseFlattening) {
        int result = displayName == null ? 0 : displayName.hashCode();
        long temp = semiMajorAxis != 0.0 ? Double.doubleToLongBits(semiMajorAxis) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = inverseFlattening != 0.0 ? Double.doubleToLongBits(inverseFlattening) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static int calcHash(GeodeticDatum d) {
        return CoordSysHashUtilities.calcGeodeticDatumHash(d.getDisplayName(null), d.getEllipsoid(), d.getPrimeMeridian());
    }

    public static int calcGeodeticDatumHash(String displayName, Ellipsoid e, PrimeMeridian primeMeridian) {
        int result = displayName == null ? 0 : displayName.hashCode();
        result = 29 * result + CoordSysHashUtilities.calcHash(e);
        double pmDeg = AngularUnit.convert((double)primeMeridian.getLongitude(), (AngularUnit)primeMeridian.getAngularUnit(), (AngularUnit)AngularUnit.DEGREE);
        long temp = pmDeg != 0.0 ? Double.doubleToLongBits(pmDeg) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static int calcHash(GeodeticDatumOperation d) {
        return CoordSysHashUtilities.calcGeodeticDatumOperationHash(d.getDisplayName(null), d.getGeodeticDatum(), d.getShiftX(), d.getShiftY(), d.getShiftZ(), d.getRotateX(), d.getRotateY(), d.getRotateZ(), d.getScaleAdjust());
    }

    public static int calcGeodeticDatumOperationHash(String displayName, GeodeticDatum d, double shiftX, double shiftY, double shiftZ, double rotateX, double rotateY, double rotateZ, double scaleAdjust) {
        int result = displayName == null ? 0 : displayName.hashCode();
        result = 29 * result + (displayName == null ? CoordSysHashUtilities.calcGeodeticDatumHash(null, d.getEllipsoid(), d.getPrimeMeridian()) : CoordSysHashUtilities.calcHash(d));
        long temp = shiftX != 0.0 ? Double.doubleToLongBits(shiftX) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = shiftY != 0.0 ? Double.doubleToLongBits(shiftY) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = shiftZ != 0.0 ? Double.doubleToLongBits(shiftZ) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = rotateX != 0.0 ? Double.doubleToLongBits(rotateX) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = rotateY != 0.0 ? Double.doubleToLongBits(rotateY) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = rotateZ != 0.0 ? Double.doubleToLongBits(rotateZ) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = scaleAdjust != 0.0 ? Double.doubleToLongBits(scaleAdjust) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static int calcHash(CoordSys t) {
        int result = t.getAffineTransform() != null ? t.getAffineTransform().hashCode() : 0;
        switch (t.getType()) {
            case GEOGRAPHIC: {
                result = 29 * result + CoordSysHashUtilities.calcHash((GeographicCoordSys)t);
                break;
            }
            case ENGINEERING: {
                result = 29 * result + CoordSysHashUtilities.calcHash((EngineeringCoordSys)t);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    public static int calcHash(GeographicCoordSys t) {
        int result = t.getAffineTransform() != null ? t.getAffineTransform().hashCode() : 0;
        result = 29 * result + CoordSysHashUtilities.calcHash(t.getGeodeticDatumOperation());
        result = 29 * result + (t.getAngularUnit() != null ? t.getAngularUnit().hashCode() : 0);
        result = 29 * result + CoordSysHashUtilities.calcHash(t.getProjection());
        return result;
    }

    public static int calcHash(EngineeringCoordSys t) {
        int result = t.getAffineTransform() != null ? t.getAffineTransform().hashCode() : 0;
        result = 29 * result + (t.getLinearUnit() != null ? t.getLinearUnit().hashCode() : 0);
        return result;
    }

    public static int calcHash(Projection p) {
        int result;
        if (p == null) {
            result = 0;
        } else {
            result = p.getClass().getName().hashCode();
            ProjectionParams params = p.getProjectionParams();
            result = 29 * result + (params.getLinearUnit() != null ? params.getLinearUnit().hashCode() : 0);
            result = 29 * result + (params.getOriginLongitude() != null ? params.getOriginLongitude().hashCode() : 0);
            result = 29 * result + (params.getOriginLatitude() != null ? params.getOriginLatitude().hashCode() : 0);
            result = 29 * result + (params.getStandardParallel1() != null ? params.getStandardParallel1().hashCode() : 0);
            result = 29 * result + (params.getStandardParallel2() != null ? params.getStandardParallel2().hashCode() : 0);
            result = 29 * result + (params.getFalseEasting() != null ? params.getFalseEasting().hashCode() : 0);
            result = 29 * result + (params.getFalseNorthing() != null ? params.getFalseNorthing().hashCode() : 0);
            long temp = params.getScaleFactor() != 0.0 ? Double.doubleToLongBits(params.getScaleFactor()) : 0L;
            result = 29 * result + (int)(temp ^ temp >>> 32);
            result = 29 * result + (params.getRange() != null ? params.getRange().hashCode() : 0);
            result = 29 * result + (params.getAzimuth() != null ? params.getAzimuth().hashCode() : 0);
        }
        return result;
    }

    public static CoordSys addCode(CoordSys coordSys, Code code) {
        CoordSys result;
        HashSet<Code> codeSet = new HashSet<Code>();
        for (Code c : coordSys.getCodes()) {
            codeSet.add(c);
        }
        codeSet.add(code);
        switch (coordSys.getType()) {
            case GEOGRAPHIC: {
                GeographicCoordSys gcs1 = (GeographicCoordSys)coordSys;
                result = new GeographicCoordSys(gcs1.getDisplayName(null), new CodeSet(codeSet), gcs1.getAffineTransform(), gcs1.getGeodeticDatumOperation(), gcs1.getAngularUnit(), gcs1.getProjection());
                break;
            }
            case ENGINEERING: {
                EngineeringCoordSys ecs1 = (EngineeringCoordSys)coordSys;
                result = new EngineeringCoordSys(ecs1.getDisplayName(null), new CodeSet(codeSet), ecs1.getAffineTransform(), ecs1.getLinearUnit());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }
}

