/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.util;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.EngineeringCoordSys;
import com.mapinfo.midev.coordsys.GeographicCoordSys;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.awt.geom.Point2D;

public final class CoordSysUtilities {
    private static final double NEGATIVE_90_DEGREES_IN_RADIANS = -1.5707963267948966;
    private static final double POSITIVE_90_DEGREES_IN_RADIANS = 1.5707963267948966;
    private static final String EPSG_CODE = "epsg";
    private static final String MAPINFO_CODE = "mapinfo";

    private CoordSysUtilities() {
    }

    public static double convertClip(double alpha, AngularUnit fromUnit, AngularUnit toUnit, double minInDegrees, double maxInDegrees) {
        double alphaInToUnit = AngularUnit.convert((double)alpha, (AngularUnit)fromUnit, (AngularUnit)toUnit);
        double minInToUnit = AngularUnit.convert((double)minInDegrees, (AngularUnit)AngularUnit.DEGREE, (AngularUnit)toUnit);
        double maxInToUnit = AngularUnit.convert((double)maxInDegrees, (AngularUnit)AngularUnit.DEGREE, (AngularUnit)toUnit);
        return MathUtil.clip((double)alphaInToUnit, (double)minInToUnit, (double)maxInToUnit);
    }

    public static double convertClip(Angle alpha, AngularUnit toUnit, double minInDegrees, double maxInDegrees) {
        double alphaInToUnit = alpha.getValue(toUnit);
        double minInToUnit = AngularUnit.convert((double)minInDegrees, (AngularUnit)AngularUnit.DEGREE, (AngularUnit)toUnit);
        double maxInToUnit = AngularUnit.convert((double)maxInDegrees, (AngularUnit)AngularUnit.DEGREE, (AngularUnit)toUnit);
        return MathUtil.clip((double)alphaInToUnit, (double)minInToUnit, (double)maxInToUnit);
    }

    public static boolean isProjected(CoordSys csys) {
        boolean result = false;
        if (csys instanceof GeographicCoordSys) {
            result = ((GeographicCoordSys)csys).getProjection() != null;
        }
        return result;
    }

    public static boolean isLongLat(CoordSys csys) {
        boolean result = false;
        if (csys instanceof GeographicCoordSys) {
            result = ((GeographicCoordSys)csys).getProjection() == null;
        }
        return result;
    }

    public static boolean isEngineering(CoordSys csys) {
        return csys instanceof EngineeringCoordSys;
    }

    public static LinearUnit getLinearUnit(CoordSys csys) {
        GeographicCoordSys geographicCoordSys;
        Object result = csys instanceof GeographicCoordSys ? ((geographicCoordSys = (GeographicCoordSys)csys).getProjection() != null ? geographicCoordSys.getProjection().getProjectionParams().getLinearUnit() : null) : (csys instanceof EngineeringCoordSys ? ((EngineeringCoordSys)csys).getLinearUnit() : null);
        return result;
    }

    public static Code removeBounds(Code codeWithBounds) {
        Code codeWithNoBounds = null;
        if (MAPINFO_CODE.equalsIgnoreCase(codeWithBounds.getCodeSpace())) {
            String coordSys = "coordsys ";
            String tempCode = codeWithBounds.getCode().substring(coordSys.length()).trim();
            String[] ss = tempCode.split(",");
            int bounds = Integer.parseInt(ss[0].trim());
            if (bounds >= 2000) {
                StringBuilder codeBuilder = new StringBuilder();
                codeBuilder.append(coordSys).append(bounds).append(",");
                for (int i = 1; i < ss.length - 4; ++i) {
                    codeBuilder.append(ss[i]).append(",");
                }
                codeBuilder = codeBuilder.deleteCharAt(codeBuilder.length() - 1);
                codeWithNoBounds = new Code(codeWithBounds.getCodeSpace(), codeBuilder.toString());
            }
        }
        return codeWithNoBounds;
    }

    public static Code addBounds(Code codeWithNoBounds) {
        Code codeWithBounds = null;
        if (MAPINFO_CODE.equalsIgnoreCase(codeWithNoBounds.getCodeSpace())) {
            String coordSys = "coordsys ";
            String tempCode = codeWithNoBounds.getCode().substring(coordSys.length()).trim();
            String[] ss = tempCode.split(",");
            int bounds = Integer.parseInt(ss[0].trim());
            if (bounds < 2000) {
                StringBuilder codeBuilder = new StringBuilder();
                codeBuilder.append(coordSys).append(bounds += 2000).append(",");
                for (int i = 1; i < ss.length; ++i) {
                    codeBuilder.append(ss[i]).append(",");
                }
                codeBuilder = codeBuilder.deleteCharAt(codeBuilder.length() - 1);
                codeWithBounds = new Code(codeWithNoBounds.getCodeSpace(), codeBuilder.toString());
            }
        }
        return codeWithBounds;
    }

    public static void adjustPointsUsingDistance(DirectPosition pnt1, DirectPosition pnt2, CoordSys coordsys, Length length, boolean bMoveBoth, boolean bAdjustX) {
        double desiredDistance = Math.abs(length.getValue());
        LinearUnit unit = length.getUnit();
        for (int i = 0; i < 10; ++i) {
            double dY;
            double dX;
            double curdist = CoordSysUtilities.cartesianDistance(coordsys, pnt1, pnt2, unit);
            if (curdist == 0.0) {
                if (bAdjustX) {
                    dX = pnt1.getX() == 0.0 ? -1.0 : pnt1.getX() / -100.0;
                    dY = 0.0;
                } else {
                    dX = 0.0;
                    dY = pnt1.getY() == 0.0 ? -1.0 : pnt1.getY() / -100.0;
                }
            } else {
                double temp = desiredDistance / curdist - 1.0;
                if (Math.abs(temp) < 1.0E-6) {
                    return;
                }
                dX = (pnt2.getX() - pnt1.getX()) * temp;
                dY = (pnt2.getY() - pnt1.getY()) * temp;
            }
            if (bMoveBoth) {
                pnt1.offsetXY(-(dX /= 2.0), -(dY /= 2.0));
            }
            pnt2.offsetXY(dX, dY);
        }
    }

    public static double cartesianDistance(CoordSys cs, DirectPosition pnt1, DirectPosition pnt2, LinearUnit unit) {
        AffineTransform xform = cs.getAffineTransform().createInverse();
        pnt1 = xform.transform(pnt1, new DirectPosition());
        pnt2 = xform.transform(pnt2, new DirectPosition());
        if (CoordSysUtilities.isProjected(cs) || CoordSysUtilities.isEngineering(cs)) {
            double distance = Point2D.distance(pnt1.getX(), pnt1.getY(), pnt2.getX(), pnt2.getY());
            return LinearUnit.convert((double)distance, (LinearUnit)CoordSysUtilities.getLinearUnit(cs), (LinearUnit)unit);
        }
        GeographicCoordSys gcs = (GeographicCoordSys)cs;
        AngularUnit srcUnit = gcs.getAngularUnit();
        double x1 = AngularUnit.convert((double)pnt1.getX(), (AngularUnit)srcUnit, (AngularUnit)AngularUnit.RADIAN);
        double y1 = AngularUnit.convert((double)pnt1.getY(), (AngularUnit)srcUnit, (AngularUnit)AngularUnit.RADIAN);
        double x2 = AngularUnit.convert((double)pnt2.getX(), (AngularUnit)srcUnit, (AngularUnit)AngularUnit.RADIAN);
        double y2 = AngularUnit.convert((double)pnt2.getY(), (AngularUnit)srcUnit, (AngularUnit)AngularUnit.RADIAN);
        y1 = MathUtil.clip((double)y1, (double)-1.5707963267948966, (double)1.5707963267948966);
        y2 = MathUtil.clip((double)y2, (double)-1.5707963267948966, (double)1.5707963267948966);
        double dx = (x2 - x1) * Math.cos((y1 + y2) / 2.0);
        double dy = y2 - y1;
        double temp = Math.sqrt(dx * dx + dy * dy);
        return LinearUnit.convert((double)(temp * 6370997.0), (LinearUnit)LinearUnit.METER, (LinearUnit)unit);
    }

    public static String getSRSName(CoordSys coordSys) {
        CodeSet codeSet = coordSys.getCodes();
        Code code = codeSet.getFirstCode(EPSG_CODE);
        if (code != null && !"0".equalsIgnoreCase(code.getCode())) {
            return code.toString();
        }
        code = codeSet.getFirstCode(MAPINFO_CODE);
        if (code != null) {
            return code.toString();
        }
        throw new UnsupportedOperationException("epsg and mapinfo codespace not found:" + codeSet);
    }

    public static String getMapInfoSRSName(CoordSys coordSys) {
        CodeSet codeSet = coordSys.getCodes();
        Code code = codeSet.getFirstCode(MAPINFO_CODE);
        if (code != null) {
            return code.toString();
        }
        throw new UnsupportedOperationException("mapinfo codespace not found:" + codeSet);
    }

    public static CoordSys normalizeForDistanceCalculation(CoordSys csys, ComputationType computationType) {
        if (csys instanceof GeographicCoordSys && computationType == ComputationType.SPHERICAL && CoordSysUtilities.isProjected(csys)) {
            csys = CoordSysUtilities.stripProjection((GeographicCoordSys)csys);
        }
        return CoordSysUtilities.normalize(csys);
    }

    private static GeographicCoordSys stripProjection(GeographicCoordSys csys) {
        GeographicCoordSys result = csys.getProjection() != null ? new GeographicCoordSys(null, null, csys.getAffineTransform(), csys.getGeodeticDatumOperation(), csys.getAngularUnit(), null) : csys;
        return result;
    }

    private static CoordSys normalize(CoordSys coordSys) {
        if (!coordSys.getAffineTransform().isIdentity() && coordSys instanceof GeographicCoordSys) {
            GeographicCoordSys geographicCoordSys = (GeographicCoordSys)coordSys;
            coordSys = new GeographicCoordSys(geographicCoordSys.getDisplayName(null), geographicCoordSys.getCodes(), AffineTransform.IDENTITY, geographicCoordSys.getGeodeticDatumOperation(), geographicCoordSys.getAngularUnit(), geographicCoordSys.getProjection());
        }
        return coordSys;
    }

    public static int getEPSGCode(CoordSys coordSys) {
        Code code = coordSys.getCodes().getFirstCode("EPSG");
        if (code != null) {
            return Integer.parseInt(code.getCode());
        }
        return 0;
    }
}

