/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.util;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.EngineeringCoordSys;
import com.mapinfo.midev.coordsys.GeodeticDatum;
import com.mapinfo.midev.coordsys.GeodeticDatumOperation;
import com.mapinfo.midev.coordsys.GeographicCoordSys;
import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.parser.UnknownProjectionParamException;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.DoubleRect;

public final class MapBasicUtilities {
    private MapBasicUtilities() {
    }

    public static String toMapBasic(CoordSys coordSys) {
        if (coordSys instanceof GeographicCoordSys) {
            return MapBasicUtilities.toMapBasic((GeographicCoordSys)coordSys);
        }
        if (coordSys instanceof EngineeringCoordSys) {
            return MapBasicUtilities.toMapBasic((EngineeringCoordSys)coordSys);
        }
        throw new UnsupportedOperationException();
    }

    private static String toMapBasic(GeographicCoordSys coordSys) {
        StringBuilder result = new StringBuilder("CoordSys Earth Projection ");
        LinearUnit linearUnit = LinearUnit.METER;
        Projection projection = coordSys.getProjection();
        if (projection == null) {
            result.append('1');
        } else {
            String projectionString = projection.getCodes().getFirstCode("mapinfo").getCode();
            projectionString = projectionString.substring("projection".length());
            result.append(projectionString);
            linearUnit = projection.getProjectionParams().getLinearUnit();
        }
        MapBasicUtilities.appendDatum(result, coordSys.getGeodeticDatumOperation());
        if (projection != null) {
            MapBasicUtilities.appendProjectionParams(result, projection, linearUnit);
        }
        MapBasicUtilities.appendAffineTransform(result, coordSys.getAffineTransform(), linearUnit);
        return result.toString();
    }

    private static String toMapBasic(EngineeringCoordSys coordSys) {
        StringBuilder result = new StringBuilder("CoordSys Nonearth Units ");
        result.append('\"');
        result.append(coordSys.getLinearUnit().getMapBasicAbbreviation());
        result.append('\"');
        MapBasicUtilities.appendAffineTransform(result, coordSys.getAffineTransform(), coordSys.getLinearUnit());
        DoubleRect bounds = coordSys.getMBR();
        result.append(" Bounds (");
        result.append(bounds.getMinX());
        result.append(", ");
        result.append(bounds.getMinY());
        result.append(") (");
        result.append(bounds.getMaxX());
        result.append(", ");
        result.append(bounds.getMaxY());
        result.append(')');
        return result.toString();
    }

    private static void appendDatum(StringBuilder sb, GeodeticDatumOperation datumOperation) {
        GeodeticDatum datum = datumOperation.getGeodeticDatum();
        Code datumOperationCode = datumOperation.getCodes().getFirstCode("mapinfo");
        if (datumOperationCode == null) {
            if (datumOperation.getRotateX() == 0.0 && datumOperation.getRotateY() == 0.0 && datumOperation.getRotateZ() == 0.0 && datumOperation.getScaleAdjust() == 0.0) {
                sb.append(", 999, ");
                String ellipsoidString = datum.getEllipsoid().getCodes().getFirstCode("mapinfo").getCode();
                ellipsoidString = ellipsoidString.substring("ellipsoid".length());
                sb.append(ellipsoidString);
                sb.append(", ");
                sb.append(datumOperation.getShiftX());
                sb.append(", ");
                sb.append(datumOperation.getShiftY());
                sb.append(", ");
                sb.append(datumOperation.getShiftZ());
            } else {
                sb.append(", 9999, ");
                String ellipsoidString = datum.getEllipsoid().getCodes().getFirstCode("mapinfo").getCode();
                ellipsoidString = ellipsoidString.substring("ellipsoid".length());
                sb.append(ellipsoidString);
                sb.append(", ");
                sb.append(datumOperation.getShiftX());
                sb.append(", ");
                sb.append(datumOperation.getShiftY());
                sb.append(", ");
                sb.append(datumOperation.getShiftZ());
                sb.append(", ");
                sb.append(datumOperation.getRotateX());
                sb.append(", ");
                sb.append(datumOperation.getRotateY());
                sb.append(", ");
                sb.append(datumOperation.getRotateZ());
                sb.append(", ");
                sb.append(datumOperation.getScaleAdjust());
                sb.append(", ");
                PrimeMeridian primeMeridian = datum.getPrimeMeridian();
                sb.append(AngularUnit.convert((double)primeMeridian.getLongitude(), (AngularUnit)primeMeridian.getAngularUnit(), (AngularUnit)AngularUnit.DEGREE));
            }
        } else {
            sb.append(", ");
            sb.append(datumOperationCode.getCode().substring("geodeticdatumoperation".length()));
        }
    }

    private static void appendProjectionParams(StringBuilder sb, Projection projection, LinearUnit linearUnit) {
        sb.append(", ");
        sb.append('\"');
        sb.append(linearUnit.getMapBasicAbbreviation());
        sb.append('\"');
        ProjectionParamType[] paramInfo = CoordSysFactory.getDefaultCoordSysFactory().getProjectionFactory(projection.getCodes().getFirstCode("mapinfo")).getParamInfo();
        ProjectionParams projectionParams = projection.getProjectionParams();
        block12: for (ProjectionParamType type : paramInfo) {
            sb.append(", ");
            switch (type) {
                case ORIGIN_LONGITUDE: {
                    sb.append(projectionParams.getOriginLongitude().getValue(AngularUnit.DEGREE));
                    continue block12;
                }
                case ORIGIN_LATITUDE: {
                    sb.append(projectionParams.getOriginLatitude().getValue(AngularUnit.DEGREE));
                    continue block12;
                }
                case STANDARD_PARALLEL_1: {
                    sb.append(projectionParams.getStandardParallel1().getValue(AngularUnit.DEGREE));
                    continue block12;
                }
                case STANDARD_PARALLEL_2: {
                    sb.append(projectionParams.getStandardParallel2().getValue(AngularUnit.DEGREE));
                    continue block12;
                }
                case AZIMUTH: {
                    sb.append(projectionParams.getAzimuth().getValue(AngularUnit.DEGREE));
                    continue block12;
                }
                case BEARING: {
                    sb.append(projectionParams.getBearing().getValue(AngularUnit.DEGREE));
                    continue block12;
                }
                case SCALE_FACTOR: {
                    sb.append(projectionParams.getScaleFactor());
                    continue block12;
                }
                case FALSE_EASTING: {
                    sb.append(projectionParams.getFalseEasting().getValue(linearUnit));
                    continue block12;
                }
                case FALSE_NORTHING: {
                    sb.append(projectionParams.getFalseNorthing().getValue(linearUnit));
                    continue block12;
                }
                case RANGE: {
                    sb.append(projectionParams.getRange().getValue(AngularUnit.DEGREE));
                    continue block12;
                }
                default: {
                    throw new UnknownProjectionParamException(type);
                }
            }
        }
    }

    private static void appendAffineTransform(StringBuilder sb, AffineTransform affineTransform, LinearUnit linearUnit) {
        if (affineTransform != null && !affineTransform.isIdentity()) {
            sb.append(" Affine Units ");
            sb.append('\"');
            sb.append(linearUnit.getMapBasicAbbreviation());
            sb.append('\"');
            sb.append(", ");
            sb.append(affineTransform.getScaleX());
            sb.append(", ");
            sb.append(affineTransform.getShearX());
            sb.append(", ");
            sb.append(affineTransform.getTranslateX());
            sb.append(", ");
            sb.append(affineTransform.getShearY());
            sb.append(", ");
            sb.append(affineTransform.getScaleY());
            sb.append(", ");
            sb.append(affineTransform.getTranslateY());
        }
    }
}

