/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.xmlprot;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.GeodeticDatum;
import com.mapinfo.midev.coordsys.GeodeticDatumOperation;
import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.parser.UnknownProjectionParamException;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.xmlprot.ConfigReaderUtilities;
import com.mapinfo.midev.coordsys.xmlprot.MissingElementException;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.Offset;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.xml.read.IXmlReader;
import com.mapinfo.midev.xml.read.XmlReaderException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;

public final class CoordSysConfigReader {
    private CoordSysConfigReader() {
    }

    public static void read(IXmlReader r, CoordSysFactory factory) throws XmlReaderException {
        Set<Serializable> geodeticDatumSet;
        r.readStartElement("CoordSysConfig", "http://www.mapinfo.com/mxp/csys");
        if (r.isStartElement("EllipsoidSet", "http://www.mapinfo.com/mxp/csys")) {
            Set<Ellipsoid> ellipsoidSet = CoordSysConfigReader.readEllipsoidSet(r);
            for (Ellipsoid e : ellipsoidSet) {
                if (e.getCodes().isEmpty()) continue;
                factory.add(e);
            }
        }
        if (r.isStartElement("GeodeticDatumSet", "http://www.mapinfo.com/mxp/csys")) {
            geodeticDatumSet = CoordSysConfigReader.readGeodeticDatumSet(r, factory);
            for (Serializable d : geodeticDatumSet) {
                if (((GeodeticDatum)d).getCodes().isEmpty()) continue;
                factory.add((GeodeticDatum)d);
            }
        }
        if (r.isStartElement("GeodeticDatumOperationSet", "http://www.mapinfo.com/mxp/csys")) {
            geodeticDatumSet = CoordSysConfigReader.readGeodeticDatumOperationSet(r, factory);
            for (Serializable d : geodeticDatumSet) {
                if (((GeodeticDatumOperation)d).getCodes().isEmpty()) continue;
                factory.add((GeodeticDatumOperation)d);
            }
        }
        r.readEndElement();
    }

    private static Set<Ellipsoid> readEllipsoidSet(IXmlReader r) throws XmlReaderException {
        r.readStartElement("EllipsoidSet", "http://www.mapinfo.com/mxp/csys");
        LinkedHashSet<Ellipsoid> result = new LinkedHashSet<Ellipsoid>();
        while (r.isStartElement("Ellipsoid", "http://www.mapinfo.com/mxp/csys")) {
            result.add(CoordSysConfigReader.readEllipsoid(r));
        }
        r.readEndElement();
        return result;
    }

    private static Ellipsoid readEllipsoid(IXmlReader r) throws XmlReaderException {
        r.readStartElement("Ellipsoid", "http://www.mapinfo.com/mxp/csys");
        CodeSet codeSet = null;
        if (r.isStartElement("CodeSet", "http://www.mapinfo.com/mxp/csys")) {
            codeSet = ConfigReaderUtilities.readCodeSet(r);
        }
        String displayName = r.readElementString("DisplayNameKey", "http://www.mapinfo.com/mxp/csys");
        double semiMajorAxis = Double.parseDouble(r.readElementString("SemiMajorAxis", "http://www.mapinfo.com/mxp/csys"));
        double inverseFlattening = Double.parseDouble(r.readElementString("InverseFlattening", "http://www.mapinfo.com/mxp/csys"));
        Ellipsoid result = new Ellipsoid(displayName, codeSet, semiMajorAxis, inverseFlattening, LinearUnit.METER);
        r.readEndElement();
        return result;
    }

    private static Set<GeodeticDatum> readGeodeticDatumSet(IXmlReader r, CoordSysFactory factory) throws XmlReaderException {
        r.readStartElement("GeodeticDatumSet", "http://www.mapinfo.com/mxp/csys");
        LinkedHashSet<GeodeticDatum> result = new LinkedHashSet<GeodeticDatum>();
        while (r.isStartElement("GeodeticDatum", "http://www.mapinfo.com/mxp/csys")) {
            result.add(CoordSysConfigReader.readGeodeticDatum(r, factory));
        }
        r.readEndElement();
        return result;
    }

    private static GeodeticDatum readGeodeticDatum(IXmlReader r, CoordSysFactory factory) throws XmlReaderException {
        Ellipsoid e;
        r.readStartElement("GeodeticDatum", "http://www.mapinfo.com/mxp/csys");
        CodeSet codeSet = null;
        if (r.isStartElement("CodeSet", "http://www.mapinfo.com/mxp/csys")) {
            codeSet = ConfigReaderUtilities.readCodeSet(r);
        }
        String displayName = r.readElementString("DisplayNameKey", "http://www.mapinfo.com/mxp/csys");
        if (r.isStartElement("Ellipsoid", "http://www.mapinfo.com/mxp/csys")) {
            e = CoordSysConfigReader.readEllipsoid(r);
        } else if (r.isStartElement("EllipsoidRef", "http://www.mapinfo.com/mxp/csys")) {
            r.readStartElement("EllipsoidRef", "http://www.mapinfo.com/mxp/csys");
            Code code = ConfigReaderUtilities.readCode(r);
            r.readEndElement();
            e = factory.getEllipsoid(code.getCodeSpace(), code.getCode());
        } else {
            HashSet<ImmutablePair> expected = new HashSet<ImmutablePair>(2);
            expected.add(new ImmutablePair((Object)"http://www.mapinfo.com/mxp/csys", (Object)"Ellipsoid"));
            expected.add(new ImmutablePair((Object)"http://www.mapinfo.com/mxp/csys", (Object)"EllipsoidRef"));
            throw new MissingElementException(Collections.unmodifiableSet(expected), r.getLocalName());
        }
        PrimeMeridian primeMeridian = PrimeMeridian.GREENWICH;
        if (r.isStartElement("PrimeMeridian", "http://www.mapinfo.com/mxp/csys")) {
            primeMeridian = CoordSysConfigReader.readPrimeMeridian(r);
        }
        r.readEndElement();
        return new GeodeticDatum(displayName, codeSet, e, primeMeridian);
    }

    private static Set<GeodeticDatumOperation> readGeodeticDatumOperationSet(IXmlReader r, CoordSysFactory factory) throws XmlReaderException {
        r.readStartElement("GeodeticDatumOperationSet", "http://www.mapinfo.com/mxp/csys");
        LinkedHashSet<GeodeticDatumOperation> result = new LinkedHashSet<GeodeticDatumOperation>();
        while (r.isStartElement("GeodeticDatumOperation", "http://www.mapinfo.com/mxp/csys")) {
            result.add(CoordSysConfigReader.readGeodeticDatumOperation(r, factory));
        }
        r.readEndElement();
        return result;
    }

    private static GeodeticDatumOperation readGeodeticDatumOperation(IXmlReader r, CoordSysFactory factory) throws XmlReaderException {
        GeodeticDatum d;
        r.readStartElement("GeodeticDatumOperation", "http://www.mapinfo.com/mxp/csys");
        CodeSet codeSet = null;
        if (r.isStartElement("CodeSet", "http://www.mapinfo.com/mxp/csys")) {
            codeSet = ConfigReaderUtilities.readCodeSet(r);
        }
        String displayName = r.readElementString("DisplayNameKey", "http://www.mapinfo.com/mxp/csys");
        if (r.isStartElement("GeodeticDatum", "http://www.mapinfo.com/mxp/csys")) {
            d = CoordSysConfigReader.readGeodeticDatum(r, factory);
        } else if (r.isStartElement("GeodeticDatumRef", "http://www.mapinfo.com/mxp/csys")) {
            r.readStartElement("GeodeticDatumRef", "http://www.mapinfo.com/mxp/csys");
            Code code = ConfigReaderUtilities.readCode(r);
            r.readEndElement();
            d = factory.getGeodeticDatum(code.getCodeSpace(), code.getCode());
        } else {
            HashSet<ImmutablePair> expected = new HashSet<ImmutablePair>(2);
            expected.add(new ImmutablePair((Object)"http://www.mapinfo.com/mxp/csys", (Object)"GeodeticDatum"));
            expected.add(new ImmutablePair((Object)"http://www.mapinfo.com/mxp/csys", (Object)"GeodeticDatumRef"));
            throw new MissingElementException(Collections.unmodifiableSet(expected), r.getLocalName());
        }
        double shiftX = Double.parseDouble(r.readElementString("ShiftX", "http://www.mapinfo.com/mxp/csys"));
        double shiftY = Double.parseDouble(r.readElementString("ShiftY", "http://www.mapinfo.com/mxp/csys"));
        double shiftZ = Double.parseDouble(r.readElementString("ShiftZ", "http://www.mapinfo.com/mxp/csys"));
        double rotateX = 0.0;
        if (r.isStartElement("RotateX", "http://www.mapinfo.com/mxp/csys")) {
            rotateX = Double.parseDouble(r.readElementString("RotateX", "http://www.mapinfo.com/mxp/csys"));
        }
        double rotateY = 0.0;
        if (r.isStartElement("RotateY", "http://www.mapinfo.com/mxp/csys")) {
            rotateY = Double.parseDouble(r.readElementString("RotateY", "http://www.mapinfo.com/mxp/csys"));
        }
        double rotateZ = 0.0;
        if (r.isStartElement("RotateZ", "http://www.mapinfo.com/mxp/csys")) {
            rotateZ = Double.parseDouble(r.readElementString("RotateZ", "http://www.mapinfo.com/mxp/csys"));
        }
        double scaleAdjust = 0.0;
        if (r.isStartElement("ScaleAdjust", "http://www.mapinfo.com/mxp/csys")) {
            scaleAdjust = Double.parseDouble(r.readElementString("ScaleAdjust", "http://www.mapinfo.com/mxp/csys"));
        }
        r.readEndElement();
        return new GeodeticDatumOperation(displayName, codeSet, d, shiftX, shiftY, shiftZ, rotateX, rotateY, rotateZ, scaleAdjust);
    }

    private static PrimeMeridian readPrimeMeridian(IXmlReader r) throws XmlReaderException {
        r.readStartElement("PrimeMeridian", "http://www.mapinfo.com/mxp/csys");
        String displayName = r.readElementString("DisplayNameKey", "http://www.mapinfo.com/mxp/csys");
        double value = Double.parseDouble(r.readElementString("GreenwichLongitude", "http://www.mapinfo.com/mxp/csys"));
        AngularUnit unit = AngularUnit.getFromMapBasicAbbreviation((String)r.readElementString("AngularUnit", "http://www.mapinfo.com/mxp/csys"));
        r.readEndElement();
        return new PrimeMeridian(displayName, value, unit);
    }

    private static Projection readProjectionRef(IXmlReader r, CoordSysFactory factory, Ellipsoid e, PrimeMeridian primeMeridian) throws XmlReaderException {
        r.readStartElement("ProjectionRef", "http://www.mapinfo.com/mxp/csys");
        Code c = ConfigReaderUtilities.readCode(r);
        IProjectionFactory projectionFactory = factory.getProjectionFactory(c.getCodeSpace(), c.getCode());
        ProjectionParamType[] paramInfo = projectionFactory.getParamInfo();
        Angle originLongitude = ProjectionParams.DEFAULT_ORIGIN_LONGITUDE;
        Angle originLatitude = ProjectionParams.DEFAULT_ORIGIN_LATITUDE;
        Angle standardParallel1 = ProjectionParams.DEFAULT_STANDARD_PARALLEL_1;
        Angle standardParallel2 = ProjectionParams.DEFAULT_STANDARD_PARALLEL_2;
        Angle azimuth = ProjectionParams.DEFAULT_AZIMUTH;
        Angle bearing = ProjectionParams.DEFAULT_BEARING;
        double scaleFactor = 1.0;
        Offset falseEasting = ProjectionParams.DEFAULT_FALSE_EASTING;
        Offset falseNorthing = ProjectionParams.DEFAULT_FALSE_NORTHING;
        Angle range = ProjectionParams.DEFAULT_RANGE;
        r.readStartElement("ProjectionParameters", "http://www.mapinfo.com/mxp/csys");
        LinearUnit lu = LinearUnit.getFromMapBasicAbbreviation((String)r.readElementString("LinearUnit", "http://www.mapinfo.com/mxp/csys"));
        block12: for (ProjectionParamType paramType : paramInfo) {
            switch (paramType) {
                case ORIGIN_LONGITUDE: {
                    originLongitude = new Angle(Double.parseDouble(r.readElementString("OriginLongitude", "http://www.mapinfo.com/mxp/csys")), AngularUnit.DEGREE);
                    continue block12;
                }
                case ORIGIN_LATITUDE: {
                    originLatitude = new Angle(Double.parseDouble(r.readElementString("OriginLatitude", "http://www.mapinfo.com/mxp/csys")), AngularUnit.DEGREE);
                    continue block12;
                }
                case STANDARD_PARALLEL_1: {
                    standardParallel1 = new Angle(Double.parseDouble(r.readElementString("StandardParallel1", "http://www.mapinfo.com/mxp/csys")), AngularUnit.DEGREE);
                    continue block12;
                }
                case STANDARD_PARALLEL_2: {
                    standardParallel2 = new Angle(Double.parseDouble(r.readElementString("StandardParallel2", "http://www.mapinfo.com/mxp/csys")), AngularUnit.DEGREE);
                    continue block12;
                }
                case AZIMUTH: {
                    azimuth = new Angle(Double.parseDouble(r.readElementString("Azimuth", "http://www.mapinfo.com/mxp/csys")), AngularUnit.DEGREE);
                    continue block12;
                }
                case BEARING: {
                    bearing = new Angle(Double.parseDouble(r.readElementString("Bearing", "http://www.mapinfo.com/mxp/csys")), AngularUnit.DEGREE);
                    continue block12;
                }
                case SCALE_FACTOR: {
                    scaleFactor = Double.parseDouble(r.readElementString("ScaleFactor", "http://www.mapinfo.com/mxp/csys"));
                    continue block12;
                }
                case FALSE_EASTING: {
                    falseEasting = new Offset(Double.parseDouble(r.readElementString("FalseEasting", "http://www.mapinfo.com/mxp/csys")), lu);
                    continue block12;
                }
                case FALSE_NORTHING: {
                    falseNorthing = new Offset(Double.parseDouble(r.readElementString("FalseNorthing", "http://www.mapinfo.com/mxp/csys")), lu);
                    continue block12;
                }
                case RANGE: {
                    range = new Angle(Double.parseDouble(r.readElementString("Range", "http://www.mapinfo.com/mxp/csys")), AngularUnit.DEGREE);
                    continue block12;
                }
                default: {
                    throw new UnknownProjectionParamException(paramType);
                }
            }
        }
        r.readEndElement();
        r.readEndElement();
        ProjectionParams params = new ProjectionParams(lu, e, primeMeridian, originLongitude, originLatitude, standardParallel1, standardParallel2, azimuth, bearing, scaleFactor, falseEasting, falseNorthing, range);
        return projectionFactory.createProjection(params);
    }
}

