/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.xmlprot;

import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public final class MissingElementException
extends RuntimeException {
    private final Set<Pair<String, String>> m_expectedElementNames;
    private final String m_localName;
    private final String m_message;

    public MissingElementException(Set<Pair<String, String>> expectedElementNames, String localName) {
        this.m_expectedElementNames = expectedElementNames;
        this.m_localName = localName;
        String message = "Expected elements ";
        for (Pair<String, String> expectedElementName : expectedElementNames) {
            String expectedNamedspace = (String)expectedElementName.getLeft();
            String expectedLocalName = (String)expectedElementName.getRight();
            message = message + "{" + expectedNamedspace + "} " + expectedLocalName + ", ";
        }
        this.m_message = message.substring(0, message.length() - 1) + " not found: " + localName;
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    public Set<Pair<String, String>> getExpectedElementNames() {
        return this.m_expectedElementNames;
    }

    public String getLocalName() {
        return this.m_localName;
    }
}

