/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.GeoSerialize;
import com.mapinfo.geocode.util.GeocodeUtils;
import java.util.HashMap;
import java.util.Map;

public class GeocodeAddress
implements Address,
GeoSerialize {
    private String mainAddressLine;
    private String addressLastLine;
    private String placeName;
    private String areaName1;
    private String areaName2;
    private String areaName3;
    private String areaName4;
    private String postCode1;
    private String postCode2;
    private String country;
    private String addressNumber;
    private String streetName;
    private String unitType;
    private String unitValue;
    private Map<String, String> customFields = new HashMap<String, String>();

    public GeocodeAddress() {
        this.mainAddressLine = "";
        this.addressLastLine = "";
        this.placeName = "";
        this.areaName1 = "";
        this.areaName2 = "";
        this.areaName3 = "";
        this.areaName4 = "";
        this.postCode1 = "";
        this.postCode2 = "";
        this.country = "";
        this.addressNumber = "";
        this.streetName = "";
        this.unitType = "";
        this.unitValue = "";
    }

    public GeocodeAddress(Address orig) {
        this.mainAddressLine = orig.getMainAddressLine();
        this.addressLastLine = orig.getAddressLastLine();
        this.placeName = orig.getPlaceName();
        this.areaName1 = orig.getAreaName1();
        this.areaName2 = orig.getAreaName2();
        this.areaName3 = orig.getAreaName3();
        this.areaName4 = orig.getAreaName4();
        this.postCode1 = orig.getPostCode1();
        this.postCode2 = orig.getPostCode2();
        this.country = orig.getCountry();
        this.addressNumber = orig.getAddressNumber();
        this.streetName = orig.getStreetName();
        this.unitType = orig.getUnitType();
        this.unitValue = orig.getUnitValue();
        if (orig.getCustomFields() != null) {
            this.customFields = orig.getCustomFields();
        }
    }

    @Override
    public String getMainAddressLine() {
        return this.mainAddressLine;
    }

    @Override
    public String getAddressLastLine() {
        return this.addressLastLine;
    }

    @Override
    public String getPlaceName() {
        return this.placeName;
    }

    @Override
    public String getAreaName1() {
        return this.areaName1;
    }

    @Override
    public String getAreaName2() {
        return this.areaName2;
    }

    @Override
    public String getAreaName3() {
        return this.areaName3;
    }

    @Override
    public String getAreaName4() {
        return this.areaName4;
    }

    @Override
    public String getPostCode1() {
        return this.postCode1;
    }

    @Override
    public String getPostCode2() {
        return this.postCode2;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getAddressNumber() {
        return this.addressNumber;
    }

    @Override
    public String getStreetName() {
        return this.streetName;
    }

    @Override
    public String getUnitType() {
        return this.unitType;
    }

    @Override
    public String getUnitValue() {
        return this.unitValue;
    }

    @Override
    public Map<String, String> getCustomFields() {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        return this.customFields;
    }

    @Override
    public void addCustomField(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.getCustomFields().remove(key);
            return;
        }
        this.getCustomFields().put(key, value);
    }

    @Override
    public void setMainAddressLine(String value) {
        this.mainAddressLine = value;
    }

    @Override
    public void setAddressLastLine(String value) {
        this.addressLastLine = value;
    }

    @Override
    public void setPlaceName(String value) {
        this.placeName = value;
    }

    @Override
    public void setAreaName1(String value) {
        this.areaName1 = value;
    }

    @Override
    public void setAreaName2(String value) {
        this.areaName2 = value;
    }

    @Override
    public void setAreaName3(String value) {
        this.areaName3 = value;
    }

    @Override
    public void setAreaName4(String value) {
        this.areaName4 = value;
    }

    @Override
    public void setPostCode1(String value) {
        this.postCode1 = value;
    }

    @Override
    public void setPostCode2(String value) {
        this.postCode2 = value;
    }

    @Override
    public void setCountry(String value) {
        this.country = value;
    }

    @Override
    public void setAddressNumber(String value) {
        this.addressNumber = value;
    }

    @Override
    public void setStreetName(String value) {
        this.streetName = value;
    }

    @Override
    public void setUnitType(String value) {
        this.unitType = value;
    }

    @Override
    public void setUnitValue(String value) {
        this.unitValue = value;
    }

    @Override
    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        GeocodeUtils.appendNonNullValues(stringBuilder, "place name: ", this.getPlaceName());
        GeocodeUtils.appendNonNullValues(stringBuilder, "main address line: ", this.getMainAddressLine());
        GeocodeUtils.appendNonNullValues(stringBuilder, "last line: ", this.getAddressLastLine());
        GeocodeUtils.appendNonNullValues(stringBuilder, "area name 1: ", this.getAreaName1());
        GeocodeUtils.appendNonNullValues(stringBuilder, "area name 2: ", this.getAreaName2());
        GeocodeUtils.appendNonNullValues(stringBuilder, "area name 3: ", this.getAreaName3());
        GeocodeUtils.appendNonNullValues(stringBuilder, "area name 4: ", this.getAreaName4());
        GeocodeUtils.appendNonNullValues(stringBuilder, "post code 1: ", this.getPostCode1());
        GeocodeUtils.appendNonNullValues(stringBuilder, "post code 2: ", this.getPostCode2());
        GeocodeUtils.appendNonNullValues(stringBuilder, "country: ", this.getCountry());
        GeocodeUtils.appendNonNullValues(stringBuilder, "address number: ", this.getAddressNumber());
        GeocodeUtils.appendNonNullValues(stringBuilder, "street name: ", this.getStreetName());
        GeocodeUtils.appendNonNullValues(stringBuilder, "unit type: ", this.getUnitType());
        GeocodeUtils.appendNonNullValues(stringBuilder, "unit value: ", this.getUnitValue());
        if (this.customFields != null && this.customFields.size() > 0) {
            GeocodeUtils.appendNewline(stringBuilder);
            stringBuilder.append("custom values:");
            for (Map.Entry<String, String> entry : this.customFields.entrySet()) {
                GeocodeUtils.appendNonNullValues(stringBuilder, entry.getKey(), entry.getValue());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<String, Object> convertToMap() {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("mainAddressLine", this.mainAddressLine);
        retVal.put("addressLastLine", this.addressLastLine);
        retVal.put("placeName", this.placeName);
        retVal.put("areaName1", this.areaName1);
        retVal.put("areaName2", this.areaName2);
        retVal.put("areaName3", this.areaName3);
        retVal.put("areaName4", this.areaName4);
        retVal.put("postCode1", this.postCode1);
        retVal.put("postCode2", this.postCode2);
        retVal.put("country", this.country);
        retVal.put("addressNumber", this.addressNumber);
        retVal.put("streetName", this.streetName);
        retVal.put("unitType", this.unitType);
        retVal.put("unitValue", this.unitValue);
        retVal.put("customValues", this.customFields);
        return retVal;
    }
}

