/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.google.common.base.Objects;
import com.mapinfo.geocode.CustomObjectDescriptor;
import com.mapinfo.geocode.GeocodeConfiguration;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.InternalGeocoder;
import com.mapinfo.geocode.Pair;
import com.mapinfo.geocode.api.CapabilitiesResponse;
import com.mapinfo.geocode.api.CustomObject;
import com.mapinfo.geocode.api.GeocodeEngine;
import com.mapinfo.geocode.api.Operation;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.geocode.util.DefaultPreferencesProvider;
import com.mapinfo.geocode.util.OverridablePreferences;
import com.mapinfo.mapmarker.user.MapMarkerJavaAPI;
import com.mapinfo.mapmarker.utils.ISO3166;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GeocodeCapabilitiesResponse
implements CapabilitiesResponse {
    private String serviceName = "Geocoding Server";
    private String serviceDesc = "Provides geocoding and reverse geocoding capabilities";
    private String coreVersion = "1.0";
    private List<String> geocodingEngines = new ArrayList<String>();
    private List<String> supportedCountries = new ArrayList<String>();
    private List<CustomObject> customObjects = new ArrayList<CustomObject>();
    private List<Operation> supportedOperations = new ArrayList<Operation>();
    private List<Pair<String, String>> geocoderVersions = new ArrayList<Pair<String, String>>();
    private static GeocodeConfiguration configuration;
    private static final String WORLD_GEOCODER = "XWG";

    public GeocodeCapabilitiesResponse() {
    }

    public GeocodeCapabilitiesResponse(InternalGeocoder internalGeocoder, String country, String operation) throws GeocodingException {
        configuration = GeocodeConfiguration.getInstance();
        this.supportedCountries = configuration.getSupportedCountries();
        SupportedCountry supportedCountry = new SupportedCountry(country);
        country = supportedCountry.getCountry();
        if (supportedCountry.isValidCountryName() || StringUtils.isEmpty((CharSequence)country)) {
            this.supportedOperations = configuration.getSupportedOperations(country, operation);
            if (this.supportedOperations.size() > 0) {
                this.customObjects = configuration.getCustomObjects();
                Preferences defaultPreferences = DefaultPreferencesProvider.getInstance().getDefaultPreferences();
                if (defaultPreferences != null) {
                    OverridablePreferences overridablePreferences = new OverridablePreferences(defaultPreferences);
                    if (country != null && overridablePreferences.hasOverridesForCountry(country)) {
                        defaultPreferences = overridablePreferences.buildPreferenceOverridesForCountry(country);
                    }
                    ArrayList<CustomObject> list = new ArrayList<CustomObject>(this.customObjects.size());
                    for (CustomObject object : this.customObjects) {
                        list.add(new CustomObjectDescriptor(object));
                    }
                    configuration.updateCustomObjectsFromPreferences(list, defaultPreferences);
                }
            }
            this.serviceName = this.prepareServiceName(operation);
            this.serviceDesc = this.prepareServiceDesc(operation);
            this.geocodingEngines = this.prepareGeocodeEngines(configuration, country, operation);
            if (internalGeocoder != null) {
                if (StringUtils.isEmpty((CharSequence)operation)) {
                    MapMarkerJavaAPI mapMarker = internalGeocoder.getMapMarkerAPI();
                    this.coreVersion = mapMarker.getSupportedVersions().getCoreVersion();
                } else {
                    this.coreVersion = null;
                }
            }
            this.prepareGeocoderVersionsAndSupportedCountries(internalGeocoder, country, operation);
        } else {
            this.emptyResponse();
        }
    }

    private void emptyResponse() {
        this.supportedCountries = null;
        this.serviceName = null;
        this.serviceDesc = null;
        this.customObjects = null;
        this.supportedOperations = null;
        this.geocodingEngines = null;
        this.coreVersion = null;
        this.geocoderVersions = null;
    }

    private List<String> prepareGeocodeEngines(GeocodeConfiguration configuration, String country, String operation) {
        ArrayList<String> local = null;
        if (!StringUtils.isEmpty((CharSequence)operation)) {
            return local;
        }
        local = new ArrayList<String>();
        for (GeocodeEngine engine : configuration.getEngines(country)) {
            local.add(engine.getName());
        }
        return local;
    }

    private String prepareServiceDesc(String operation) {
        if (!StringUtils.isEmpty((CharSequence)configuration.getServiceDesc()) && StringUtils.isEmpty((CharSequence)operation)) {
            return configuration.getServiceDesc();
        }
        if (!StringUtils.isEmpty((CharSequence)configuration.getServiceDesc()) && !StringUtils.isEmpty((CharSequence)operation)) {
            return null;
        }
        return this.serviceDesc;
    }

    private String prepareServiceName(String operation) {
        if (!StringUtils.isEmpty((CharSequence)configuration.getServiceName()) && StringUtils.isEmpty((CharSequence)operation)) {
            return configuration.getServiceName();
        }
        if (!StringUtils.isEmpty((CharSequence)configuration.getServiceName()) && !StringUtils.isEmpty((CharSequence)operation)) {
            return null;
        }
        return this.serviceName;
    }

    private void prepareGeocoderVersionsAndSupportedCountries(InternalGeocoder internalGeocoder, String country, String operation) {
        if (!StringUtils.isEmpty((CharSequence)operation)) {
            this.geocoderVersions = null;
            this.supportedCountries = null;
            return;
        }
        this.supportedCountries.clear();
        HashSet<String> isoCountrySet = new HashSet<String>();
        for (GeocodeEngine engine : configuration.getEngines(country)) {
            String version = engine.getVersion();
            if (version == null && internalGeocoder != null) {
                MapMarkerJavaAPI mapMarker = internalGeocoder.getMapMarkerAPI();
                version = mapMarker.getSupportedVersions().getVersion(ISO3166.findCountryByISO3((String)engine.getPrimaryCountry()));
            }
            if (StringUtils.isEmpty((CharSequence)country)) {
                this.geocoderVersions.add(new Pair<String, String>(engine.getName(), version));
                for (String isoCountry : engine.getSupportedCountries()) {
                    isoCountrySet.add(isoCountry);
                }
                continue;
            }
            if (!engine.getSupportedCountries().contains(country.toUpperCase())) continue;
            this.geocoderVersions.add(new Pair<String, String>(engine.getName(), version));
            for (String isoCountry : engine.getSupportedCountries()) {
                isoCountrySet.add(isoCountry);
            }
        }
        this.supportedCountries = new ArrayList<String>(isoCountrySet);
    }

    public GeocodeCapabilitiesResponse(InternalGeocoder geocoder) throws GeocodingException {
        this(geocoder, null, null);
    }

    @Override
    public void setServiceName(String name) {
        this.serviceName = name;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceDesc(String desc) {
        this.serviceDesc = desc;
    }

    @Override
    public String getServiceDesc() {
        return this.serviceDesc;
    }

    @Override
    public void setCoreVersion(String desc) {
        this.coreVersion = desc;
    }

    @Override
    public String getCoreVersion() {
        return this.coreVersion;
    }

    @Override
    public void setSupportedCountries(List<String> countries) {
        this.supportedCountries = countries;
    }

    @Override
    public List<String> getSupportedCountries() {
        return this.supportedCountries;
    }

    @Override
    public void setCustomObjects(List<CustomObject> customObjects) {
        this.customObjects = customObjects;
    }

    @Override
    public List<CustomObject> getCustomObjects() {
        return this.customObjects;
    }

    @Override
    public void setGeocoderVersions(List<Pair<String, String>> geocoderVersions) {
        this.geocoderVersions = geocoderVersions;
    }

    @Override
    public List<Pair<String, String>> getGeocoderVersions() {
        return this.geocoderVersions;
    }

    @Override
    public void setSupportedOperations(List<Operation> operations) {
        this.supportedOperations = operations;
    }

    @Override
    public List<Operation> getSupportedOperations() {
        return this.supportedOperations;
    }

    @Override
    public List<String> getGeocodingEngines() {
        return this.geocodingEngines;
    }

    @Override
    public void setGeocodingEngines(List<String> geocodeEngines) {
        this.geocodingEngines = geocodeEngines;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("serviceName", (Object)this.serviceName).add("serviceDesc", (Object)this.serviceDesc).add("coreVersion", (Object)this.coreVersion).add("geocodingEngines", this.geocodingEngines).add("supportedOperations", this.supportedOperations).add("supportedCountries", this.supportedCountries).add("customObjects", this.customObjects).add("geocoderVersions", this.geocoderVersions).toString();
    }

    private class SupportedCountry {
        private boolean isValidCountryName = true;
        private String country;

        public SupportedCountry(String country) {
            if (country != null) {
                this.country = country;
                if (ConfigurationManager.isISO3Valid(country)) {
                    if (GeocodeCapabilitiesResponse.this.supportedCountries.contains(country)) {
                        this.country = country;
                    } else if (GeocodeCapabilitiesResponse.this.supportedCountries.contains(GeocodeCapabilitiesResponse.WORLD_GEOCODER)) {
                        this.country = GeocodeCapabilitiesResponse.WORLD_GEOCODER;
                    }
                } else if (GeocodeCapabilitiesResponse.WORLD_GEOCODER.equals(country)) {
                    this.country = country;
                } else {
                    this.isValidCountryName = false;
                }
            }
        }

        public boolean isValidCountryName() {
            return this.isValidCountryName;
        }

        public String getCountry() {
            return this.country;
        }
    }
}

