/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.CountrySupport;
import com.mapinfo.geocode.CustomObjectDescriptor;
import com.mapinfo.geocode.CustomObjectMember;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodeCapabilitiesResponse;
import com.mapinfo.geocode.GeocodeMatchFields;
import com.mapinfo.geocode.GeocodeOperation;
import com.mapinfo.geocode.Geocoder;
import com.mapinfo.geocode.GeocodingEngine;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.InputParameter;
import com.mapinfo.geocode.OutputParameter;
import com.mapinfo.geocode.Pair;
import com.mapinfo.geocode.SupportLevel;
import com.mapinfo.geocode.api.CustomObject;
import com.mapinfo.geocode.api.DataType;
import com.mapinfo.geocode.api.Dictionary;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.GeocodeEngine;
import com.mapinfo.geocode.api.InputParam;
import com.mapinfo.geocode.api.Operation;
import com.mapinfo.geocode.api.OutputParam;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.SupportLevelDescriptor;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.geocode.util.GeocoderPreferencesFactory;
import com.mapinfo.geocode.util.OverridablePreferences;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocodeConfiguration {
    private static final String xmlConfigFileName = "configuration.xml";
    private static final Logger logger = LoggerFactory.getLogger(GeocodeCapabilitiesResponse.class);
    public static final String CUSTOMOBJECTS = "customobjects";
    public static final String CUSTOMOBJECT = "customobject";
    public static final String OPERATIONS = "operations";
    public static final String GEOCODING_ENGINES = "geocodingEngines";
    public static final String GEOCODING_ENGINE = "geocodingEngine";
    public static final String OPERATION = "operation";
    public static final String CUSTOM_VALUES = "customValues";
    public static final String CUSTOM_VALUE = "customValue";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String INPUT_PARAM = "inputParam";
    public static final String OUTPUT_PARAM = "outputParam";
    public static final String TYPE = "type";
    public static final String BASE = "base";
    public static final String DEFVAL = "defval";
    public static final String HIGHVAL = "highval";
    public static final String LOWVAL = "lowval";
    public static final String OPTIONAL = "optional";
    public static final String VINTAGE = "vintage";
    public static final String VERSION = "version";
    public static final String ONEOF = "oneof";
    public static final String SUPPORTED_COUNTRIES = "supportedCountries";
    public static final String SUPPORTED_DICTIONARIES = "supportedDictionaries";
    public static final String UNSUPPORTED_OPERATIONS = "unsupportedOperations";
    public static final String MATCH_MODE_OVERRIDE = "matchModeOverride";
    public static final String MUST_MATCH_INPUT = "INPUT";
    public static final String MUST_MATCH_POSTCODE = "POSTCODE";
    public static final String MUST_MATCH_STREET = "STREET";
    public static final String MUST_MATCH_NUMBER = "NUMBER";
    public static final String MUST_MATCH_AREA1 = "AREA1";
    public static final String MUST_MATCH_AREA2 = "AREA2";
    public static final String MUST_MATCH_AREA3 = "AREA3";
    public static final String MUST_MATCH_AREA4 = "AREA4";
    public static final String MEMBER = "member";
    public static final String PRIMARY_COUNTRY = "primaryCountry";
    private static final String BASE_COUNTRY = "XXX";
    private String serviceName;
    private String serviceDesc;
    private List<CustomObject> customObjects;
    private List<GeocodeEngine> engines;
    private Set<String> supportedCountries;
    private Map<String, FieldsMatching> customMatchingMap;
    private static final int COMPLETE_DATA_TYPES = 15;
    List<OperationFilter> allOperationsByCountry;
    private static GeocodeConfiguration configuration;
    private static final AtomicBoolean configIsCreated;

    public static GeocodeConfiguration getInstance() throws GeocodingException {
        if (configIsCreated.compareAndSet(false, true)) {
            configuration = new GeocodeConfiguration();
        }
        return configuration;
    }

    public static void reset() throws GeocodingException {
        configIsCreated.set(false);
        GeocodeConfiguration.getInstance();
    }

    private GeocodeConfiguration() throws GeocodingException {
        List<Element> localGeocoders;
        XMLConfiguration xmlConfiguration;
        block8: {
            this.customObjects = new ArrayList<CustomObject>();
            this.engines = new ArrayList<GeocodeEngine>();
            this.supportedCountries = new HashSet<String>();
            File xmlConfigFile = new File(Geocoder.getConfigurationLocation().toAbsolutePath().toString(), xmlConfigFileName);
            try {
                if (xmlConfigFile != null && xmlConfigFile.exists()) {
                    xmlConfiguration = new XMLConfiguration(xmlConfigFile);
                    break block8;
                }
                xmlConfiguration = new XMLConfiguration();
                InputStream inputStream = this.getClass().getResourceAsStream("/configuration.xml");
                if (inputStream != null) {
                    xmlConfiguration.load(inputStream);
                    break block8;
                }
                throw new GeocodingException(String.format("Configuration file %s at %s could not find", xmlConfigFileName, Geocoder.getConfigurationLocation().toAbsolutePath().toString()), ExceptionCode.INTERNAL_ERROR);
            }
            catch (ConfigurationException ce) {
                logger.debug("Configuration Exception while attempting to parse the xml configuration file {}", (Object)xmlConfigFile, (Object)ce);
                throw new GeocodingException(String.format("Configuration file %s at %s could not be parsed", xmlConfigFileName, Geocoder.getConfigurationLocation()), ExceptionCode.INTERNAL_ERROR, ce);
            }
        }
        try {
            localGeocoders = ConfigurationManager.collectAllLocalCapabilitiesFiles();
        }
        catch (IOException ex) {
            logger.debug("Unable to read local configuration xml file {}", (Throwable)ex);
            throw new GeocodingException(ex.getMessage(), ExceptionCode.INTERNAL_ERROR, ex);
        }
        this.serviceName = xmlConfiguration.getString(NAME);
        this.serviceDesc = xmlConfiguration.getString(DESCRIPTION);
        this.customObjects = this.getCustomObjectsFromNode(this.getConfig(CUSTOMOBJECTS, xmlConfiguration));
        this.updateCustomObjectsFromPreferences(this.customObjects, GeocoderPreferencesFactory.getDefaultPreferences());
        this.allOperationsByCountry = this.getSupportedOperationFromNode(this.getConfig(OPERATIONS, xmlConfiguration), localGeocoders);
        this.customMatchingMap = Collections.unmodifiableMap(this.buildCustomMatchModeOverrideMap(localGeocoders));
        XMLConfiguration engineConfig = ConfigurationManager.collectAllMatches(localGeocoders);
        if (!engineConfig.isEmpty()) {
            this.engines = this.getGeocodingEnginesFromNode(this.getConfig(GEOCODING_ENGINES, engineConfig));
        } else {
            logger.debug("engines are empty ****");
        }
    }

    public List<OperationFilter> getSupportedOperationFromNode(HierarchicalConfiguration node, List<Element> localGeocoders) {
        ArrayList<OperationFilter> operations_desc = new ArrayList<OperationFilter>();
        for (HierarchicalConfiguration operationNode : node.configurationsAt(OPERATION)) {
            GeocodeOperation operation = new GeocodeOperation();
            operation.setName(operationNode.getString(NAME));
            ArrayList<InputParam> inputParams = new ArrayList<InputParam>();
            ArrayList<InputParam> optionalInputParams = new ArrayList<InputParam>();
            List<InputParamWrapper> inputParamWrappers = this.getInputParamWrappersFromNode(operationNode);
            for (InputParamWrapper wrapper : inputParamWrappers) {
                if (wrapper.isOptional) {
                    optionalInputParams.add(wrapper.inputParam);
                    continue;
                }
                inputParams.add(wrapper.inputParam);
            }
            operation.setRequiredInput(inputParams);
            operation.setOptionalInput(optionalInputParams);
            List<OutputParam> outputParams = this.getOutputParamsFromNode(operationNode);
            operation.setOutput(outputParams);
            Map<String, List<SupportLevelDescriptor>> descriptors = this.buildSupportLevelDescriptors(localGeocoders, operation.getName());
            for (String country : descriptors.keySet()) {
                String localCountry = country.substring(0, 3);
                boolean hasCustom = country.endsWith("1");
                operation.setLevelsOfSupport(descriptors.get(country));
                if (operation.getLevelsOfSupport().size() != 0) {
                    operations_desc.add(new OperationFilter(localCountry, hasCustom, operation));
                }
                this.supportedCountries.add(localCountry);
            }
        }
        return operations_desc;
    }

    Map<String, List<SupportLevelDescriptor>> buildSupportLevelDescriptors(List<Element> locals, String operation) {
        HashMap<String, List<SupportLevelDescriptor>> supportLevelDescriptors = new HashMap<String, List<SupportLevelDescriptor>>();
        operation = operation.toLowerCase();
        ArrayList<String> baseCountries = new ArrayList<String>();
        if (locals != null) {
            for (Element local : locals) {
                ArrayList<String> unsupportedOperations = new ArrayList<String>(this.breakAndLowercaseString(local.getChildText(UNSUPPORTED_OPERATIONS)));
                if (unsupportedOperations.contains(operation)) continue;
                ArrayList<String> localCountryList = new ArrayList<String>(this.breakAndUppercaseString(local.getChildText(SUPPORTED_COUNTRIES)));
                Element custom = local.getChild(CUSTOM_VALUES);
                if (custom == null) {
                    baseCountries.addAll(localCountryList);
                    for (String country : localCountryList) {
                        supportLevelDescriptors.put(country.toUpperCase() + 0, this.customDescriptors(custom, operation, localCountryList));
                    }
                    continue;
                }
                for (String country : localCountryList) {
                    supportLevelDescriptors.put(country.toUpperCase() + 1, this.customDescriptors(custom, operation, localCountryList));
                }
            }
        }
        supportLevelDescriptors.put(BASE_COUNTRY, this.customDescriptors(null, operation, baseCountries));
        return supportLevelDescriptors;
    }

    Map<String, FieldsMatching> buildCustomMatchModeOverrideMap(List<Element> locals) {
        HashMap<String, FieldsMatching> matchingMap = new HashMap<String, FieldsMatching>();
        if (locals != null) {
            for (Element local : locals) {
                ArrayList<String> customMustMatch = new ArrayList<String>(this.breakAndUppercaseString(local.getChildText(MATCH_MODE_OVERRIDE)));
                if (customMustMatch.isEmpty()) continue;
                GeocodeMatchFields mustMatch = new GeocodeMatchFields();
                if (customMustMatch.contains(MUST_MATCH_INPUT)) {
                    mustMatch.setMatchOnInputFields(true);
                }
                if (customMustMatch.contains(MUST_MATCH_NUMBER)) {
                    mustMatch.setMatchOnAddressNumber(true);
                }
                if (customMustMatch.contains(MUST_MATCH_STREET)) {
                    mustMatch.setMatchOnStreetName(true);
                }
                if (customMustMatch.contains(MUST_MATCH_POSTCODE)) {
                    mustMatch.setMatchOnPostCode1(true);
                }
                if (customMustMatch.contains(MUST_MATCH_AREA1)) {
                    mustMatch.setMatchOnAreaName1(true);
                }
                if (customMustMatch.contains(MUST_MATCH_AREA2)) {
                    mustMatch.setMatchOnAreaName2(true);
                }
                if (customMustMatch.contains(MUST_MATCH_AREA3)) {
                    mustMatch.setMatchOnAreaName3(true);
                }
                if (customMustMatch.contains(MUST_MATCH_AREA4)) {
                    mustMatch.setMatchOnAreaName4(true);
                }
                ArrayList<String> localCountryList = new ArrayList<String>(this.breakAndUppercaseString(local.getChildText(SUPPORTED_COUNTRIES)));
                for (String country : localCountryList) {
                    matchingMap.put(country.toUpperCase(), mustMatch);
                }
            }
        }
        return matchingMap;
    }

    List<SupportLevelDescriptor> noCustomDescriptors(List<String> localCountryList) {
        ArrayList<SupportLevelDescriptor> descriptors = new ArrayList<SupportLevelDescriptor>();
        SupportLevel descriptor = new SupportLevel();
        descriptor.setCountries(localCountryList);
        this.determineDataSupportLevel(descriptor);
        descriptors.add(descriptor);
        return descriptors;
    }

    List<SupportLevelDescriptor> customDescriptors(Element custom, String operation, List<String> localCountryList) {
        ArrayList<SupportLevelDescriptor> descriptors = new ArrayList();
        if (custom != null) {
            for (Object customValue : custom.getChildren(CUSTOM_VALUE)) {
                List outputs;
                Element customEl = (Element)customValue;
                List<String> operations = this.breakAndLowercaseString(customEl.getChildText(OPERATIONS));
                if (!operations.contains(operation)) continue;
                SupportLevel sld = new SupportLevel();
                sld.setBaseObject(customEl.getChildText(BASE));
                sld.setCountries(localCountryList);
                this.determineDataSupportLevel(sld);
                List inputs = customEl.getChildren(INPUT_PARAM);
                ArrayList<InputParam> optionalInputs = new ArrayList<InputParam>();
                ArrayList<InputParam> requiredInputs = new ArrayList<InputParam>();
                ArrayList<OutputParam> outputParams = new ArrayList<OutputParam>();
                if (inputs != null) {
                    for (Object input : inputs) {
                        Element inputEl = (Element)input;
                        InputParam ip = this.buildInputParamFromElement(inputEl);
                        String isOPt = inputEl.getChildText(OPTIONAL);
                        if (isOPt != null && "true".equalsIgnoreCase(isOPt)) {
                            optionalInputs.add(ip);
                            continue;
                        }
                        requiredInputs.add(ip);
                    }
                    if (!optionalInputs.isEmpty()) {
                        sld.setUpdatedOptionalInput(optionalInputs);
                    }
                    if (!requiredInputs.isEmpty()) {
                        sld.setUpdatedRequiredInput(requiredInputs);
                    }
                }
                if ((outputs = customEl.getChildren(OUTPUT_PARAM)) != null) {
                    for (Object output : outputs) {
                        outputParams.add(this.buildOutputParamFromElement((Element)output));
                    }
                    if (!outputParams.isEmpty()) {
                        sld.setUpdatedOptionalOutput(outputParams);
                    }
                }
                descriptors.add(sld);
            }
        } else {
            descriptors = this.noCustomDescriptors(localCountryList);
        }
        return descriptors;
    }

    private void determineDataSupportLevel(SupportLevelDescriptor supportLevelDescriptor) {
        int dataHash = 0;
        for (String country : supportLevelDescriptor.getCountries()) {
            if (!ConfigurationManager.getDictionaryMap().containsKey(country)) continue;
            for (Dictionary dictionary : ConfigurationManager.getDictionaryMap().get(country)) {
                for (CountrySupport support : dictionary.getCountrySupportInformation()) {
                    for (DataType type : support.getSupportedDataTypes()) {
                        switch (type) {
                            case POINT: {
                                dataHash |= 8;
                                break;
                            }
                            case STREET: {
                                dataHash |= 4;
                                break;
                            }
                            case POST_CODE_1: 
                            case POST_CODE_2: {
                                dataHash |= 1;
                                break;
                            }
                            case AREA_NAME_1: 
                            case AREA_NAME_2: 
                            case AREA_NAME_3: 
                            case AREA_NAME_4: {
                                dataHash |= 2;
                            }
                        }
                        supportLevelDescriptor.setSupportedDataLevel(dataHash);
                        if (dataHash != 15) continue;
                        return;
                    }
                }
            }
        }
    }

    private HierarchicalConfiguration getConfig(String name, XMLConfiguration node) {
        if (node.getRootNode().getChildrenCount(name) == 1) {
            return node.configurationAt(name);
        }
        return null;
    }

    private CustomObjectMember getCustomObjectMemberFromNode(HierarchicalConfiguration node) {
        CustomObjectMember member = new CustomObjectMember();
        member.setName(node.getString(NAME));
        try {
            member.setInput(this.getInputParamFromNode((Configuration)node.configurationAt(INPUT_PARAM)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            member.setOutput(this.getOutputParamFromNode((HierarchicalConfiguration)node.configurationAt(OUTPUT_PARAM)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return member;
    }

    List<OutputParam> getOutputParamsFromNode(HierarchicalConfiguration node) {
        ArrayList<OutputParam> outputParams = new ArrayList<OutputParam>();
        for (HierarchicalConfiguration outputParamNode : node.configurationsAt(OUTPUT_PARAM)) {
            outputParams.add(this.getOutputParamFromNode(outputParamNode));
        }
        return outputParams;
    }

    OutputParam getOutputParamFromNode(HierarchicalConfiguration node) {
        if (node == null) {
            return null;
        }
        OutputParameter outputParam = new OutputParameter();
        outputParam.setName(node.getString(NAME));
        outputParam.setType(node.getString(TYPE));
        outputParam.setDescription(node.getString(DESCRIPTION));
        return outputParam;
    }

    List<InputParamWrapper> getInputParamWrappersFromNode(HierarchicalConfiguration node) {
        ArrayList<InputParamWrapper> inputParams = new ArrayList<InputParamWrapper>();
        for (HierarchicalConfiguration inputParamNode : node.configurationsAt(INPUT_PARAM)) {
            inputParams.add(this.getInputParamWrapperFromNode(inputParamNode));
        }
        return inputParams;
    }

    InputParamWrapper getInputParamWrapperFromNode(HierarchicalConfiguration node) {
        return new InputParamWrapper(this.getInputParamFromNode((Configuration)node), node.getBoolean(OPTIONAL, false));
    }

    private InputParam getInputParamFromNode(Configuration node) {
        if (node == null) {
            return null;
        }
        InputParameter inputParam = new InputParameter();
        inputParam.setName(node.getString(NAME));
        inputParam.setType(node.getString(TYPE));
        inputParam.setDescription(node.getString(DESCRIPTION));
        inputParam.setDefaultValue(node.getString(DEFVAL));
        inputParam.setLowBoundary(node.getString(LOWVAL));
        inputParam.setHighBoundary(node.getString(HIGHVAL));
        if (ONEOF.equalsIgnoreCase(inputParam.getType())) {
            ArrayList<Pair<String, String>> allowed = new ArrayList<Pair<String, String>>();
            for (String str : node.getStringArray("allowedValues")) {
                allowed.add(new Pair<String, String>(str, str));
            }
            inputParam.setAllowedValuesWithDescriptions(allowed);
        }
        return inputParam;
    }

    private InputParam buildInputParamFromElement(Element element) {
        InputParameter inputParam = new InputParameter();
        inputParam.setName(element.getChildText(NAME));
        inputParam.setType(element.getChildText(TYPE));
        inputParam.setDescription(element.getChildText(DESCRIPTION));
        inputParam.setDefaultValue(element.getChildText(DEFVAL));
        inputParam.setLowBoundary(element.getChildText(LOWVAL));
        inputParam.setHighBoundary(element.getChildText(HIGHVAL));
        if (ONEOF.equalsIgnoreCase(inputParam.getType())) {
            ArrayList<Pair<String, String>> allowed = new ArrayList<Pair<String, String>>();
            List values = element.getChildren("allowedValues");
            for (Element value : values) {
                String txt = value.getTextTrim();
                allowed.add(new Pair<String, String>(txt, txt));
            }
            inputParam.setAllowedValuesWithDescriptions(allowed);
        }
        return inputParam;
    }

    private OutputParam buildOutputParamFromElement(Element element) {
        OutputParameter outputParam = new OutputParameter();
        outputParam.setName(element.getChildText(NAME));
        outputParam.setType(element.getChildText(TYPE));
        outputParam.setDescription(element.getChildText(DESCRIPTION));
        return outputParam;
    }

    private List<String> breakAndUppercaseString(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (str == null) {
            return list;
        }
        StringTokenizer pieces = new StringTokenizer(str, ", ");
        while (pieces.hasMoreTokens()) {
            list.add(pieces.nextToken().toUpperCase());
        }
        return list;
    }

    private List<String> breakAndLowercaseString(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (str == null) {
            return list;
        }
        StringTokenizer pieces = new StringTokenizer(str, ", ");
        while (pieces.hasMoreTokens()) {
            list.add(pieces.nextToken().toLowerCase());
        }
        return list;
    }

    private List<String> breakString(String str) {
        String[] pieces;
        ArrayList<String> list = new ArrayList<String>();
        if (str == null) {
            return list;
        }
        for (String piece : pieces = str.split(",")) {
            list.add(piece);
        }
        return list;
    }

    public List<Operation> getSupportedOperations(String country, String operation) {
        List<Operation> operationList = this.filterByCountry(country);
        operationList = this.filterByOperation(operation, operationList);
        return operationList;
    }

    private List<Operation> filterByCountry(String country) {
        ArrayList<Operation> local = new ArrayList<Operation>();
        if (country == null || country.isEmpty()) {
            for (OperationFilter filter : this.allOperationsByCountry) {
                if (!filter.isCustom() && !filter.getCountry().equals(BASE_COUNTRY)) continue;
                local.add(filter.getOperation());
            }
        } else {
            for (OperationFilter filter : this.allOperationsByCountry) {
                if (!filter.getCountry().equalsIgnoreCase(country)) continue;
                local.add(filter.getOperation());
            }
        }
        return local;
    }

    private List<Operation> filterByOperation(String operation, List<Operation> operationList) {
        if (operation == null || operation.isEmpty()) {
            return operationList;
        }
        ArrayList<Operation> local = new ArrayList<Operation>();
        if (operationList != null) {
            for (Operation localOperation : operationList) {
                if (!localOperation.getName().equalsIgnoreCase(operation)) continue;
                local.add(localOperation);
            }
        }
        return local;
    }

    List<GeocodeEngine> getGeocodingEnginesFromNode(HierarchicalConfiguration node) {
        ArrayList<GeocodeEngine> enginesFromNode = new ArrayList<GeocodeEngine>();
        if (node == null) {
            return enginesFromNode;
        }
        for (HierarchicalConfiguration engineNode : node.configurationsAt(GEOCODING_ENGINE)) {
            GeocodingEngine engine = new GeocodingEngine();
            engine.setName(engineNode.getString(NAME));
            engine.setVintage(engineNode.getString(VINTAGE));
            engine.setVersion(engineNode.getString(VERSION));
            engine.setPrimaryCountry(engineNode.getString(PRIMARY_COUNTRY));
            engine.setSupportedCountries(this.breakString(engineNode.getString(SUPPORTED_COUNTRIES)));
            engine.setDictionaryOrdering(this.breakString(engineNode.getString(SUPPORTED_DICTIONARIES)));
            enginesFromNode.add(engine);
        }
        return enginesFromNode;
    }

    List<CustomObject> getCustomObjectsFromNode(HierarchicalConfiguration node) {
        ArrayList<CustomObject> customObjectsFromNode = new ArrayList<CustomObject>();
        if (node == null) {
            return customObjectsFromNode;
        }
        for (HierarchicalConfiguration customObjectNode : node.configurationsAt(CUSTOMOBJECT)) {
            CustomObjectDescriptor customObject = new CustomObjectDescriptor();
            customObject.setName(customObjectNode.getString(NAME));
            customObject.setDescription(customObjectNode.getString(DESCRIPTION));
            ArrayList<CustomObjectMember> members = new ArrayList<CustomObjectMember>();
            for (HierarchicalConfiguration memberNode : customObjectNode.configurationsAt(MEMBER)) {
                members.add(this.getCustomObjectMemberFromNode(memberNode));
            }
            customObject.setMembers(members);
            customObjectsFromNode.add(customObject);
        }
        return customObjectsFromNode;
    }

    public List<GeocodeEngine> getEngines(String country) {
        ArrayList<GeocodeEngine> local = new ArrayList();
        if (!StringUtils.isEmpty((String)country)) {
            block0: for (GeocodeEngine engine : this.engines) {
                if (engine.getPrimaryCountry().equalsIgnoreCase(country)) {
                    local.add(engine);
                    break;
                }
                for (String localCountry : engine.getSupportedCountries()) {
                    if (!localCountry.equalsIgnoreCase(country)) continue;
                    GeocodeEngine localEngine = (GeocodeEngine)SerializationUtils.clone((Serializable)engine);
                    Iterator<String> countryItr = localEngine.getSupportedCountries().iterator();
                    while (countryItr.hasNext()) {
                        if (countryItr.next().equalsIgnoreCase(country)) continue;
                        countryItr.remove();
                    }
                    local.add(localEngine);
                    continue block0;
                }
            }
        } else {
            local = this.engines;
        }
        return local;
    }

    public String getPrimaryCountry(String country) {
        if (StringUtils.isEmpty((String)country) || this.engines == null) {
            return country;
        }
        for (GeocodeEngine engine : this.engines) {
            if (engine.getPrimaryCountry().equalsIgnoreCase(country)) {
                return country;
            }
            for (String localCountry : engine.getSupportedCountries()) {
                if (!localCountry.equalsIgnoreCase(country)) continue;
                return engine.getPrimaryCountry();
            }
        }
        return country;
    }

    void updateCustomObjectsFromPreferences(List<CustomObject> customObjectList, Preferences defaultPrefs) {
        boolean foundPrefs = false;
        boolean foundRFD = false;
        boolean foundMF = false;
        for (CustomObject customObject : customObjectList) {
            String name = customObject.getName();
            if ("preferences".equals(name)) {
                foundPrefs = true;
            } else if ("ReturnFieldsDescriptor".equals(name)) {
                foundRFD = true;
            } else {
                if (!"FieldsMatching".equals(name)) continue;
                foundMF = true;
            }
            for (CustomObjectMember member : customObject.getMembers()) {
                StringBuilder stringBuilder = new StringBuilder(".");
                stringBuilder.append(member.getName());
                String defString = OverridablePreferences.getValueAsString(defaultPrefs, stringBuilder.toString());
                if (defString == null) continue;
                member.getInput().setDefaultValue(defString);
            }
            if (!foundMF || !foundPrefs || !foundRFD) continue;
            break;
        }
    }

    public List<GeocodeEngine> getEngines() {
        return this.getEngines(null);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceDesc() {
        return this.serviceDesc;
    }

    public List<CustomObject> getCustomObjects() {
        return this.customObjects;
    }

    public List<String> getSupportedCountries() {
        ArrayList<String> local = new ArrayList<String>();
        local.addAll(this.supportedCountries);
        local.remove(BASE_COUNTRY);
        return local;
    }

    public FieldsMatching getCustomMatching(String country) {
        return country == null ? null : this.customMatchingMap.get(country.toUpperCase());
    }

    static {
        configIsCreated = new AtomicBoolean(false);
    }

    public class OperationFilter {
        private boolean custom;
        private String country;
        private Operation operation;

        public OperationFilter(String country, boolean custom, Operation operation) {
            this.country = country;
            this.custom = custom;
            this.operation = this.newInstance(operation);
        }

        private Operation newInstance(Operation operation) {
            GeocodeOperation local = new GeocodeOperation();
            local.setRequiredInput(operation.getRequiredInput());
            local.setLevelsOfSupport(operation.getLevelsOfSupport());
            local.setName(operation.getName());
            local.setOptionalInput(operation.getOptionalInput());
            local.setOutput(operation.getOutput());
            return local;
        }

        public String getCountry() {
            return this.country;
        }

        public boolean isCustom() {
            return this.custom;
        }

        public Operation getOperation() {
            return this.operation;
        }
    }

    private class InputParamWrapper {
        final InputParam inputParam;
        final boolean isOptional;

        public InputParamWrapper(InputParam inputParam, boolean isOptional) {
            this.inputParam = inputParam;
            this.isOptional = isOptional;
        }
    }
}

