/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.GeoSerialize;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.mapmarker.CandidateAddress;
import java.util.HashMap;
import java.util.Map;

public class GeocodeMatchFields
implements FieldsMatching,
GeoSerialize {
    private boolean matchOnAddressNumber;
    private boolean matchOnPostCode1;
    private boolean matchOnPostCode2;
    private boolean matchOnAreaName1;
    private boolean matchOnAreaName2;
    private boolean matchOnAreaName3;
    private boolean matchOnAreaName4;
    private boolean matchOnAllStreetFields;
    private boolean matchOnStreetName;
    private boolean matchOnStreetType;
    private boolean matchOnStreetDirectional;
    private boolean matchOnPlaceName;
    private boolean matchOnInputFields;

    public GeocodeMatchFields() {
    }

    public GeocodeMatchFields(FieldsMatching orig) {
        this.matchOnAddressNumber = orig.isMatchOnAddressNumber();
        this.matchOnPostCode1 = orig.isMatchOnPostCode1();
        this.matchOnPostCode2 = orig.isMatchOnPostCode2();
        this.matchOnAreaName1 = orig.isMatchOnAreaName1();
        this.matchOnAreaName2 = orig.isMatchOnAreaName2();
        this.matchOnAreaName3 = orig.isMatchOnAreaName3();
        this.matchOnAreaName4 = orig.isMatchOnAreaName4();
        this.matchOnPlaceName = orig.isMatchOnPlaceName();
        this.matchOnAllStreetFields = orig.isMatchOnAllStreetFields();
        this.matchOnStreetType = orig.isMatchOnStreetType();
        this.matchOnStreetName = orig.isMatchOnStreetName();
        this.matchOnStreetDirectional = orig.isMatchOnStreetDirectional();
        this.matchOnInputFields = orig.isMatchOnInputFields();
    }

    GeocodeMatchFields(CandidateAddress mmCand) {
        this.matchOnPlaceName = mmCand.doesPlaceNameMatch();
        this.matchOnAddressNumber = mmCand.doesAddressNumberMatch();
        this.matchOnPostCode1 = mmCand.doesPostalCode1Match();
        this.matchOnPostCode2 = mmCand.doesPostalCode2Match();
        this.matchOnAreaName1 = mmCand.doesAreaName1Match();
        this.matchOnAreaName2 = mmCand.doesAreaName2Match();
        this.matchOnAreaName3 = mmCand.doesAreaName3Match();
        this.matchOnAreaName4 = mmCand.doesAreaName4Match();
        this.matchOnStreetName = mmCand.doesStreetNameMatch();
        this.matchOnStreetDirectional = mmCand.doesPreDirectionalMatch() && mmCand.doesPostDirectionalMatch();
        this.matchOnStreetType = mmCand.doesThoroughfareTypeMatch();
        this.matchOnAllStreetFields = this.matchOnStreetDirectional & this.matchOnStreetType & this.matchOnStreetName & mmCand.doStreetPrefixAndSuffixMatch();
    }

    @Override
    public boolean isMatchOnAddressNumber() {
        return this.matchOnAddressNumber;
    }

    @Override
    public boolean isMatchOnPostCode1() {
        return this.matchOnPostCode1;
    }

    @Override
    public boolean isMatchOnPostCode2() {
        return this.matchOnPostCode2;
    }

    @Override
    public boolean isMatchOnAreaName1() {
        return this.matchOnAreaName1;
    }

    @Override
    public boolean isMatchOnAreaName2() {
        return this.matchOnAreaName2;
    }

    @Override
    public boolean isMatchOnAreaName3() {
        return this.matchOnAreaName3;
    }

    @Override
    public boolean isMatchOnAreaName4() {
        return this.matchOnAreaName4;
    }

    @Override
    public boolean isMatchOnAllStreetFields() {
        return this.matchOnAllStreetFields;
    }

    @Override
    public boolean isMatchOnStreetName() {
        return this.matchOnStreetName;
    }

    @Override
    public boolean isMatchOnStreetType() {
        return this.matchOnStreetType;
    }

    @Override
    public boolean isMatchOnStreetDirectional() {
        return this.matchOnStreetDirectional;
    }

    @Override
    public boolean isMatchOnInputFields() {
        return this.matchOnInputFields;
    }

    @Override
    public void setMatchOnAddressNumber(boolean bMatch) {
        this.matchOnAddressNumber = bMatch;
    }

    @Override
    public void setMatchOnPostCode1(boolean bMatch) {
        this.matchOnPostCode1 = bMatch;
    }

    @Override
    public void setMatchOnPostCode2(boolean bMatch) {
        this.matchOnPostCode2 = bMatch;
    }

    @Override
    public void setMatchOnAreaName1(boolean bMatch) {
        this.matchOnAreaName1 = bMatch;
    }

    @Override
    public void setMatchOnAreaName2(boolean bMatch) {
        this.matchOnAreaName2 = bMatch;
    }

    @Override
    public void setMatchOnAreaName3(boolean bMatch) {
        this.matchOnAreaName3 = bMatch;
    }

    @Override
    public void setMatchOnAreaName4(boolean bMatch) {
        this.matchOnAreaName4 = bMatch;
    }

    @Override
    public void setMatchOnAllStreetFields(boolean bMatch) {
        this.matchOnAllStreetFields = bMatch;
    }

    @Override
    public void setMatchOnStreetName(boolean bMatch) {
        this.matchOnStreetName = bMatch;
    }

    @Override
    public void setMatchOnStreetType(boolean bMatch) {
        this.matchOnStreetType = bMatch;
    }

    @Override
    public void setMatchOnStreetDirectional(boolean bMatch) {
        this.matchOnStreetDirectional = bMatch;
    }

    @Override
    public boolean isMatchOnPlaceName() {
        return this.matchOnPlaceName;
    }

    @Override
    public void setMatchOnPlaceName(boolean matchOnPlaceName) {
        this.matchOnPlaceName = matchOnPlaceName;
    }

    @Override
    public void setMatchOnInputFields(boolean bMatch) {
        this.matchOnInputFields = bMatch;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("Match on fields: ");
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("address number: ");
        stringBuilder.append(this.matchOnAddressNumber);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("post code1: ");
        stringBuilder.append(this.matchOnPostCode1);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("post code2: ");
        stringBuilder.append(this.matchOnPostCode2);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("areaName1: ");
        stringBuilder.append(this.matchOnAreaName1);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("areaName2: ");
        stringBuilder.append(this.matchOnAreaName2);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("areaName3: ");
        stringBuilder.append(this.matchOnAreaName3);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("areaName4: ");
        stringBuilder.append(this.matchOnAreaName4);
        GeocodeUtils.appendNewline(stringBuilder);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("allStreetFields: ");
        stringBuilder.append(this.matchOnAllStreetFields);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("streetName: ");
        stringBuilder.append(this.matchOnStreetName);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("streettype: ");
        stringBuilder.append(this.matchOnStreetType);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("streetDirectional: ");
        stringBuilder.append(this.matchOnStreetDirectional);
        stringBuilder.append("inputFields: ");
        stringBuilder.append(this.matchOnInputFields);
        GeocodeUtils.appendNewline(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public Map<String, Object> convertToMap() {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("matchOnAddressNumber", String.valueOf(this.matchOnAddressNumber));
        retVal.put("matchOnPostCode1", String.valueOf(this.matchOnPostCode1));
        retVal.put("matchOnPostCode2", String.valueOf(this.matchOnPostCode2));
        retVal.put("matchOnAreaName1", String.valueOf(this.matchOnAreaName1));
        retVal.put("matchOnAreaName2", String.valueOf(this.matchOnAreaName2));
        retVal.put("matchOnAreaName3", String.valueOf(this.matchOnAreaName3));
        retVal.put("matchOnAreaName4", String.valueOf(this.matchOnAreaName4));
        retVal.put("matchOnAllStreetFields", String.valueOf(this.matchOnAllStreetFields));
        retVal.put("matchOnStreetName", String.valueOf(this.matchOnStreetName));
        retVal.put("matchOnStreetType", String.valueOf(this.matchOnStreetType));
        retVal.put("matchOnStreetDirectional", String.valueOf(this.matchOnStreetDirectional));
        retVal.put("matchOnPlaceName", String.valueOf(this.matchOnPlaceName));
        retVal.put("matchOnInputFields", String.valueOf(this.matchOnInputFields));
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeocodeMatchFields that = (GeocodeMatchFields)o;
        if (this.matchOnAddressNumber != that.matchOnAddressNumber) {
            return false;
        }
        if (this.matchOnAllStreetFields != that.matchOnAllStreetFields) {
            return false;
        }
        if (this.matchOnAreaName1 != that.matchOnAreaName1) {
            return false;
        }
        if (this.matchOnAreaName2 != that.matchOnAreaName2) {
            return false;
        }
        if (this.matchOnAreaName3 != that.matchOnAreaName3) {
            return false;
        }
        if (this.matchOnAreaName4 != that.matchOnAreaName4) {
            return false;
        }
        if (this.matchOnPlaceName != that.matchOnPlaceName) {
            return false;
        }
        if (this.matchOnPostCode1 != that.matchOnPostCode1) {
            return false;
        }
        if (this.matchOnPostCode2 != that.matchOnPostCode2) {
            return false;
        }
        if (this.matchOnStreetDirectional != that.matchOnStreetDirectional) {
            return false;
        }
        if (this.matchOnStreetName != that.matchOnStreetName) {
            return false;
        }
        if (this.matchOnStreetType != that.matchOnStreetType) {
            return false;
        }
        return this.matchOnInputFields == that.matchOnInputFields;
    }

    public int hashCode() {
        int result = this.matchOnAddressNumber ? 1 : 0;
        result = 31 * result + (this.matchOnPostCode1 ? 1 : 0);
        result = 31 * result + (this.matchOnPostCode2 ? 1 : 0);
        result = 31 * result + (this.matchOnAreaName1 ? 1 : 0);
        result = 31 * result + (this.matchOnAreaName2 ? 1 : 0);
        result = 31 * result + (this.matchOnAreaName3 ? 1 : 0);
        result = 31 * result + (this.matchOnAreaName4 ? 1 : 0);
        result = 31 * result + (this.matchOnAllStreetFields ? 1 : 0);
        result = 31 * result + (this.matchOnStreetName ? 1 : 0);
        result = 31 * result + (this.matchOnStreetType ? 1 : 0);
        result = 31 * result + (this.matchOnStreetDirectional ? 1 : 0);
        result = 31 * result + (this.matchOnPlaceName ? 1 : 0);
        result = 31 * result + (this.matchOnInputFields ? 1 : 0);
        return result;
    }
}

