/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.CountrySupport;
import com.mapinfo.geocode.api.Dictionary;
import com.mapinfo.geocode.util.GeocodeUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class GeocoderDictionary
implements Dictionary {
    private String repositoryName;
    private String path;
    private boolean customDictionary;
    private Set<CountrySupport> countrySupportInformation;
    private String vintage;
    private String source;
    private String region;
    private String description;

    public GeocoderDictionary() {
    }

    public GeocoderDictionary(Dictionary dict) {
        this.repositoryName = dict.getRepositoryName();
        this.path = dict.getPath();
        this.customDictionary = dict.isCustomDictionary();
        this.vintage = dict.getVintage();
        this.source = dict.getSource();
        this.region = dict.getRegion();
        this.description = dict.getDescription();
        Set<CountrySupport> otherSupport = dict.getCountrySupportInformation();
        if (otherSupport != null) {
            this.countrySupportInformation = new HashSet<CountrySupport>();
            for (CountrySupport other : otherSupport) {
                this.countrySupportInformation.add(new CountrySupport(other));
            }
        }
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<CountrySupport> getCountrySupportInformation() {
        if (this.countrySupportInformation == null) {
            return Collections.emptySet();
        }
        return this.countrySupportInformation;
    }

    @Override
    public String getVintage() {
        return this.vintage;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isCustomDictionary() {
        return this.customDictionary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setRepositoryName(String name) {
        this.repositoryName = name;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setCountrySupportInformation(Set<CountrySupport> countries) {
        this.countrySupportInformation = countries;
    }

    @Override
    public void setVintage(String vintage) {
        this.vintage = vintage;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public void setCustomDictionary(boolean bCustom) {
        this.customDictionary = bCustom;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public void setRegion(String region) {
        this.region = region;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tRepositoryName: ", this.getRepositoryName());
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tPath: ", this.getPath());
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tSource: ", this.getSource());
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tVintage: ", this.getVintage());
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tDescription: ", this.getDescription());
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tIs custom: ", String.valueOf(this.isCustomDictionary()));
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tRegion: ", String.valueOf(this.getRegion()));
        stringBuilder.append("Supported countries: ");
        GeocodeUtils.appendNewline(stringBuilder);
        if (this.countrySupportInformation != null) {
            for (CountrySupport support : this.countrySupportInformation) {
                stringBuilder.append(support);
                GeocodeUtils.appendNewline(stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeocoderDictionary that = (GeocoderDictionary)o;
        if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.vintage != null ? !this.vintage.equals(that.vintage) : that.vintage != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return this.customDictionary == that.customDictionary;
    }
}

