/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.centrus.geostan.FindProps;
import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.GeographicIteratorEx;
import com.centrus.geostan.GeographicQueryEx;
import com.centrus.geostan.InitProps;
import com.mapinfo.geocode.CountrySupport;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.Geocoder;
import com.mapinfo.geocode.GeocoderDictionary;
import com.mapinfo.geocode.GeocoderPreferences;
import com.mapinfo.geocode.GeocoderResponse;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.DataType;
import com.mapinfo.geocode.api.DefaultMatchMode;
import com.mapinfo.geocode.api.Dictionary;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.GeoStanCandidate;
import com.mapinfo.geocode.api.GeocodeType;
import com.mapinfo.geocode.api.KeyType;
import com.mapinfo.geocode.api.MatchMode;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.geocode.api.ReturnFieldsDescriptor;
import com.mapinfo.geocode.api.StandardMatchMode;
import com.mapinfo.geocode.api.USAMatchMode;
import com.mapinfo.geocode.geostan.GeoStanObject;
import com.mapinfo.geocode.geostan.GeoStanObjectFactory;
import com.mapinfo.geocode.util.DataManagerSettingsMapper;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocoderGeoStan {
    private static final String defaultFileMemoryLimit = "1000";
    private static final double LOCATION_MULTIPLIER = 1000000.0;
    private static final String GEOSTAN_PASSWORD = "77653489";
    private static final String DPV_SECURITY_KEY = "C20E-02A1-8126-A5BF";
    private static final String LACS_SECURITY_KEY = "930F-06A1-A891-45C7";
    private static final Logger logger = LoggerFactory.getLogger(GeocoderGeoStan.class);
    private static final Set<DistanceUnit> metricUnits;
    private AtomicBoolean poolIsOpened = new AtomicBoolean(false);
    private GenericObjectPool<GeoStanObject> m_geoStanPool;

    public GeocoderGeoStan(DataManagerSettingsMapper dataManagerSettingsMapper) throws GeocodingException {
        String dictCount;
        int numInstPropVal;
        Properties props = new Properties();
        try {
            props = dataManagerSettingsMapper.getCountryPropMap().get("USA");
            String libPath = props.getProperty("LIB_PATH", Geocoder.getResourceLocation().toAbsolutePath().toString());
            GeoStan.loadGeoStanLibs((String)libPath);
        }
        catch (Exception e) {
            logger.error("Failure while loading GeoStan libraries from {}", (Object)Geocoder.getResourceLocation());
            logger.error("Failure loading GeoStan properties: properties are {}", props != null ? props.toString() : props);
            logger.debug("Failure while loading GeoStan libraries", (Throwable)e);
            throw new GeocodingException(e.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, e);
        }
        int numInstances = Runtime.getRuntime().availableProcessors();
        String numInstancesProp = props.getProperty("GEOSTAN_INSTANCE_COUNT", "");
        if (GeocodeUtils.canParseInt(numInstancesProp) && (numInstPropVal = Integer.parseInt(numInstancesProp)) > 0 && numInstPropVal < 64) {
            numInstances = numInstPropVal;
        }
        if (GeocodeUtils.canParseInt(dictCount = props.getProperty("DICTIONARY_COUNT", "0")) && Integer.parseInt(dictCount) > 0) {
            if (this.poolIsOpened.compareAndSet(false, true)) {
                this.m_geoStanPool = new GenericObjectPool((PoolableObjectFactory)new GeoStanObjectFactory(this.setupProps(props)), numInstances);
            }
        } else {
            logger.info(String.format("data for %s is not configured", "USA"));
        }
    }

    public GeocoderGeoStan(Properties initProperties) throws GeocodingException {
        try {
            GeoStan.loadGeoStanLibs((String)Geocoder.getResourceLocation().toAbsolutePath().toString());
        }
        catch (GeoStanException e) {
            logger.error("Failure while loading GeoStan libraries");
            throw new GeocodingException(e.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, e);
        }
        int numInstances = Runtime.getRuntime().availableProcessors();
        if (this.poolIsOpened.compareAndSet(false, true)) {
            this.m_geoStanPool = new GenericObjectPool((PoolableObjectFactory)new GeoStanObjectFactory(this.populateInitProp(initProperties)), numInstances);
        }
    }

    private InitProps populateInitProp(Properties initProperties) {
        String suitelinkPath;
        String lacslinkPath;
        String dpvPath;
        String elevationPath;
        Boolean elvCode;
        String apnPath;
        String dataPath = (String)initProperties.get("DATA_PATH");
        InitProps initProps = new InitProps();
        initProps.clear();
        initProps.set(4, Integer.valueOf(GEOSTAN_PASSWORD).intValue());
        this.initDefaultProps(initProps);
        initProps.set(16, Integer.valueOf((String)initProperties.get("FILE_MEMORY_LIMIT")).intValue());
        initProps.set(3, (String)initProperties.get("Z4_FILE_PATH"));
        Boolean apnCode = (Boolean)initProperties.get("APN_CODE");
        if (apnCode != null && apnCode.booleanValue() && (apnPath = (String)initProperties.get("APN_PATH")) != null && !apnPath.trim().isEmpty()) {
            initProps.set(10, true);
            dataPath = dataPath + ";" + apnPath;
        }
        if ((elvCode = (Boolean)initProperties.get("ELV_CODE")) != null && elvCode.booleanValue() && (elevationPath = (String)initProperties.get("ELEVATION_PATH")) != null && !elevationPath.trim().isEmpty()) {
            initProps.set(11, true);
            dataPath = dataPath + ";" + elevationPath;
        }
        if ((dpvPath = (String)initProperties.get("DPV_PATH")) != null && !dpvPath.trim().isEmpty()) {
            initProps.set(14, true);
            initProps.set(18, dpvPath);
            String dpvSecurityKey = (String)initProperties.get("DPV_SECURITY_KEY");
            if (dpvSecurityKey == null || dpvSecurityKey.trim().isEmpty()) {
                dpvSecurityKey = DPV_SECURITY_KEY;
            }
            initProps.set(19, dpvSecurityKey);
            initProps.set(17, 1);
        }
        if ((lacslinkPath = (String)initProperties.get("LACSLINK_PATH")) != null && !lacslinkPath.trim().isEmpty()) {
            String lacsSecurityKey = (String)initProperties.get("LACS_SECURITY_KEY");
            if (lacsSecurityKey == null || lacsSecurityKey.trim().isEmpty()) {
                lacsSecurityKey = LACS_SECURITY_KEY;
            }
            initProps.set(15, true);
            initProps.set(20, lacslinkPath);
            initProps.set(21, lacsSecurityKey);
        }
        if ((suitelinkPath = (String)initProperties.get("SUITELINK_PATH")) != null && !suitelinkPath.trim().isEmpty()) {
            initProps.set(24, suitelinkPath);
            initProps.set(23, true);
        }
        initProps.set(2, dataPath);
        return initProps;
    }

    private InitProps setupProps(Properties props) throws GeocodingException {
        String zipPbkeys;
        String SuiteLinkDataPath;
        InitProps initProps = new InitProps();
        initProps.clear();
        String password = props.getProperty("PASSWORD", GEOSTAN_PASSWORD);
        String license = props.getProperty("LICENSE_FILE", "");
        String fileMemLimit = props.getProperty("FILE_MEMORY_LIMIT", "");
        String dictCount = props.getProperty("DICTIONARY_COUNT", "");
        if (!GeocodeUtils.canParseInt(password)) {
            logger.warn("Could not parse the PASSWORD property of : {} , in the DataManagerProperties file", (Object)password);
            throw new GeocodingException("Exception while setting initialization properties for GeoStan: could not parse PASSWORD", ExceptionCode.MAPMARKER_FATAL_EXCEPTION);
        }
        if (!GeocodeUtils.canParseInt(fileMemLimit)) {
            logger.debug("Could not parse the INIT_FILE_MEMORY_LIMIT property of : {} , in the DataManagerProperties file. Falling back to default; {}", (Object)fileMemLimit, (Object)defaultFileMemoryLimit);
            fileMemLimit = defaultFileMemoryLimit;
        }
        if (!GeocodeUtils.canParseInt(dictCount)) {
            logger.warn("Could not parse the DICTIONARY_COUNT property of : {} , in the DataManagerProperties file", (Object)dictCount);
            throw new GeocodingException("Exception while setting initialization properties for GeoStan: could not parse DICTIONARY_COUNT", ExceptionCode.MAPMARKER_FATAL_EXCEPTION);
        }
        initProps.set(1, license);
        initProps.set(4, Integer.parseInt(password));
        initProps.set(16, Integer.parseInt(fileMemLimit));
        this.initDefaultProps(initProps);
        String dictPath = "";
        boolean foundZ9 = false;
        File z9File = null;
        for (int i = 1; i <= Integer.parseInt(dictCount); ++i) {
            String currentDictPath = props.getProperty("DICTIONARY_PATH" + i, "");
            if (currentDictPath.isEmpty()) continue;
            String string = dictPath = dictPath.isEmpty() ? currentDictPath : dictPath + ";" + currentDictPath;
            if (foundZ9 || !(z9File = new File(currentDictPath, "us.z9")).exists()) continue;
            foundZ9 = true;
        }
        String DPVDataPath = props.getProperty("DPV_DATA_PATH", "");
        String DPVSecKey = props.getProperty("DPV_SECURITY_KEY", DPV_SECURITY_KEY);
        if (!DPVDataPath.isEmpty() && !DPVSecKey.isEmpty()) {
            initProps.set(14, true);
            initProps.set(18, DPVDataPath);
            initProps.set(19, DPVSecKey);
            initProps.set(17, 1);
        }
        String LACSDataPath = props.getProperty("LACS_DATA_PATH", "");
        String LACSSecKey = props.getProperty("LACS_SECURITY_KEY", LACS_SECURITY_KEY);
        if (!LACSDataPath.isEmpty() && !LACSSecKey.isEmpty()) {
            initProps.set(15, true);
            initProps.set(20, LACSDataPath);
            initProps.set(21, LACSSecKey);
        }
        if (!(SuiteLinkDataPath = props.getProperty("SUITELINK_DATA_PATH", "")).isEmpty()) {
            initProps.set(24, SuiteLinkDataPath);
            initProps.set(23, true);
        }
        String APNKey = props.getProperty("APN_CODE", "");
        String APNDataPath = props.getProperty("APN_DATA_PATH", "");
        if (!APNKey.isEmpty() && Boolean.parseBoolean(APNKey) && !APNDataPath.isEmpty()) {
            initProps.set(10, true);
            dictPath = dictPath + ";" + APNDataPath;
        }
        String ELVKey = props.getProperty("ELV_CODE", "");
        String ELVDataPath = props.getProperty("ELEVATION_DATA_PATH", "");
        if (!ELVKey.isEmpty() && Boolean.parseBoolean(ELVKey) && !ELVDataPath.isEmpty()) {
            initProps.set(11, Boolean.parseBoolean(ELVKey));
            dictPath = dictPath + ";" + ELVDataPath;
        }
        if (Boolean.parseBoolean(zipPbkeys = props.getProperty("ZIP_PBKEYS", ""))) {
            initProps.set(26, Boolean.parseBoolean(zipPbkeys));
        }
        if (dictPath.isEmpty()) {
            logger.warn("Could find dictionary paths in DataManagerSettingsProperties file");
            throw new GeocodingException("Exception while setting initialization properties for GeoStan: could not find dictionary paths", ExceptionCode.MAPMARKER_FATAL_EXCEPTION);
        }
        if (z9File == null || !z9File.exists()) {
            logger.warn("Could find dictionary paths in DataManagerSettingsProperties file");
            throw new GeocodingException("Exception while setting initialization properties for GeoStan: could not find z9file", ExceptionCode.MAPMARKER_FATAL_EXCEPTION);
        }
        initProps.set(2, dictPath);
        initProps.set(3, z9File.getAbsolutePath());
        return initProps;
    }

    private void initDefaultProps(InitProps initProps) {
        initProps.set(6, true);
        initProps.set(7, true);
        initProps.set(8, true);
        initProps.set(13, 2);
    }

    private GeocoderResponse convertOutputCoords(GeocoderResponse response, String coordSys) {
        CoordSys sys;
        if (!(response.getCandidates().isEmpty() || coordSys == null || coordSys.isEmpty() || CoordSysConstants.longLatWGS84.equivalent(sys = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordSys)) || CoordSysConstants.longLatNAD83.equivalent(sys))) {
            CoordTransform xform = new CoordTransform(CoordSysConstants.longLatNAD83, sys);
            SpatialInfo si = new SpatialInfo(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordSys));
            List<Candidate> newList = response.getCandidates();
            for (Candidate element : newList) {
                if (element.getPoint() == null) continue;
                DirectPosition xformDest = new DirectPosition();
                DirectPosition xformSrc = new DirectPosition(element.getPoint().getX(), element.getPoint().getY());
                xform.transform(xformSrc, xformDest);
                Point point = new Point(si, xformDest);
                element.setPoint((IPoint)point);
            }
            response.setCandidates(newList);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response geocode(GeocodeType type, Address address, Preferences preferences) throws GeocodingException {
        GeoStanObject geoObj = null;
        GeocoderResponse response = new GeocoderResponse();
        try {
            String check;
            boolean noAreaNames;
            geoObj = this.borrowGeoStan();
            GeoStan gs = geoObj.getGsHandle();
            gs.clear();
            FindProps fp = geoObj.getFindProps();
            this.setGeoStanDataFromAddress(gs, address, type);
            Map<String, String> customPrefs = preferences.getCustomPreferences();
            this.convertToForwardFindProps(fp, preferences, type, customPrefs);
            this.canDoForwardGeocode(fp, preferences, type);
            String city = address.getAreaName3();
            String county = address.getAreaName2();
            String state = address.getAreaName1();
            boolean bl = noAreaNames = !(city != null && !city.isEmpty() || county != null && !county.isEmpty() || state != null && !state.isEmpty());
            if (type == GeocodeType.GEOGRAPHIC) {
                if (noAreaNames) {
                    gs.find(fp);
                    city = gs.getInputData(5);
                    state = gs.getInputData(26);
                }
                response.setCandidates(this.getGeographicCentroids(gs, city, county, state, preferences));
            } else {
                boolean badMatch;
                boolean isCenterLineEnabled = Boolean.parseBoolean(customPrefs.get("FIND_CENTERLN_PROJ_OF_POINT"));
                short returnCode = gs.find(fp);
                int numMatches = gs.getNumMatches();
                boolean returnCloseMatches = true;
                if (numMatches > 0) {
                    int numEqualMatches = 1;
                    if (returnCode != 0) {
                        double firstCandScore = 0.0;
                        try {
                            firstCandScore = Double.parseDouble(gs.getMultipleData(38, (short)0));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        for (int i = 1; i < numMatches; i = (int)((short)(i + 1))) {
                            double candScore;
                            try {
                                candScore = Double.parseDouble(gs.getMultipleData(38, (short)i));
                            }
                            catch (NumberFormatException e) {
                                break;
                            }
                            if (candScore != firstCandScore) break;
                            ++numEqualMatches;
                        }
                    }
                    if (returnCloseMatches) {
                        numMatches = numEqualMatches;
                    }
                }
                String matchCode = gs.getData(17);
                boolean bl2 = badMatch = returnCode == 2 && matchCode.startsWith("E0") && !matchCode.equals("E029") && !matchCode.equals("E030");
                if (numMatches > 0 && !badMatch) {
                    response.setCandidates(this.getCandidatesFromGeoStanHandle(gs, fp, isCenterLineEnabled, returnCode, numMatches, preferences, false, false));
                } else if (returnCode == 0 && type == GeocodeType.POSTAL && matchCode.startsWith("Z")) {
                    response.setCandidates(this.getCandidatesFromGeoStanHandle(gs, fp, false, returnCode, 1, preferences, false, true));
                } else if (returnCode == 2 && this.checkCustomDictionaryUsageDisabled(preferences)) {
                    if (preferences.isFallbackToPostal()) {
                        this.setFindPropsForPostalGeocoding(fp);
                        returnCode = gs.find(fp);
                        matchCode = gs.getData(17);
                    }
                    if (returnCode == 0 && matchCode.startsWith("Z")) {
                        response.setCandidates(this.getCandidatesFromGeoStanHandle(gs, fp, false, returnCode, 1, preferences, false, false));
                    } else if (preferences.isFallbackToGeographic()) {
                        fp.set(1000, true);
                        fp.set(1047, false);
                        if (noAreaNames) {
                            city = gs.getInputData(5);
                            state = gs.getInputData(26);
                        }
                        response.setCandidates(this.getGeographicCentroids(gs, city, county, state, preferences));
                    }
                }
            }
            response.setTotalPossibleCandidates(response.getCandidates().size());
            response.setTotalMatches(this.getCloseCandidateCount(response.getCandidates()));
            response = this.convertOutputCoords(response, preferences.getClientCoordSysName());
            if (preferences.getCustomPreferences() != null && (check = preferences.getCustomPreferences().get("RETURN_PARSED_INPUT")) != null && Boolean.valueOf(check.toLowerCase()).booleanValue()) {
                // empty if block
            }
        }
        catch (Exception e) {
            this.geoStanExceptionFilter(e);
        }
        finally {
            this.returnObjectToPool(geoObj);
        }
        return response;
    }

    public Response keyLookup(KeyType keyType, String keyValue, Preferences preferences) throws GeocodingException {
        if (keyType == null) {
            throw new GeocodingException("Null KeyType not supported for USA", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        if (keyValue == null) {
            throw new GeocodingException("Invalid key value", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        switch (keyType) {
            case PB_KEY: {
                return this.pbkeyLookup(keyValue, preferences);
            }
        }
        return new GeocoderResponse();
    }

    protected boolean checkCustomDictionaryUsageDisabled(Preferences preferences) {
        Map<String, String> custom = preferences.getCustomPreferences();
        return custom == null || !"USE_CUSTOM_DICTIONARIES_ONLY".equals(custom.get("KEY_CUSTOM_DICTIONARY_USAGE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response pbkeyLookup(String pbkey, Preferences preferences) throws GeocodingException {
        GeocoderResponse response = new GeocoderResponse();
        if (preferences == null) {
            preferences = new GeocoderPreferences();
        }
        ReturnFieldsDescriptor descriptor = preferences.getReturnFieldsDescriptor();
        HashSet<String> customFields = new HashSet<String>(descriptor.getKeysOfCustomFieldsToReturn());
        customFields.add("PB_KEY");
        descriptor.setKeysOfCustomFieldsToReturn(customFields);
        preferences.setReturnFieldsDescriptor(descriptor);
        GeoStanObject geoObj = null;
        try {
            geoObj = this.borrowGeoStan();
            GeoStan gs = geoObj.getGsHandle();
            FindProps fp = geoObj.getFindProps();
            Map<String, String> customPrefs = preferences.getCustomPreferences();
            this.convertToForwardFindProps(fp, preferences, null, customPrefs);
            gs.clear();
            gs.setData(pbkey, 595);
            short returnCode = gs.find(fp);
            int geoStanCandidates = this.geoStanMultipleCorrectCandidates(gs, returnCode);
            boolean centerlineProj = Boolean.parseBoolean(customPrefs.get("FIND_CENTERLN_PROJ_OF_POINT"));
            response.setCandidates(this.getCandidatesFromGeoStanHandle(gs, fp, centerlineProj, returnCode, geoStanCandidates, preferences, false, false));
        }
        catch (Exception e) {
            this.geoStanExceptionFilter(e);
        }
        finally {
            this.returnObjectToPool(geoObj);
        }
        response.setTotalPossibleCandidates(response.getCandidates().size());
        response.setTotalMatches(this.getCloseCandidateCount(response.getCandidates()));
        response = this.convertOutputCoords(response, preferences.getClientCoordSysName());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response reverseGeocode(IPoint point, Preferences preferences) throws GeocodingException {
        GeoStanObject geoObj = null;
        GeocoderResponse response = new GeocoderResponse();
        Map<String, String> customPrefs = preferences.getCustomPreferences();
        try {
            geoObj = this.borrowGeoStan();
            GeoStan gs = geoObj.getGsHandle();
            FindProps fp = geoObj.getFindProps();
            gs.clear();
            boolean isAPN = Boolean.parseBoolean(customPrefs.get("FIND_APN_SEARCH"));
            this.setRevGeoInput(gs, point);
            this.convertToReverseFindProps(fp, preferences, isAPN, customPrefs);
            this.canDoReverseGeocoding(fp, gs, isAPN);
            short returnCode = gs.find(fp);
            short numMatches = gs.getNumMatches();
            if (numMatches > 0) {
                boolean bConvert;
                response.setCandidates(this.getCandidatesFromGeoStanHandle(gs, fp, false, returnCode, numMatches, preferences, true, false));
                response.setTotalPossibleCandidates(numMatches);
                response.setTotalMatches(this.getCloseCandidateCount(response.getCandidates()));
                response = this.convertOutputCoords(response, preferences.getClientCoordSysName());
                boolean bl = bConvert = preferences.getDistanceUnits() != null && metricUnits.contains((Object)preferences.getDistanceUnits());
                if (bConvert) {
                    List<Candidate> newList = response.getCandidates();
                    for (Candidate element : newList) {
                        String distStr = element.getCustomFieldValue("REVERSE_GEOCODE_DISTANCE");
                        if (distStr == null) continue;
                        Length orig = new Length(Double.parseDouble(distStr), LinearUnit.FOOT);
                        element.getAddress().addCustomField("REVERSE_GEOCODE_DISTANCE", String.valueOf(orig.getValue(LinearUnit.METER)));
                        element.getAddress().addCustomField("REVERSE_GEOCODE_DISTANCE_UNIT", DistanceUnit.METERS.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            this.geoStanExceptionFilter(e);
        }
        finally {
            this.returnObjectToPool(geoObj);
        }
        return response;
    }

    private int geoStanMultipleCorrectCandidates(GeoStan gs, int returnCode) throws GeoStanException {
        int geoStanCandidates = 0;
        if (returnCode == 0 && gs.getNumMatches() == 1) {
            geoStanCandidates = 1;
        } else if (returnCode == 0) {
            String firstScoreString = gs.getMultipleData(38, (short)0);
            double firstScore = firstScoreString == null || firstScoreString.isEmpty() ? 0.0 : Double.parseDouble(firstScoreString);
            for (int i = 0; i < gs.getNumMatches(); ++i) {
                double currentScore;
                String currentScoreString = gs.getMultipleData(38, (short)i);
                double d = currentScore = currentScoreString == null || currentScoreString.isEmpty() ? 0.0 : Double.parseDouble(currentScoreString);
                if (currentScore > firstScore) break;
                ++geoStanCandidates;
            }
        }
        return geoStanCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dictionary> getConfiguredDictionaries() throws GeocodingException {
        if (this.m_geoStanPool == null) {
            return new ArrayList<Dictionary>();
        }
        GeoStanObject geoObj = null;
        ArrayList<Dictionary> dictList = new ArrayList<Dictionary>();
        try {
            geoObj = this.borrowGeoStan();
            GeoStan gs = geoObj.getGsHandle();
            int dbCount = gs.getNumDB();
            dictList = new ArrayList(dbCount);
            for (int dbId = 0; dbId < dbCount; ++dbId) {
                GeocoderDictionary newDict = new GeocoderDictionary();
                String path = gs.getDBMetadata(12, dbId);
                newDict.setPath(path);
                File f = new File(path);
                String name = f.getName();
                newDict.setRepositoryName(name);
                newDict.setVintage(gs.getDBMetadata(11, dbId));
                String dataTypeNumber = gs.getDBMetadata(0, dbId);
                newDict.setCustomDictionary(String.valueOf(10).equals(dataTypeNumber));
                final CountrySupport info = new CountrySupport();
                info.setSupportedCountries((Set<String>)new HashSet<String>(){
                    {
                        this.add("USA");
                    }
                });
                final DataType type = name.toUpperCase().contains("POINT") ? DataType.POINT : DataType.STREET;
                info.setSupportedDataTypes((Set<DataType>)new HashSet<DataType>(){
                    {
                        this.add(type);
                    }
                });
                newDict.setCountrySupportInformation((Set<CountrySupport>)new HashSet<CountrySupport>(){
                    {
                        this.add(info);
                    }
                });
                newDict.setSource(GeoStan.getDataSetName((short)Short.valueOf(dataTypeNumber)));
                newDict.setDescription(gs.getDBMetadata(1, dbId) + "_" + String.valueOf(dbId));
                dictList.add(newDict);
            }
        }
        catch (Exception e) {
            this.geoStanExceptionFilter(e);
        }
        finally {
            this.returnObjectToPool(geoObj);
        }
        return dictList;
    }

    private void canDoForwardGeocode(FindProps fp, Preferences preferences, GeocodeType type) throws GeocodingException, GeoStanException {
        boolean findZ5Code;
        boolean findAddrCode = fp.contains(1000) && fp.getBool(1000);
        boolean findZ9Code = fp.contains(1001) && fp.getBool(1001);
        boolean findZ7Code = fp.contains(1004) && fp.getBool(1004);
        boolean bl = findZ5Code = fp.contains(1005) && fp.getBool(1005);
        if (!(findAddrCode || findZ9Code || findZ7Code || findZ5Code)) {
            throw new GeocodingException("FIND_ADDRCODE or one of the FIND_Z_CODEs should be specified", ExceptionCode.INVALID_CLIENT_INPUT);
        }
    }

    private void canDoReverseGeocoding(FindProps fp, GeoStan gs, boolean isAPN) throws GeoStanException, GeocodingException {
        boolean findNearestUnranged;
        boolean findNearestAddress = fp.contains(1011) && fp.getBool(1011);
        boolean findNearestIntersect = fp.contains(1012) && fp.getBool(1012);
        boolean bl = findNearestUnranged = fp.contains(1013) && fp.getBool(1013);
        if (!(findNearestAddress || findNearestIntersect || findNearestUnranged)) {
            throw new GeocodingException("FIND_NEAREST_ADDRESS or FIND_NEAREST_INTERSECTION or FIND_NEAREST_UNRANGED should be set", ExceptionCode.INVALID_CLIENT_INPUT);
        }
    }

    private void setGeoStanDataFromAddress(GeoStan gs, Address address, GeocodeType type) throws GeoStanException {
        assert (address.getCustomFields() != null);
        if (type == null) {
            type = GeocodeType.ADDRESS;
        }
        gs.clear();
        switch (type) {
            case ADDRESS: 
            case POSTAL: {
                String temp;
                String streetName;
                String mainAddressLine = address.getMainAddressLine() == null ? "" : address.getMainAddressLine();
                String addressNumber = address.getAddressNumber() == null ? "" : address.getAddressNumber();
                String string = streetName = address.getStreetName() == null ? "" : address.getStreetName();
                if (mainAddressLine.isEmpty() && !streetName.isEmpty()) {
                    StringBuilder reformatted = new StringBuilder();
                    if (!addressNumber.isEmpty()) {
                        reformatted.append(addressNumber);
                        reformatted.append(" ");
                    }
                    reformatted.append(streetName);
                    String unitType = address.getUnitType();
                    String unitValue = address.getUnitValue();
                    if (unitType != null && !unitType.isEmpty()) {
                        reformatted.append(" ");
                        reformatted.append(unitType);
                    }
                    if (unitValue != null && !unitValue.isEmpty()) {
                        reformatted.append(" ");
                        reformatted.append(unitValue);
                    }
                    address.setMainAddressLine(reformatted.toString());
                }
                if ((temp = address.getMainAddressLine()) != null && temp.length() > 0) {
                    gs.setData(temp, 1);
                }
                if ((temp = address.getAddressLastLine()) != null && temp.length() > 0) {
                    gs.setData(temp, 10);
                }
                if ((temp = address.getPlaceName()) != null && temp.length() > 0) {
                    gs.setData(temp, 59);
                }
                if ((temp = address.getAreaName1()) != null && temp.length() > 0) {
                    gs.setData(temp, 26);
                }
                if ((temp = address.getAreaName2()) != null && temp.length() > 0) {
                    gs.setData(temp, 64);
                }
                if ((temp = address.getAreaName3()) != null && temp.length() > 0) {
                    gs.setData(temp, 5);
                }
                if ((temp = address.getPostCode1()) != null && temp.length() > 0) {
                    gs.setData(temp, 31);
                }
                if ((temp = address.getPostCode2()) != null && temp.length() > 0) {
                    gs.setData(temp, 32);
                }
                if (address.getCustomFields() == null || !address.getCustomFields().containsKey("ADDR2") || (temp = address.getCustomFields().get("ADDR2")) == null || temp.length() <= 0) break;
                gs.setData(temp, 85);
                break;
            }
            case GEOGRAPHIC: {
                String temp = address.getMainAddressLine();
                if (temp != null && temp.length() > 0) {
                    gs.setData(temp, 1);
                }
                if ((temp = address.getAddressLastLine()) != null && temp.length() > 0) {
                    gs.setData(temp, 10);
                }
                if ((temp = address.getAreaName3()) != null && temp.length() > 0) {
                    gs.setData(temp, 5);
                }
                if ((temp = address.getAreaName2()) != null && temp.length() > 0) {
                    gs.setData(temp, 64);
                }
                if ((temp = address.getAreaName1()) == null || temp.length() <= 0) break;
                gs.setData(temp, 26);
                break;
            }
        }
    }

    private void setRevGeoInput(GeoStan gs, IPoint point) throws GeoStanException {
        CoordSys sys;
        DirectPosition xformDest = new DirectPosition(point.getDirectPosition());
        if (point.getSpatialInfo() != null && !CoordSysConstants.longLatWGS84.equivalent(sys = point.getCoordSys()) && !CoordSysConstants.longLatNAD83.equivalent(sys)) {
            DirectPosition xformSrc = new DirectPosition(point.getDirectPosition());
            CoordTransform xform = new CoordTransform(sys, CoordSysConstants.longLatNAD83);
            xform.transform(xformSrc, xformDest);
        }
        int iLat = (int)(xformDest.getY() * 1000000.0);
        gs.setData(String.valueOf(iLat), 11);
        int iLon = (int)(xformDest.getX() * 1000000.0);
        gs.setData(String.valueOf(iLon), 15);
    }

    private void convertToForwardFindProps(FindProps fp, Preferences preferences, GeocodeType type, Map<String, String> customPrefs) {
        String val;
        int searchDist;
        fp.reset();
        fp.set(1000, true);
        fp.set(1014, true);
        fp.set(1003, 1);
        fp.set(1036, true);
        fp.set(1046, true);
        fp.set(1050, true);
        int matchMode = this.convertMatchMode(preferences.getMatchMode(), customPrefs);
        FieldsMatching mustMatch = preferences.getMustMatchFields();
        if (mustMatch != null && matchMode == 7) {
            if (mustMatch.isMatchOnInputFields()) {
                fp.set(1025, true);
                fp.set(1026, true);
                fp.set(1027, true);
                fp.set(1029, true);
                fp.set(1028, true);
            } else {
                fp.set(1025, mustMatch.isMatchOnAddressNumber());
                fp.set(1026, mustMatch.isMatchOnAllStreetFields());
                fp.set(1027, mustMatch.isMatchOnAreaName1());
                fp.set(1029, mustMatch.isMatchOnAreaName3());
                fp.set(1028, mustMatch.isMatchOnPostCode1());
            }
        }
        int cornerGeoOffset = this.convertOffsetUnitsToFeet(preferences.getCornerOffset(), preferences.getCornerOffsetUnits());
        int streetGeoOffset = this.convertOffsetUnitsToFeet(preferences.getStreetOffset(), preferences.getStreetOffsetUnits());
        fp.set(1017, cornerGeoOffset);
        fp.set(1016, streetGeoOffset);
        fp.set(1018, matchMode);
        if (preferences.getDistance() < 0.0) {
            String warnMsg = "Negative rev geo search distance not allowed: " + preferences.getDistance() + ", capping it to 0.0";
            logger.warn(warnMsg);
            preferences.setDistance(0.0);
        }
        if ((searchDist = this.convertOffsetUnitsToFeet(preferences.getDistance(), preferences.getDistanceUnits())) > 5280) {
            String warnMsg = "Rev geo search distance out of range: " + searchDist + " ft, capping it to 5280";
            logger.warn(warnMsg);
            searchDist = 5280;
        }
        fp.set(1015, searchDist);
        String dual = customPrefs.get("PREFER_POBOX_OVER_STREET");
        if (dual != null && !dual.isEmpty()) {
            if (Boolean.valueOf(dual).booleanValue()) {
                fp.set(1008, true);
                fp.set(1009, false);
            } else {
                fp.set(1008, false);
                fp.set(1009, true);
            }
        }
        if (type == GeocodeType.POSTAL) {
            this.setFindPropsForPostalGeocoding(fp);
        }
        if ((val = customPrefs.get("FIND_SEARCH_AREA")) != null && !val.isEmpty() && GeocodeUtils.canParseInt(val)) {
            fp.set(1003, Integer.parseInt(val));
        }
        if ((val = customPrefs.get("FIND_EXPANDED_SEARCH_RADIUS")) != null && !val.isEmpty() && GeocodeUtils.canParseInt(val)) {
            fp.set(1031, Integer.parseInt(val));
        }
        if ((val = customPrefs.get("FIND_DB_ORDER")) != null && !val.isEmpty()) {
            fp.set(1045, val);
        }
        if ((val = customPrefs.get("FIND_MIXED_CASE")) != null && !val.isEmpty()) {
            fp.set(1038, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_EXPND_SRCH_LIM_TO_STATE")) != null && !val.isEmpty()) {
            fp.set(1032, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_CENTERLINE_OFFSET")) != null && !val.isEmpty() && GeocodeUtils.canParseInt(val)) {
            fp.set(1039, Integer.parseInt(val));
        }
        if ((val = customPrefs.get("FIND_CENTERLN_PROJ_OF_POINT")) != null && !val.isEmpty()) {
            fp.set(1006, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_CORRECT_LASTLINE")) != null && !val.isEmpty()) {
            fp.set(1046, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_FIRST_LETTER_EXPANDED")) != null && !val.isEmpty()) {
            fp.set(1042, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_ALTERNATE_LOOKUP")) != null && !val.isEmpty() && GeocodeUtils.canParseInt(val)) {
            fp.set(1034, Integer.parseInt(val));
        }
        if ((val = customPrefs.get("FIND_PREFER_ZIP_OVER_CITY")) != null && !val.isEmpty()) {
            fp.set(1047, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_ADDR_POINT_INTERP")) != null && !val.isEmpty()) {
            fp.set(1041, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_DPV")) != null && !val.isEmpty()) {
            fp.set(1033, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_LACSLINK")) != null && !val.isEmpty()) {
            fp.set(1035, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_SUITELINK")) != null && !val.isEmpty()) {
            fp.set(1044, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_STREET_CENTROID")) != null && !val.isEmpty()) {
            fp.set(1036, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_ADDRESS_RANGE")) != null && !val.isEmpty()) {
            fp.set(1043, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_Z_CODE")) != null && !val.isEmpty()) {
            fp.set(1014, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_Z9_CODE")) != null && !val.isEmpty()) {
            fp.set(1001, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_Z7_CODE")) != null && !val.isEmpty()) {
            fp.set(1004, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_Z5_CODE")) != null && !val.isEmpty()) {
            fp.set(1005, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_ADDRCODE")) != null && !val.isEmpty()) {
            fp.set(1000, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_BUILDING_SEARCH")) != null && !val.isEmpty()) {
            fp.set(1010, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_PREFER_STREET")) != null && !val.isEmpty()) {
            fp.set(1009, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_PREFER_POBOX")) != null && !val.isEmpty()) {
            fp.set(1008, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_ZIP_SEARCH")) != null && !val.isEmpty()) {
            fp.set(1019, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_CITY_SEARCH")) != null && !val.isEmpty()) {
            fp.set(1020, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_SDX_SEARCH")) != null && !val.isEmpty()) {
            fp.set(1021, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_EXTRA_SEARCH")) != null && !val.isEmpty()) {
            fp.set(1023, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_POINT_ZIP_MATCH")) != null && !val.isEmpty()) {
            fp.set(1040, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_ADDR_POINT_INTERP")) != null && !val.isEmpty()) {
            fp.set(1041, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_WIDE_SEARCH")) != null && !val.isEmpty()) {
            fp.set(1002, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_APPROXIMATE_PBKEY")) != null && !val.isEmpty()) {
            fp.set(1049, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_SEARCH_DIST")) != null && !val.isEmpty()) {
            fp.set(1015, Integer.valueOf(val).intValue());
        }
        if ((val = customPrefs.get("FIND_MATCH_CODE_EXTENDED")) != null && !val.isEmpty()) {
            fp.set(1050, Boolean.parseBoolean(val));
        }
    }

    private void convertToReverseFindProps(FindProps fp, Preferences preferences, boolean isAPN, Map<String, String> customPrefs) throws GeocodingException {
        String val;
        int searchDist;
        fp.reset();
        fp.set(1012, true);
        fp.set(1011, true);
        fp.set(1013, true);
        fp.set(1024, "NAD83");
        if (preferences.getDistance() < 0.0) {
            String warnMsg = "Negative rev geo search distance not allowed: " + preferences.getDistance() + ", capping it to 0.0";
            logger.warn(warnMsg);
            preferences.setDistance(0.0);
        }
        if ((searchDist = this.convertOffsetUnitsToFeet(preferences.getDistance(), preferences.getDistanceUnits())) > 5280) {
            String warnMsg = "Rev geo search distance out of range: " + searchDist + " ft, capping it to 5280";
            logger.warn(warnMsg);
            searchDist = 5280;
        }
        fp.set(1015, searchDist);
        int cornerGeoOffset = this.convertOffsetUnitsToFeet(preferences.getCornerOffset(), preferences.getCornerOffsetUnits());
        fp.set(1017, cornerGeoOffset);
        int streetGeoOffset = this.convertOffsetUnitsToFeet(preferences.getStreetOffset(), preferences.getStreetOffsetUnits());
        fp.set(1016, streetGeoOffset);
        if (isAPN) {
            fp.set(1007, true);
        }
        if ((val = customPrefs.get("FIND_SEARCH_AREA")) != null && !val.isEmpty() && GeocodeUtils.canParseInt(val)) {
            fp.set(1003, Integer.parseInt(val));
        }
        if ((val = customPrefs.get("FIND_EXPANDED_SEARCH_RADIUS")) != null && !val.isEmpty() && GeocodeUtils.canParseInt(val)) {
            fp.set(1031, Integer.parseInt(val));
        }
        if ((val = customPrefs.get("FIND_DB_ORDER")) != null && !val.isEmpty()) {
            fp.set(1045, val);
        }
        if ((val = customPrefs.get("FIND_MIXED_CASE")) != null && !val.isEmpty()) {
            fp.set(1038, Boolean.parseBoolean(val));
        }
        if ((val = customPrefs.get("FIND_EXPND_SRCH_LIM_TO_STATE")) != null && !val.isEmpty()) {
            fp.set(1032, Boolean.parseBoolean(val));
        }
        if (!isAPN) {
            val = customPrefs.get("FIND_SEARCH_DIST");
            if (val != null && !val.isEmpty() && GeocodeUtils.canParseInt(val)) {
                fp.set(1015, Integer.parseInt(val));
            }
            if ((val = customPrefs.get("FIND_CLOSEST_POINT")) != null && !val.isEmpty()) {
                fp.set(1048, Boolean.parseBoolean(val));
            }
            if ((val = customPrefs.get("FIND_NEAREST_INTERSECTION")) != null && !val.isEmpty()) {
                fp.set(1012, Boolean.parseBoolean(val));
            }
            if ((val = customPrefs.get("FIND_NEAREST_ADDRESS")) != null && !val.isEmpty()) {
                fp.set(1011, Boolean.parseBoolean(val));
            }
            if ((val = customPrefs.get("FIND_NEAREST_UNRANGED")) != null && !val.isEmpty()) {
                fp.set(1013, Boolean.parseBoolean(val));
            }
        }
        if ((val = customPrefs.get("FIND_APPROXIMATE_PBKEY")) != null && !val.isEmpty()) {
            fp.set(1049, Boolean.parseBoolean(val));
        }
    }

    private void setFindPropsForPostalGeocoding(FindProps fp) {
        fp.clear();
        fp.set(1047, true);
        fp.set(1000, false);
        fp.set(1014, true);
        fp.set(1046, true);
    }

    private int convertMatchMode(MatchMode matchMode, Map<String, String> customPrefs) {
        String override;
        if (customPrefs != null && (override = customPrefs.get("USA_MATCH_MODE")) != null) {
            if ("CASS".equalsIgnoreCase(override)) {
                return 4;
            }
            if ("INTERACTIVE".equalsIgnoreCase(override)) {
                return 8;
            }
        }
        if (matchMode instanceof USAMatchMode) {
            switch ((USAMatchMode)matchMode) {
                case RELAXED: {
                    return 2;
                }
                case EXACT: {
                    return 0;
                }
                case STANDARD: {
                    return 1;
                }
                case CASS: {
                    return 4;
                }
                case INTERACTIVE: {
                    return 8;
                }
                case CUSTOM: {
                    return 7;
                }
            }
        } else if (matchMode instanceof StandardMatchMode) {
            switch ((StandardMatchMode)matchMode) {
                case RELAXED: {
                    return 2;
                }
                case EXACT: {
                    return 0;
                }
                case STANDARD: {
                    return 1;
                }
                case CUSTOM: {
                    return 7;
                }
            }
        } else if (matchMode == DefaultMatchMode.UNSPECIFIED) {
            return 1;
        }
        return 1;
    }

    private int convertOffsetUnitsToFeet(double unitValue, DistanceUnit mmUnitType) {
        if (mmUnitType == null) {
            return 0;
        }
        Length length = new Length(unitValue, mmUnitType.getLinearUnit());
        return (int)Math.round(length.getValue(LinearUnit.FOOT));
    }

    private List<Candidate> getCandidatesFromGeoStanHandle(GeoStan gs, FindProps fp, boolean isCenterline, short gsFindReturnCode, int numMatches, Preferences preferences, boolean isReverseGeocode, boolean isPostalGeocode) throws GeocodingException, GeoStanException {
        int maxToFetch = preferences.getMaxReturnedCandidates();
        if (maxToFetch < 0) {
            maxToFetch = numMatches;
        } else if (maxToFetch != numMatches) {
            maxToFetch = Math.min(maxToFetch, numMatches);
        }
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (int i = 0; i < maxToFetch; i = (short)(i + 1)) {
            candidates.add(new GeoStanCandidate(gs, fp, (short)i, isCenterline, gsFindReturnCode, preferences, isReverseGeocode, isPostalGeocode));
        }
        return candidates;
    }

    private List<Candidate> getGeographicCentroids(GeoStan gs, String city, String county, String state, Preferences preferences) {
        boolean noFetchLimit;
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        gs.clear();
        GeographicIteratorEx geoIt = gs.createGeographicIteratorEx(city, county, state, 23L);
        boolean bl = noFetchLimit = preferences.getMaxReturnedCandidates() < 0;
        while (geoIt.hasNext() && (noFetchLimit || candidates.size() < preferences.getMaxReturnedCandidates())) {
            GeographicQueryEx geographicQueryEx = (GeographicQueryEx)geoIt.next();
            if (!geographicQueryEx.outClose) break;
            GeoStanCandidate candidate = new GeoStanCandidate(geographicQueryEx, preferences);
            candidates.add(candidate);
        }
        return candidates;
    }

    private int getCloseCandidateCount(List<Candidate> candidates) {
        return candidates.size();
    }

    private void geoStanExceptionFilter(Exception e) throws GeocodingException {
        if (e instanceof GeocodingException) {
            GeocodingException ge = (GeocodingException)e;
            if (ge.getFaultInfo() == ExceptionCode.INVALID_CLIENT_INPUT) {
                logger.debug("Invalid client input: {}", (Object)ge.getMessage());
                throw ge;
            }
            logger.error("GeoCoding Exception while attempting to geocode, message: {}", (Object)ge.getMessage(), (Object)ge);
            throw ge;
        }
        if (e instanceof GeoStanException) {
            GeoStanException gse = (GeoStanException)((Object)e);
            logger.error("Geostan Exception while attempting to geocode, message: {}", (Object)gse.getMessage(), (Object)gse);
            throw new GeocodingException(gse.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, gse);
        }
        if (e instanceof RuntimeException) {
            RuntimeException runE = (RuntimeException)e;
            logger.error(runE.getMessage(), (Throwable)runE);
            throw new GeocodingException(runE.getMessage(), ExceptionCode.INVALID_CLIENT_INPUT);
        }
        throw new GeocodingException(e.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, e);
    }

    private void cleanup() {
        try {
            if (this.poolIsOpened.compareAndSet(true, false)) {
                this.m_geoStanPool.close();
            }
        }
        catch (RuntimeException runE) {
            throw runE;
        }
        catch (Exception e) {
            logger.warn("Suppressing exception in GeocoderGeoStan cleanup: ", (Throwable)e);
        }
    }

    private GeoStanObject borrowGeoStan() throws Exception {
        GeoStanObject geoObj = null;
        if (this.poolIsOpened.get()) {
            try {
                geoObj = (GeoStanObject)this.m_geoStanPool.borrowObject();
            }
            catch (Exception e) {
                throw new Exception("Cannot borrow GeoStan object from pool", e);
            }
        } else {
            throw new Exception("Attempting to borrow from pool, but it is closed already.");
        }
        return geoObj;
    }

    private void returnObjectToPool(GeoStanObject geoObj) {
        if (geoObj != null) {
            if (geoObj.getGsHandle() != null) {
                geoObj.updateMessages();
            }
            try {
                this.m_geoStanPool.returnObject((Object)geoObj);
            }
            catch (Exception e) {
                this.cleanup();
                throw new RuntimeException("Failed to return object to pool.", e);
            }
        }
    }

    protected boolean isPoolOpen() {
        return this.poolIsOpened.get();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    static {
        HashSet<DistanceUnit> tempSet = new HashSet<DistanceUnit>();
        tempSet.add(DistanceUnit.METERS);
        tempSet.add(DistanceUnit.KILOMETERS);
        metricUnits = Collections.unmodifiableSet(tempSet);
    }
}

