/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.GeoSerialize;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.user.ClientGeocodeResponse;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class GeocoderResponse
implements Response,
GeoSerialize {
    private static final String newline = System.getProperty("line.separator");
    private List<Candidate> candidates = null;
    private int totalPossibleCandidates = 0;
    private int totalMatches = 0;
    private Map<String, String> customValues = new HashMap<String, String>();

    public GeocoderResponse() {
        this.candidates = new ArrayList<Candidate>();
    }

    public GeocoderResponse(ClientGeocodeResponse response, Preferences preferences) throws GeocodingException {
        String value;
        this.setTotalMatches(response.totalPossibleCloseMatchCandidates());
        this.setTotalPossibleCandidates(response.totalPossibleCloseMatchCandidates());
        ParsedInputAddress parsedInputAddress = response.getParsedInputAddress();
        int tot = response.candidateCount();
        for (int i = 0; i < tot; ++i) {
            this.addCandidate(new Candidate(response.candidateAt(i), preferences, parsedInputAddress));
        }
        if (preferences != null && preferences.getCustomPreferences() != null && parsedInputAddress != null && (value = preferences.getCustomPreferences().get("RETURN_PARSED_INPUT")) != null && Boolean.valueOf(value.toLowerCase()).booleanValue()) {
            this.addIfNotNull("PARSED_INPUT_ADDRESS_NUMBER", parsedInputAddress.getAddressNumber());
            this.addIfNotNull("PARSED_INPUT_PLACE_NAME", parsedInputAddress.getPlaceName());
            this.addIfNotNull("PARSED_INPUT_STREET_NAME", parsedInputAddress.getMainAddress());
            this.addIfNotNull("PARSED_INPUT_AREA_NAME_1", parsedInputAddress.getAreaName1());
            this.addIfNotNull("PARSED_INPUT_AREA_NAME_2", parsedInputAddress.getAreaName2());
            this.addIfNotNull("PARSED_INPUT_AREA_NAME_3", parsedInputAddress.getAreaName3());
            this.addIfNotNull("PARSED_INPUT_AREA_NAME_4", parsedInputAddress.getAreaName4());
            this.addIfNotNull("PARSED_INPUT_POST_CODE_1", parsedInputAddress.getPostCode1());
            this.addIfNotNull("PARSED_INPUT_POST_CODE_2", parsedInputAddress.getPostCode2());
            this.addIfNotNull("PARSED_INPUT_GENERIC_FIELD_1", parsedInputAddress.getGenericField1());
            this.addIfNotNull("PARSED_INPUT_GENERIC_FIELD_2", parsedInputAddress.getGenericField2());
            this.addIfNotNull("PARSED_INPUT_GENERIC_FIELD_3", parsedInputAddress.getGenericField3());
            this.addIfNotNull("PARSED_INPUT_GENERIC_FIELD_4", parsedInputAddress.getGenericField4());
            this.addIfNotNull("PARSED_INPUT_INTERSECTING_STREET", parsedInputAddress.getGenericField2());
            this.addIfNotNull("PARSED_INPUT_COUNTRY", parsedInputAddress.getCountry());
            this.addIfNotNull("PARSED_INPUT_STREET_POST_DIRECTIONAL", parsedInputAddress.getPostDirectional());
            this.addIfNotNull("PARSED_INPUT_STREET_PRE_DIRECTIONAL", parsedInputAddress.getPreDirectional());
            this.addIfNotNull("PARSED_INPUT_STREET_POST_TYPE", parsedInputAddress.getPostThoroughfareType());
            this.addIfNotNull("PARSED_INPUT_STREET_PRE_TYPE", parsedInputAddress.getPreThoroughfareType());
            this.addIfNotNull("PARSED_INPUT_UNIT_TYPE", parsedInputAddress.getUnitType());
            this.addIfNotNull("PARSED_INPUT_UNIT_VALUE", parsedInputAddress.getUnitValue());
            HashMap additional = parsedInputAddress.getAdditionalFields();
            if (additional != null) {
                for (Object key : additional.keySet()) {
                    this.addIfNotNull(key.toString(), (String)additional.get(key));
                }
            }
        }
    }

    protected void addIfNotNull(String key, String value) {
        if (!StringUtils.isEmpty((CharSequence)value) && !StringUtils.isEmpty((CharSequence)key)) {
            this.customValues.put(key, value);
        }
    }

    public GeocoderResponse(ReverseGeocodeResponse response, boolean convertToFeet, Preferences preferences) throws GeocodingException {
        this.setTotalMatches(response.candidateCount());
        this.setTotalPossibleCandidates(response.candidateCount());
        int tot = response.candidateCount();
        for (int i = 0; i < tot; ++i) {
            Candidate candidate = new Candidate(response.candidateAt(i), preferences);
            if (convertToFeet) {
                String distStr = candidate.getCustomFieldValue("REVERSE_GEOCODE_DISTANCE");
                String unitStr = candidate.getCustomFieldValue("REVERSE_GEOCODE_DISTANCE_UNIT");
                DistanceUnit unit = DistanceUnit.fromValueWithDefault(unitStr);
                Length orig = new Length(Double.parseDouble(distStr), unit.getLinearUnit());
                candidate.getAddress().addCustomField("REVERSE_GEOCODE_DISTANCE", String.valueOf(orig.getValue(LinearUnit.FOOT)));
                candidate.getAddress().addCustomField("REVERSE_GEOCODE_DISTANCE_UNIT", DistanceUnit.FEET.toString());
            }
            this.addCandidate(candidate);
        }
    }

    void setTotalPossibleCandidates(int value) {
        this.totalPossibleCandidates = value;
    }

    void setTotalMatches(int value) {
        this.totalMatches = value;
    }

    void addCandidate(Candidate candidate) {
        if (this.candidates == null) {
            this.candidates = new ArrayList<Candidate>();
        }
        this.candidates.add(candidate);
    }

    void addCandidates(List<Candidate> candidates) {
        for (Candidate candidate : candidates) {
            this.addCandidate(candidate);
        }
    }

    void setCandidates(List<Candidate> candidates) {
        this.candidates = candidates;
    }

    @Override
    public List<Candidate> getCandidates() {
        if (this.candidates == null) {
            return Collections.emptyList();
        }
        return this.candidates;
    }

    @Override
    public int getTotalPossibleCandidates() {
        return this.totalPossibleCandidates;
    }

    @Override
    public int getTotalMatches() {
        return this.totalMatches;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Total candidates found: ");
        sb.append(this.totalPossibleCandidates);
        sb.append(newline);
        sb.append("Total candidates returned: ");
        sb.append(this.candidates == null ? 0 : this.candidates.size());
        sb.append(newline);
        sb.append("Total close candidates found: ");
        sb.append(this.totalMatches);
        sb.append(newline);
        sb.append(newline);
        if (this.candidates != null) {
            int i = 0;
            for (Candidate candidate : this.candidates) {
                sb.append("Candidate ");
                sb.append(i);
                ++i;
                sb.append(":");
                sb.append(newline);
                sb.append(candidate.toString());
                sb.append(newline);
                sb.append(newline);
            }
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> convertToMap() {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> arrayOfCands = new ArrayList<Map<String, Object>>();
        for (Candidate cand : this.candidates) {
            arrayOfCands.add(cand.convertToMap());
        }
        retVal.put("candidates", arrayOfCands);
        retVal.put("totalPossibleCandidates", String.valueOf(this.totalPossibleCandidates));
        retVal.put("totalPossibleCloseMatchCandidates", String.valueOf(this.totalMatches));
        retVal.put("customValues", this.customValues);
        return retVal;
    }

    @Override
    public Map<String, String> getCustomValues() {
        return this.customValues;
    }

    @Override
    public Set<String> getCustomFieldKeys() {
        return this.customValues.keySet();
    }

    @Override
    public String getCustomFieldValue(String key) {
        return this.customValues.get(key);
    }
}

