/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.api.GeocodeEngine;
import com.mapinfo.geocode.util.GeocodeUtils;
import java.util.ArrayList;
import java.util.List;

public class GeocodingEngine
implements GeocodeEngine {
    private String name;
    private String version;
    private String vintage;
    private String primaryCountry;
    private List<String> dictionaryOrdering;
    private List<String> supportedCountries = new ArrayList<String>();

    public GeocodingEngine() {
        this.dictionaryOrdering = new ArrayList<String>();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getPrimaryCountry() {
        return this.primaryCountry;
    }

    @Override
    public void setPrimaryCountry(String name) {
        this.primaryCountry = name;
    }

    @Override
    public void setSupportedCountries(List<String> countries) {
        this.supportedCountries = countries;
    }

    @Override
    public List<String> getSupportedCountries() {
        return this.supportedCountries;
    }

    @Override
    public void setDictionaryOrdering(List<String> dicts) {
        this.dictionaryOrdering = dicts;
    }

    @Override
    public List<String> getDictionaryOrdering() {
        return this.dictionaryOrdering;
    }

    @Override
    public String getVintage() {
        return this.vintage;
    }

    @Override
    public void setVintage(String vintage) {
        this.vintage = vintage;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tName: ", this.getName());
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tVersion: ", this.getName());
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tPrimaryCountry: ", this.getPrimaryCountry());
        GeocodeUtils.appendNonNullValues(stringBuilder, "\tVintage: ", this.getVintage());
        stringBuilder.append("Supported countries: ");
        GeocodeUtils.appendNewline(stringBuilder);
        for (String country : this.supportedCountries) {
            stringBuilder.append(country);
            GeocodeUtils.appendNewline(stringBuilder);
        }
        stringBuilder.append("Supported dictionary names: ");
        GeocodeUtils.appendNewline(stringBuilder);
        for (String dict : this.dictionaryOrdering) {
            stringBuilder.append(dict);
            GeocodeUtils.appendNewline(stringBuilder);
        }
        return stringBuilder.toString();
    }
}

