/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class UsaToInternationalCandidateComparator
implements Comparator<Candidate> {
    private Set<String> availableCountrySet = new HashSet<String>();
    private boolean preferADoverUD;

    public UsaToInternationalCandidateComparator(Set<String> availableCountries) {
        this.availableCountrySet.addAll(availableCountries);
        this.preferADoverUD = true;
    }

    @Override
    public int compare(Candidate usaCand, Candidate intlCand) {
        if (intlCand.getCountry() == "USA") {
            return -1;
        }
        char usaMatchType = usaCand.getPrecisionCode().charAt(0);
        if (usaMatchType != intlCand.getPrecisionCode().charAt(0)) {
            return this.compareGeographicToStreet(usaCand, intlCand);
        }
        if (usaMatchType == 'S') {
            return this.compareStreetMatches(usaCand, intlCand);
        }
        if (usaMatchType == 'G') {
            return this.compareGeographicMatches(usaCand, intlCand);
        }
        return this.compareCountryAvailability(usaCand, intlCand);
    }

    protected int compareStreetMatches(Candidate usaCand, Candidate intlCand) {
        String usaPrec = usaCand.getPrecisionCode();
        String intlPrec = intlCand.getPrecisionCode();
        int usaMisses = this.countMisses(usaPrec);
        int intlMisses = this.countMisses(intlPrec);
        if (usaMisses > 3 || usaMisses == 3 && usaPrec.indexOf(78) < 0 && usaPrec.indexOf(67) < 0) {
            return 1;
        }
        if (usaMisses < intlMisses) {
            return -1;
        }
        if (intlMisses < usaMisses) {
            return 1;
        }
        if (usaCand.getPrecisionLevel() > intlCand.getPrecisionLevel()) {
            return -1;
        }
        if (usaCand.getPrecisionLevel() < intlCand.getPrecisionLevel()) {
            return 1;
        }
        if (usaPrec.length() == intlPrec.length()) {
            char usaMatchType = usaPrec.charAt(0);
            char intlMatchType = intlPrec.charAt(0);
            usaMatchType = usaPrec.charAt(usaPrec.length() - 1);
            if (usaMatchType != (intlMatchType = intlPrec.charAt(intlPrec.length() - 1))) {
                if (this.preferADoverUD) {
                    if (usaMatchType == 'A') {
                        return -1;
                    }
                    return 1;
                }
                if (usaMatchType == 'U') {
                    return -1;
                }
                return 1;
            }
        }
        return 0;
    }

    protected int compareGeographicMatches(Candidate usaCand, Candidate intlCand) {
        int secondPrec;
        int firstPrec = usaCand.getPrecisionLevel();
        if (firstPrec != (secondPrec = intlCand.getPrecisionLevel())) {
            if (firstPrec > secondPrec) {
                return 1;
            }
            if (firstPrec < secondPrec) {
                return -1;
            }
        }
        if ("10".equals(intlCand.getCustomFieldValue("CITYRANK"))) {
            return -1;
        }
        return 1;
    }

    protected int compareCountryAvailability(Candidate first, Candidate second) {
        boolean firstBool = this.availableCountrySet.contains(first.getCountry());
        boolean secondBool = this.availableCountrySet.contains(second.getCountry());
        if (firstBool && !secondBool) {
            return -1;
        }
        if (secondBool && !firstBool) {
            return 1;
        }
        return 0;
    }

    protected int compareGeographicToStreet(Candidate usaCand, Candidate intlCand) {
        int preferFirst = 0;
        int preferSecond = 0;
        String usaPrec = usaCand.getPrecisionCode();
        String intlPrec = intlCand.getPrecisionCode();
        if (usaPrec.charAt(0) == 'G') {
            preferSecond = this.adjustByPrecision(intlPrec, preferSecond);
        } else {
            String missed = StringUtilities.trimToChars((String)usaPrec, (String)"-");
            if (missed.length() > 3 || missed.length() == 3 && usaCand.getPrecisionCode().indexOf(78) < 0) {
                return 1;
            }
            preferSecond = this.adjustByRank(intlCand.getCustomFieldValue("CITYRANK"), preferSecond);
            preferFirst = this.adjustByPrecision(usaPrec, preferFirst);
        }
        if (preferFirst > preferSecond) {
            return -1;
        }
        if (preferFirst < preferSecond) {
            return 1;
        }
        return 0;
    }

    protected int adjustByRank(String rank, int initVal) {
        int value = initVal;
        if (rank != null && !rank.isEmpty()) {
            ++value;
            if ("10".equals(rank)) {
                --value;
            }
            if ("1".equals(rank)) {
                ++value;
            }
        }
        return value;
    }

    protected int adjustByPrecision(String precision, int initVal) {
        int value = initVal;
        if (precision.indexOf(67) > 0) {
            ++value;
        }
        if (precision.indexOf(90) > 0) {
            ++value;
        }
        if (precision.indexOf(72) > 0) {
            ++value;
        }
        if (precision.indexOf(78) > 0) {
            ++value;
        }
        return value;
    }

    protected int countMisses(String str) {
        String missed = StringUtilities.trimToChars((String)str, (String)"-");
        return missed.length();
    }

    public boolean isPreferADoverUD() {
        return this.preferADoverUD;
    }

    public void setPreferADoverUD(boolean preferADoverUD) {
        this.preferADoverUD = preferADoverUD;
    }
}

