/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.api;

import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.Range;
import com.mapinfo.geocode.AdditionalFieldKeys;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.CandidateRangeUnit;
import com.mapinfo.geocode.api.GeoSerialize;
import com.mapinfo.geocode.api.OddEvenIndicator;
import com.mapinfo.geocode.api.StreetSideIndicator;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CandidateRange
implements GeoSerialize {
    private String placeName;
    private String lowHouse;
    private String highHouse;
    private List<CandidateRangeUnit> units = new ArrayList<CandidateRangeUnit>();
    private StreetSideIndicator side = StreetSideIndicator.UNKNOWN;
    private OddEvenIndicator oddEvenIndicator = OddEvenIndicator.UNKNOWN;
    private Map<String, String> customValues = new HashMap<String, String>();

    public CandidateRange() {
    }

    public CandidateRange(Range geoStanRange) throws GeocodingException {
        try {
            this.placeName = geoStanRange.getData(59);
            this.lowHouse = geoStanRange.getData(16);
            this.highHouse = geoStanRange.getData(8);
            String leftRight = geoStanRange.getData(39);
            this.side = leftRight.equals("L") ? StreetSideIndicator.LEFT : (leftRight.equals("R") ? StreetSideIndicator.RIGHT : (leftRight.equals("B") ? StreetSideIndicator.BOTH : StreetSideIndicator.UNKNOWN));
            String oddEven = geoStanRange.getData(41);
            this.oddEvenIndicator = oddEven.equals("E") ? OddEvenIndicator.EVEN : (oddEven.equals("O") ? OddEvenIndicator.ODD : (oddEven.equals("B") ? OddEvenIndicator.BOTH : OddEvenIndicator.UNKNOWN));
            this.units.add(new CandidateRangeUnit(geoStanRange));
        }
        catch (GeoStanException ex) {
            throw new GeocodingException("null range passed to constructor", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
    }

    @Deprecated
    public CandidateRange(com.mapinfo.mapmarker.CandidateRange internalRange) throws GeocodingException {
        this(internalRange, null);
    }

    public CandidateRange(com.mapinfo.mapmarker.CandidateRange internalRange, ParsedInputAddress parsedAddress) throws GeocodingException {
        if (internalRange == null) {
            throw new GeocodingException("null range passed to constructor", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
        this.placeName = internalRange.getPlaceName();
        this.lowHouse = internalRange.getLowAddress();
        this.highHouse = internalRange.getHighAddress();
        int leftRight = internalRange.getLeftRightIndicator();
        switch (leftRight) {
            case 1: {
                this.side = StreetSideIndicator.LEFT;
                break;
            }
            case 2: {
                this.side = StreetSideIndicator.RIGHT;
                break;
            }
            default: {
                this.side = StreetSideIndicator.UNKNOWN;
            }
        }
        int oddEven = internalRange.getOddEvenIndicator();
        switch (oddEven) {
            case 0: {
                this.oddEvenIndicator = OddEvenIndicator.BOTH;
                break;
            }
            case 1: {
                this.oddEvenIndicator = OddEvenIndicator.ODD;
                break;
            }
            case 2: {
                this.oddEvenIndicator = OddEvenIndicator.EVEN;
                break;
            }
            case 5: {
                this.oddEvenIndicator = OddEvenIndicator.IRREGULAR;
                break;
            }
            default: {
                this.oddEvenIndicator = OddEvenIndicator.UNKNOWN;
            }
        }
        if (!(null == parsedAddress || StringUtils.isEmpty((CharSequence)parsedAddress.getUnitType()) && StringUtils.isEmpty((CharSequence)parsedAddress.getUnitValue()) || null == internalRange.getRangeUnitAt(0))) {
            this.units.add(new CandidateRangeUnit(internalRange.getRangeUnitAt(0)));
        }
        this.convertCustom(internalRange);
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public String getLowHouse() {
        return this.lowHouse;
    }

    public String getHighHouse() {
        return this.highHouse;
    }

    public List<CandidateRangeUnit> getUnits() {
        return this.units;
    }

    public Map<String, String> getCustomValues() {
        return this.customValues;
    }

    public OddEvenIndicator getOddEvenIndicator() {
        return this.oddEvenIndicator;
    }

    public StreetSideIndicator getStreetSide() {
        return this.side;
    }

    public Set<String> getCustomFieldKeys() {
        return this.customValues.keySet();
    }

    public String getCustomFieldValue(String key) {
        return this.customValues.get(key);
    }

    protected String getCustomFieldValue(AdditionalFieldKeys key) {
        return this.customValues.get(key.toString());
    }

    public void setPlaceName(String name) {
        this.placeName = name;
    }

    public void setLowHouse(String num) {
        this.lowHouse = num;
    }

    public void setHighHouse(String num) {
        this.highHouse = num;
    }

    public void setUnits(List<CandidateRangeUnit> units) {
        this.units = units;
    }

    public void setSide(StreetSideIndicator side) {
        this.side = side;
    }

    public void setOddEvenIndicator(OddEvenIndicator oddEvenIndicator) {
        this.oddEvenIndicator = oddEvenIndicator;
    }

    private void convertCustom(com.mapinfo.mapmarker.CandidateRange internalRange) {
        this.addCustom(AdditionalFieldKeys.AREA_NAME_1, internalRange.getAreaName1());
        this.addCustom(AdditionalFieldKeys.AREA_NAME_2, internalRange.getAreaName2());
        this.addCustom(AdditionalFieldKeys.AREA_NAME_3, internalRange.getAreaName3());
        this.addCustom(AdditionalFieldKeys.AREA_NAME_4, internalRange.getAreaName4());
        this.addCustom(AdditionalFieldKeys.POST_CODE_1, internalRange.getPostalCode1());
        this.addCustom(AdditionalFieldKeys.POST_CODE_2, internalRange.getPostalCode2());
        Map addFlds = internalRange.getAdditionalFields();
        if (addFlds != null && addFlds.size() > 0) {
            for (Object keyObj : addFlds.keySet()) {
                Object valueObj = addFlds.get(keyObj);
                if (!(keyObj instanceof String) || !(valueObj instanceof String)) continue;
                this.addCustom((String)keyObj, (String)valueObj);
            }
        }
    }

    private void addCustom(AdditionalFieldKeys key, String value) {
        this.addCustom(key.toString(), value);
    }

    private void addCustom(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.customValues.remove(key);
            return;
        }
        this.customValues.put(key, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        GeocodeUtils.appendNonNullValues(sb, "Place name: ", this.placeName);
        GeocodeUtils.appendNonNullValues(sb, "Low house: ", this.lowHouse);
        GeocodeUtils.appendNonNullValues(sb, "High house: ", this.highHouse);
        sb.append("Street side: ");
        sb.append((Object)this.getStreetSide());
        GeocodeUtils.appendNewline(sb);
        sb.append("Odd/even indicator: ");
        sb.append((Object)this.oddEvenIndicator);
        GeocodeUtils.appendNewline(sb);
        GeocodeUtils.appendNewline(sb);
        sb.append("Returned units: ");
        sb.append(this.units.size());
        int i = 0;
        for (CandidateRangeUnit unit : this.units) {
            sb.append("Unit ");
            sb.append(i);
            ++i;
            sb.append(":");
            GeocodeUtils.appendNewline(sb);
            sb.append(unit);
        }
        sb.append("Custom Mappings:");
        GeocodeUtils.appendNewline(sb);
        StringBuilder label = new StringBuilder();
        for (Map.Entry<String, String> entry : this.customValues.entrySet()) {
            int len = label.length();
            if (len > 0) {
                label.replace(0, len - 1, "");
            }
            label.append(entry.getKey()).append(" = ");
            GeocodeUtils.appendNonNullValues(sb, label.toString(), entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> convertToMap() {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("placeName", this.placeName);
        retVal.put("lowHouse", this.lowHouse);
        retVal.put("highHouse", this.highHouse);
        ArrayList<Map<String, Object>> arrayOfUnits = new ArrayList<Map<String, Object>>();
        for (CandidateRangeUnit unit : this.units) {
            arrayOfUnits.add(unit.convertToMap());
        }
        retVal.put("units", arrayOfUnits);
        retVal.put("side", this.side.toString());
        retVal.put("oddEvenIndicator", this.oddEvenIndicator.toString());
        retVal.put("customValues", this.customValues);
        return retVal;
    }
}

