/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.api;

import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.Range;
import com.google.common.base.Objects;
import com.mapinfo.geocode.AdditionalFieldKeys;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.GeoSerialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CandidateRangeUnit
implements GeoSerialize {
    private String placeName;
    private String unitType;
    private String highUnitValue;
    private String lowUnitValue;
    private Map<String, String> customValues = new HashMap<String, String>();

    public CandidateRangeUnit() {
    }

    public CandidateRangeUnit(com.mapinfo.mapmarker.CandidateRangeUnit internalUnit) throws GeocodingException {
        if (internalUnit == null) {
            throw new GeocodingException("null unit passed to constructor", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
        this.placeName = internalUnit.getPlaceName();
        this.unitType = internalUnit.getUnitType();
        this.highUnitValue = internalUnit.getHighUnitNumber();
        this.lowUnitValue = internalUnit.getLowUnitNumber();
        this.convertCustom(internalUnit);
    }

    public CandidateRangeUnit(Range geoStanRange) throws GeocodingException {
        try {
            this.placeName = geoStanRange.getData(59);
            this.unitType = geoStanRange.getData(30);
            this.highUnitValue = geoStanRange.getData(36);
            this.lowUnitValue = geoStanRange.getData(37);
        }
        catch (GeoStanException ex) {
            throw new GeocodingException("null unit passed to constructor", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public String getLowUnitValue() {
        return this.lowUnitValue;
    }

    public String getHighUnitValue() {
        return this.highUnitValue;
    }

    public Map<String, String> getCustomValues() {
        return this.customValues;
    }

    public Set<String> getCustomFieldKeys() {
        return this.customValues.keySet();
    }

    public String getCustomFieldValue(String key) {
        return this.customValues.get(key);
    }

    protected String getCustomFieldValue(AdditionalFieldKeys key) {
        return this.customValues.get(key.toString());
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    public void setUnitType(String unitType) {
        this.unitType = unitType;
    }

    public void setLowUnitValue(String lowUnitValue) {
        this.lowUnitValue = lowUnitValue;
    }

    public void setHighUnitValue(String highUnitValue) {
        this.highUnitValue = highUnitValue;
    }

    private void convertCustom(com.mapinfo.mapmarker.CandidateRangeUnit internalUnit) {
        this.addCustom(AdditionalFieldKeys.AREA_NAME_1, internalUnit.getAreaName1());
        this.addCustom(AdditionalFieldKeys.AREA_NAME_2, internalUnit.getAreaName2());
        this.addCustom(AdditionalFieldKeys.AREA_NAME_3, internalUnit.getAreaName3());
        this.addCustom(AdditionalFieldKeys.AREA_NAME_4, internalUnit.getAreaName4());
        this.addCustom(AdditionalFieldKeys.POST_CODE_1, internalUnit.getPostalCode1());
        this.addCustom(AdditionalFieldKeys.POST_CODE_2, internalUnit.getPostalCode2());
        HashMap addFlds = internalUnit.getAdditionalFields();
        if (addFlds != null && addFlds.size() > 0) {
            for (Object keyObj : addFlds.keySet()) {
                Object valueObj = addFlds.get(keyObj);
                if (!(keyObj instanceof String) || !(valueObj instanceof String)) continue;
                this.addCustom((String)keyObj, (String)valueObj);
            }
        }
    }

    private void addCustom(AdditionalFieldKeys key, String value) {
        this.addCustom(key.toString(), value);
    }

    private void addCustom(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.customValues.remove(key);
            return;
        }
        this.customValues.put(key, value);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("placeName", (Object)this.placeName).add("unitType", (Object)this.unitType).add("highUnitValue", (Object)this.highUnitValue).add("lowUnitValue", (Object)this.lowUnitValue).add("customValues", this.customValues).toString();
    }

    @Override
    public Map<String, Object> convertToMap() {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("placeName", this.placeName);
        retVal.put("unitType", this.unitType);
        retVal.put("highUnitValue", this.highUnitValue);
        retVal.put("lowUnitValue", this.lowUnitValue);
        retVal.put("customValues", this.customValues);
        return retVal;
    }
}

