/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.api;

import com.centrus.geostan.FindProps;
import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanBase;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.GeographicQueryEx;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodeConfiguration;
import com.mapinfo.geocode.GeocodeMatchFields;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.CandidateRange;
import com.mapinfo.geocode.api.CandidateRangeUnit;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.OddEvenIndicator;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.ReturnFieldsDescriptor;
import com.mapinfo.geocode.api.StreetSideIndicator;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoStanCandidate
extends Candidate {
    private static final double LOCATION_DIVISOR = 1000000.0;
    private static final SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private static final String DATATYPE_NAME = "DATATYPE_NAME";
    private static final String PREDIR = "PRE_DIRECTIONAL";
    private static final String POSTDIR = "POST_DIRECTIONAL";
    private static final String TYPE = "THOROUGHFARE_TYPE";
    private static final String NAME = "MAIN_ADDRESS";
    private static final String PERCENT_GEOCODE = "PERCENT_GEOCODE";
    private static final String USA_DEFAULT_LANGUAGE = "en";
    private static final String DEFAULT_COUNTRY = "USA";
    private static final Logger logger = LoggerFactory.getLogger(GeoStanCandidate.class);

    public GeoStanCandidate(GeoStan geoStan, FindProps fp, short index, boolean isCenterline, short gsFindReturnCode, Preferences preferences, boolean isReverseGeocode, boolean isPostalGeocode) throws GeocodingException, GeoStanException {
        String matchCode;
        String str;
        this.address.setCountry(DEFAULT_COUNTRY);
        ReturnFieldsDescriptor returnFieldsDescriptor = null;
        if (preferences != null && !preferences.isReturnAllCandidateInfo()) {
            returnFieldsDescriptor = preferences.getReturnFieldsDescriptor();
        }
        boolean returnMatchDescriptor = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnMatchDescriptor();
        boolean returnUnitFields = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnUnitInformation();
        boolean returnStreetFields = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnStreetAddressFields();
        String sLat = this.getOutputDataField(geoStan, 11, index, gsFindReturnCode);
        String sLon = this.getOutputDataField(geoStan, 15, index, gsFindReturnCode);
        if (!sLat.isEmpty() && !sLon.isEmpty()) {
            DirectPosition dp = new DirectPosition();
            dp.setY(Double.parseDouble(this.div1E6(sLat)));
            dp.setX(Double.parseDouble(this.div1E6(sLon)));
            this.point = new Point(SPATIAL_INFO, dp);
        }
        this.setSourceDictionary(this.getOutputDataField(geoStan, 571, index, gsFindReturnCode));
        if ((returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnAllCustomFields() || returnFieldsDescriptor.getKeysOfCustomFieldsToReturn().contains(DATATYPE_NAME)) && (str = this.getOutputDataField(geoStan, 540, index, gsFindReturnCode)) != null && str.length() > 0) {
            this.address.addCustomField(DATATYPE_NAME, GeoStanBase.DataSetStatus.getDataTypeName((short)Short.valueOf(str)));
        }
        if (isReverseGeocode) {
            String percent;
            String sDistance = this.getOutputDataField(geoStan, 544, index, gsFindReturnCode);
            this.address.addCustomField("REVERSE_GEOCODE_DISTANCE", sDistance);
            this.address.addCustomField("REVERSE_GEOCODE_DISTANCE_UNIT", DistanceUnit.FEET.toString());
            if ((returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnAllCustomFields() || returnFieldsDescriptor.getKeysOfCustomFieldsToReturn().contains(PERCENT_GEOCODE)) && (percent = this.getOutputDataField(geoStan, 545, index, gsFindReturnCode)) != null && !percent.isEmpty()) {
                this.address.addCustomField(PERCENT_GEOCODE, percent);
            }
        }
        this.formattedStreetAddress = this.getOutputDataField(geoStan, 1, index, gsFindReturnCode);
        this.formattedLocationAddress = this.getOutputDataField(geoStan, 10, index, gsFindReturnCode);
        this.identifier = this.getOutputDataField(geoStan, 517, index, gsFindReturnCode);
        this.address.setPlaceName(this.getOutputDataField(geoStan, 59, index, gsFindReturnCode));
        this.address.setAreaName1(this.getOutputDataField(geoStan, 26, index, gsFindReturnCode));
        this.address.setAreaName2(this.getOutputDataField(geoStan, 65, index, gsFindReturnCode));
        this.address.setAreaName3(this.getOutputDataField(geoStan, 5, index, gsFindReturnCode));
        this.address.setPostCode1(this.getOutputDataField(geoStan, 31, index, gsFindReturnCode));
        this.address.setPostCode2(this.getOutputDataField(geoStan, 32, index, gsFindReturnCode));
        this.address.setAddressNumber(this.getOutputDataField(geoStan, 9, index, gsFindReturnCode));
        this.address.setStreetName(this.getOutputDataField(geoStan, 20, index, gsFindReturnCode));
        String unitType = returnUnitFields ? this.getOutputDataField(geoStan, 30, index, gsFindReturnCode) : null;
        String unitValue = returnUnitFields ? this.getOutputDataField(geoStan, 29, index, gsFindReturnCode) : null;
        this.address.setUnitType(unitType);
        this.address.setUnitValue(unitValue);
        this.precisionCode = this.getOutputDataField(geoStan, 19, index, gsFindReturnCode);
        if (!isPostalGeocode && (matchCode = this.getOutputDataField(geoStan, 17, index, gsFindReturnCode)).matches("Z[0-9A-F]?")) {
            this.precisionCode = this.address.getPostCode2() != null && this.address.getPostCode2().length() == 4 ? "Z3" : "Z1";
        }
        this.precisionLevel = this.getPrecisionLevel(this.precisionCode);
        this.address.setMainAddressLine(this.formattedStreetAddress);
        this.address.setAddressLastLine(this.formattedLocationAddress);
        if (returnMatchDescriptor) {
            matchCode = this.getOutputDataField(geoStan, 17, index, gsFindReturnCode);
            this.copyMatchingInformation(matchCode);
        }
        if (returnStreetFields) {
            this.addIfNotEmpty(this.address.getCustomFields(), NAME, this.getOutputDataField(geoStan, 20, index, gsFindReturnCode));
            this.addIfNotEmpty(this.address.getCustomFields(), PREDIR, this.getOutputDataField(geoStan, 24, index, gsFindReturnCode));
            this.addIfNotEmpty(this.address.getCustomFields(), POSTDIR, this.getOutputDataField(geoStan, 22, index, gsFindReturnCode));
            this.addIfNotEmpty(this.address.getCustomFields(), TYPE, this.getOutputDataField(geoStan, 27, index, gsFindReturnCode));
        }
        this.getMatchingRange(geoStan, index, gsFindReturnCode);
        boolean returnIntegerLatLon = false;
        if (preferences != null && preferences.getCustomPreferences() != null) {
            String checkVal = preferences.getCustomPreferences().get("RETURN_LAT_LON_AS_INTEGER_VALUE");
            returnIntegerLatLon = checkVal != null && Boolean.valueOf(checkVal) != false;
        }
        this.getData(geoStan, returnFieldsDescriptor, fp, index, isCenterline, gsFindReturnCode, returnIntegerLatLon);
    }

    public GeoStanCandidate(GeographicQueryEx geographicQueryEx, Preferences preferences) {
        boolean returnMatchDescriptor;
        this.address.setCountry(DEFAULT_COUNTRY);
        this.address.setAreaName1(geographicQueryEx.outState);
        this.address.setAreaName2(geographicQueryEx.outCounty);
        this.address.setAreaName3(geographicQueryEx.outCity);
        String sLat = geographicQueryEx.outLat;
        String sLon = geographicQueryEx.outLong;
        if (!sLat.isEmpty() && !sLon.isEmpty()) {
            DirectPosition dp = new DirectPosition();
            dp.setY(Double.parseDouble(sLat) / 1000000.0);
            dp.setX(Double.parseDouble(sLon) / 1000000.0);
            this.point = new Point(SPATIAL_INFO, dp);
        }
        this.precisionCode = geographicQueryEx.outResultCode;
        this.precisionLevel = this.getPrecisionLevel(this.precisionCode);
        ReturnFieldsDescriptor returnFieldsDescriptor = null;
        if (preferences != null && !preferences.isReturnAllCandidateInfo()) {
            returnFieldsDescriptor = preferences.getReturnFieldsDescriptor();
        }
        boolean bl = returnMatchDescriptor = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnMatchDescriptor();
        if (returnMatchDescriptor) {
            this.matchedFields = new GeocodeMatchFields();
            if (this.precisionCode.equalsIgnoreCase("G3")) {
                this.matchedFields.setMatchOnAreaName3(true);
                this.matchedFields.setMatchOnAreaName2(true);
                this.matchedFields.setMatchOnAreaName1(true);
            }
            if (this.precisionCode.equalsIgnoreCase("G2")) {
                this.matchedFields.setMatchOnAreaName2(true);
                this.matchedFields.setMatchOnAreaName1(true);
            }
            if (this.precisionCode.equalsIgnoreCase("G1")) {
                this.matchedFields.setMatchOnAreaName1(true);
            }
        }
    }

    private String div1E6(String val) {
        return val.isEmpty() ? val : String.valueOf(Double.parseDouble(val) / 1000000.0);
    }

    private void addCustomField(String key, ReturnFieldsDescriptor returnFieldsDescriptor, GeoStan geoStan, int dataField, short index, short gsFindReturnCode) throws GeocodingException, GeoStanException {
        if (returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnAllCustomFields() || returnFieldsDescriptor.getKeysOfCustomFieldsToReturn().contains(key)) {
            this.addIfNotEmpty(this.address.getCustomFields(), key, this.getOutputDataField(geoStan, dataField, index, gsFindReturnCode));
        }
    }

    private void addCustomFieldLanguage(String key, ReturnFieldsDescriptor returnFieldsDescriptor, String country, String sourceDictionary) throws GeocodingException, GeoStanException {
        if (returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnAllCustomFields() || returnFieldsDescriptor.getKeysOfCustomFieldsToReturn().contains(key)) {
            try {
                GeocodeConfiguration configuration = GeocodeConfiguration.getInstance();
                if (configuration != null) {
                    country = configuration.getPrimaryCountry(country);
                }
            }
            catch (Exception configuration) {
                // empty catch block
            }
            String language = ConfigurationManager.getPrimaryLanguage(country, sourceDictionary);
            language = language == null || language.trim().length() == 0 ? USA_DEFAULT_LANGUAGE : language;
            this.addIfNotEmpty(this.address.getCustomFields(), "LANGUAGE", language);
        }
    }

    private void addCustomLatLonField(String key, ReturnFieldsDescriptor returnFieldsDescriptor, GeoStan geoStan, int dataField, short index, short gsFindReturnCode, boolean bIntegerFormat) throws GeocodingException, GeoStanException {
        if (returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnAllCustomFields() || returnFieldsDescriptor.getKeysOfCustomFieldsToReturn().contains(key)) {
            if (!bIntegerFormat) {
                this.address.addCustomField(key, this.div1E6(this.getOutputDataField(geoStan, dataField, index, gsFindReturnCode)));
            } else {
                this.addIfNotEmpty(this.address.getCustomFields(), key, this.getOutputDataField(geoStan, dataField, index, gsFindReturnCode));
            }
        }
    }

    private void addCustomCenterlineField(String key, ReturnFieldsDescriptor returnFieldsDescriptor, GeoStan geoStan, int dataField, short index, short gsFindReturnCode) throws GeocodingException, GeoStanException {
        if (returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnAllCustomFields() || returnFieldsDescriptor.getKeysOfCustomFieldsToReturn().contains(key)) {
            if (dataField == 11 || dataField == 15) {
                this.address.addCustomField(key, this.div1E6(this.getCenterlineDataField(geoStan, dataField, index, gsFindReturnCode)));
            } else {
                this.addIfNotEmpty(this.address.getCustomFields(), key, this.getCenterlineDataField(geoStan, dataField, index, gsFindReturnCode));
            }
        }
    }

    private void getData(GeoStan geoStan, ReturnFieldsDescriptor returnFieldsDescriptor, FindProps fp, short index, boolean isCenterline, short gsFindReturnCode, boolean returnIntegerLatLon) throws GeocodingException, GeoStanException {
        boolean isIntersection = false;
        String intersection = geoStan.getData(35);
        if (intersection.charAt(0) == 'T') {
            isIntersection = true;
        }
        this.addCustomField("ADDRLINE", returnFieldsDescriptor, geoStan, 1, index, gsFindReturnCode);
        this.addCustomField("LAST_LINE", returnFieldsDescriptor, geoStan, 10, index, gsFindReturnCode);
        this.addCustomField("STATE", returnFieldsDescriptor, geoStan, 26, index, gsFindReturnCode);
        this.addCustomField("COUNTY_NAME", returnFieldsDescriptor, geoStan, 65, index, gsFindReturnCode);
        this.addCustomField("CITY", returnFieldsDescriptor, geoStan, 5, index, gsFindReturnCode);
        this.addCustomField("DATATYPE", returnFieldsDescriptor, geoStan, 540, index, gsFindReturnCode);
        this.addCustomField("SEGMENT_ID", returnFieldsDescriptor, geoStan, 517, index, gsFindReturnCode);
        this.addCustomLatLonField("LAT", returnFieldsDescriptor, geoStan, 11, index, gsFindReturnCode, returnIntegerLatLon);
        this.addCustomLatLonField("LON", returnFieldsDescriptor, geoStan, 15, index, gsFindReturnCode, returnIntegerLatLon);
        this.addCustomField("BLOCK_LEFT", returnFieldsDescriptor, geoStan, 42, index, gsFindReturnCode);
        this.addCustomField("BLOCK_RIGHT", returnFieldsDescriptor, geoStan, 43, index, gsFindReturnCode);
        this.addCustomField("BLOCK_SFX_LEFT", returnFieldsDescriptor, geoStan, 519, index, gsFindReturnCode);
        this.addCustomField("BLOCK_SFX_RIGHT", returnFieldsDescriptor, geoStan, 520, index, gsFindReturnCode);
        this.addCustomField("SEG_HIRANGE", returnFieldsDescriptor, geoStan, 61, index, gsFindReturnCode);
        this.addCustomField("SEG_LORANGE", returnFieldsDescriptor, geoStan, 60, index, gsFindReturnCode);
        this.addCustomField("IS_ALIAS", returnFieldsDescriptor, geoStan, 67, index, gsFindReturnCode);
        this.addCustomField(NAME, returnFieldsDescriptor, geoStan, 20, index, gsFindReturnCode);
        this.addCustomField("NEAREST_DIST", returnFieldsDescriptor, geoStan, 544, index, gsFindReturnCode);
        this.addCustomField(POSTDIR, returnFieldsDescriptor, geoStan, 22, index, gsFindReturnCode);
        this.addCustomField(PREDIR, returnFieldsDescriptor, geoStan, 24, index, gsFindReturnCode);
        this.addCustomField("QCITY", returnFieldsDescriptor, geoStan, 63, index, gsFindReturnCode);
        this.addCustomField("ROAD_CLASS", returnFieldsDescriptor, geoStan, 66, index, gsFindReturnCode);
        this.addCustomField("SEGMENT_DIRECTION", returnFieldsDescriptor, geoStan, 44, index, gsFindReturnCode);
        this.addCustomField("SEGMENT_PARITY", returnFieldsDescriptor, geoStan, 40, index, gsFindReturnCode);
        this.addCustomField(TYPE, returnFieldsDescriptor, geoStan, 27, index, gsFindReturnCode);
        this.addCustomField("MATCH_CODE", returnFieldsDescriptor, geoStan, 17, index, gsFindReturnCode);
        this.addCustomField("MM_RESULT_CODE", returnFieldsDescriptor, geoStan, 19, index, gsFindReturnCode);
        this.addCustomField("FIRM_NAME", returnFieldsDescriptor, geoStan, 59, index, gsFindReturnCode);
        this.addCustomField("HOUSE_NUMBER", returnFieldsDescriptor, geoStan, 9, index, gsFindReturnCode);
        this.addCustomField("UNIT_NUMBER", returnFieldsDescriptor, geoStan, 29, index, gsFindReturnCode);
        this.addCustomField("UNIT_TYPE", returnFieldsDescriptor, geoStan, 30, index, gsFindReturnCode);
        this.addCustomField("ADDRLINE_SHORT", returnFieldsDescriptor, geoStan, 557, index, gsFindReturnCode);
        this.addCustomField("NAME_SHORT", returnFieldsDescriptor, geoStan, 558, index, gsFindReturnCode);
        this.addCustomField("TYPE_SHORT", returnFieldsDescriptor, geoStan, 561, index, gsFindReturnCode);
        this.addCustomField("POSTDIR_SHORT", returnFieldsDescriptor, geoStan, 560, index, gsFindReturnCode);
        this.addCustomField("PREDIR_SHORT", returnFieldsDescriptor, geoStan, 559, index, gsFindReturnCode);
        this.addCustomField("CITY_SHORT", returnFieldsDescriptor, geoStan, 555, index, gsFindReturnCode);
        this.addCustomField("LASTLINE_SHORT", returnFieldsDescriptor, geoStan, 556, index, gsFindReturnCode);
        this.addCustomField("PREF_CITY", returnFieldsDescriptor, geoStan, 514, index, gsFindReturnCode);
        this.addCustomField("NAME_CITY", returnFieldsDescriptor, geoStan, 515, index, gsFindReturnCode);
        this.addCustomField("R_RTE_DFLT", returnFieldsDescriptor, geoStan, 99, index, gsFindReturnCode);
        this.addCustomField("COUNTY", returnFieldsDescriptor, geoStan, 64, index, gsFindReturnCode);
        this.addCustomField("CBSA_NAME", returnFieldsDescriptor, geoStan, 522, index, gsFindReturnCode);
        this.addCustomField("CBSA_NUMBER", returnFieldsDescriptor, geoStan, 521, index, gsFindReturnCode);
        this.addCustomField("CBSA_DIVISION_NUMBER", returnFieldsDescriptor, geoStan, 525, index, gsFindReturnCode);
        this.addCustomField("CBSA_DIVISION_NAME", returnFieldsDescriptor, geoStan, 526, index, gsFindReturnCode);
        this.addCustomField("CSA_NUMBER", returnFieldsDescriptor, geoStan, 523, index, gsFindReturnCode);
        this.addCustomField("CSA_NAME", returnFieldsDescriptor, geoStan, 524, index, gsFindReturnCode);
        this.addCustomField("METRO_FLAG", returnFieldsDescriptor, geoStan, 527, index, gsFindReturnCode);
        this.addCustomField("LOT_CODE", returnFieldsDescriptor, geoStan, 74, index, gsFindReturnCode);
        this.addCustomField("CHECK_DIGIT", returnFieldsDescriptor, geoStan, 4, index, gsFindReturnCode);
        this.addCustomField("CTYST_KEY", returnFieldsDescriptor, geoStan, 58, index, gsFindReturnCode);
        this.addCustomField("LOT_NUM", returnFieldsDescriptor, geoStan, 75, index, gsFindReturnCode);
        this.addCustomField("DPBC", returnFieldsDescriptor, geoStan, 7, index, gsFindReturnCode);
        this.addCustomField("STREET_SIDE", returnFieldsDescriptor, geoStan, 39, index, gsFindReturnCode);
        this.addCustomField("STATE_FIPS", returnFieldsDescriptor, geoStan, 553, index, gsFindReturnCode);
        this.addCustomField("LOC_CODE", returnFieldsDescriptor, geoStan, 14, index, gsFindReturnCode);
        this.addCustomField("BLOCK", returnFieldsDescriptor, geoStan, 2, index, gsFindReturnCode);
        this.addCustomField("CART", returnFieldsDescriptor, geoStan, 3, index, gsFindReturnCode);
        this.addCustomField("ZIP", returnFieldsDescriptor, geoStan, 31, index, gsFindReturnCode);
        this.addCustomField("ZIP4", returnFieldsDescriptor, geoStan, 32, index, gsFindReturnCode);
        this.addCustomField("DFLT", returnFieldsDescriptor, geoStan, 100, index, gsFindReturnCode);
        this.addCustomField("HI_RISE_DFLT", returnFieldsDescriptor, geoStan, 98, index, gsFindReturnCode);
        if (isCenterline) {
            this.addCustomCenterlineField("CENTERLINE_BEARING", returnFieldsDescriptor, geoStan, 550, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_LAT", returnFieldsDescriptor, geoStan, 11, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_LON", returnFieldsDescriptor, geoStan, 15, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_DATATYPE", returnFieldsDescriptor, geoStan, 540, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_SEGMENT_ID", returnFieldsDescriptor, geoStan, 517, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_NEAREST_DIST", returnFieldsDescriptor, geoStan, 544, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_BLOCK_LEFT", returnFieldsDescriptor, geoStan, 42, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_BLOCK_RIGHT", returnFieldsDescriptor, geoStan, 43, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_BLOCK_SFX_LEFT", returnFieldsDescriptor, geoStan, 519, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_BLOCK_SFX_RIGHT", returnFieldsDescriptor, geoStan, 520, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_SEG_HIRANGE", returnFieldsDescriptor, geoStan, 61, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_SEG_LORANGE", returnFieldsDescriptor, geoStan, 60, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_IS_ALIAS", returnFieldsDescriptor, geoStan, 67, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_NAME", returnFieldsDescriptor, geoStan, 20, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_POSTDIR", returnFieldsDescriptor, geoStan, 22, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_PREDIR", returnFieldsDescriptor, geoStan, 24, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_QCITY", returnFieldsDescriptor, geoStan, 63, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_ROAD_CLASS", returnFieldsDescriptor, geoStan, 66, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_SEGMENT_DIRECTION", returnFieldsDescriptor, geoStan, 44, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_SEGMENT_PARITY", returnFieldsDescriptor, geoStan, 40, index, gsFindReturnCode);
            this.addCustomCenterlineField("CENTERLINE_TYPE", returnFieldsDescriptor, geoStan, 27, index, gsFindReturnCode);
        }
        if (isIntersection) {
            this.addCustomField("BLOCK_LEFT2", returnFieldsDescriptor, geoStan, 579, index, gsFindReturnCode);
            this.addCustomField("BLOCK_RIGHT2", returnFieldsDescriptor, geoStan, 580, index, gsFindReturnCode);
            this.addCustomField("BLOCK_SFX_LEFT2", returnFieldsDescriptor, geoStan, 581, index, gsFindReturnCode);
            this.addCustomField("BLOCK_SFX_RIGHT2", returnFieldsDescriptor, geoStan, 582, index, gsFindReturnCode);
            this.addCustomField("CBSA_DIVISION_NAME2", returnFieldsDescriptor, geoStan, 591, index, gsFindReturnCode);
            this.addCustomField("CBSA_DIVISION_NUMBER2", returnFieldsDescriptor, geoStan, 590, index, gsFindReturnCode);
            this.addCustomField("CBSA_NAME2", returnFieldsDescriptor, geoStan, 587, index, gsFindReturnCode);
            this.addCustomField("CBSA_NUMBER2", returnFieldsDescriptor, geoStan, 586, index, gsFindReturnCode);
            this.addCustomField("COUNTY2", returnFieldsDescriptor, geoStan, 584, index, gsFindReturnCode);
            this.addCustomField("COUNTY_NAME2", returnFieldsDescriptor, geoStan, 585, index, gsFindReturnCode);
            this.addCustomField("CSA_NAME2", returnFieldsDescriptor, geoStan, 589, index, gsFindReturnCode);
            this.addCustomField("CSA_NUMBER2", returnFieldsDescriptor, geoStan, 588, index, gsFindReturnCode);
            this.addCustomField("DATATYPE2", returnFieldsDescriptor, geoStan, 593, index, gsFindReturnCode);
            this.addCustomField("METRO_FLAG2", returnFieldsDescriptor, geoStan, 592, index, gsFindReturnCode);
            this.addCustomField("NAME2", returnFieldsDescriptor, geoStan, 21, index, gsFindReturnCode);
            this.addCustomField("POSTDIR2", returnFieldsDescriptor, geoStan, 23, index, gsFindReturnCode);
            this.addCustomField("PREDIR2", returnFieldsDescriptor, geoStan, 25, index, gsFindReturnCode);
            this.addCustomField("SEG_HIRANGE2", returnFieldsDescriptor, geoStan, 576, index, gsFindReturnCode);
            this.addCustomField("SEG_LORANGE2", returnFieldsDescriptor, geoStan, 575, index, gsFindReturnCode);
            this.addCustomField("ROAD_CLASS2", returnFieldsDescriptor, geoStan, 583, index, gsFindReturnCode);
            this.addCustomField("SEGMENT_DIRECTION2", returnFieldsDescriptor, geoStan, 578, index, gsFindReturnCode);
            this.addCustomField("SEGMENT_ID2", returnFieldsDescriptor, geoStan, 574, index, gsFindReturnCode);
            this.addCustomField("SEGMENT_PARITY2", returnFieldsDescriptor, geoStan, 577, index, gsFindReturnCode);
            this.addCustomField("TYPE2", returnFieldsDescriptor, geoStan, 28, index, gsFindReturnCode);
        } else {
            boolean outputSuiteLink;
            boolean outputLACSLink;
            boolean outputDPV;
            this.addCustomField("LORANGE", returnFieldsDescriptor, geoStan, 16, index, gsFindReturnCode);
            this.addCustomField("HIRANGE", returnFieldsDescriptor, geoStan, 8, index, gsFindReturnCode);
            this.addCustomField("LOUNIT", returnFieldsDescriptor, geoStan, 37, index, gsFindReturnCode);
            this.addCustomField("HIUNIT", returnFieldsDescriptor, geoStan, 36, index, gsFindReturnCode);
            this.addCustomField("LOZIP4", returnFieldsDescriptor, geoStan, 45, index, gsFindReturnCode);
            this.addCustomField("HIZIP4", returnFieldsDescriptor, geoStan, 46, index, gsFindReturnCode);
            this.addCustomField("APN_ID", returnFieldsDescriptor, geoStan, 551, index, gsFindReturnCode);
            this.addCustomField("PARCEN_ELEVATION", returnFieldsDescriptor, geoStan, 552, index, gsFindReturnCode);
            this.addCustomField("POINT_ID", returnFieldsDescriptor, geoStan, 541, index, gsFindReturnCode);
            this.addCustomField("REC_TYPE", returnFieldsDescriptor, geoStan, 57, index, gsFindReturnCode);
            boolean bl = outputDPV = fp.contains(1033) && fp.getBool(1033);
            if (outputDPV) {
                this.addCustomField("DPV_CONFIRM", returnFieldsDescriptor, geoStan, 528, index, gsFindReturnCode);
                this.addCustomField("DPV_CMRA", returnFieldsDescriptor, geoStan, 529, index, gsFindReturnCode);
                this.addCustomField("DPV_FALSE_POS", returnFieldsDescriptor, geoStan, 530, index, gsFindReturnCode);
                this.addCustomField("DPV_FOOTNOTE1", returnFieldsDescriptor, geoStan, 531, index, gsFindReturnCode);
                this.addCustomField("DPV_FOOTNOTE2", returnFieldsDescriptor, geoStan, 532, index, gsFindReturnCode);
                this.addCustomField("DPV_FOOTNOTE3", returnFieldsDescriptor, geoStan, 533, index, gsFindReturnCode);
                this.addCustomField("DPV_NO_STAT", returnFieldsDescriptor, geoStan, 570, index, gsFindReturnCode);
                this.addCustomField("DPV_SHUTDOWN", returnFieldsDescriptor, geoStan, 572, index, gsFindReturnCode);
                this.addCustomField("DPV_VACANT", returnFieldsDescriptor, geoStan, 569, index, gsFindReturnCode);
            }
            boolean bl2 = outputLACSLink = fp.contains(1035) && fp.getBool(1035);
            if (outputLACSLink) {
                this.addCustomField("LACS_FLAG", returnFieldsDescriptor, geoStan, 76, index, gsFindReturnCode);
                this.addCustomField("LACSLINK_IND", returnFieldsDescriptor, geoStan, 538, index, gsFindReturnCode);
                this.addCustomField("LACSLINK_RETCODE", returnFieldsDescriptor, geoStan, 539, index, gsFindReturnCode);
                this.addCustomField("LACSLINK_SHUTDOWN", returnFieldsDescriptor, geoStan, 573, index, gsFindReturnCode);
            }
            boolean bl3 = outputSuiteLink = fp.contains(1044) && fp.getBool(1044);
            if (outputSuiteLink) {
                this.addCustomField("SUITELINK_RET_CODE", returnFieldsDescriptor, geoStan, 568, index, gsFindReturnCode);
            }
        }
        this.addCustomField("URB_NAME", returnFieldsDescriptor, geoStan, 62, index, gsFindReturnCode);
        this.addCustomField("GOVT_FLAG", returnFieldsDescriptor, geoStan, 77, index, gsFindReturnCode);
        this.addCustomField("ALT_FLAG", returnFieldsDescriptor, geoStan, 78, index, gsFindReturnCode);
        this.addCustomField("MCD_NAME", returnFieldsDescriptor, geoStan, 548, index, gsFindReturnCode);
        this.addCustomField("MCD_NUMBER", returnFieldsDescriptor, geoStan, 549, index, gsFindReturnCode);
        this.addCustomField("MATCHED_DB", returnFieldsDescriptor, geoStan, 571, index, gsFindReturnCode);
        this.addCustomField("ZIP_CLASS", returnFieldsDescriptor, geoStan, 79, index, gsFindReturnCode);
        this.addCustomField("ZIP_FACILITY", returnFieldsDescriptor, geoStan, 80, index, gsFindReturnCode);
        this.addCustomField("AUX_USERDATA", returnFieldsDescriptor, geoStan, 547, index, gsFindReturnCode);
        this.addCustomField("EWS_MATCH", returnFieldsDescriptor, geoStan, 516, index, gsFindReturnCode);
        this.addCustomField("MAIL_STOP", returnFieldsDescriptor, geoStan, 84, index, gsFindReturnCode);
        this.addCustomField("PMB_DESIGNATOR", returnFieldsDescriptor, geoStan, 88, index, gsFindReturnCode);
        this.addCustomField("PMB_NUMBER", returnFieldsDescriptor, geoStan, 89, index, gsFindReturnCode);
        this.addCustomField("RANGE_PARITY", returnFieldsDescriptor, geoStan, 41, index, gsFindReturnCode);
        this.addCustomField("RESOLVED_LINE", returnFieldsDescriptor, geoStan, 87, index, gsFindReturnCode);
        this.addCustomField("ZIP9", returnFieldsDescriptor, geoStan, 33, index, gsFindReturnCode);
        this.addCustomField("ZIP10", returnFieldsDescriptor, geoStan, 34, index, gsFindReturnCode);
        this.addCustomField("ZIP_CARRTSORT", returnFieldsDescriptor, geoStan, 82, index, gsFindReturnCode);
        this.addCustomFieldLanguage("LANGUAGE", returnFieldsDescriptor, DEFAULT_COUNTRY, this.getSourceDictionary());
        this.addCustomField("PB_KEY", returnFieldsDescriptor, geoStan, 595, index, gsFindReturnCode);
    }

    private void copyMatchingInformation(String matchCode) throws GeocodingException {
        this.matchedFields = new GeocodeMatchFields();
        Character zeroChar = Character.valueOf(matchCode.charAt(0));
        if (zeroChar.charValue() == 'E') {
            return;
        }
        Character aChar = Character.valueOf(matchCode.charAt(1));
        if (matchCode.length() >= 3) {
            int iMatchBits;
            if (zeroChar.charValue() == 'S' || zeroChar.charValue() == 'A' || zeroChar.charValue() == 'J' || zeroChar.charValue() == 'Q' || zeroChar.charValue() == 'T' || zeroChar.charValue() == 'U') {
                this.matchedFields.setMatchOnAddressNumber(true);
            }
            if (((iMatchBits = Character.getNumericValue(aChar.charValue())) & 1) == 0) {
                this.matchedFields.setMatchOnPostCode1(true);
            }
            if ((iMatchBits & 2) == 0) {
                this.matchedFields.setMatchOnAreaName3(true);
            }
            if ((iMatchBits & 4) == 0) {
                this.matchedFields.setMatchOnAreaName1(true);
            }
            if ((iMatchBits & 8) == 0) {
                this.matchedFields.setMatchOnPostCode2(true);
            }
            if (((iMatchBits = Character.getNumericValue((aChar = Character.valueOf(matchCode.charAt(2))).charValue())) & 1) == 0) {
                this.matchedFields.setMatchOnStreetType(true);
            }
            if ((iMatchBits & 2) == 0) {
                this.matchedFields.setMatchOnStreetDirectional(true);
            }
            if ((iMatchBits & 4) == 0) {
                this.matchedFields.setMatchOnStreetDirectional(true);
            }
            if ((iMatchBits & 8) == 0) {
                this.matchedFields.setMatchOnStreetName(true);
            }
            if ((zeroChar.charValue() == 'X' || zeroChar.charValue() == 'Y') && matchCode.length() == 4) {
                aChar = Character.valueOf(matchCode.charAt(3));
                iMatchBits = Character.getNumericValue(aChar.charValue());
                if ((iMatchBits & 1) == 0) {
                    this.matchedFields.setMatchOnStreetType(true);
                }
                if ((iMatchBits & 2) == 0) {
                    this.matchedFields.setMatchOnStreetDirectional(true);
                }
                if ((iMatchBits & 4) == 0) {
                    this.matchedFields.setMatchOnStreetDirectional(true);
                }
                if ((iMatchBits & 8) == 0) {
                    this.matchedFields.setMatchOnStreetName(true);
                }
            }
        } else if (matchCode.length() >= 2 && zeroChar.charValue() == 'Z') {
            int iMatchBits = Character.getNumericValue(matchCode.charAt(1));
            if ((iMatchBits & 1) == 0) {
                this.matchedFields.setMatchOnPostCode1(true);
            }
            if ((iMatchBits & 2) == 0) {
                this.matchedFields.setMatchOnAreaName3(true);
            }
            if ((iMatchBits & 4) == 0) {
                this.matchedFields.setMatchOnAreaName1(true);
            }
            if ((iMatchBits & 8) == 0) {
                this.matchedFields.setMatchOnPostCode2(true);
            }
        }
        if (this.matchedFields.isMatchOnAddressNumber() && this.matchedFields.isMatchOnStreetName() && this.matchedFields.isMatchOnStreetType() && this.matchedFields.isMatchOnStreetDirectional()) {
            this.matchedFields.setMatchOnAllStreetFields(true);
        }
    }

    private void getMatchingRange(GeoStan geoStan, short index, short gsFindReturnCode) throws GeocodingException, GeoStanException {
        CandidateRange range = new CandidateRange();
        range.setPlaceName(this.getOutputDataField(geoStan, 59, index, gsFindReturnCode));
        range.setHighHouse(this.getOutputDataField(geoStan, 61, index, gsFindReturnCode));
        range.setLowHouse(this.getOutputDataField(geoStan, 60, index, gsFindReturnCode));
        String streetSide = this.getOutputDataField(geoStan, 39, index, gsFindReturnCode);
        if ("L".equals(streetSide)) {
            range.setSide(StreetSideIndicator.LEFT);
        } else if ("R".equals(streetSide)) {
            range.setSide(StreetSideIndicator.RIGHT);
        } else if ("B".equals(streetSide)) {
            range.setSide(StreetSideIndicator.BOTH);
        } else {
            range.setSide(StreetSideIndicator.UNKNOWN);
        }
        String rangeParity = this.getOutputDataField(geoStan, 41, index, gsFindReturnCode);
        if ("E".equals(rangeParity)) {
            range.setOddEvenIndicator(OddEvenIndicator.EVEN);
        } else if ("O".equals(rangeParity)) {
            range.setOddEvenIndicator(OddEvenIndicator.ODD);
        } else if ("B".equals(rangeParity)) {
            range.setOddEvenIndicator(OddEvenIndicator.BOTH);
        } else {
            range.setOddEvenIndicator(OddEvenIndicator.UNKNOWN);
        }
        CandidateRangeUnit unit = new CandidateRangeUnit();
        unit.setPlaceName(this.getOutputDataField(geoStan, 59, index, gsFindReturnCode));
        unit.setUnitType(this.getOutputDataField(geoStan, 30, index, gsFindReturnCode));
        unit.setHighUnitValue(this.getOutputDataField(geoStan, 36, index, gsFindReturnCode));
        unit.setLowUnitValue(this.getOutputDataField(geoStan, 37, index, gsFindReturnCode));
        range.getUnits().add(unit);
        this.ranges.add(range);
    }

    private String getOutputDataField(GeoStan geoStan, int dataField, short candidateIndex, short gsFindReturnCode) throws GeocodingException {
        try {
            if (candidateIndex == 0 && gsFindReturnCode == 0) {
                return geoStan.getData(dataField);
            }
            return geoStan.getMultipleData(dataField, candidateIndex);
        }
        catch (GeoStanException gse) {
            logger.debug("GeoStan Exception caught while transferring data from GeoStan to candidate, field name: {}, candidate index: {}", new Object[]{dataField, candidateIndex, gse});
            throw new GeocodingException(gse.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, gse);
        }
    }

    private String getCenterlineDataField(GeoStan geoStan, int dataField, short candidateIndex, short gsFindReturnCode) throws GeocodingException {
        try {
            if (candidateIndex == 0 && gsFindReturnCode == 0) {
                return geoStan.getCenterlineData(dataField);
            }
            return geoStan.getMultipleData(dataField, candidateIndex);
        }
        catch (GeoStanException gse) {
            logger.debug("GeoStan Exception caught while transferring data from GeoStan to candidate, field name: {}, candidate index: {}", new Object[]{dataField, candidateIndex, gse});
            throw new GeocodingException(gse.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, gse);
        }
    }

    private int getPrecisionLevel(String georesult) {
        int retVal = 0;
        if (georesult == null || georesult.length() == 0) {
            return retVal;
        }
        char c1 = georesult.charAt(0);
        if ((c1 == 'S' || c1 == 'M') && georesult.length() >= 2) {
            switch (georesult.charAt(1)) {
                case '0': {
                    retVal = 0;
                    break;
                }
                case '1': {
                    retVal = 3;
                    break;
                }
                case '2': {
                    retVal = 4;
                    break;
                }
                case '3': {
                    retVal = 5;
                    break;
                }
                case '4': {
                    retVal = 2;
                    break;
                }
                case '5': {
                    retVal = 1;
                    break;
                }
                case '6': {
                    retVal = 12;
                    break;
                }
                case '7': {
                    retVal = 17;
                    break;
                }
                case '8': {
                    retVal = 16;
                    break;
                }
                case 'C': {
                    retVal = 18;
                    break;
                }
                case 'X': {
                    retVal = 6;
                }
            }
        }
        if (c1 == 'Z' && georesult.length() == 2) {
            switch (georesult.charAt(1)) {
                case '0': {
                    retVal = 3;
                    break;
                }
                case '1': {
                    retVal = 3;
                    break;
                }
                case '2': {
                    retVal = 4;
                    break;
                }
                case '3': {
                    retVal = 5;
                    break;
                }
                case '6': {
                    retVal = 3;
                }
            }
        }
        if (c1 == 'G' && georesult.length() == 2) {
            switch (georesult.charAt(1)) {
                case '1': {
                    retVal = 8;
                    break;
                }
                case '2': {
                    retVal = 9;
                    break;
                }
                case '3': {
                    retVal = 10;
                }
            }
        }
        return retVal;
    }
}

