/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.classloader;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(CustomClassLoader.class);
    List<Path> pathList;
    ClassLoader classLoader;
    static CustomClassLoader current;

    private CustomClassLoader(List<Path> pathList) {
        this.pathList = pathList;
    }

    public static CustomClassLoader getInstance(List<Path> pathList) {
        if (current == null) {
            pathList = pathList == null ? new ArrayList<Path>() : pathList;
            current = new CustomClassLoader(pathList);
        }
        return current;
    }

    public void loadContext(LibraryLoaderStrategy strategy) {
        List<URL> list = this.getListOfFiles(strategy);
        this.classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL url : list) {
                method.invoke((Object)this.classLoader, url);
            }
        }
        catch (IllegalAccessException e) {
            logger.debug("unable to add new lib to class loader", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.debug("unable to add new lib to class loader", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.debug("unable to add new lib to class loader", (Throwable)e);
        }
    }

    protected List<URL> getListOfFiles(LibraryLoaderStrategy strategy) {
        List<URL> urlList = new ArrayList<URL>();
        if (strategy == null) {
            strategy = LibraryLoaderStrategy.LIB_FIRST_FOUND;
        }
        switch (strategy) {
            case LIB_FIRST_FOUND: {
                urlList = this.getListOfFiles(this.pathList.size() > 0 ? this.pathList.get(0) : null);
                break;
            }
            case LIB_HIGHEST_VERSION: {
                urlList = this.getListOfFiles(this.getPathHighestVersion());
                break;
            }
            case LIB_LOAD_ALL: {
                urlList = this.getListOfFiles(this.pathList);
            }
        }
        return urlList;
    }

    protected Path getPathHighestVersion() {
        Path path = this.pathList.size() > 0 ? this.pathList.get(0) : null;
        for (Path path2 : this.pathList) {
        }
        return path;
    }

    protected List<URL> getListOfFiles(List<Path> libPath) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (libPath == null) {
            return urlList;
        }
        for (Path path : libPath) {
            urlList.addAll(this.getListOfFiles(path));
        }
        return urlList;
    }

    protected List<URL> getListOfFiles(Path libPath) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (libPath != null) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(libPath);){
                for (Path path : directoryStream) {
                    logger.debug(String.format("external lib: %s", path.toString()));
                    urlList.add(path.toUri().toURL());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return urlList;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static enum LibraryLoaderStrategy {
        LIB_FIRST_FOUND,
        LIB_HIGHEST_VERSION,
        LIB_LOAD_ALL;

    }
}

