/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.geostan;

import com.centrus.geostan.GeoStan;
import com.centrus.geostan.InitProps;
import com.mapinfo.geocode.geostan.GeoStanObject;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoStanObjectFactory
extends BasePoolableObjectFactory<GeoStanObject> {
    private final InitProps props;
    private static final Logger logger = LoggerFactory.getLogger(GeoStanObjectFactory.class);

    public GeoStanObjectFactory(InitProps props) {
        this.props = props;
    }

    public GeoStanObject makeObject() throws Exception {
        return new GeoStanObject(this.props);
    }

    public void destroyObject(GeoStanObject geoStanObject) throws Exception {
        GeoStan gs = geoStanObject.getGsHandle();
        if (gs != null) {
            long gsID = gs.getGsId();
            gs.term();
            logger.debug("Destroying GeoStan object with handle: {}, messages: {}", (Object)gsID, (Object)gs.getMessage());
        }
    }

    public void passivateObject(GeoStanObject geoStanObject) throws Exception {
        geoStanObject.updateMessages();
        if (!geoStanObject.getMessages().isEmpty()) {
            logger.debug(geoStanObject.getMessages());
            geoStanObject.deleteMessages();
        }
    }
}

