/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.interactive;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodeMatchFields;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.CandidateRange;
import com.mapinfo.geocode.api.CandidateRangeUnit;
import com.mapinfo.geocode.api.OddEvenIndicator;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedRangeUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class InteractiveCandidate
extends Candidate {
    public static final String FORMATTED_STRING = "FORMATTED_STRING";
    public static final String PREFERRED_FORMATTED_STRING = "PREFERRED_FORMATTED_STRING";
    public static final String PREFERRED_LOCATION_ADDRESS = "PREFERRED_LOCATION_ADDRESS";
    public static final String PREFERRED_AREA_NAME_1 = "PREFERRED_AREA_NAME_1";
    public static final String PREFERRED_AREA_NAME_2 = "PREFERRED_AREA_NAME_2";
    public static final String PREFERRED_AREA_NAME_3 = "PREFERRED_AREA_NAME_3";
    public static final String PREFERRED_AREA_NAME_4 = "PREFERRED_AREA_NAME_4";
    public static final String RECORD_TYPE = "RECORD_TYPE";
    public static final String CATEGORY = "CATEGORY";
    public static final String SUB_CATEGORY = "SUB_CATEGORY";
    public static final String BRAND_NAME = "BRAND_NAME";
    public static final String UNIT_INFO = "UNIT_INFO";
    public static final String RANGE_INFO = "RANGE_INFO";
    public static final String FROM_CUSTOM_DATASET = "FROM_CUSTOM_DATASET";
    public static final String DISTANCE = "DISTANCE";
    public static final String DISTANCE_UNIT = "DISTANCE_UNIT";
    public static final String RANGE_PLACE_NAME = "RANGE_PLACE_NAME";
    private static final String FIRM_NAME = "firm_name";

    public InteractiveCandidate(ISuggestedCandidate candidate, Preferences preferences) throws GeocodingException {
        if (preferences == null) {
            throw new GeocodingException("Invalid internal response", ExceptionCode.INTERNAL_ERROR);
        }
        if (candidate != null) {
            this.convertAddress(candidate, preferences);
            this.formattedStreetAddress = candidate.getFormattedStreetAddress();
            this.formattedLocationAddress = candidate.getFormattedLocationAddress();
            this.loadRanges(candidate.getSuggestedRangeList());
            this.convertMatchFields(candidate, preferences);
            this.point = GeocodeUtils.getPointFromDirectPosition(candidate.getLocationPoint(), preferences.getClientCoordSysName());
        }
    }

    protected void convertAddress(ISuggestedCandidate candidate, Preferences preferences) {
        this.address.setCountry(candidate.getCountry());
        this.address.setAreaName4(candidate.getAreaName4());
        this.address.setAreaName3(candidate.getAreaName3());
        this.address.setAreaName2(candidate.getAreaName2());
        this.address.setAreaName1(candidate.getAreaName1());
        this.address.setPlaceName(candidate.getName());
        this.address.setPostCode1(candidate.getPostCode());
        this.address.setAddressNumber(candidate.getAddressNumber());
        if (this.address.getCustomFields() == null) {
            this.address.setCustomFields(new HashMap<String, String>());
        }
        this.copyAdditionalFields(candidate.getAdditionalFields());
        boolean preferredString = true;
        this.address.getCustomFields().put(FORMATTED_STRING, candidate.getFormattedString());
        this.addCustomAddressField(PREFERRED_FORMATTED_STRING, candidate.getFormattedString(), candidate.getFormattedString(preferredString));
        this.addCustomAddressField(PREFERRED_LOCATION_ADDRESS, candidate.getFormattedLocationAddress(), candidate.getFormattedLocationAddress(preferredString));
        this.addCustomAddressField(PREFERRED_AREA_NAME_1, this.address.getAreaName1(), candidate.getAreaName1(preferredString));
        this.addCustomAddressField(PREFERRED_AREA_NAME_2, this.address.getAreaName2(), candidate.getAreaName2(preferredString));
        this.addCustomAddressField(PREFERRED_AREA_NAME_3, this.address.getAreaName3(), candidate.getAreaName3(preferredString));
        this.addCustomAddressField(PREFERRED_AREA_NAME_4, this.address.getAreaName4(), candidate.getAreaName4(preferredString));
        this.address.getCustomFields().put(RECORD_TYPE, String.valueOf(candidate.getType()));
        if (StringUtils.isNotEmpty((CharSequence)candidate.getCategory())) {
            this.address.getCustomFields().put(CATEGORY, candidate.getCategory());
        }
        if (StringUtils.isNotEmpty((CharSequence)candidate.getSubCategory())) {
            this.address.getCustomFields().put(SUB_CATEGORY, candidate.getSubCategory());
        }
        if (StringUtils.isNotEmpty((CharSequence)candidate.getBrandName())) {
            this.address.getCustomFields().put(BRAND_NAME, candidate.getBrandName());
        }
        this.addAdditionalField(preferences, FROM_CUSTOM_DATASET, String.valueOf(candidate.isFromUserDictionary()));
        this.addAdditionalField(preferences, DISTANCE, String.valueOf(candidate.getDistance()));
        this.addAdditionalField(preferences, DISTANCE_UNIT, candidate.getDistanceUnits() != null ? candidate.getDistanceUnits().name() : "");
        this.copyMatchedCharactes(candidate.getMatchedFieldCharacters(), preferences);
    }

    private void copyAdditionalFields(Map<String, String> additionalFields) {
        if (additionalFields != null) {
            for (String key : additionalFields.keySet()) {
                this.address.getCustomFields().put(key.toUpperCase(), additionalFields.get(key));
            }
        }
    }

    private void copyMatchedCharactes(Map<String, String> matched, Preferences preferences) {
        if (matched != null) {
            for (String key : matched.keySet()) {
                String ggsKey = "MATCHED_FROM_" + key.toUpperCase();
                this.addAdditionalField(preferences, ggsKey, matched.get(key));
            }
        }
    }

    protected void convertMatchFields(ISuggestedCandidate candidate, Preferences preferences) {
        Map map = candidate.getMatchedFields();
        if (map != null && (preferences.isReturnAllCandidateInfo() || preferences.getReturnFieldsDescriptor() != null && preferences.getReturnFieldsDescriptor().isReturnMatchDescriptor())) {
            this.matchedFields = new GeocodeMatchFields();
            for (String key : map.keySet()) {
                Integer value = (Integer)map.get(key);
                if (4 == value) {
                    this.matchedFields.setMatchOnAddressNumber(true);
                    continue;
                }
                if (15 == value) {
                    this.matchedFields.setMatchOnPostCode1(true);
                    continue;
                }
                if (201 == value) {
                    this.matchedFields.setMatchOnPostCode2(true);
                    continue;
                }
                if (16 == value) {
                    this.matchedFields.setMatchOnAreaName1(true);
                    continue;
                }
                if (17 == value) {
                    this.matchedFields.setMatchOnAreaName2(true);
                    continue;
                }
                if (18 == value) {
                    this.matchedFields.setMatchOnAreaName3(true);
                    continue;
                }
                if (19 == value) {
                    this.matchedFields.setMatchOnAreaName4(true);
                    continue;
                }
                if (8 == value) {
                    this.matchedFields.setMatchOnStreetName(true);
                    continue;
                }
                if (11 == value) {
                    this.matchedFields.setMatchOnStreetDirectional(true);
                    continue;
                }
                if (12 == value) {
                    this.matchedFields.setMatchOnStreetDirectional(true);
                    continue;
                }
                if (7 == value) {
                    this.matchedFields.setMatchOnPlaceName(true);
                    continue;
                }
                if ("Category".equals(key)) {
                    this.address.getCustomFields().put("MATCHED_ON_CATEGORY", "true");
                    continue;
                }
                if (!"SubCategory".equals(key)) continue;
                this.address.getCustomFields().put("MATCHED_ON_SUB_CATEGORY", "true");
            }
        }
    }

    private void addAdditionalField(Preferences preferences, String key, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        if (preferences.isReturnAllCandidateInfo()) {
            this.address.getCustomFields().put(key, value);
        } else if (preferences.getReturnFieldsDescriptor() != null && preferences.getReturnFieldsDescriptor().getKeysOfCustomFieldsToReturn() != null && preferences.getReturnFieldsDescriptor().getKeysOfCustomFieldsToReturn().contains(key)) {
            this.address.getCustomFields().put(key, value);
        }
    }

    private void addCustomAddressField(String key, String addressField, String addressField1) {
        if (StringUtils.isNotEmpty((CharSequence)addressField1) && !addressField1.equals(addressField)) {
            this.address.getCustomFields().put(key, addressField1);
        }
    }

    protected void loadRanges(List<ISuggestedCandidateRange> rangeList) {
        if (rangeList != null) {
            for (ISuggestedCandidateRange range : rangeList) {
                CandidateRange range1 = new CandidateRange();
                range1.setHighHouse(range.getTo());
                range1.setLowHouse(range.getFrom());
                range1.setOddEvenIndicator(this.geOddEvenType(range.getOddEvenType()));
                range1.setUnits(this.convertUnits(range.getRangeUnits()));
                range1.getCustomValues().put(RANGE_INFO, range.getRangeString());
                if (range.getAdditionalFields() != null) {
                    for (String key : range.getAdditionalFields().keySet()) {
                        if (RANGE_PLACE_NAME.equalsIgnoreCase(key)) {
                            range1.setPlaceName((String)range.getAdditionalFields().get(key));
                            continue;
                        }
                        range1.getCustomValues().put(key.toUpperCase(), (String)range.getAdditionalFields().get(key));
                    }
                }
                this.ranges.add(range1);
            }
        }
    }

    protected List<CandidateRangeUnit> convertUnits(List<ISuggestedRangeUnit> unitList) {
        ArrayList<CandidateRangeUnit> units = new ArrayList<CandidateRangeUnit>();
        if (unitList != null) {
            for (ISuggestedRangeUnit unit : unitList) {
                CandidateRangeUnit candidateRangeUnit = new CandidateRangeUnit();
                candidateRangeUnit.getCustomValues().put(UNIT_INFO, unit.getUnitString());
                if (unit.getAdditionalFields() != null) {
                    String val = (String)unit.getAdditionalFields().get(FIRM_NAME);
                    candidateRangeUnit.setPlaceName(val);
                    for (String key : unit.getAdditionalFields().keySet()) {
                        if (FIRM_NAME.equals(key)) continue;
                        candidateRangeUnit.getCustomValues().put(key.toUpperCase(), (String)unit.getAdditionalFields().get(key));
                    }
                }
                units.add(candidateRangeUnit);
            }
        }
        return units;
    }

    protected OddEvenIndicator geOddEvenType(int value) {
        OddEvenIndicator indicator;
        switch (value) {
            case 0: {
                indicator = OddEvenIndicator.BOTH;
                break;
            }
            case 1: {
                indicator = OddEvenIndicator.ODD;
                break;
            }
            case 2: {
                indicator = OddEvenIndicator.EVEN;
                break;
            }
            default: {
                indicator = OddEvenIndicator.UNKNOWN;
            }
        }
        return indicator;
    }
}

