/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.interactive;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.InteractiveGeocodingAPI;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.geocode.classloader.CustomClassLoader;
import com.mapinfo.geocode.interactive.InteractiveGeocoderAdapter;
import com.mapinfo.geocode.util.ApplicationConfiguration;
import com.mapinfo.geocode.util.DefaultPreferencesProvider;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.midev.geometry.IPoint;
import com.pb.geocoding.config.JsonConfigurationImpl;
import com.pb.geocoding.config.api.GeocodingConfiguration;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class InteractiveGeocoder
implements InteractiveGeocodingAPI {
    static final ApplicationConfiguration configuration;
    InteractiveGeocoderAdapter adapter;
    private static final Logger logger;

    public InteractiveGeocoder() throws GeocodingException {
        File settings = new File(InteractiveGeocoder.getConfigurationLocation().toAbsolutePath().toString(), "JsonDataConfig.json");
        JsonConfigurationImpl config = new JsonConfigurationImpl(settings);
        this.init((GeocodingConfiguration)config);
    }

    public InteractiveGeocoder(GeocodingConfiguration configuration) throws GeocodingException {
        this.init(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(GeocodingConfiguration config) throws GeocodingException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            CustomClassLoader.LibraryLoaderStrategy strategy = CustomClassLoader.LibraryLoaderStrategy.LIB_FIRST_FOUND;
            ArrayList<Path> paths = new ArrayList<Path>();
            if (config != null) {
                Map classLoaderConfig;
                String strategyString = (String)config.getConfig("LIBRARY_LOADING_STRATEGY");
                if (EnumUtils.isValidEnum(CustomClassLoader.LibraryLoaderStrategy.class, (String)strategyString)) {
                    strategy = CustomClassLoader.LibraryLoaderStrategy.valueOf(strategyString);
                }
                if ((classLoaderConfig = (Map)config.getConfig("classloader")) != null) {
                    List libPaths = (List)classLoaderConfig.get("libraries");
                    for (String libPath : libPaths) {
                        paths.add(Paths.get(libPath, new String[0]));
                    }
                }
            }
            CustomClassLoader classLoader = CustomClassLoader.getInstance(paths);
            classLoader.loadContext(strategy);
            Class<?> interactiveAdapterClass = classLoader.getClassLoader().loadClass("com.mapinfo.geocode.interactive.InteractiveGeocoderAdapter");
            this.adapter = (InteractiveGeocoderAdapter)interactiveAdapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.adapter.configure(config);
        }
        catch (NoClassDefFoundError e) {
            logger.debug("Cannot initialize interactive geocoding", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.debug("Cannot initialize interactive geocoding", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.debug("Cannot initialize interactive geocoding", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.debug("Cannot initialize interactive geocoding", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.debug("Cannot initialize interactive geocoding", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Cannot initialize interactive geocoding", (Throwable)e);
        }
        catch (Exception e) {
            logger.debug("Cannot initialize interactive geocoding", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    @Override
    public Response suggest(Address address, Preferences preferences) throws GeocodingException {
        if (this.adapter == null) {
            throw new GeocodingException("Data not available", ExceptionCode.INVALID_CONFIGURATION);
        }
        if (preferences == null) {
            preferences = DefaultPreferencesProvider.getInstance().getDefaultInteractivePreferences();
        }
        if (address == null) {
            throw new GeocodingException("Invalid address object", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        return this.adapter.suggest(address, preferences);
    }

    @Override
    public Response findNearest(IPoint origin, Preferences preferences) throws GeocodingException {
        if (this.adapter == null) {
            throw new GeocodingException("Data not available", ExceptionCode.INVALID_CONFIGURATION);
        }
        if (preferences == null) {
            preferences = DefaultPreferencesProvider.getInstance().getDefaultInteractivePreferences();
        }
        if (origin == null) {
            throw new GeocodingException("Invalid point object", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        preferences.setPoint(origin);
        return this.adapter.findNearest(preferences);
    }

    @Override
    public Response findNearest(double x, double y, Preferences preferences) throws GeocodingException {
        if (preferences == null) {
            preferences = DefaultPreferencesProvider.getInstance().getDefaultInteractivePreferences();
        }
        IPoint point = GeocodeUtils.getPointFromXY(x, y, preferences.getClientCoordSysName());
        return this.findNearest(point, preferences);
    }

    public static Path getConfigurationLocation() {
        return Paths.get(configuration.getConfigLocation(), new String[0]);
    }

    static {
        logger = LoggerFactory.getLogger(InteractiveGeocoder.class);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("propertiesBeans.xml");
        configuration = (ApplicationConfiguration)context.getBean("applicationConfigurationBean");
    }
}

