/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.service;

import com.google.common.base.Objects;
import com.mapinfo.geocode.Pair;
import com.mapinfo.geocode.api.CapabilitiesResponse;
import com.mapinfo.geocode.api.CustomObject;
import com.mapinfo.geocode.api.Operation;
import com.mapinfo.geocode.service.KeyValuePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class CapabilitiesServiceResponse {
    private final CapabilitiesResponse response;

    public CapabilitiesServiceResponse(CapabilitiesResponse internalResponse) {
        this.response = internalResponse;
    }

    public String getServiceName() {
        return this.response.getServiceName();
    }

    public String getServiceDesc() {
        return this.response.getServiceDesc();
    }

    public String getCoreVersion() {
        return this.response.getCoreVersion();
    }

    public List<String> getGeocodingEngines() {
        return this.response.getGeocodingEngines();
    }

    public List<Operation> getSupportedOperations() {
        return this.response.getSupportedOperations();
    }

    public List<String> getSupportedCountries() {
        return this.response.getSupportedCountries();
    }

    public List<CustomObject> getCustomObjects() {
        return this.response.getCustomObjects();
    }

    public List<KeyValuePair> getGeocoderVersions() {
        List<Pair<String, String>> internalList = this.response.getGeocoderVersions();
        if (internalList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<KeyValuePair> returnableList = new ArrayList<KeyValuePair>(internalList.size());
        for (Pair<String, String> pair : internalList) {
            returnableList.add(new KeyValuePair(pair.getVal1().toString(), pair.getVal2().toString()));
        }
        return returnableList;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("response", (Object)this.response).toString();
    }
}

