/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.service;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.GeocodeType;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.util.GeocodeUtils;
import java.util.ArrayList;
import java.util.List;

public class GeocodeRequest {
    public static final GeocodeType DEFAULT_TYPE = GeocodeType.ADDRESS;
    private GeocodeType type;
    private Preferences preferences;
    private List<Address> addresses;

    public GeocodeType getType() {
        return this.type;
    }

    public void setType(GeocodeType type) {
        this.type = type;
    }

    public List<Address> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Address>();
        }
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) throws GeocodingException {
        if (addresses == null || addresses.isEmpty()) {
            throw new GeocodingException("At least one address must be provided", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
        this.addresses = addresses;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("Geocode request type: ");
        stringBuilder.append((Object)this.type);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append(this.addresses);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append(this.preferences);
        return stringBuilder.toString();
    }
}

