/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import java.io.File;
import java.io.FilenameFilter;

public class CommonFileUtils {
    private static final String CAPABILITIES_FILE_FILTER = "capabilities.xml";
    public static FilenameFilter capabilitiesFileNameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(CommonFileUtils.CAPABILITIES_FILE_FILTER);
        }
    };
    public static FilenameFilter geographicFilenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lower = name.toLowerCase();
            return "geoinfo.jdr".equals(lower) || lower.contains("geo") && lower.endsWith(".adw");
        }
    };
    public static FilenameFilter postalFilenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lower = name.toLowerCase();
            return "postinfo.jdr".equals(lower) || lower.contains("post") && lower.endsWith(".adw");
        }
    };
    public static FilenameFilter cggePointFilenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lower = name.toLowerCase();
            return lower.endsWith(".adw") && (lower.contains("point") || lower.contains("pnt"));
        }
    };
}

