/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mapinfo.geocode.CharacterSets;
import com.mapinfo.geocode.CharsetCountries;
import com.mapinfo.geocode.Countries;
import com.mapinfo.geocode.CountryNames;
import com.mapinfo.geocode.CountrySupport;
import com.mapinfo.geocode.DictionaryLanguage;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodeConfiguration;
import com.mapinfo.geocode.Geocoder;
import com.mapinfo.geocode.GeocoderDictionary;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.DataType;
import com.mapinfo.geocode.api.Dictionary;
import com.mapinfo.geocode.util.CommonFileUtils;
import com.mapinfo.geocode.util.DataManagerSettingsMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.EnumUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    public static final String NAME = "name";
    public static final String OPTIONAL = "optional";
    public static final String VINTAGE = "vintage";
    public static final String VERSION = "version";
    public static final String PROVIDER = "provider";
    public static final String REGION = "region";
    public static final String DESCRIPTION = "description";
    public static final String SUPPORTED_COUNTRIES = "supportedCountries";
    public static final String SUPPORTED_DICTIONARIES = "supportedDictionaries";
    public static final String PRIMARY_COUNTRY = "primaryCountry";
    public static final String PRIMARY_LANGUAGE = "primaryLanguage";
    public static final String GEOCODING_ENGINES = "geocodingEngines";
    public static final String GEOCODING_ENGINE = "geocodingEngine";
    public static final String DATA_TYPE = "dataType";
    private static final String NO_INFORMATION_AVAILABLE = "no information available";
    private static DataManagerSettingsMapper dataManagerSettingsMapper;
    private static Map<String, List<Dictionary>> countryToDictionaryMap;
    private static List<Element> localCapabilityElements;
    private static IOException setupException;
    private static final AtomicBoolean initDone;
    private static final AtomicBoolean initCountryNames;
    private static Set<CountryNames> countryNamesSet;
    private static final AtomicBoolean initCharsetCountries;
    private static String charsetCountriesString;
    protected static Map<String, DictionaryLanguage> dictionaryLanguageMap;

    public static void setDataManagerSettingsMapper(DataManagerSettingsMapper dataMgr) throws GeocodingException {
        dataManagerSettingsMapper = dataMgr;
        initDone.set(false);
        initCountryNames.set(false);
        initCharsetCountries.set(false);
        ConfigurationManager.initCapabilities();
        GeocodeConfiguration.reset();
    }

    public static void initCapabilities() {
        if (initDone.compareAndSet(false, true)) {
            try {
                localCapabilityElements = Collections.unmodifiableList(ConfigurationManager.readLocalCapabilitiesFiles());
            }
            catch (IOException ex) {
                setupException = ex;
            }
            dictionaryLanguageMap = new HashMap<String, DictionaryLanguage>();
            countryToDictionaryMap = Collections.unmodifiableMap(ConfigurationManager.collectAllDictionaryInfo());
        }
    }

    public static List<Element> collectAllLocalCapabilitiesFiles() throws IOException {
        if (setupException != null) {
            throw setupException;
        }
        return localCapabilityElements;
    }

    private static List<Element> readLocalCapabilitiesFiles() throws IOException {
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        ConfigurationManager.getCapabilitiesFiles(elementMap, Geocoder.getConfigurationLocation());
        Map<String, Properties> map = dataManagerSettingsMapper.getCountryPropMap();
        for (Map.Entry<String, Properties> entry : map.entrySet()) {
            Properties properties = entry.getValue();
            int count = 1;
            String countStr = properties.getProperty("DICTIONARY_COUNT");
            if (countStr != null) {
                try {
                    count = Integer.valueOf(countStr);
                }
                catch (NumberFormatException ex) {
                    count = 0;
                }
            }
            for (int i = 1; i <= count; ++i) {
                String dir = properties.getProperty("DICTIONARY_PATH" + i);
                if (dir == null) continue;
                ConfigurationManager.getCapabilitiesFiles(elementMap, Paths.get(dir, new String[0]));
            }
        }
        ArrayList<Element> list = new ArrayList<Element>(elementMap.values());
        return list;
    }

    public static Map<String, List<Dictionary>> getDictionaryMap() {
        HashMap<String, List<Dictionary>> copyMap = new HashMap<String, List<Dictionary>>();
        for (String key : countryToDictionaryMap.keySet()) {
            List<Dictionary> otherList = countryToDictionaryMap.get(key);
            ArrayList<GeocoderDictionary> myList = new ArrayList<GeocoderDictionary>();
            for (Dictionary otherDict : otherList) {
                myList.add(new GeocoderDictionary(otherDict));
            }
            copyMap.put(key, myList);
        }
        return copyMap;
    }

    protected static Map<String, List<Dictionary>> collectAllDictionaryInfo() {
        HashMap<String, String> countryMap = new HashMap<String, String>();
        HashSet<String> localGeocodingEngines = new HashSet<String>();
        if (localCapabilityElements != null && !localCapabilityElements.isEmpty()) {
            for (Element element : localCapabilityElements) {
                String primary = element.getChildText(PRIMARY_COUNTRY);
                if ("USA".equals(primary)) continue;
                localGeocodingEngines.add(primary);
                String otherCountries = element.getChildText(SUPPORTED_COUNTRIES);
                if (otherCountries == null || otherCountries.indexOf(44) <= 0) continue;
                countryMap.put(primary, otherCountries);
            }
        }
        localGeocodingEngines.addAll(ConfigurationManager.dataManagerSettingsMapper.countryPropMap.keySet());
        HashMap<String, List<Dictionary>> masterMap = new HashMap<String, List<Dictionary>>();
        Map<String, Properties> map = dataManagerSettingsMapper.getCountryPropMap();
        for (String countryKey : localGeocodingEngines) {
            Properties properties = map.get(countryKey);
            if (properties == null) continue;
            int count = 1;
            String countStr = properties.getProperty("DICTIONARY_COUNT");
            if (countStr != null) {
                try {
                    count = Integer.valueOf(countStr);
                }
                catch (NumberFormatException ex) {
                    count = 0;
                }
            }
            if (count == 0) continue;
            ArrayList<Dictionary> dictionaryList = new ArrayList<Dictionary>();
            for (int i = 1; i <= count; ++i) {
                String dir = properties.getProperty("DICTIONARY_PATH" + i);
                Dictionary dictionary = ConfigurationManager.buildDictionary(dir, countryKey, (String)countryMap.get(countryKey), i);
                if (dictionary == null) continue;
                dictionaryList.add(dictionary);
            }
            if (dictionaryList.size() <= 0) continue;
            masterMap.put(countryKey, dictionaryList);
        }
        return masterMap;
    }

    protected static Dictionary buildDictionary(String path, String country, String supplementalCountries, int sourceDictionary) {
        GeocoderDictionary dictionary;
        block6: {
            dictionary = new GeocoderDictionary();
            dictionary.setPath(path);
            File file = new File(path, "dictionarydesc.properties");
            try {
                if (file.exists()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(file));
                    dictionary.setVintage(properties.getProperty(VINTAGE));
                    dictionary.setSource(properties.getProperty(PROVIDER));
                    dictionary.setRegion(properties.getProperty(REGION));
                    CountrySupport countrySupport = ConfigurationManager.buildCountrySupportWithCountryList(properties.getProperty(SUPPORTED_COUNTRIES), null);
                    String description = properties.getProperty(DESCRIPTION);
                    if (description != null) {
                        description = description.toLowerCase();
                    }
                    String dataType = properties.getProperty(DATA_TYPE);
                    countrySupport.setSupportedDataTypes(ConfigurationManager.getDictionaryDataTypesFromDirectory(path, country, dataType, description));
                    dictionary.setCountrySupportInformation(ConfigurationManager.buildCountrySupportSet(countrySupport));
                    dictionary.setDescription(properties.getProperty(DESCRIPTION));
                    dictionary.setRepositoryName(properties.getProperty(DESCRIPTION));
                    String language = properties.getProperty(PRIMARY_LANGUAGE);
                    if (language != null) {
                        DictionaryLanguage dictionaryLanguage = dictionaryLanguageMap.containsKey(country) ? dictionaryLanguageMap.get(country) : new DictionaryLanguage();
                        dictionaryLanguage.addDictionaryLanguage(String.valueOf(sourceDictionary - 1), language);
                        dictionaryLanguageMap.put(country, dictionaryLanguage);
                    }
                    break block6;
                }
                file = new File(path, "dictionarydesc.txt");
                if (file.exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    String desc = reader.readLine();
                    reader.close();
                    ConfigurationManager.processDictionarySearchOrderDescription(dictionary, desc, country, supplementalCountries);
                    break block6;
                }
                dictionary.setDescription(NO_INFORMATION_AVAILABLE);
                dictionary.setRepositoryName(NO_INFORMATION_AVAILABLE);
                return dictionary;
            }
            catch (IOException fnf) {
                return null;
            }
        }
        return dictionary;
    }

    private static void processDictionarySearchOrderDescription(Dictionary dict, String desc, String countryCode, String supplementalCountries) {
        String[] parts;
        if (desc == null) {
            return;
        }
        dict.setRepositoryName(desc);
        dict.setDescription(desc);
        int idx = desc.lastIndexOf(46);
        if (idx > 0) {
            StringBuilder stringBuilder = new StringBuilder(desc);
            stringBuilder.setCharAt(idx, '_');
            desc = stringBuilder.toString();
        }
        if ((parts = desc.split("_")).length < 4) {
            return;
        }
        StringBuilder sb = new StringBuilder(parts[parts.length - 2]);
        sb.append('.');
        sb.append(parts[parts.length - 1]);
        dict.setVintage(sb.toString());
        String country = countryCode;
        if (supplementalCountries != null) {
            country = supplementalCountries;
        }
        CountrySupport cs = ConfigurationManager.buildCountrySupportWithCountryList(country, countryCode);
        cs.setSupportedDataTypes(ConfigurationManager.getDictionaryDataTypesFromDirectory(dict.getPath(), countryCode, null, desc.toLowerCase()));
        dict.setCountrySupportInformation(ConfigurationManager.buildCountrySupportSet(cs));
        sb.setLength(0);
        for (int i = 2; i < parts.length - 2; ++i) {
            if (sb.length() != 0) {
                sb.append('_');
            }
            sb.append(parts[i]);
        }
        if (sb.length() > 0) {
            dict.setSource(sb.toString());
        }
    }

    private static CountrySupport buildCountrySupportWithCountryList(String countries, String country) {
        CountrySupport cs = new CountrySupport();
        if (countries != null) {
            StringTokenizer st = new StringTokenizer(countries, ", ");
            HashSet<String> countrySet = new HashSet<String>(st.countTokens());
            while (st.hasMoreTokens()) {
                countrySet.add(st.nextToken());
            }
            cs.setSupportedCountries(countrySet);
        } else {
            HashSet<String> countrySet = new HashSet<String>(1);
            countrySet.add(country);
            cs.setSupportedCountries(countrySet);
        }
        return cs;
    }

    private static Set<CountrySupport> buildCountrySupportSet(CountrySupport countrySupport) {
        HashSet<CountrySupport> countrySupports = new HashSet<CountrySupport>(1);
        countrySupports.add(countrySupport);
        return countrySupports;
    }

    private static void getCapabilitiesFiles(Map<String, Element> map, Path dir) throws IOException {
        File dataDir = dir.toFile();
        File[] capabilityFiles = dataDir.listFiles(CommonFileUtils.capabilitiesFileNameFilter);
        if (capabilityFiles != null) {
            for (File capabilityFile : capabilityFiles) {
                try {
                    boolean skip;
                    SAXBuilder builder = new SAXBuilder();
                    Document doc = builder.build(capabilityFile);
                    String key = capabilityFile.getName().substring(0, 3);
                    Element element = doc.getRootElement();
                    String primary = element.getChildText(PRIMARY_COUNTRY);
                    boolean bl = skip = dataManagerSettingsMapper != null && primary != null && !dataManagerSettingsMapper.isCountryConfigured(primary.toUpperCase());
                    if (skip) continue;
                    map.put(key, doc.getRootElement());
                }
                catch (JDOMException ex) {
                    throw new IOException("cannot read capabilities file " + capabilityFile, ex);
                }
                catch (IOException ioex) {
                    throw new IOException("cannot read capabilities file " + capabilityFile, ioex);
                }
            }
        }
    }

    public static XMLConfiguration collectAllMatches(List<Element> localCapabilities) {
        ArrayList<ConfigurationNode> collectionElement = new ArrayList<ConfigurationNode>();
        if (localCapabilities != null) {
            for (Element local : localCapabilities) {
                collectionElement.add(ConfigurationManager.buildEngineDescription(local));
            }
        }
        XMLConfiguration xmlConfiguration = new XMLConfiguration();
        xmlConfiguration.addNodes(GEOCODING_ENGINES, collectionElement);
        return xmlConfiguration;
    }

    private static ConfigurationNode buildEngineDescription(Element element) {
        DefaultConfigurationNode engineElement = new DefaultConfigurationNode(GEOCODING_ENGINE);
        ConfigurationManager.addString((ConfigurationNode)engineElement, NAME, element.getChildText(NAME));
        ConfigurationManager.addString((ConfigurationNode)engineElement, VINTAGE, element.getChildText(VINTAGE));
        ConfigurationManager.addString((ConfigurationNode)engineElement, VERSION, element.getChildText(VERSION));
        ConfigurationManager.addString((ConfigurationNode)engineElement, PRIMARY_COUNTRY, element.getChildText(PRIMARY_COUNTRY));
        ConfigurationManager.addString((ConfigurationNode)engineElement, SUPPORTED_COUNTRIES, element.getChildText(SUPPORTED_COUNTRIES));
        ConfigurationManager.addString((ConfigurationNode)engineElement, SUPPORTED_DICTIONARIES, element.getChildText(SUPPORTED_DICTIONARIES));
        return engineElement;
    }

    private static void addString(ConfigurationNode base, String key, String value) {
        if (value != null && !value.isEmpty()) {
            DefaultConfigurationNode element = new DefaultConfigurationNode(key);
            element.setValue((Object)value);
            base.addChild((ConfigurationNode)element);
        }
    }

    protected static Set<DataType> getDictionaryDataTypesFromDirectory(String dir, String country, String dataType, String descLowerCase) {
        HashSet<DataType> types = new HashSet<DataType>();
        if (country == null) {
            return types;
        }
        if ("XWG".equals(country)) {
            types.add(DataType.AREA_NAME_3);
            types.add(DataType.POST_CODE_1);
            return types;
        }
        File dataDir = new File(dir);
        File[] files = dataDir.listFiles(CommonFileUtils.geographicFilenameFilter);
        if (files != null && files.length > 0) {
            types.add(DataType.AREA_NAME_3);
        }
        if ((files = dataDir.listFiles(CommonFileUtils.postalFilenameFilter)) != null && files.length > 0) {
            types.add(DataType.POST_CODE_1);
        }
        if (StringUtils.isNotEmpty((String)dataType)) {
            DataType dataTypeTemp = null;
            if (EnumUtils.isValidEnum(DataType.class, (String)dataType)) {
                dataTypeTemp = DataType.valueOf(dataType.toUpperCase());
            }
            if (dataTypeTemp != null) {
                types.add(dataTypeTemp);
            } else {
                ConfigurationManager.addDataTypesAlternate(dataDir, types, country, descLowerCase);
            }
        } else {
            ConfigurationManager.addDataTypesAlternate(dataDir, types, country, descLowerCase);
        }
        return types;
    }

    private static void addDataTypesAlternate(File dataDir, Set<DataType> types, String country, String descLowerCase) {
        if (ConfigurationManager.isPointDictionary(dataDir, country, descLowerCase)) {
            types.add(DataType.POINT);
        } else {
            types.add(DataType.STREET);
        }
    }

    private static boolean isPointDictionary(File dataDir, String country, String descLowerCase) {
        File[] files = dataDir.listFiles(CommonFileUtils.cggePointFilenameFilter);
        if (files != null && files.length > 0) {
            return true;
        }
        if (country.equals("AUS") && descLowerCase != null && descLowerCase.contains("gnaf")) {
            return true;
        }
        return descLowerCase != null && (descLowerCase.contains("point") || descLowerCase.contains("pt") || descLowerCase.contains("pnt"));
    }

    protected static Set<CountryNames> buildCountryNames() {
        Set<CountryNames> countryNamesSet = new HashSet<CountryNames>();
        ObjectMapper maapper = new ObjectMapper();
        File file = new File(Geocoder.getConfigurationLocation().toAbsolutePath().toString(), "alternateCountryNames.json");
        try {
            InputStream inputStream = file.exists() ? new FileInputStream(file) : ConfigurationManager.class.getResourceAsStream("/alternateCountryNames.json");
            if (inputStream == null) {
                throw new GeocodingException(String.format("Required resource missing %s", "alternateCountryNames.json"), ExceptionCode.INVALID_CONFIGURATION);
            }
            Countries countries = (Countries)maapper.readValue((Reader)new InputStreamReader(inputStream, "UTF-8"), Countries.class);
            countryNamesSet = countries.getCountries();
        }
        catch (JsonGenerationException e) {
            logger.error("An error occurred while reading country names", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error("An error occurred while reading country names", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("An error occurred while reading country names", (Throwable)e);
        }
        catch (GeocodingException e) {
            logger.error("An error occurred while reading country names", (Throwable)e);
        }
        return countryNamesSet;
    }

    public static String getISO3CountryFromDatabase(String country) {
        if (initCountryNames.compareAndSet(false, true)) {
            countryNamesSet = ConfigurationManager.buildCountryNames();
        }
        if (country != null) {
            country = country.toUpperCase();
        }
        for (CountryNames countryNames : countryNamesSet) {
            if (countryNames.getPrimary().equals(country)) {
                return country;
            }
            if (!countryNames.getAltNames().contains(country)) continue;
            return countryNames.getPrimary();
        }
        return country;
    }

    public static boolean isISO3Valid(String country) {
        if (initCountryNames.compareAndSet(false, true)) {
            countryNamesSet = ConfigurationManager.buildCountryNames();
        }
        if (country != null) {
            country = country.toUpperCase();
            for (CountryNames countryNames : countryNamesSet) {
                if (!countryNames.getPrimary().equals(country)) continue;
                return true;
            }
        }
        return false;
    }

    public static CountryNames getCountryNames(String country) {
        if (initCountryNames.compareAndSet(false, true)) {
            countryNamesSet = ConfigurationManager.buildCountryNames();
        }
        if (country != null) {
            country = country.toUpperCase();
        }
        for (CountryNames countryNames : countryNamesSet) {
            if (countryNames.getPrimary().equals(country)) {
                return countryNames;
            }
            if (!countryNames.getAltNames().contains(country)) continue;
            return countryNames;
        }
        return null;
    }

    public static String getPrimaryLanguage(String country, String sourceDictionary) {
        String lang = null;
        try {
            DictionaryLanguage dictionaryLanguage = dictionaryLanguageMap.get(country);
            lang = dictionaryLanguage.getDictionaryLanguage().get(sourceDictionary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lang;
    }

    public static CountryNames findCountryNameOnEndsOfString(StringBuilder possibleCountry) {
        if (possibleCountry == null || possibleCountry.length() == 0) {
            return null;
        }
        CountryNames names = ConfigurationManager.getCountryNames(possibleCountry.toString());
        if (names != null) {
            possibleCountry.replace(0, possibleCountry.length(), "");
            return names;
        }
        String upperString = possibleCountry.toString().toUpperCase();
        for (CountryNames countryNames : countryNamesSet) {
            String name = countryNames.getPrimary();
            if (ConfigurationManager.findStringAtStartOrEnd(upperString, possibleCountry, name)) {
                return countryNames;
            }
            for (String alt : countryNames.getAltNames()) {
                if (!ConfigurationManager.findStringAtStartOrEnd(upperString, possibleCountry, alt)) continue;
                return countryNames;
            }
        }
        return null;
    }

    protected static boolean findStringAtStartOrEnd(String uppercaseString, StringBuilder sb, String stringToFind) {
        if (uppercaseString == null || sb == null || stringToFind == null || !uppercaseString.equalsIgnoreCase(sb.toString())) {
            return false;
        }
        int lenToFind = stringToFind.length();
        if (lenToFind > uppercaseString.length()) {
            return false;
        }
        int foundIdx = uppercaseString.lastIndexOf(stringToFind);
        if (foundIdx < 0) {
            return false;
        }
        int totalLen = foundIdx + lenToFind;
        if (foundIdx == 0 && (uppercaseString.length() == totalLen || uppercaseString.charAt(totalLen) == ' ')) {
            sb.replace(0, lenToFind, "");
            String remaining = sb.toString();
            if (remaining.length() > 0) {
                sb.replace(0, remaining.length(), remaining.trim());
            }
            return true;
        }
        if (foundIdx > 0 && totalLen == uppercaseString.length() && uppercaseString.charAt(foundIdx - 1) == ' ') {
            sb.delete(foundIdx - 1, totalLen);
            return true;
        }
        if (totalLen < uppercaseString.length() && uppercaseString.indexOf(stringToFind) == 0 && uppercaseString.charAt(totalLen) == ' ') {
            sb.replace(0, lenToFind, "");
            String remaining = sb.toString();
            if (remaining.length() > 0) {
                sb.replace(0, remaining.length(), remaining.trim());
            }
            return true;
        }
        return false;
    }

    public static String getCharsetCountriesAsString() {
        if (initCharsetCountries.compareAndSet(false, true)) {
            Set<CharsetCountries> set = ConfigurationManager.buildSupportedCharsets();
            StringBuilder sb = new StringBuilder();
            if (set != null) {
                for (CharsetCountries value : set) {
                    sb.append(value.getName());
                    sb.append(' ');
                    for (String country : value.getCountries()) {
                        sb.append(country);
                        sb.append(' ');
                    }
                    sb.append(':');
                }
            }
            charsetCountriesString = sb.toString();
        }
        return charsetCountriesString;
    }

    protected static Set<CharsetCountries> buildSupportedCharsets() {
        Set<CharsetCountries> charsetCountriesSet = new HashSet<CharsetCountries>();
        ObjectMapper mapper = new ObjectMapper();
        File file = new File(Geocoder.getConfigurationLocation().toAbsolutePath().toString(), "supportedCharsets.json");
        try {
            InputStream inputStream = file.exists() ? new FileInputStream(file) : ConfigurationManager.class.getResourceAsStream("/supportedCharsets.json");
            if (inputStream == null) {
                throw new GeocodingException(String.format("Required resource missing %s", "supportedCharsets.json"), ExceptionCode.INVALID_CONFIGURATION);
            }
            CharacterSets countries = (CharacterSets)mapper.readValue((Reader)new InputStreamReader(inputStream, "UTF-8"), CharacterSets.class);
            charsetCountriesSet = countries.getCharsets();
        }
        catch (JsonGenerationException e) {
            logger.error("An error occurred while reading country names", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error("An error occurred while reading country names", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("An error occurred while reading country names", (Throwable)e);
        }
        catch (GeocodingException e) {
            logger.error("An error occurred while reading country names", (Throwable)e);
        }
        return charsetCountriesSet;
    }

    static {
        setupException = null;
        initDone = new AtomicBoolean(false);
        initCountryNames = new AtomicBoolean(false);
        initCharsetCountries = new AtomicBoolean(false);
    }
}

