/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import com.mapinfo.geocode.util.CountryBoundaryManager;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.pb.geocoding.config.api.GeocodingConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManagerSettingsMapper {
    private Map<String, String> subCountriesMapping;
    private Set<String> availableCountries = null;
    protected Map<String, Properties> countryPropMap = new HashMap<String, Properties>();
    private static final Logger logger = LoggerFactory.getLogger(DataManagerSettingsMapper.class);

    public DataManagerSettingsMapper() {
        this.subCountriesMapping = new HashMap<String, String>();
        this.subCountriesMapping.put("LUX", "BEL");
        this.subCountriesMapping.put("GLP", "FRA");
        this.subCountriesMapping.put("GUF", "FRA");
        this.subCountriesMapping.put("MCO", "FRA");
        this.subCountriesMapping.put("MTQ", "FRA");
        this.subCountriesMapping.put("MYT", "FRA");
        this.subCountriesMapping.put("REU", "FRA");
        this.subCountriesMapping.put("AND", "ESP");
        this.subCountriesMapping.put("GIB", "ESP");
        this.subCountriesMapping.put("SMR", "ITA");
        this.subCountriesMapping.put("VAT", "ITA");
        this.subCountriesMapping.put("LIE", "CHE");
    }

    public void init(GeocodingConfiguration configuration) {
        this.loadSettingFiles(configuration);
        try {
            if (GeocodeUtils.isClass("com.mapinfo.mapmarker.common.dp.binary.IReverseGeocodeDataDictionary")) {
                CountryBoundaryManager.initialize(this.countryPropMap);
                this.mapPropertiesToGeocoder();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    protected void loadSettingFiles(GeocodingConfiguration configuration) {
        try {
            this.countryPropMap = configuration.getCountryProperties();
        }
        catch (Exception e) {
            logger.error("Error loading settings file: {}", (Object)"", (Object)e);
        }
    }

    public void mapPropertiesToGeocoder() {
        DataManagerSettingsProvider provider = DataManagerSettingsProvider.getInstance();
        for (Map.Entry<String, Properties> entry : this.countryPropMap.entrySet()) {
            Properties properties = entry.getValue();
            GeocodeUtils.orderByDictionaryType(entry.getKey(), properties);
            provider.setSettingsForCountry(entry.getKey(), properties);
        }
    }

    public Map<String, Properties> getCountryPropMap() {
        return Collections.unmodifiableMap(this.countryPropMap);
    }

    public boolean isCountryConfigured(String isoCountryCode) {
        Properties dataConfigurationProperty;
        boolean isCountryConfigured = true;
        String countryTocheck = this.subCountriesMapping.containsKey(isoCountryCode = isoCountryCode != null ? isoCountryCode.toUpperCase() : "") ? this.subCountriesMapping.get(isoCountryCode) : isoCountryCode;
        isCountryConfigured = this.countryPropMap.containsKey(countryTocheck);
        if (isCountryConfigured && null != (dataConfigurationProperty = this.countryPropMap.get(countryTocheck))) {
            String dictionaryCount = dataConfigurationProperty.getProperty("DICTIONARY_COUNT", "0");
            if ("0".equals(dictionaryCount)) {
                isCountryConfigured = false;
            } else {
                try {
                    String path = dataConfigurationProperty.getProperty("DICTIONARY_PATH1");
                    File testFile = new File(path);
                    if (!testFile.isDirectory()) {
                        isCountryConfigured = false;
                    }
                }
                catch (Exception ex) {
                    isCountryConfigured = false;
                }
            }
        }
        return isCountryConfigured;
    }

    public Set<String> getConfiguredCountries() {
        if (this.availableCountries == null) {
            HashSet<String> countries = new HashSet<String>();
            for (String country : this.countryPropMap.keySet()) {
                if (!this.isCountryConfigured(country)) continue;
                countries.add(country);
            }
            for (String key : this.subCountriesMapping.keySet()) {
                if (!countries.contains(this.subCountriesMapping.get(key))) continue;
                countries.add(key);
            }
            this.availableCountries = Collections.unmodifiableSet(countries);
        }
        return this.availableCountries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataManagerSettingsMapper{");
        sb.append("subCountriesMapping=").append(this.subCountriesMapping);
        sb.append(", availableCountries=").append(this.availableCountries);
        sb.append(", countryPropMap=").append(this.countryPropMap);
        sb.append('}');
        return sb.toString();
    }
}

