/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import com.mapinfo.geocode.GeocoderPreferences;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.interactive.InteractivePreferences;
import com.mapinfo.geocode.util.GeocoderPreferencesFactory;

public class DefaultPreferencesProvider {
    private Preferences geocoding = null;
    private Preferences interactive = null;
    private static DefaultPreferencesProvider provider;

    private DefaultPreferencesProvider() {
    }

    public static DefaultPreferencesProvider getInstance() {
        if (provider == null) {
            provider = new DefaultPreferencesProvider();
        }
        return provider;
    }

    public Preferences getDefaultPreferences() {
        if (this.geocoding == null) {
            this.geocoding = GeocoderPreferencesFactory.getDefaultPreferences();
        }
        return new GeocoderPreferences(this.geocoding);
    }

    public Preferences getDefaultInteractivePreferences() {
        if (this.interactive == null) {
            this.interactive = GeocoderPreferencesFactory.getDefaultInteractuvePreferences();
        }
        return new InteractivePreferences(this.interactive);
    }

    public void setDefaultPreferences(Preferences newPreferences) {
        this.geocoding = newPreferences;
    }

    public void setDefaultInteractivePreferences(Preferences newPreferences) {
        this.interactive = newPreferences;
    }
}

