/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.geocode.util.CountryBoundaryManager;
import com.mapinfo.geocode.util.DataManagerSettingsMapper;
import com.mapinfo.geocode.util.GeocodeUtils;
import java.util.Map;
import java.util.Properties;

public class ExternalDataManagerSettingsMapper
extends DataManagerSettingsMapper {
    private Properties initProperties;

    public void setProperties(Map<String, Object> countryPropertiesMap, Properties initProperties) throws GeocodingException {
        for (Map.Entry<String, Object> entry : countryPropertiesMap.entrySet()) {
            this.countryPropMap.put(entry.getKey(), (Properties)entry.getValue());
        }
        this.initProperties = initProperties;
        this.postOperations();
    }

    private void postOperations() throws GeocodingException {
        try {
            if (GeocodeUtils.isClass("com.mapinfo.mapmarker.common.dp.binary.IReverseGeocodeDataDictionary")) {
                CountryBoundaryManager.initialize(this.countryPropMap);
                this.mapPropertiesToGeocoder();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        ConfigurationManager.setDataManagerSettingsMapper(this);
        ConfigurationManager.initCapabilities();
    }

    public Properties getInitProps() {
        return this.initProperties;
    }
}

