/*
 * Decompiled with CFR 0.152.
 */
package com.pb.geocoding.config;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import com.pb.geocoding.config.JsonConfigurationImpl;
import com.pb.geocoding.config.api.GeocodingConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationBuilder {
    private GeocodingConfiguration configuration;
    private Path configurationLocation;
    private Path nativeBinariesLocation;
    private String baseConfigutaionFileName;
    private boolean resolveClassPathConfig = true;

    public ConfigurationBuilder setConfigirationLocation(Path configurationLocation) {
        this.configurationLocation = configurationLocation;
        return this;
    }

    public ConfigurationBuilder setNativeBinariesLocation(Path nativeBinariesLocation) {
        this.nativeBinariesLocation = nativeBinariesLocation;
        return this;
    }

    public ConfigurationBuilder setBaseConfigurationFileName(String name) {
        this.baseConfigutaionFileName = name;
        return this;
    }

    public ConfigurationBuilder setResolveClassPathConfig(boolean resolveClassPathConfig) {
        this.resolveClassPathConfig = resolveClassPathConfig;
        return this;
    }

    public GeocodingConfiguration build() throws GeocodingException {
        if (this.resolveClassPathConfig) {
            this.resolveClassPathResource();
        }
        if (this.configurationLocation == null || !this.configurationLocation.toFile().exists()) {
            throw new GeocodingException("Invalid configuration location", ExceptionCode.INVALID_CONFIGURATION);
        }
        String configFileName = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.baseConfigutaionFileName}) ? this.baseConfigutaionFileName : "JsonDataConfig.json";
        File configFile = new File(this.configurationLocation.toAbsolutePath().toString() + "/" + configFileName);
        if (configFile == null || !configFile.exists()) {
            throw new GeocodingException("Invalid configuration location", ExceptionCode.INVALID_CONFIGURATION);
        }
        if (this.nativeBinariesLocation == null || !this.nativeBinariesLocation.toFile().exists()) {
            throw new GeocodingException("Invalid binaries location", ExceptionCode.INVALID_CONFIGURATION);
        }
        try {
            this.configuration = new JsonConfigurationImpl(configFile);
            this.configuration.addConfig("config.location", (Object)this.configurationLocation.toAbsolutePath().toString());
            if (this.nativeBinariesLocation != null) {
                this.configuration.addConfig("res.location", (Object)this.nativeBinariesLocation.toAbsolutePath().toString());
            }
        }
        catch (Exception e) {
            throw new GeocodingException(e.getMessage(), ExceptionCode.INVALID_CONFIGURATION, e);
        }
        return this.configuration;
    }

    private Path getClassPathResource(String name) throws URISyntaxException {
        return Paths.get(ClassLoader.getSystemResource(name).toURI());
    }

    private Properties readProperties(Path path) {
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path.toFile());
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    private void resolveClassPathResource() {
        try {
            Path binPath;
            Properties properties = this.readProperties(this.getClassPathResource("application.properties"));
            Path configPath = this.makePath(properties.getProperty("config.location"));
            if (this.isValidPath(configPath)) {
                this.configurationLocation = configPath;
            }
            if (this.isValidPath(binPath = this.makePath(properties.getProperty("res.location")))) {
                this.nativeBinariesLocation = binPath;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isValidPath(Path path) {
        File file;
        return path != null && (file = path.toFile()).exists();
    }

    private Path makePath(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return Paths.get(value, new String[0]);
        }
        return null;
    }
}

