/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBounds;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBoundsProvider;
import com.mapinfo.mapmarker.common.dp.ProgressBarUpdaterProvider;
import com.mapinfo.mapmarker.common.dp.ProgressComputer;
import com.mapinfo.mapmarker.common.dp.TempDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.utils.DebugLevel;
import java.util.ArrayList;
import java.util.Properties;

public abstract class AbstractDataHandler
implements IDataHandler {
    private Properties m_dataProperties;
    private IDataSource m_dataAccess;
    private ITempDataRecordHandler m_tempDataHandler;
    private IDataSourceRecordConvertor m_dataConvertor;
    private IIntermediateDataHandler m_intermediateHandler;
    private long m_sourceDataRecordCount;
    private long m_intermediateDataRecordCount;
    private long m_intermediateDataRecordsReProcessedCount;
    private long m_updateFrequency;
    private int m_sourceRecordCount;

    public AbstractDataHandler(IDataSource dataSourceAccess, IDataSourceRecordConvertor dataConvertor, IIntermediateDataHandler intermediateHandler, ITempDataRecordHandler tempHandler) {
        this.m_dataAccess = dataSourceAccess;
        this.m_dataConvertor = dataConvertor;
        this.m_intermediateHandler = intermediateHandler;
        this.m_tempDataHandler = tempHandler;
        this.m_sourceDataRecordCount = 0L;
        this.m_intermediateDataRecordCount = 0L;
        this.m_intermediateDataRecordsReProcessedCount = 0L;
        this.m_updateFrequency = 1L;
    }

    protected abstract void openDataSourceAccess() throws DataSourceException;

    @Override
    public void open(Properties dataProperties) throws DataSourceException {
        this.m_dataProperties = dataProperties;
        this.openDataSourceAccess();
        this.m_intermediateHandler.open();
        this.m_tempDataHandler.open();
        this.m_sourceRecordCount = this.m_dataAccess.getRecordCount();
    }

    @Override
    public void close() throws DataSourceException {
        if (this.m_dataAccess != null) {
            this.m_dataAccess.close();
        }
        if (this.m_intermediateHandler != null) {
            this.m_intermediateHandler.close();
            this.m_intermediateHandler.cleanUp();
        }
        if (this.m_tempDataHandler != null) {
            this.m_tempDataHandler.close();
            this.m_tempDataHandler = null;
        }
    }

    @Override
    public void prepare() throws DataCreationException {
        try {
            this.preProcessDataSet();
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(-1, (Throwable)DSEx);
        }
        DataCreationLogger.getLogger().logStatus("\n" + this.m_sourceDataRecordCount + " were pre-processed into " + this.m_intermediateDataRecordCount + " intermediate data records.");
        this.m_updateFrequency = this.m_intermediateDataRecordCount / 1000L;
        if (this.m_updateFrequency < 10L) {
            this.m_updateFrequency = 10L;
        }
    }

    @Override
    public Object getNextDataRecord() throws DataCreationException {
        try {
            ArrayList dataRecords = this.getNextDataRecords();
            if (dataRecords == null) {
                return null;
            }
            return dataRecords.get(0);
        }
        catch (DataSourceException DSEx) {
            throw this.makeDataCreationException(DSEx);
        }
    }

    @Override
    public FrequentDataFileStrings getFrequentDataFileStrings(int maxFrequentStrings) throws DataCreationException {
        return new FrequentDataFileStrings();
    }

    protected ArrayList getNextDataRecords() throws DataSourceException {
        if (this.getTempDataRecordHandler().hasNextTempDataRecord()) {
            TempDataRecord tempRecord = this.getTempDataRecordHandler().getNextTempDataRecord();
            return this.reProcessDataRecords(tempRecord);
        }
        return null;
    }

    protected IDataSource getDataSourceAccess() {
        return this.m_dataAccess;
    }

    protected IDataSourceRecordConvertor getDataSourceRecordConvertor() {
        return this.m_dataConvertor;
    }

    protected IIntermediateDataHandler getIntermediateDataHandler() {
        return this.m_intermediateHandler;
    }

    protected Properties getDataProperties() {
        return this.m_dataProperties;
    }

    protected void addDataRecord(TempDataRecord record) throws DataSourceException {
        this.m_tempDataHandler.addTempDataRecord(record);
    }

    protected ITempDataRecordHandler getTempDataRecordHandler() {
        return this.m_tempDataHandler;
    }

    protected abstract IDataSourceRecord makeDataSourceRecord(IDataSourceRecordObjects var1);

    protected void updateProgress(PhaseProgressBounds bounds, int recordsComplete, int totalRecords) {
        if (totalRecords > 0 && bounds != null) {
            ProgressBarUpdaterProvider.getUpdaterInstance().update(ProgressComputer.compute(bounds, recordsComplete, totalRecords));
        }
    }

    protected void preProcessDataSet() throws DataSourceException, DataCreationException {
        IDataSourceRecordObjects dataObjects;
        IDataSource access = this.getDataSourceAccess();
        PhaseProgressBounds bounds = PhaseProgressBoundsProvider.getInstance().getBounds(0);
        if (this.m_sourceRecordCount > 0 && bounds != null) {
            ProgressBarUpdaterProvider.getUpdaterInstance().update(bounds.getStart());
        } else if (bounds != null) {
            ProgressBarUpdaterProvider.getUpdaterInstance().update(bounds.getEnd());
        }
        while ((dataObjects = access.getNextDataSourceRecordObjects()) != null) {
            ++this.m_sourceDataRecordCount;
            if (this.m_sourceDataRecordCount % 10L == 0L) {
                this.updateProgress(bounds, (int)this.m_sourceDataRecordCount, this.m_sourceRecordCount);
            }
            IDataSourceRecord record = this.makeDataSourceRecord(dataObjects);
            this.processDataSourceRecord(record);
        }
        if (this.getTempDataRecordHandler().getTempDataRecordCount() == 0) {
            this.m_dataAccess.close();
            this.m_dataAccess = null;
            this.m_intermediateHandler.close();
            this.m_intermediateHandler.cleanUp();
            this.m_intermediateHandler = null;
            DataCreationLogger.getLogger().logError("No valid records found in the data source.");
            throw new DataCreationException(3);
        }
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logMemoryUsage();
            DataCreationLogger.getLogger().logStatus("Setting converter to null.");
        }
        this.m_dataConvertor = null;
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logMemoryUsageWithGC();
        }
        this.m_dataAccess.close();
        this.m_dataAccess = null;
        if (bounds != null) {
            ProgressBarUpdaterProvider.getUpdaterInstance().update(bounds.getEnd());
        }
    }

    protected void processDataSourceRecord(IDataSourceRecord record) throws DataSourceException, DataCreationException {
        Object o = this.getDataSourceRecordConvertor().convert(record);
        if (o != null) {
            IDataRecordID ID = this.getIntermediateDataHandler().putIntermediateData(o);
            TempDataRecord temp = this.makeTempDataRecord(o, ID);
            this.addDataRecord(temp);
            ++this.m_intermediateDataRecordCount;
            while ((o = this.getDataSourceRecordConvertor().convert(null)) != null) {
                ++this.m_intermediateDataRecordCount;
                ID = this.getIntermediateDataHandler().putIntermediateData(o);
                temp = this.makeTempDataRecord(o, ID);
                this.addDataRecord(temp);
            }
        }
    }

    protected abstract TempDataRecord makeTempDataRecord(Object var1, IDataRecordID var2);

    protected abstract void replaceDataFromTempDataRecord(Object var1, TempDataRecord var2);

    protected ArrayList reProcessDataRecords(TempDataRecord temp) throws DataSourceException {
        ArrayList dataRecordIDs = temp.getDataRecordIDs();
        ArrayList<Object> records = new ArrayList<Object>();
        for (int i = 0; i < dataRecordIDs.size(); ++i) {
            PhaseProgressBounds bounds;
            ++this.m_intermediateDataRecordsReProcessedCount;
            if (this.m_intermediateDataRecordsReProcessedCount % this.m_updateFrequency == 0L) {
                DataCreationLogger.getLogger().logStatusNoLF("Reprocessed " + this.m_intermediateDataRecordsReProcessedCount + " of " + this.m_intermediateDataRecordCount + " total intermediate records.\r");
            }
            if (this.m_intermediateDataRecordsReProcessedCount % 10L == 0L && (bounds = PhaseProgressBoundsProvider.getInstance().getBounds(1)) != null) {
                this.updateProgress(bounds, (int)this.m_intermediateDataRecordsReProcessedCount, (int)this.m_intermediateDataRecordCount);
            }
            Object o = this.getIntermediateDataHandler().getIntermediateData((IDataRecordID)dataRecordIDs.get(i));
            this.replaceDataFromTempDataRecord(o, temp);
            records.add(o);
        }
        return records;
    }

    protected DataCreationException makeDataCreationException(DataSourceException DSEx) {
        return new DataCreationException(-1, (Throwable)DSEx);
    }
}

