/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.AbstractDataHandler;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.TempDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.index.BaseRecordNoIOIndexKey;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class AbstractGeo2SacDataHandler
extends AbstractDataHandler {
    private Iterator m_geo2sacIterator;

    public AbstractGeo2SacDataHandler(IDataSource dataSourceAccess, IDataSourceRecordConvertor dataConvertor, IIntermediateDataHandler intermediateHandler, ITempDataRecordHandler tempHandler) {
        super(dataSourceAccess, dataConvertor, intermediateHandler, tempHandler);
    }

    @Override
    protected TempDataRecord makeTempDataRecord(Object geo2sac, IDataRecordID ID) {
        return new TempDataRecord(new BaseRecordNoIOIndexKey((Comparable)((MMJGeo2SacRecord)geo2sac).getGeoBase()), ID);
    }

    @Override
    protected void replaceDataFromTempDataRecord(Object o, TempDataRecord temp) {
    }

    @Override
    public Object getNextDataRecord() throws DataCreationException {
        ArrayList geo2sacRecords;
        if (this.m_geo2sacIterator != null && this.m_geo2sacIterator.hasNext()) {
            MMJGeo2SacRecord record = (MMJGeo2SacRecord)this.m_geo2sacIterator.next();
            this.m_geo2sacIterator.remove();
            return record;
        }
        try {
            geo2sacRecords = this.getNextDataRecords();
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(701, (Throwable)DSEx);
        }
        if (geo2sacRecords == null) {
            return null;
        }
        if (geo2sacRecords.size() == 1) {
            return geo2sacRecords.get(0);
        }
        TreeSet geo2sacSet = new TreeSet(new MMJGeo2SacRecordComparator());
        Iterator recordsIterator = geo2sacRecords.iterator();
        while (recordsIterator.hasNext()) {
            geo2sacSet.add(recordsIterator.next());
            recordsIterator.remove();
        }
        this.m_geo2sacIterator = geo2sacSet.iterator();
        MMJGeo2SacRecord record = (MMJGeo2SacRecord)this.m_geo2sacIterator.next();
        this.m_geo2sacIterator.remove();
        return record;
    }
}

