/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdditionalFieldsDefinitionTranslator {
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("\\{ *\\[ *\\w+ *\\, *\\w+ *\\](?: *,\\[ *\\w+ *\\, *\\w+ *\\])* *\\}");
    private static final Pattern ENTRY_FIND_PATTERN = Pattern.compile("\\[ *\\w+ *\\, *\\w+ *\\]");
    private static final Pattern ENTRY_PATTERN = Pattern.compile("\\[( *\\w+ *)\\,( *\\w+ *)\\]");

    private AdditionalFieldsDefinitionTranslator() {
    }

    public static Map<String, String> translate(String definition) throws IllegalArgumentException {
        if (StringUtilities.isEmpty((String)definition) || "NONE".equals(definition)) {
            return Collections.emptyMap();
        }
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        if (m.matches()) {
            HashMap<String, String> result = new HashMap<String, String>();
            Matcher entryFindMatcher = ENTRY_FIND_PATTERN.matcher(definition);
            while (entryFindMatcher.find()) {
                Matcher entryMatcher = ENTRY_PATTERN.matcher(entryFindMatcher.group(0));
                if (!entryMatcher.matches() || result.put(entryMatcher.group(1).toUpperCase().trim(), entryMatcher.group(2).trim()) == null) continue;
                throw new IllegalArgumentException(definition + " not a proper definition of additional fields, key: " + entryMatcher.group(1).toUpperCase() + " appears more than once");
            }
            return result;
        }
        throw new IllegalArgumentException(definition + " not a proper definition of additional fields");
    }
}

