/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CombinedDataSource
implements IDataSource {
    private List<IDataSource> m_sources = new ArrayList<IDataSource>();
    private Iterator<IDataSource> m_sourcesIterator;
    private IDataSource m_currentSource;
    private boolean m_bIsOpen;

    public void addOpenedDataSource(IDataSource source) {
        if (this.m_bIsOpen) {
            throw new IllegalStateException("cannot add to opened source");
        }
        this.m_sources.add(source);
    }

    @Override
    public void open(String[] args) {
        if (this.m_bIsOpen) {
            throw new IllegalStateException("source already open");
        }
        if (this.m_sources.isEmpty()) {
            throw new IllegalStateException("Cannot open with no sources");
        }
        this.m_sourcesIterator = this.m_sources.iterator();
        if (this.m_sourcesIterator.hasNext()) {
            this.m_currentSource = this.m_sourcesIterator.next();
        }
        this.m_bIsOpen = true;
    }

    @Override
    public IDataSourceRecordObjects getNextDataSourceRecordObjects() throws DataSourceException {
        if (!this.m_bIsOpen) {
            throw new IllegalStateException("Cannot getNextDataRecords with un opened source");
        }
        IDataSourceRecordObjects objects = this.m_currentSource.getNextDataSourceRecordObjects();
        while (objects == null && this.m_sourcesIterator.hasNext()) {
            this.m_currentSource = this.m_sourcesIterator.next();
            objects = this.m_currentSource.getNextDataSourceRecordObjects();
        }
        return objects;
    }

    @Override
    public void close() throws DataSourceException {
        this.m_currentSource = null;
        this.m_sourcesIterator = null;
        try {
            for (IDataSource source : this.m_sources) {
                source.close();
            }
        }
        finally {
            this.m_sources.clear();
            this.m_bIsOpen = false;
        }
    }

    @Override
    public int getRecordCount() throws DataSourceException {
        if (!this.m_bIsOpen) {
            throw new IllegalStateException("Cannot get record count from unopened source");
        }
        int total = 0;
        for (IDataSource source : this.m_sources) {
            long subTotal = source.getRecordCount();
            if (subTotal != -1L) {
                total += source.getRecordCount();
                continue;
            }
            return -1;
        }
        return total;
    }
}

