/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.AbstractDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import java.util.Properties;

public class Geo2SacDataSourceRecordConvertorImpl
extends AbstractDataSourceRecordConvertor {
    protected Soundex m_soundex;

    public Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex) {
        super(dataProperties);
        this.m_soundex = soundex;
    }

    @Override
    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IGeo2SacDataSourceRecord input = (IGeo2SacDataSourceRecord)inputData;
        MMJGeo2SacRecord record = null;
        try {
            if (!input.hasSac()) {
                DataCreationLogger.getLogger().logInternalError("AbstractDataSourceRecordConvertor:: convertGeo2Sac(): data source record must have sac field.");
                return null;
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(701, (Throwable)DSEx);
        }
        IGeoBase[] geoBases = null;
        try {
            geoBases = this.makeGeoBases(input);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(701, (Throwable)DSEx);
        }
        if (geoBases == null) {
            DataCreationLogger.getLogger().logInternalError("AbstractDataSourceRecordConvertor:: convertGeo2Sac(): no geoBases created from input.");
            return null;
        }
        if (geoBases.length == 1) {
            this.m_dataRecords = null;
            this.m_nextDataRecordIndex = -1;
            try {
                return this.makeGeo2SacRecord(input.getSac(), geoBases[0]);
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(701, (Throwable)DSEx);
            }
        }
        this.m_dataRecords = new Object[geoBases.length - 1];
        for (int i = 1; i < geoBases.length; ++i) {
            try {
                this.m_dataRecords[i - 1] = this.makeGeo2SacRecord(input.getSac(), geoBases[i]);
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(701, (Throwable)DSEx);
            }
            geoBases[i] = null;
        }
        try {
            record = this.makeGeo2SacRecord(input.getSac(), geoBases[0]);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(701, (Throwable)DSEx);
        }
        this.m_nextDataRecordIndex = 0;
        return record;
    }

    protected MMJGeo2SacRecord makeGeo2SacRecord(int sac, IGeoBase base) {
        return new MiSoundexGeo2SacRecord(sac, base);
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
            IGeoBase[] bases = new IGeoBase[]{new MiSoundexGeoBase((MiSoundexKey)this.makeSoundexKey(input.getAreaName3()))};
            return bases;
        }
        return null;
    }

    protected ISoundexKey makeSoundexKey(String soundexSource) {
        return this.m_soundex.getSoundex(soundexSource);
    }
}

