/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.TAIntermediateRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;

public class InvalidRangeRecordFixer {
    private InvalidRangeRecordFixer() {
    }

    public static void fixInvalidRange(MMJRangeRecord range) {
        if (range.isValid()) {
            throw new IllegalArgumentException();
        }
        if (range.getFromHouse().getNumFields() != range.getToHouse().getNumFields() && InvalidRangeRecordFixer.handleDifferentFieldCounts(range)) {
            return;
        }
        IIntermediateDataRecord[] intermediateRecords = new IIntermediateDataRecord[2];
        intermediateRecords[0] = new TAIntermediateRecord();
        intermediateRecords[0].setHnr(range.getFromHouse().getCombinedAddressNumber());
        intermediateRecords[0].setSeqNum((short)0);
        intermediateRecords[0].setIsLeft(range.isLeft());
        intermediateRecords[1] = new TAIntermediateRecord();
        intermediateRecords[1].setHnr(range.getToHouse().getCombinedAddressNumber());
        intermediateRecords[1].setSeqNum((short)1);
        intermediateRecords[1].setIsLeft(range.isLeft());
        range.setIntermediateDataRecordArray(intermediateRecords);
        DataCreationLogger.getLogger().logInternalError("Fail-safe fix for invalid range (from: " + range.getFromHouse().getCombinedAddressNumber() + " -- to: " + range.getToHouse().getCombinedAddressNumber() + ")");
    }

    private static boolean handleDifferentFieldCounts(MMJRangeRecord range) {
        if (Math.abs(range.getFromHouse().getNumFields() - range.getToHouse().getNumFields()) == 1) {
            if (InvalidRangeRecordFixer.checkCommonFields(1, range.getFromHouse(), range.getToHouse(), false) || InvalidRangeRecordFixer.checkCommonFields(2, range.getFromHouse(), range.getToHouse(), false) && InvalidRangeRecordFixer.checkCommonFields(1, range.getFromHouse(), range.getToHouse(), true)) {
                if (Math.max(range.getFromHouse().getNumFields(), range.getToHouse().getNumFields()) == 2 && range.getFromHouse().getAddressNumberExists() && range.getToHouse().getAddressNumberExists()) {
                    InvalidRangeRecordFixer.incrementNumericIntoIntermediates(range);
                    return true;
                }
                if (Math.max(range.getFromHouse().getNumFields(), range.getToHouse().getNumFields()) == 2 && range.getFromHouse().hasAddressPrefix() && range.getToHouse().hasAddressPrefix() && range.getFromHouse().getAddressPrefix().length() == 1 && range.getToHouse().getAddressPrefix().length() == 1) {
                    InvalidRangeRecordFixer.incrementPrefixIntoIntermediates(range);
                    return true;
                }
            }
        } else if (range.getFromHouse().getAddressNumberExists() && range.getToHouse().getAddressNumberExists()) {
            ParsedNumber testNumber;
            Object object = range.getFromHouse().getNumFields() == 1 ? range.getToHouse() : (testNumber = range.getToHouse().getNumFields() == 1 ? range.getFromHouse() : null);
            if (testNumber != null && !testNumber.hasAddressPrefix() && !testNumber.hasPrefixSeparator()) {
                InvalidRangeRecordFixer.incrementNumericIntoIntermediates(range);
                return true;
            }
        }
        return false;
    }

    private static boolean checkCommonFields(int allowableDiff, ParsedNumber from, ParsedNumber to, boolean bIgnoreValues) {
        int diffs = 0;
        if (!(from.hasAddressPrefix() == to.hasAddressPrefix() || bIgnoreValues && StringUtilities.equalStrings((String)from.getAddressPrefix(), (String)to.getAddressPrefix()))) {
            ++diffs;
        }
        if (!(from.hasAddressSuffix() == to.hasAddressSuffix() || bIgnoreValues && StringUtilities.equalStrings((String)from.getAddressSuffix(), (String)to.getAddressSuffix()))) {
            ++diffs;
        }
        if (!(from.hasAddressTrailer() == to.hasAddressTrailer() || bIgnoreValues && StringUtilities.equalStrings((String)from.getAddressTrailer(), (String)to.getAddressTrailer()))) {
            ++diffs;
        }
        if (!(from.hasNumberSeparator() == to.hasNumberSeparator() || bIgnoreValues && StringUtilities.equalStrings((String)from.getNumberSeparator(), (String)to.getNumberSeparator()))) {
            ++diffs;
        }
        if (!(from.hasPrefixSeparator() == to.hasPrefixSeparator() || bIgnoreValues && StringUtilities.equalStrings((String)from.getPrefixSeparator(), (String)to.getPrefixSeparator()))) {
            ++diffs;
        }
        if (!(from.hasSeparator() == to.hasSeparator() || bIgnoreValues && StringUtilities.equalStrings((String)from.getNumberSeparator(), (String)to.getNumberSeparator()))) {
            ++diffs;
        }
        if (!(from.hasSuffixSeparator() == to.hasSuffixSeparator() || bIgnoreValues && StringUtilities.equalStrings((String)from.getSuffixSeparator(), (String)to.getSuffixSeparator()))) {
            ++diffs;
        }
        if (!(from.hasTrailerSeparator() == to.hasTrailerSeparator() || bIgnoreValues && StringUtilities.equalStrings((String)from.getTrailerSeparator(), (String)to.getTrailerSeparator()))) {
            ++diffs;
        }
        if (from.getAddressNumberExists() != to.getAddressNumberExists()) {
            ++diffs;
        } else if (!bIgnoreValues && from.getAddressNumberExists() && to.getAddressNumberExists() && from.getAddressNumber() != to.getAddressNumber()) {
            ++diffs;
        }
        if (from.getSuffixNumberExists() != to.getSuffixNumberExists()) {
            ++diffs;
        } else if (!bIgnoreValues && from.getSuffixNumberExists() && to.getSuffixNumberExists() && from.getSuffixNumber() != to.getSuffixNumber()) {
            ++diffs;
        }
        return diffs == allowableDiff;
    }

    private static void incrementNumericIntoIntermediates(MMJRangeRecord range) {
        int increment;
        int n = increment = range.getOddEven() == 0 ? 1 : 2;
        if (range.getFromHouse().getAddressNumber() > range.getToHouse().getAddressNumber()) {
            increment *= -1;
        }
        ArrayList<String> houses = new ArrayList<String>();
        houses.add(range.getFromHouse().getCombinedAddressNumber());
        long currentNumeric = range.getFromHouse().getAddressNumber() + (long)increment;
        long stopValue = range.getToHouse().getAddressNumber();
        if (range.getFromHouse().getNumFields() < range.getToHouse().getNumFields()) {
            if (increment > 0) {
                stopValue += (long)increment;
            }
        } else if (increment < 0) {
            currentNumeric -= (long)increment;
        }
        if (increment < 0) {
            while (currentNumeric > stopValue) {
                houses.add(String.valueOf(currentNumeric));
                currentNumeric += (long)increment;
            }
        } else {
            while (currentNumeric < stopValue) {
                houses.add(String.valueOf(currentNumeric));
                currentNumeric += (long)increment;
            }
        }
        houses.add(range.getToHouse().getCombinedAddressNumber());
        IIntermediateDataRecord[] intermediateRecords = new IIntermediateDataRecord[houses.size()];
        for (short i = 0; i < houses.size(); i = (short)(i + 1)) {
            intermediateRecords[i] = new TAIntermediateRecord();
            intermediateRecords[i].setHnr((String)houses.get(i));
            intermediateRecords[i].setSeqNum(i);
            intermediateRecords[i].setIsLeft(range.isLeft());
        }
        range.setIntermediateDataRecordArray(intermediateRecords);
    }

    private static void incrementPrefixIntoIntermediates(MMJRangeRecord range) {
        ArrayList<String> houses = new ArrayList<String>();
        houses.add(range.getFromHouse().getCombinedAddressNumber());
        int increment = range.getFromHouse().getAddressPrefix().compareTo(range.getToHouse().getAddressPrefix()) < 0 ? 1 : -1;
        char currentPrefix = (char)(range.getFromHouse().getAddressPrefix().charAt(0) + increment);
        char stopValue = range.getToHouse().getAddressPrefix().charAt(0);
        if (range.getFromHouse().getNumFields() < range.getToHouse().getNumFields()) {
            if (increment > 0) {
                stopValue = (char)(stopValue + increment);
            }
        } else if (increment < 0) {
            currentPrefix = (char)(currentPrefix - increment);
        }
        if (increment < 0) {
            while (currentPrefix > stopValue) {
                houses.add(String.valueOf(currentPrefix));
                currentPrefix = (char)(currentPrefix + increment);
            }
        } else {
            while (currentPrefix < stopValue) {
                houses.add(String.valueOf(currentPrefix));
                currentPrefix = (char)(currentPrefix + increment);
            }
        }
        houses.add(range.getToHouse().getCombinedAddressNumber());
        IIntermediateDataRecord[] intermediateRecords = new IIntermediateDataRecord[houses.size()];
        for (short i = 0; i < houses.size(); i = (short)(i + 1)) {
            intermediateRecords[i] = new TAIntermediateRecord();
            intermediateRecords[i].setHnr((String)houses.get(i));
            intermediateRecords[i].setSeqNum(i);
            intermediateRecords[i].setIsLeft(range.isLeft());
        }
        range.setIntermediateDataRecordArray(intermediateRecords);
    }
}

