/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.INamedFieldDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateRangeDataSourceRecord;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;

public class RangeDataSourceRecordImpl
implements IRangeDataSourceRecord,
IIntermediateRangeDataSourceRecord {
    private final INamedFieldDataSourceRecord m_record;
    private final boolean m_bIsLeft;
    private final String m_fromFieldKey;
    private final String m_toFieldKey;
    private final String m_statusFieldKey;
    private final String m_placeNameFieldKey;
    private final ArrayList m_unitRecords;
    private final IIntermediateDataRecord[] m_intermediates;

    public RangeDataSourceRecordImpl(INamedFieldDataSourceRecord record, boolean bIsLeft, ArrayList unitRecords, IIntermediateDataRecord[] intermediates, String fromFieldKey, String toFieldKey, String statusFieldKey, String placeNameFieldKey) {
        this.m_record = record;
        this.m_bIsLeft = bIsLeft;
        this.m_unitRecords = unitRecords;
        this.m_fromFieldKey = fromFieldKey;
        this.m_toFieldKey = toFieldKey;
        this.m_statusFieldKey = statusFieldKey;
        this.m_placeNameFieldKey = placeNameFieldKey;
        this.m_intermediates = intermediates;
    }

    @Override
    public boolean isLeft() {
        return this.m_bIsLeft;
    }

    @Override
    public boolean hasFrom() throws DataSourceException {
        return this.m_record.hasField(this.m_fromFieldKey);
    }

    @Override
    public String getFrom() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_fromFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldStringValue(fieldName);
        }
        return null;
    }

    @Override
    public boolean hasTo() throws DataSourceException {
        return this.m_record.hasField(this.m_toFieldKey);
    }

    @Override
    public String getTo() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_toFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldStringValue(fieldName);
        }
        return null;
    }

    @Override
    public boolean hasStatus() throws DataSourceException {
        return this.m_record.hasField(this.m_statusFieldKey);
    }

    @Override
    public String getStatus() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_statusFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldStringValue(fieldName);
        }
        return null;
    }

    @Override
    public boolean hasPlaceName() throws DataSourceException {
        return this.m_record.hasField(this.m_placeNameFieldKey);
    }

    @Override
    public String getPlaceName() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_placeNameFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldStringValue(fieldName);
        }
        return null;
    }

    @Override
    public ArrayList getUnits() {
        return this.m_unitRecords;
    }

    @Override
    public DirectPosition getPoint() throws DataSourceException {
        return this.m_record.getRecordPoint();
    }

    @Override
    public IIntermediateDataRecord[] getIntermediateRecordArray() {
        return this.m_intermediates;
    }
}

