/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.AbstractStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.AddressDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IAddressDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.INamedFieldDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.RangeDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.SacDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.SegmentDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.TAIntermediateRecord;
import com.mapinfo.mapmarker.common.dp.UnitDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StreetDataSourceRecordImpl
extends AbstractStreetDataSourceRecord {
    public StreetDataSourceRecordImpl(INamedFieldDataSourceRecord record, ISegmentDataSourceRecord segment) {
        this(record, segment, "street_leftSac", "street_rightSac", "street_genericField1", "street_genericField2", "street_genericField3", "street_genericField4", "street_mainAddress", "street_alternateMainAddress");
    }

    public StreetDataSourceRecordImpl(INamedFieldDataSourceRecord record, ISegmentDataSourceRecord segment, String leftSacFieldKey, String rightSacFieldKey, String genericField1FieldKey, String genericField2FieldKey, String genericField3FieldKey, String genericField4FieldKey, String mainAddressFieldKey, String alternateMainAddressFieldKey) {
        this(new SacDataSourceRecordImpl(record, leftSacFieldKey), new SacDataSourceRecordImpl(record, rightSacFieldKey), new AddressDataSourceRecordImpl(record, genericField1FieldKey, genericField2FieldKey, genericField3FieldKey, genericField4FieldKey, mainAddressFieldKey, alternateMainAddressFieldKey), segment);
    }

    public StreetDataSourceRecordImpl(ISacDataSourceRecord leftSacRecord, ISacDataSourceRecord rightSacRecord, IAddressDataSourceRecord addressRecord, ISegmentDataSourceRecord segmentRecord) {
        this.m_leftSacRecord = leftSacRecord;
        this.m_rightSacRecord = rightSacRecord;
        this.m_addressRecord = addressRecord;
        this.m_segmentRecord = segmentRecord;
    }

    public StreetDataSourceRecordImpl(INamedFieldDataSourceRecord record, IIntermediateDataHandler intermediateData) throws DataSourceException {
        this.m_leftSacRecord = new SacDataSourceRecordImpl(record, "street_leftSac");
        this.m_rightSacRecord = new SacDataSourceRecordImpl(record, "street_rightSac");
        this.m_addressRecord = this.makeAddressDataSourceRecord(record);
        this.m_segmentRecord = this.makeSegmentDataSourceRecord(record, intermediateData);
    }

    protected IAddressDataSourceRecord makeAddressDataSourceRecord(INamedFieldDataSourceRecord record) {
        return new AddressDataSourceRecordImpl(record, "street_genericField1", "street_genericField2", "street_genericField3", "street_genericField4", "street_mainAddress", "street_alternateMainAddress");
    }

    protected ISegmentDataSourceRecord makeSegmentDataSourceRecord(INamedFieldDataSourceRecord record, IIntermediateDataHandler intermediateData) throws DataSourceException {
        return new SegmentDataSourceRecordImpl(record, this.makeRangeDataSourceRecords(record, intermediateData, this.getTAId(record, "ta_id_column")));
    }

    protected String getTAId(INamedFieldDataSourceRecord record, String taIdFieldKey) throws DataSourceException {
        if (record.hasField(taIdFieldKey)) {
            String fieldName = record.getFieldName(taIdFieldKey);
            return record.getFieldStringValue(fieldName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<IRangeDataSourceRecord> makeRangeDataSourceRecords(INamedFieldDataSourceRecord record, IIntermediateDataHandler intermediateData, String segmentID) throws DataSourceException {
        List intermediates = null;
        boolean bLeftIntermediates = false;
        boolean bRightIntermediates = false;
        boolean bSuccess = false;
        try {
            if (intermediateData != null && segmentID != null) {
                bLeftIntermediates = this.possibleIntermediates(record, "street_leftRangeStatus", "street_leftIntermediateRangeIndicator");
                bRightIntermediates = this.possibleIntermediates(record, "street_rightRangeStatus", "street_rightIntermediateRangeIndicator");
                if (bLeftIntermediates || bRightIntermediates) {
                    intermediates = intermediateData.getIntermediateRecords(segmentID);
                }
            }
            if (intermediates == null) {
                intermediates = Collections.emptyList();
            }
            ArrayList<IRangeDataSourceRecord> ranges = new ArrayList<IRangeDataSourceRecord>(2);
            try {
                ranges.add(this.makeLeftRangeDataSourceRecord(record, bLeftIntermediates, intermediates));
                ranges.add(this.makeRightRangeDataSourceRecord(record, bRightIntermediates, intermediates));
            }
            catch (IllegalStateException ISEx) {
                DataCreationLogger.getLogger().logError("Unable to sort intermediate records for id: " + segmentID);
                DataCreationLogger.getLogger().logError(ISEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace(ISEx);
                throw ISEx;
            }
            bSuccess = true;
            ArrayList<IRangeDataSourceRecord> arrayList = ranges;
            return arrayList;
        }
        finally {
            if (!bSuccess) {
                DataCreationLogger.getLogger().logInternalError("Error with intermediate house numbers for segment id: " + segmentID);
            }
        }
    }

    protected boolean possibleIntermediates(INamedFieldDataSourceRecord record, String statusFieldKey, String hasIntermediatesFieldKey) throws DataSourceException {
        String fieldName;
        if (record.hasField(hasIntermediatesFieldKey) && record.getFieldIntValue(fieldName = record.getFieldName(hasIntermediatesFieldKey)) == 1) {
            return true;
        }
        return record.hasField(statusFieldKey) && record.getFieldIntValue(fieldName = record.getFieldName(statusFieldKey)) == 5;
    }

    protected TAIntermediateRecord[] getIntermediatesForSide(INamedFieldDataSourceRecord record, boolean bLeft, List<TAIntermediateRecord> intermediates, String fromHouseKey, String toHouseKey) throws DataSourceException {
        ArrayList<TAIntermediateRecord> allRecords = new ArrayList<TAIntermediateRecord>();
        allRecords.add(this.makeIntermediateHouse(record, bLeft, fromHouseKey, 0));
        allRecords.addAll(intermediates);
        allRecords.add(this.makeIntermediateHouse(record, bLeft, toHouseKey, allRecords.size()));
        ArrayList<TAIntermediateRecord> sideRecords = new ArrayList<TAIntermediateRecord>();
        for (TAIntermediateRecord intermediate : allRecords) {
            if (intermediate.isLeft() != bLeft) continue;
            sideRecords.add(intermediate);
        }
        Collections.sort(sideRecords, new IntermediateDataRecordSequenceNumberComparator());
        return sideRecords.toArray(new TAIntermediateRecord[sideRecords.size()]);
    }

    protected TAIntermediateRecord makeIntermediateHouse(INamedFieldDataSourceRecord record, boolean bLeft, String houseKey, int sequence) throws DataSourceException {
        TAIntermediateRecord intermediate = new TAIntermediateRecord();
        intermediate.setSeqNum((short)sequence);
        intermediate.setIsLeft(bLeft);
        if (record.hasField(houseKey)) {
            String houseNumber = record.getFieldStringValue(record.getFieldName(houseKey));
            if (!StringUtilities.isEmpty((String)houseNumber)) {
                intermediate.setHnr(houseNumber);
                return intermediate;
            }
            throw new DataSourceException(9, houseKey + " field does not contain a house number for record");
        }
        throw new DataSourceException(9, houseKey + " field not mapped for record");
    }

    protected IRangeDataSourceRecord makeLeftRangeDataSourceRecord(INamedFieldDataSourceRecord record, boolean bIntermediates, List<TAIntermediateRecord> intermediates) throws DataSourceException {
        TAIntermediateRecord[] leftIntermediates = null;
        if (bIntermediates) {
            leftIntermediates = this.getIntermediatesForSide(record, true, intermediates, "street_fromLeft", "street_toLeft");
        }
        return new RangeDataSourceRecordImpl(record, true, this.makeLeftRangeUnitDataSourceRecord(record), (IIntermediateDataRecord[])leftIntermediates, "street_fromLeft", "street_toLeft", "street_leftRangeStatus", "street_leftPlaceName");
    }

    protected ArrayList<IUnitDataSourceRecord> makeLeftRangeUnitDataSourceRecord(INamedFieldDataSourceRecord record) {
        ArrayList<IUnitDataSourceRecord> units = new ArrayList<IUnitDataSourceRecord>(1);
        units.add(new UnitDataSourceRecordImpl(record, "street_leftLowUnit", "street_leftHighUnit", "street_leftUnitType", "street_leftUnitPlaceName"));
        return units;
    }

    protected IRangeDataSourceRecord makeRightRangeDataSourceRecord(INamedFieldDataSourceRecord record, boolean bIntermediates, List<TAIntermediateRecord> intermediates) throws DataSourceException {
        TAIntermediateRecord[] rightIntermediates = null;
        if (bIntermediates) {
            rightIntermediates = this.getIntermediatesForSide(record, false, intermediates, "street_fromRight", "street_toRight");
        }
        return new RangeDataSourceRecordImpl(record, false, this.makeRightRangeUnitDataSourceRecord(record), (IIntermediateDataRecord[])rightIntermediates, "street_fromRight", "street_toRight", "street_rightRangeStatus", "street_rightPlaceName");
    }

    protected ArrayList<IUnitDataSourceRecord> makeRightRangeUnitDataSourceRecord(INamedFieldDataSourceRecord record) {
        ArrayList<IUnitDataSourceRecord> units = new ArrayList<IUnitDataSourceRecord>(1);
        units.add(new UnitDataSourceRecordImpl(record, "street_rightLowUnit", "street_rightHighUnit", "street_rightUnitType", "street_rightUnitPlaceName"));
        return units;
    }

    protected static void writeSampleProperties(PrintWriter writer) {
        AbstractStreetDataSourceRecord.writeSampleProperties(writer);
        writer.println("street_leftIntermediateRangeIndicator=NONE");
        writer.println("street_rightIntermediateRangeIndicator=NONE");
    }

    private class IntermediateDataRecordSequenceNumberComparator
    implements Comparator<IIntermediateDataRecord> {
        private IntermediateDataRecordSequenceNumberComparator() {
        }

        @Override
        public int compare(IIntermediateDataRecord record1, IIntermediateDataRecord record2) {
            if (record1.getSeqNum() == record2.getSeqNum()) {
                System.out.println("record1 seqNum: " + record1.getSeqNum());
                System.out.println("record2 seqNum: " + record2.getSeqNum());
                throw new IllegalStateException("No two intermediate houses should have the same sequence number");
            }
            return record1.getSeqNum() - record2.getSeqNum();
        }
    }
}

