/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.TAIntermediateRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TAIntermediateFileHandler
implements IIntermediateDataFileFormatHandler {
    public static final int LEFT_SIDE = 1;
    private static final String CONNECTIONDRIVER = "com.hxtt.sql.dbf.DBFDriver";
    private static final String DBF_URL = "jdbC:dbf:/";
    private static final String USERID = "";
    private static final String PASSWORD = "";
    private static final String COLUMN_SEGMENT_ID = "ID";
    private static final String COLUMN_SEGMENT_SIDE = "SOL";
    private static final String COLUMN_SEQUENCE_NUMBER = "SEQNR";
    private static final String COLUMN_ADDRESS_NUMBER_WITH_ALPHA = "F_ADD";
    private static final String COLUMN_ADDRESS_NUMBER_WITHOUT_ALPHA = "ADD";
    private final boolean m_bUseAlphaColumn;
    private Connection m_Connection;
    private PreparedStatement m_PreStmts;
    private boolean m_FileExist = true;
    private static DataCreationLogger m_DataLogger = DataCreationLogger.getLogger();

    public TAIntermediateFileHandler(String path) throws FileNotFoundException, DataSourceException {
        this(path, true);
    }

    protected TAIntermediateFileHandler(String path, boolean bUseAlphaColumn) throws FileNotFoundException, DataSourceException {
        this.m_bUseAlphaColumn = bUseAlphaColumn;
        this.setUpFileConfiguration(path);
        if (!this.m_bUseAlphaColumn) {
            DataCreationLogger.getLogger().logInternalError("WARNING: Using the non-alpha address column for intermediate data.");
        }
    }

    private String getAddressNumberColumn() {
        if (this.m_bUseAlphaColumn) {
            return COLUMN_ADDRESS_NUMBER_WITH_ALPHA;
        }
        return COLUMN_ADDRESS_NUMBER_WITHOUT_ALPHA;
    }

    private void setUpFileConfiguration(String path) throws FileNotFoundException, DataSourceException {
        File relativeFilePath = new File(path);
        File absoulteFile = relativeFilePath.getAbsoluteFile();
        this.prepareDBFDriver(absoulteFile.getParent());
        this.createIndexesonFile(absoulteFile.getParent(), absoulteFile.getName());
        this.prepareQueryStatements(absoulteFile.getName());
        absoulteFile = null;
    }

    private void createIndexesonFile(String path, String table) {
        String tableName = this.removeExtension(table);
        String indexName = tableName + "_ID";
        try {
            File indexFile = new File(path + "\\" + indexName + ".IDX");
            if (indexFile.exists()) {
                indexFile.delete();
            }
            Statement stmt = this.m_Connection.createStatement();
            stmt.executeUpdate("Create INDEX " + indexName + " on \"" + tableName + "\"(" + COLUMN_SEGMENT_ID + ")");
        }
        catch (SQLException e) {
            m_DataLogger.logError("Sql exception caused" + e.getMessage());
        }
    }

    private String removeExtension(String filename) {
        int idx = filename.lastIndexOf(46);
        if (idx > 0) {
            return filename.substring(0, idx);
        }
        return filename;
    }

    private void prepareQueryStatements(String tableName) throws DataSourceException {
        String query = "Select \"" + this.getAddressNumberColumn() + "\",\"" + COLUMN_SEQUENCE_NUMBER + "\",\"" + COLUMN_SEGMENT_SIDE + "\" from \"" + tableName + "\" where ID=?";
        try {
            this.m_PreStmts = this.m_Connection.prepareStatement(query, 1003, 1007);
            this.m_Connection.setReadOnly(true);
        }
        catch (SQLException e) {
            m_DataLogger.logStatus("Prepeared query is " + query.toString());
            m_DataLogger.logStatus("\n ");
            m_DataLogger.logError("Sql exception caused" + e.getMessage());
            throw new DataSourceException(e.getMessage());
        }
    }

    private void prepareDBFDriver(String path) {
        try {
            Class.forName(CONNECTIONDRIVER);
            this.m_Connection = DriverManager.getConnection(DBF_URL + path, "", "");
        }
        catch (ClassNotFoundException e) {
            m_DataLogger.logError("No suitable driver found " + e.getMessage());
        }
        catch (SQLException e) {
            m_DataLogger.logError("Sql exception caused" + e.getMessage());
        }
    }

    @Override
    public List getIntermediateRecords(String id) {
        try {
            this.m_PreStmts.setLong(1, Long.parseLong(id));
            ResultSet rs = this.m_PreStmts.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                if (!rs.isAfterLast()) {
                    ArrayList<TAIntermediateRecord> recs = new ArrayList<TAIntermediateRecord>();
                    do {
                        TAIntermediateRecord rec = new TAIntermediateRecord();
                        rec.setHnr(rs.getString(this.getAddressNumberColumn()));
                        rec.setSeqNum(rs.getShort(COLUMN_SEQUENCE_NUMBER));
                        rec.setIsLeft(rs.getInt(COLUMN_SEGMENT_SIDE) == 1);
                        recs.add(rec);
                    } while (rs.next());
                    rs.close();
                    return recs;
                }
            }
        }
        catch (SQLException sqle) {
            m_DataLogger.logError("Sql exception caused" + sqle.getMessage());
        }
        return null;
    }

    @Override
    public boolean doesIntermediateFileExists() {
        return this.m_FileExist;
    }

    @Override
    public void closeConnections() {
        try {
            this.m_PreStmts.close();
        }
        catch (SQLException e) {
            m_DataLogger.logError("Sql exception caused" + e.getMessage());
        }
        try {
            this.m_Connection.close();
        }
        catch (Exception e) {
            m_DataLogger.logError("Sql exception caused" + e.getMessage());
        }
    }

    class DBFFileFilter
    implements FilenameFilter {
        private String filename = "";

        public DBFFileFilter(String name) {
            this.filename = this.filename == null ? "" : name.toUpperCase();
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toUpperCase().endsWith(this.filename);
        }
    }
}

