/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.CustomMaskCodeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutomaticCustomMaskCodeWriter {
    static final Pattern m_patternGroupLine = Pattern.compile("^\\s*((Custom\\s+)?([^:]*))(:(\\s+\\d+)?)?\\s*$");
    static final int m_groupMaskGroupName = 1;
    static final Pattern m_patternMaskLine = Pattern.compile("^\\s*(Index:\\s+\\d+\\s+)?Count:\\s+(\\d+)\\s+(Types:\\s+.*)$");
    static final int m_groupMask = 3;
    static final int m_groupMaskCount = 2;
    static String m_stsDir;
    static String m_stsOutputPrefix;
    static Map<String, Integer> m_geoinfoMasks;
    static Map<String, Integer> m_postinfoMasks;
    static Map<String, Integer> m_streetMasks;
    static Map<String, Integer> m_segmentMasks;
    static Map<String, Integer> m_rangeMasks;
    static Map<String, Integer> m_rangeunitMasks;
    static PrintWriter m_helperClassWriter;

    public static void main(String[] args) {
        File maskFile;
        File stsDir;
        if (args.length < 1) {
            System.err.println("Required argument (sts file directroy) not supplied!");
            System.exit(-1);
        }
        if (!(stsDir = new File(m_stsDir = args[0])).exists()) {
            System.err.println("Specified directory (" + m_stsDir + ") does not exist!");
            System.exit(-1);
        }
        boolean foundStsFiles = false;
        for (File stsFile : stsDir.listFiles(new StsFileFilter())) {
            foundStsFiles = true;
            AutomaticCustomMaskCodeWriter.readMasks(stsFile);
        }
        if (!foundStsFiles) {
            System.err.println("No .sts files in specified directory (" + m_stsDir + ")!");
            System.exit(-1);
        }
        if (args.length > 1) {
            String helperClassName = args[1];
            String helperPackageName = "";
            int idx = helperClassName.lastIndexOf(46);
            if (idx > 0) {
                helperPackageName = helperClassName.substring(0, idx);
                helperClassName = helperClassName.substring(idx + 1);
            }
            try {
                m_helperClassWriter = new PrintWriter(new File(m_stsDir, helperClassName + ".java"));
                m_helperClassWriter.print(AutomaticCustomMaskCodeWriter.buildHelperClassHeader(helperClassName, helperPackageName));
            }
            catch (IOException e) {
                m_helperClassWriter = null;
                System.out.println("Error creating helper class (" + args[0] + ")!");
                e.printStackTrace();
            }
        }
        String maskFileContent = "";
        String maskFilePath = AutomaticCustomMaskCodeWriter.writeMasks("GeoInfo", m_geoinfoMasks);
        if (m_helperClassWriter != null) {
            maskFile = new File(maskFilePath);
            maskFileContent = maskFile.exists() ? AutomaticCustomMaskCodeWriter.readFully(maskFile) : "";
            m_helperClassWriter.print(AutomaticCustomMaskCodeWriter.buildHelperClassMethod("buildGeoInfoDataFileMasks", maskFileContent));
        }
        maskFilePath = AutomaticCustomMaskCodeWriter.writeMasks("PostInfo", m_postinfoMasks);
        if (m_helperClassWriter != null) {
            maskFile = new File(maskFilePath);
            maskFileContent = maskFile.exists() ? AutomaticCustomMaskCodeWriter.readFully(maskFile) : "";
            m_helperClassWriter.print(AutomaticCustomMaskCodeWriter.buildHelperClassMethod("buildPostInfoDataFileMasks", maskFileContent));
        }
        maskFilePath = AutomaticCustomMaskCodeWriter.writeMasks("Street", m_streetMasks);
        if (m_helperClassWriter != null) {
            maskFile = new File(maskFilePath);
            maskFileContent = maskFile.exists() ? AutomaticCustomMaskCodeWriter.readFully(maskFile) : "";
        }
        maskFilePath = AutomaticCustomMaskCodeWriter.writeMasks("Segment", m_segmentMasks);
        if (m_helperClassWriter != null && (maskFile = new File(maskFilePath)).exists()) {
            maskFileContent = maskFileContent + '\n' + AutomaticCustomMaskCodeWriter.readFully(maskFile);
        }
        maskFilePath = AutomaticCustomMaskCodeWriter.writeMasks("Range", m_rangeMasks);
        if (m_helperClassWriter != null && (maskFile = new File(maskFilePath)).exists()) {
            maskFileContent = maskFileContent + '\n' + AutomaticCustomMaskCodeWriter.readFully(maskFile);
        }
        maskFilePath = AutomaticCustomMaskCodeWriter.writeMasks("Unit", m_rangeunitMasks);
        if (m_helperClassWriter != null) {
            maskFile = new File(maskFilePath);
            if (maskFile.exists()) {
                maskFileContent = maskFileContent + '\n' + AutomaticCustomMaskCodeWriter.readFully(maskFile);
            }
            m_helperClassWriter.print(AutomaticCustomMaskCodeWriter.buildHelperClassMethod("buildStreetDataFileMasks", maskFileContent));
        }
        if (m_helperClassWriter != null) {
            m_helperClassWriter.print(AutomaticCustomMaskCodeWriter.buildHelperClassFooter());
            m_helperClassWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMasks(File stsFile) {
        System.out.println("");
        System.out.println("Analyzing STS file: " + stsFile.getAbsolutePath());
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(stsFile));
            Map<String, Integer> masks = null;
            while ((line = in.readLine()) != null) {
                Matcher m = m_patternGroupLine.matcher(line);
                if (m.matches()) {
                    masks = AutomaticCustomMaskCodeWriter.getMapForGroup(m.group(1));
                }
                if (masks == null || !(m = m_patternMaskLine.matcher(line)).matches()) continue;
                String mask = m.group(3);
                int count = masks.containsKey(mask) ? masks.get(mask) : 0;
                masks.put(mask, count += Integer.parseInt(m.group(2)));
            }
            in.close();
        }
        catch (IOException ioex) {
            System.out.println("Error reading file!");
            ioex.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        System.out.println("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String writeMasks(String type, Map<String, Integer> masks) {
        System.out.println("");
        String javaFilePath = "";
        if (masks == null || masks.size() == 0) {
            System.out.println("No masks of type: " + type);
        }
        System.out.println("Writing combined " + type + " mask file...");
        File maskFile = new File(m_stsDir, m_stsOutputPrefix + type + ".sts");
        System.out.println("Destination File: " + maskFile.getAbsolutePath());
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(maskFile));
            int maskId = 0;
            ArrayList<SortedMaskEntry> sortedMasks = new ArrayList<SortedMaskEntry>();
            for (String mask : masks.keySet()) {
                Integer localCount = masks.get(mask);
                sortedMasks.add(new SortedMaskEntry(mask, localCount));
            }
            Collections.sort(sortedMasks);
            for (SortedMaskEntry entry : sortedMasks) {
                if (++maskId > 255) break;
                Integer count = entry.getCount();
                writer.println("Count: " + count + " " + entry.getMask());
            }
            writer.close();
            writer = null;
            javaFilePath = maskFile.getAbsolutePath() + ".java";
            CustomMaskCodeWriter.main(new String[]{type.toLowerCase(), maskFile.getAbsolutePath(), javaFilePath});
            maskFile.delete();
        }
        catch (IOException ioex) {
            System.out.println("Error writing file!");
            ioex.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
        System.out.println("Done!");
        return javaFilePath;
    }

    private static Map<String, Integer> getMapForGroup(String groupName) {
        Map<String, Integer> m;
        if (groupName == null) {
            return null;
        }
        if ("streets".equalsIgnoreCase(groupName = groupName.trim()) || "custom streets".equalsIgnoreCase(groupName)) {
            m = m_streetMasks;
        } else if ("segments".equalsIgnoreCase(groupName) || "custom segments".equalsIgnoreCase(groupName)) {
            m = m_segmentMasks;
        } else if ("ranges".equalsIgnoreCase(groupName) || "custom ranges".equalsIgnoreCase(groupName)) {
            m = m_rangeMasks;
        } else if ("rangeunits".equalsIgnoreCase(groupName) || "custom rangeunits".equalsIgnoreCase(groupName)) {
            m = m_rangeunitMasks;
        } else if ("geoinfo".equalsIgnoreCase(groupName) || "custom geoinfo".equalsIgnoreCase(groupName)) {
            m = m_geoinfoMasks;
        } else if ("postinfo".equalsIgnoreCase(groupName) || "custom postinfo".equalsIgnoreCase(groupName)) {
            m = m_postinfoMasks;
        } else {
            return null;
        }
        System.out.println("Analyzing masks for: " + groupName);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFully(File file) {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            in.close();
        }
        catch (IOException ioex) {
            System.out.println("Error reading file (" + file + ")!");
            ioex.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    private static String buildHelperClassHeader(String className, String packageName) {
        String helperClassHeader = "/****************************************************************************\n * Copyright (c) 1985-2009, Pitney Bowes Software Inc.\n * All Rights Reserved.\n * Confidential Property of Pitney Bowes Software Inc.\n * <p/>\n * Automatically generated data file masks using " + AutomaticCustomMaskCodeWriter.class.getName() + "\n * <p/>\n * ***************************************************************************\n */\n\n";
        String helperClassImports = "import com.mapinfo.mapmarker.common.dp.binary.TypeMask;\nimport com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;\n\n";
        StringBuilder sb = new StringBuilder(helperClassHeader);
        if (packageName != null && packageName.length() > 0) {
            sb.append("package " + packageName + ";\n\n");
        }
        sb.append(helperClassImports);
        sb.append("class " + className + "\n{\n");
        return sb.toString();
    }

    private static String buildHelperClassFooter() {
        StringBuilder sb = new StringBuilder();
        sb.append("}\n");
        return sb.toString();
    }

    private static String buildHelperClassMethod(String methodName, String maskContent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\tstatic DataFileMasks " + methodName + "() {\n");
        sb.append("\t\tDataFileMasks masks = new DataFileMasks();\n");
        sb.append("\t\tTypeMask mask;\n\n");
        sb.append(maskContent);
        sb.append("\t\treturn masks;\n");
        sb.append("\t}\n\n");
        return sb.toString();
    }

    static {
        m_stsOutputPrefix = "combined-";
        m_geoinfoMasks = new HashMap<String, Integer>();
        m_postinfoMasks = new HashMap<String, Integer>();
        m_streetMasks = new HashMap<String, Integer>();
        m_segmentMasks = new HashMap<String, Integer>();
        m_rangeMasks = new HashMap<String, Integer>();
        m_rangeunitMasks = new HashMap<String, Integer>();
        m_helperClassWriter = null;
    }

    private static class SortedMaskEntry
    implements Comparable {
        private String m_mask;
        private Integer m_count;

        public SortedMaskEntry(String mask, Integer count) {
            this.m_mask = mask;
            this.m_count = count;
        }

        public int compareTo(Object that) {
            return -1 * this.m_count.compareTo(((SortedMaskEntry)that).m_count);
        }

        public String getMask() {
            return this.m_mask;
        }

        public Integer getCount() {
            return this.m_count;
        }
    }

    private static class StsFileFilter
    implements FilenameFilter {
        private StsFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".sts");
        }
    }
}

