/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.ExceptionCodeToStringItem;
import com.mapinfo.mapmarker.utils.MapMarkerResourceLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DataCreationException
extends Exception {
    public static final int UNKNOWN = -1;
    public static final int OUT_OF_MEMORY = 0;
    public static final int NO_COUNTRY = 1;
    public static final int UNSUPPORTED_COUNTRY = 2;
    public static final int NO_VALID_SOURCE_DATA = 3;
    public static final int STREET_DATA_FILE = 100;
    public static final int STREET_RECORD = 101;
    public static final int STREET_SAC = 102;
    public static final int STREET_MAINADDRESS = 103;
    public static final int STREET_ALTERNATE_MAIN_ADDRESS = 104;
    public static final int STREET_ALT_FILE = 105;
    public static final int SEGMENT_RECORD = 106;
    public static final int RANGE_RECORD = 107;
    public static final int UNIT_RECORD = 108;
    public static final int DICTIONARY_DESCRIPTION_FILE = 109;
    public static final int STREET_INDEX_FILE = 200;
    public static final int STREET_INDEX_KEY = 201;
    public static final int GEOINFO_DATA_FILE = 300;
    public static final int GEOINFO_RECORD = 301;
    public static final int GEOINFO_INDEX_FILE = 400;
    public static final int GEOINFO_INDEX_KEY = 401;
    public static final int POSTINFO_DATA_FILE = 500;
    public static final int POSTINFO_RECORD = 501;
    public static final int POSTINFO_INDEX_FILE = 600;
    public static final int POSTINFO_INDEX_KEY = 601;
    public static final int GEO2SAC_DATA_FILE = 700;
    public static final int GEO2SAC_RECORD = 701;
    public static final int POST2SAC_DATA_FILE = 800;
    public static final int POST2SAC_RECORD = 801;
    public static final int STREET_TEMP_DATA_FILE = 1601;
    public static final int POSTINFO_TEMP_INDEX_FILE = 1602;
    public static final int LOCAL_BASE = 2000;
    private int m_code;
    private static final String m_messageStringFile = "com.mapinfo.mapmarker.common.dp.binary.DataCreationExceptionMessages";
    private static ExceptionCodeToStringItem[] m_exceptionMap = new ExceptionCodeToStringItem[]{new ExceptionCodeToStringItem(-1, "err_unknown"), new ExceptionCodeToStringItem(0, "err_out_of_memory"), new ExceptionCodeToStringItem(1, "err_no_country"), new ExceptionCodeToStringItem(2, "err_unsupported_country"), new ExceptionCodeToStringItem(3, "err_no_valid_source_data"), new ExceptionCodeToStringItem(100, "err_street_data_file"), new ExceptionCodeToStringItem(101, "err_street_record"), new ExceptionCodeToStringItem(102, "err_street_sac"), new ExceptionCodeToStringItem(103, "err_street_mainaddress"), new ExceptionCodeToStringItem(104, "err_street_alternate_main_address"), new ExceptionCodeToStringItem(105, "err_street_alt_file"), new ExceptionCodeToStringItem(106, "err_segment_record"), new ExceptionCodeToStringItem(107, "err_range_record"), new ExceptionCodeToStringItem(108, "err_unit_record"), new ExceptionCodeToStringItem(109, "err_dictionary_description_file"), new ExceptionCodeToStringItem(200, "err_street_index_file"), new ExceptionCodeToStringItem(201, "err_street_index_key"), new ExceptionCodeToStringItem(300, "err_geoinfo_data_file"), new ExceptionCodeToStringItem(301, "err_geoinfo_record"), new ExceptionCodeToStringItem(400, "err_geoinfo_index_file"), new ExceptionCodeToStringItem(401, "err_geoinfo_index_key"), new ExceptionCodeToStringItem(500, "err_postinfo_data_file"), new ExceptionCodeToStringItem(501, "err_postinfo_record"), new ExceptionCodeToStringItem(600, "err_postinfo_index_file"), new ExceptionCodeToStringItem(601, "err_postinfo_index_key"), new ExceptionCodeToStringItem(700, "err_geo2sac_data_file"), new ExceptionCodeToStringItem(701, "err_geo2sac_record"), new ExceptionCodeToStringItem(800, "err_post2sac_data_file"), new ExceptionCodeToStringItem(801, "err_post2sac_record"), new ExceptionCodeToStringItem(1601, "err_street_temp_data_file"), new ExceptionCodeToStringItem(1602, "err_postinfo_temp_index_file"), new ExceptionCodeToStringItem(2000, "err_local_base")};

    public DataCreationException(String message) {
        this(-1, message);
    }

    public DataCreationException(Throwable e) {
        this(-1, e);
    }

    public DataCreationException(int exceptionCode) {
        super((String)null);
        this.m_code = exceptionCode;
    }

    public DataCreationException(int exceptionCode, Throwable e) {
        super(e);
        this.m_code = exceptionCode;
    }

    public DataCreationException(int exceptionCode, String message) {
        super(message);
        this.m_code = exceptionCode;
    }

    public DataCreationException(int exceptionCode, String message, Throwable e) {
        super(message, e);
        this.m_code = exceptionCode;
    }

    public int getExceptionCode() {
        return this.m_code;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof DataSourceException) {
            if (message != null) {
                return this.buildMessageFromExceptionCode() + ":\n\t" + cause.getMessage();
            }
            return this.buildMessageFromExceptionCode();
        }
        if (message == null) {
            return this.buildMessageFromExceptionCode();
        }
        return message + "\t" + this.buildMessageFromExceptionCode();
    }

    protected String buildMessageFromExceptionCode() {
        for (int i = 0; i < m_exceptionMap.length; ++i) {
            if (!m_exceptionMap[i].equals(this.m_code)) continue;
            return this.getMessageFromResource(m_exceptionMap[i].getString(), m_messageStringFile);
        }
        return "" + this.m_code;
    }

    protected String getMessageFromResource(String messageKey, String messageStringFile) {
        String message = null;
        if (messageKey != null) {
            ResourceBundle messageBundle = MapMarkerResourceLoader.loadForLocale((Locale)Locale.getDefault(), (String)messageStringFile);
            try {
                message = messageBundle.getString(messageKey);
            }
            catch (MissingResourceException MREx) {
                message = null;
            }
        } else {
            return "" + this.m_code;
        }
        if (message != null && message.trim().length() > 0) {
            return message;
        }
        return messageKey;
    }
}

