/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class DataCreationLogger {
    private static DataCreationLogger m_logger = null;
    private PrintStream m_errorLog = null;
    private PrintStream m_statusLog = null;
    private PrintStream m_internalErrorLog = null;
    private boolean m_teeErrors = false;
    private boolean m_teeStatus = false;
    private boolean m_teeInternalErrors = false;

    private DataCreationLogger() {
    }

    public static final DataCreationLogger getLogger() {
        if (m_logger == null) {
            m_logger = new DataCreationLogger();
        }
        return m_logger;
    }

    public void setErrorLog(String errorLogFileName, boolean toConsole) {
        this.setErrorLog(this.makePrintStream(errorLogFileName), toConsole);
    }

    public void setErrorLog(PrintStream errorLog, boolean toConsole) {
        this.m_errorLog = errorLog;
        this.m_teeErrors = toConsole;
    }

    public void setStatusLog(String statusLogFileName, boolean toConsole) {
        this.setStatusLog(this.makePrintStream(statusLogFileName), toConsole);
    }

    public void setStatusLog(PrintStream statusLog, boolean toConsole) {
        this.m_statusLog = statusLog;
        this.m_teeStatus = toConsole;
    }

    public void setInternalErrorLog(String internalErrorLogFileName, boolean toConsole) {
        this.setInternalErrorLog(this.makePrintStream(internalErrorLogFileName), toConsole);
    }

    public void setInternalErrorLog(PrintStream internalErrorLog, boolean toConsole) {
        this.m_internalErrorLog = internalErrorLog;
        this.m_teeInternalErrors = toConsole;
    }

    public void logError(String errorMessage) {
        if (this.m_errorLog != null) {
            this.m_errorLog.println(errorMessage);
        }
        if (this.m_teeErrors) {
            System.err.println(errorMessage);
        }
    }

    public void logStatusNoLF(String statusMessage) {
        this.logStatus(statusMessage, false);
    }

    public void logStatus(String statusMessage) {
        this.logStatus(statusMessage, true);
    }

    private void logStatus(String statusMessage, boolean LF) {
        if (this.m_statusLog != null) {
            if (LF) {
                this.m_statusLog.println(statusMessage);
            } else {
                this.m_statusLog.print(statusMessage);
            }
        }
        if (this.m_teeStatus) {
            if (LF) {
                System.out.println(statusMessage);
            } else {
                System.out.print(statusMessage);
            }
        }
    }

    public void logInternalError(String internalErrorMessage) {
        if (this.m_internalErrorLog != null) {
            this.m_internalErrorLog.println(internalErrorMessage);
        }
        if (this.m_teeInternalErrors) {
            System.err.println(internalErrorMessage);
        }
    }

    public void logStackTrace(Throwable t) {
        if (this.m_internalErrorLog != null) {
            t.printStackTrace(this.m_internalErrorLog);
        }
        if (this.m_teeInternalErrors) {
            t.printStackTrace(System.err);
        }
    }

    public void closeLogger() {
        if (this.m_errorLog != null) {
            this.m_errorLog.flush();
            this.m_errorLog.close();
            this.m_errorLog = null;
        }
        if (this.m_statusLog != null) {
            this.m_statusLog.flush();
            this.m_statusLog.close();
            this.m_statusLog = null;
        }
        if (this.m_internalErrorLog != null) {
            this.m_internalErrorLog.flush();
            this.m_internalErrorLog.close();
            this.m_internalErrorLog = null;
        }
    }

    protected PrintStream makePrintStream(String fileName) {
        try {
            return new PrintStream(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException FNFEx) {
            return null;
        }
        catch (NullPointerException NPEx) {
            return null;
        }
    }

    public void logMemoryUsage() {
        Runtime run = Runtime.getRuntime();
        this.m_statusLog.println("  Memory: free: " + run.freeMemory() + " total: " + run.totalMemory() + " max: " + run.maxMemory());
    }

    public void logMemoryUsageWithGC() {
        this.logMemoryUsage();
        this.m_statusLog.println("Calling gc.");
        System.gc();
        this.logMemoryUsage();
    }
}

