/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.PhaseProgressBounds;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBoundsProvider;
import com.mapinfo.mapmarker.common.dp.ProgressBarUpdaterProvider;
import com.mapinfo.mapmarker.common.dp.ProgressComputer;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.MMJSupportedAltsWriter;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.SpecialAltIndexTransformer;
import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGIndexBuilder;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.RangeCombiningSpatialIndexValueIterator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValueEnvelopeDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValueIterator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValuePersistenceDecorator;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.ReadOnlyNIODataAccess;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DataCreator {
    protected static final String CONTAINS_LOG_FILES = "logFiles";
    protected static final String ERROR_LOG_FILE = "errorLog";
    protected static final String STATUS_LOG_FILE = "statusLog";
    protected static final String INTERNAL_ERROR_LOG_FILE = "internalErrorLog";
    protected static final String LOG_TO_CONSOLE = "useConsole";
    protected static final String DATA_PROVIDER_CLASS = "dataProviderClass";
    protected String m_dataProviderBaseClass = "_TabDataProvider";
    protected String m_geoInfoSoundexIndexerBaseClass = "_GeoInfoSoundexIndexer";
    protected boolean m_internalProcess;
    protected IDataProvider m_dataProvider;

    public DataCreator() {
        this(false);
    }

    protected DataCreator(boolean logInternalErrors) {
        this.m_internalProcess = logInternalErrors;
    }

    protected void setUpLogger(Properties processingProperties) {
        String containsLogFilesProp;
        DataCreationLogger logger = DataCreationLogger.getLogger();
        String useConsoleProp = processingProperties.getProperty(LOG_TO_CONSOLE);
        boolean useConsole = false;
        if (useConsoleProp != null && Boolean.valueOf(useConsoleProp).booleanValue()) {
            useConsole = true;
        }
        if ((containsLogFilesProp = processingProperties.getProperty(CONTAINS_LOG_FILES)) != null && Boolean.valueOf(containsLogFilesProp).booleanValue()) {
            logger.setErrorLog((PrintStream)processingProperties.get(ERROR_LOG_FILE), useConsole);
            logger.setStatusLog((PrintStream)processingProperties.get(STATUS_LOG_FILE), useConsole);
            PrintStream ps = (PrintStream)processingProperties.get(INTERNAL_ERROR_LOG_FILE);
            if (ps != null) {
                logger.setInternalErrorLog((PrintStream)processingProperties.get(INTERNAL_ERROR_LOG_FILE), useConsole);
            }
        } else {
            logger.setErrorLog(processingProperties.getProperty(ERROR_LOG_FILE), useConsole);
            logger.setStatusLog(processingProperties.getProperty(STATUS_LOG_FILE), useConsole);
            if (this.m_internalProcess) {
                logger.setInternalErrorLog(processingProperties.getProperty(INTERNAL_ERROR_LOG_FILE), useConsole);
            }
        }
    }

    protected void deleteFile(String fileToDelete) throws DataCreationException {
        if (fileToDelete == null) {
            return;
        }
        File fileRef = new File(fileToDelete);
        if (fileRef.exists() && !fileRef.delete()) {
            DataCreationLogger.getLogger().logInternalError("Unable to remove file: " + fileToDelete);
            throw new DataCreationException(-1);
        }
    }

    protected boolean fileExists(String fileName) {
        File fileRef = new File(fileName);
        return fileRef.exists();
    }

    protected String getDataProviderClassName(Properties properties) {
        String dataProviderClass = properties.getProperty(DATA_PROVIDER_CLASS);
        if (StringUtilities.isEmpty((String)dataProviderClass)) {
            String countryCode = properties.getProperty("COUNTRY");
            dataProviderClass = "com.mapinfo.mapmarker." + countryCode + ".dp.binary." + countryCode + this.m_dataProviderBaseClass;
        }
        return dataProviderClass;
    }

    protected void initializeDataProvider(Properties processingProperties) throws DataCreationException {
        IDataProvider provider;
        Class<?> providerClass;
        String providerClassName = this.getDataProviderClassName(processingProperties);
        try {
            providerClass = Class.forName(providerClassName);
        }
        catch (ClassNotFoundException e) {
            DataCreationLogger.getLogger().logError("Unable to create data tools for country: " + processingProperties + " please check classpath.");
            throw new DataCreationException(2, (Throwable)e);
        }
        try {
            provider = (IDataProvider)providerClass.newInstance();
        }
        catch (InstantiationException e) {
            DataCreationLogger.getLogger().logError("Unable to create needed classes for country: " + processingProperties);
            throw new DataCreationException(2, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            DataCreationLogger.getLogger().logError("Unable to create needed classes for country: " + processingProperties);
            throw new DataCreationException(2, (Throwable)e);
        }
        this.m_dataProvider = provider;
        provider.initialize(processingProperties);
    }

    protected GeoInfoSoundexIndexer getGeoInfoSoundexIndexer(String countryAbbreviation) throws DataCreationException {
        GeoInfoSoundexIndexer indexer;
        Class<?> indexerClass;
        String indexerClassName = "com.mapinfo.mapmarker." + countryAbbreviation + ".dp.binary.index." + countryAbbreviation + this.m_geoInfoSoundexIndexerBaseClass;
        try {
            indexerClass = Class.forName(indexerClassName);
        }
        catch (ClassNotFoundException e) {
            DataCreationLogger.getLogger().logError("Unable to create geoInfo indexer for country: " + countryAbbreviation + " please check classpath.");
            throw new DataCreationException(2, (Throwable)e);
        }
        try {
            indexer = (GeoInfoSoundexIndexer)indexerClass.newInstance();
        }
        catch (InstantiationException e) {
            DataCreationLogger.getLogger().logError("Unable to create needed classes for country: " + countryAbbreviation);
            throw new DataCreationException(2, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            DataCreationLogger.getLogger().logError("Unable to create needed classes for country: " + countryAbbreviation);
            throw new DataCreationException(2, (Throwable)e);
        }
        return indexer;
    }

    protected boolean propIsYes(String prop) {
        return prop != null && prop.equals("YES");
    }

    protected boolean processStreets(Properties processingProperties) {
        String processStreetsString = (String)processingProperties.get("street_create");
        return this.propIsYes(processStreetsString);
    }

    protected boolean processGeoInfo(Properties processingProperties) {
        String processGeoInfoString = (String)processingProperties.get("geoInfo_create");
        return this.propIsYes(processGeoInfoString);
    }

    protected boolean processGeo2Sac(Properties processingProperties) {
        String processGeo2SacString = (String)processingProperties.get("geo2sac_create");
        return this.propIsYes(processGeo2SacString);
    }

    protected boolean processPostInfo(Properties processingProperties) {
        String processPostInfoString = (String)processingProperties.get("postInfo_create");
        return this.propIsYes(processPostInfoString);
    }

    protected boolean processPost2Sac(Properties processingProperties) {
        String processPost2SacString = (String)processingProperties.get("post2sac_create");
        return this.propIsYes(processPost2SacString);
    }

    protected boolean processAltsFile(Properties processingProperties) {
        String processPost2SacString = (String)processingProperties.get("alts_create");
        return this.propIsYes(processPost2SacString);
    }

    protected void createStreets(IDataProvider provider) throws DataCreationException {
        provider.processStreets(this.m_internalProcess);
    }

    protected void createGeoInfo(IDataProvider provider) throws DataCreationException {
        provider.processGeoInfo(this.m_internalProcess);
    }

    protected void createGeo2Sac(IDataProvider provider) throws DataCreationException {
        provider.processGeo2Sac(this.m_internalProcess);
    }

    protected void createPostInfo(IDataProvider provider) throws DataCreationException {
        provider.processPostInfo(this.m_internalProcess);
    }

    protected void createPost2Sac(IDataProvider provider) throws DataCreationException {
        provider.processPost2Sac(this.m_internalProcess);
    }

    protected void createAltsFile(Properties processingProperties) throws DataCreationException {
        String countryCode = processingProperties.getProperty("COUNTRY");
        String writerClassName = "com.mapinfo.mapmarker." + countryCode + ".dp.binary." + countryCode + "_MMJAltFileCreatorRunner";
        try {
            Class<?> writerClass = Class.forName(writerClassName);
            ((MMJSupportedAltsWriter)writerClass.newInstance()).createFile();
        }
        catch (ClassNotFoundException e) {
            DataCreationLogger.getLogger().logStatus("Creation of alternates file not supported for " + countryCode);
        }
        catch (IllegalAccessException e) {
            DataCreationLogger.getLogger().logStatus("Error instantiating class: " + writerClassName);
            throw new DataCreationException(-1, (Throwable)e);
        }
        catch (InstantiationException e) {
            DataCreationLogger.getLogger().logStatus("Error instantiating class: " + writerClassName);
            throw new DataCreationException(-1, (Throwable)e);
        }
    }

    protected void createDataFiles(Properties processingProperties) throws DataCreationException {
        if (this.processStreets(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating street data file.");
            String streetFileBaseName = processingProperties.getProperty("street_outputFile");
            String streetFilePathAndBaseName = StringUtilities.appendToPath((String)this.m_dataProvider.getStreetFilePath(), (String)streetFileBaseName);
            this.deleteFile(streetFilePathAndBaseName + ".jdr");
            this.deleteFile(streetFilePathAndBaseName + ".tdx");
            this.deleteFile(streetFilePathAndBaseName + ".jdx");
            this.deleteFile(streetFilePathAndBaseName + ".tbx");
            this.deleteFile(streetFilePathAndBaseName + ".bdx");
            this.createStreets(this.m_dataProvider);
            this.createDescriptionFile(processingProperties);
            DataCreationLogger.getLogger().logStatus("Finished creating street data file.");
        }
        if (this.processGeoInfo(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating geoInfo data file.");
            String geoInfoFileBaseName = processingProperties.getProperty("geoInfo_outputFile");
            String geoInfoPathAndBaseName = StringUtilities.appendToPath((String)this.m_dataProvider.getGeoInfoFilePath(), (String)geoInfoFileBaseName);
            this.deleteFile(geoInfoPathAndBaseName + ".jdr");
            this.deleteFile(geoInfoPathAndBaseName + ".tdx");
            this.deleteFile(geoInfoPathAndBaseName + ".jdx");
            this.deleteFile(geoInfoPathAndBaseName + ".tsx");
            this.deleteFile(geoInfoPathAndBaseName + ".sdx");
            this.createGeoInfo(this.m_dataProvider);
            DataCreationLogger.getLogger().logStatus("Finished creating geoInfo data file.");
        }
        if (this.processGeo2Sac(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating geo2sac data file.");
            this.deleteFile(StringUtilities.appendToPath((String)this.m_dataProvider.getGeo2SacFilePath(), (String)"geo2sac.mmj"));
            this.createGeo2Sac(this.m_dataProvider);
            DataCreationLogger.getLogger().logStatus("Finished creating geo2sac data file.");
        }
        if (this.processPostInfo(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating postInfo data file.");
            String postInfoFileBaseName = processingProperties.getProperty("postInfo_outputFile");
            String postInfoFilePathAndBaseName = StringUtilities.appendToPath((String)this.m_dataProvider.getPostInfoFilePath(), (String)postInfoFileBaseName);
            this.deleteFile(postInfoFilePathAndBaseName + ".jdr");
            this.deleteFile(postInfoFilePathAndBaseName + ".tdx");
            this.deleteFile(postInfoFilePathAndBaseName + ".jdx");
            this.createPostInfo(this.m_dataProvider);
            DataCreationLogger.getLogger().logStatus("Finished creating postInfo data file.");
        }
        if (this.processPost2Sac(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating post2sac data file.");
            this.deleteFile(StringUtilities.appendToPath((String)this.m_dataProvider.getPost2SacFilePath(), (String)"post2sac.mmj"));
            this.createPost2Sac(this.m_dataProvider);
            DataCreationLogger.getLogger().logStatus("Finished creating post2sac data file.");
        }
        if (this.processAltsFile(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating alt.mmj file");
            this.createAltsFile(processingProperties);
            DataCreationLogger.getLogger().logStatus("Finished creating alt.mmj file.");
        }
    }

    protected void createDescriptionFile(Properties processingProperties) throws DataCreationException {
        String description = processingProperties.getProperty("outputDatasetDescription");
        if (!StringUtilities.isEmpty((String)description)) {
            File descrFile = new File(StringUtilities.appendToPath((String)this.m_dataProvider.getStreetFilePath(), (String)"dictionarydesc.txt"));
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(descrFile));
                bw.write(description);
            }
            catch (IOException e) {
                throw new DataCreationException(109);
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    throw new DataCreationException(109);
                }
            }
        }
    }

    protected void updateProgress(PhaseProgressBounds bounds, int complete, int total) {
        if (bounds != null) {
            ProgressBarUpdaterProvider.getUpdaterInstance().update(ProgressComputer.compute(bounds, complete, total));
        }
    }

    protected void transformStreetSpecialIndexes(Properties processingProperties) throws DataCreationException {
        byte[] specials;
        String streetBaseName = processingProperties.getProperty("street_outputFile");
        for (byte special : specials = this.m_dataProvider.getSpecialStreetAltTypesSupported()) {
            String intermediateFileName = StringUtilities.appendToPath((String)this.m_dataProvider.getStreetFilePath(), (String)streetBaseName, (String)this.m_dataProvider.getSpecialIntermediateIndexExtension(special));
            String tempFileName = StringUtilities.appendToPath((String)this.m_dataProvider.getStreetFilePath(), (String)streetBaseName, (String)this.m_dataProvider.getSpecialTemporaryIndexExtension(special));
            if (this.fileExists(intermediateFileName)) {
                ReadOnlyNIODataAccess input = null;
                NIOOutputStream output = null;
                boolean bFinished = false;
                try {
                    input = new ReadOnlyNIODataAccess(new File(intermediateFileName), 2048, true);
                    output = new NIOOutputStream(new File(tempFileName));
                    SpecialAltIndexTransformer transformer = new SpecialAltIndexTransformer();
                    transformer.transform((DataInput)input, (DataOutput)output);
                    bFinished = true;
                    continue;
                }
                catch (IOException IOEx) {
                    throw new DataCreationException(IOEx);
                }
                finally {
                    IOException closeException;
                    block19: {
                        closeException = null;
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException IOEx) {
                                closeException = IOEx;
                            }
                        }
                        if (input != null) {
                            try {
                                input.close();
                                if (bFinished) {
                                    this.deleteFile(intermediateFileName);
                                }
                            }
                            catch (IOException IOEx) {
                                if (closeException != null) break block19;
                                closeException = IOEx;
                            }
                        }
                    }
                    if (bFinished && closeException != null) {
                        throw new DataCreationException(closeException);
                    }
                }
            }
            DataCreationLogger.getLogger().logInternalError("No intermediate special street index file: " + intermediateFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createStreetIndexes(Properties processingProperties) throws DataCreationException {
        String alternateFinalExt;
        String alternateTempExt;
        byte altType;
        int i;
        this.transformStreetSpecialIndexes(processingProperties);
        String streetBaseName = processingProperties.getProperty("street_outputFile");
        if (streetBaseName == null || streetBaseName.length() == 0) {
            throw new DataCreationException(200);
        }
        String streetPathAndBaseName = StringUtilities.appendToPath((String)this.m_dataProvider.getStreetFilePath(), (String)streetBaseName);
        IFileInnerIndexConvertor soundexConvertor = this.m_dataProvider.getStreetIndexFileConvertor();
        IFileInnerIndexConvertor browseConvertor = this.m_dataProvider.getStreetBrowseIndexFileConvertor();
        byte[] altSearchTypes = this.m_dataProvider.getAlternateStreetSearchSupportedTypes();
        byte[] altBrowseTypes = this.m_dataProvider.getAlternateStreetBrowseSupportedTypes();
        int currentIndexNumber = 0;
        int totalIndexes = 1;
        if (browseConvertor != null) {
            ++totalIndexes;
        }
        if (altSearchTypes != null) {
            totalIndexes += altSearchTypes.length;
        }
        if (altBrowseTypes != null) {
            totalIndexes += altBrowseTypes.length;
        }
        PhaseProgressBounds bounds = PhaseProgressBoundsProvider.getInstance().getBounds(2);
        this.updateProgress(bounds, currentIndexNumber, totalIndexes);
        try {
            try {
                soundexConvertor.convert(this.m_dataProvider.getStreetFilePath(), streetBaseName + ".tdx", streetBaseName + ".jdx");
            }
            catch (IndexAccessException IAEx) {
                throw new DataCreationException(200);
            }
            catch (IOException IOEx) {
                throw new DataCreationException(200);
            }
            finally {
                try {
                    soundexConvertor.cleanUp();
                }
                catch (IOException IOEx) {
                    throw new DataCreationException(200);
                }
            }
            this.deleteFile(streetPathAndBaseName + ".tdx");
        }
        catch (DataCreationException e) {
            throw new DataCreationException(200, (Throwable)e);
        }
        this.updateProgress(bounds, ++currentIndexNumber, totalIndexes);
        if (browseConvertor != null) {
            DataCreationLogger.getLogger().logStatus("Creating street browse index file.");
            try {
                browseConvertor.convert(this.m_dataProvider.getStreetFilePath(), streetBaseName + ".tbx", streetBaseName + ".bdx");
                ++currentIndexNumber;
            }
            catch (IndexAccessException IAEx) {
                throw new DataCreationException(200);
            }
            catch (IOException IOEx) {
                throw new DataCreationException(200);
            }
            finally {
                try {
                    browseConvertor.cleanUp();
                }
                catch (IOException IOEx) {
                    throw new DataCreationException(200);
                }
            }
            this.deleteFile(streetPathAndBaseName + ".tbx");
            DataCreationLogger.getLogger().logStatus("Finished creating street browse index file.");
        } else {
            this.deleteFile(streetPathAndBaseName + ".tbx");
        }
        this.updateProgress(bounds, currentIndexNumber, totalIndexes);
        if (altSearchTypes != null) {
            DataCreationLogger.getLogger().logStatus("Creating alternate street search index files.");
            for (i = 0; i < altSearchTypes.length; ++i) {
                altType = altSearchTypes[i];
                alternateTempExt = this.m_dataProvider.getAlternateSearchTypeTempIndexExtension(altType);
                alternateFinalExt = this.m_dataProvider.getAlternateSearchTypeFinalIndexExtension(altType);
                if (alternateTempExt != null && alternateFinalExt != null && this.fileExists(streetPathAndBaseName + alternateTempExt) && (soundexConvertor = this.m_dataProvider.getStreetAlternateSearchTypeIndexFileConvertor(altType)) != null) {
                    try {
                        soundexConvertor.convert(this.m_dataProvider.getStreetFilePath(), streetBaseName + alternateTempExt, streetBaseName + alternateFinalExt);
                        ++currentIndexNumber;
                    }
                    catch (IndexAccessException IAEx) {
                        throw new DataCreationException(200);
                    }
                    catch (IOException IOEx) {
                        throw new DataCreationException(200);
                    }
                    finally {
                        try {
                            soundexConvertor.cleanUp();
                            this.deleteFile(streetPathAndBaseName + alternateTempExt);
                        }
                        catch (IOException IOEx) {
                            throw new DataCreationException(200);
                        }
                    }
                }
                this.updateProgress(bounds, currentIndexNumber, totalIndexes);
            }
            DataCreationLogger.getLogger().logStatus("Alternate street search index files created.");
        }
        if (altBrowseTypes != null) {
            DataCreationLogger.getLogger().logStatus("Creating alternate street browse index files.");
            for (i = 0; i < altBrowseTypes.length; ++i) {
                altType = altBrowseTypes[i];
                alternateTempExt = this.m_dataProvider.getAlternateBrowseTypeTempIndexExtension(altType);
                alternateFinalExt = this.m_dataProvider.getAlternateBrowseTypeFinalIndexExtension(altType);
                if (alternateTempExt != null && alternateFinalExt != null && this.fileExists(streetPathAndBaseName + alternateTempExt) && (browseConvertor = this.m_dataProvider.getStreetAlternateBrowseTypeIndexFileConvertor(altType)) != null) {
                    try {
                        browseConvertor.convert(this.m_dataProvider.getStreetFilePath(), streetBaseName + alternateTempExt, streetBaseName + alternateFinalExt);
                        ++currentIndexNumber;
                    }
                    catch (IndexAccessException IAEx) {
                        throw new DataCreationException(200);
                    }
                    catch (IOException IOEx) {
                        throw new DataCreationException(200);
                    }
                    finally {
                        try {
                            browseConvertor.cleanUp();
                            this.deleteFile(streetPathAndBaseName + alternateTempExt);
                        }
                        catch (IOException IOEx) {
                            throw new DataCreationException(200);
                        }
                    }
                }
                this.updateProgress(bounds, currentIndexNumber, totalIndexes);
            }
            DataCreationLogger.getLogger().logStatus("Alternate street browse index files created.");
        }
        this.updateProgress(bounds, totalIndexes, totalIndexes);
        if (this.m_dataProvider.supportsReverseGeocode()) {
            SpatialIndexValueIterator baseIterator = new SpatialIndexValueIterator();
            try {
                baseIterator.open(StringUtilities.appendToPath((String)this.m_dataProvider.getStreetFilePath(), (String)streetBaseName, (String)"tsx"));
            }
            catch (IOException IOEx) {
                throw new DataCreationException(200, (Throwable)IOEx);
            }
            RangeCombiningSpatialIndexValueIterator iterator = new RangeCombiningSpatialIndexValueIterator(this.m_dataProvider.getNumberOfRangesToCombineForSpatialIndexValues(), (Iterator<SpatialIndexValue>)((Object)baseIterator));
            boolean bFinished = false;
            DiskRGIndexBuilder builder = new DiskRGIndexBuilder(new File(StringUtilities.appendToPath((String)this.m_dataProvider.getStreetFilePath(), (String)streetBaseName, (String)"spx")));
            try {
                DataCreationLogger.getLogger().logStatus("Building spatial index file.");
                builder.buildIndex((Iterator)iterator, (IPersistenceDecorator)new SpatialIndexValuePersistenceDecorator(streetBaseName), (IEnvelopeDecorator)new SpatialIndexValueEnvelopeDecorator());
                DataCreationLogger.getLogger().logStatus("Spatial index file completed.");
                bFinished = true;
            }
            finally {
                block69: {
                    try {
                        iterator.close();
                    }
                    catch (IOException IOEx) {
                        if (!bFinished) break block69;
                        throw new DataCreationException(200, (Throwable)IOEx);
                    }
                }
            }
        }
    }

    protected void createGeoInfoIndexes(Properties processingProperties) throws DataCreationException {
        String geoInfoFileBaseName = processingProperties.getProperty("geoInfo_outputFile");
        String geoInfoPathAndBaseName = StringUtilities.appendToPath((String)this.m_dataProvider.getGeoInfoFilePath(), (String)geoInfoFileBaseName);
        IndexFileConvertor geoInfoStandardConvertor = this.m_dataProvider.getExactMatchGeoInfoIndexConvertor(geoInfoPathAndBaseName + ".tdx", geoInfoPathAndBaseName + ".jdx");
        if (geoInfoStandardConvertor != null) {
            try {
                DataCreationLogger.getLogger().logStatus("Creating geoInfo exact index file.");
                geoInfoStandardConvertor.convert();
                DataCreationLogger.getLogger().logStatus("Finished creating geoInfo exact index file.");
            }
            catch (DataCreationException e) {
                throw new DataCreationException(400, (Throwable)e);
            }
        }
        this.deleteFile(geoInfoPathAndBaseName + ".tdx");
        GeoInfoSoundexIndexer indexer = this.m_dataProvider.getGeoInfoSoundexIndexer();
        if (indexer != null) {
            DataCreationLogger.getLogger().logStatus("Creating temporary geoInfo soundex index file.");
            indexer.processGeoInfoFile(geoInfoPathAndBaseName);
            DataCreationLogger.getLogger().logStatus("Finished creating temporary geoInfo soundex index file.");
            IndexFileConvertor geoInfoSoundexConvertor = this.m_dataProvider.getSoundexGeoInfoIndexConvertor(geoInfoPathAndBaseName + ".tsx", geoInfoPathAndBaseName + ".sdx");
            if (geoInfoSoundexConvertor != null) {
                try {
                    DataCreationLogger.getLogger().logStatus("Creating geoInfo soundex index file.");
                    geoInfoSoundexConvertor.convert();
                    this.deleteFile(geoInfoPathAndBaseName + ".tsx");
                    DataCreationLogger.getLogger().logStatus("Finished creating soundex geoInfo index file.");
                }
                catch (DataCreationException e) {
                    throw new DataCreationException(400, (Throwable)e);
                }
            } else {
                this.deleteFile(geoInfoPathAndBaseName + ".tsx");
            }
        }
    }

    protected void createPostInfoIndexes(Properties processingProperties) throws DataCreationException {
        String postInfoFileBaseName = processingProperties.getProperty("postInfo_outputFile");
        String postInfoFilePathAndBaseName = StringUtilities.appendToPath((String)this.m_dataProvider.getPostInfoFilePath(), (String)postInfoFileBaseName);
        if (postInfoFileBaseName == null || postInfoFileBaseName.length() == 0) {
            throw new DataCreationException(600);
        }
        IndexFileConvertor convertor = this.m_dataProvider.getPostInfoIndexFileConvertor(postInfoFilePathAndBaseName + ".tdx", postInfoFilePathAndBaseName + ".jdx");
        if (convertor != null) {
            try {
                convertor.convert();
                this.deleteFile(postInfoFilePathAndBaseName + ".tdx");
            }
            catch (DataCreationException e) {
                throw new DataCreationException(600, (Throwable)e);
            }
        } else {
            this.deleteFile(postInfoFilePathAndBaseName + ".tdx");
        }
    }

    protected void createIndexFiles(Properties processingProperties) throws DataCreationException {
        if (this.processStreets(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating street index files:");
            this.createStreetIndexes(processingProperties);
            DataCreationLogger.getLogger().logStatus("Finished creating street index files.");
        }
        if (this.processGeoInfo(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating geoInfo index files.");
            this.createGeoInfoIndexes(processingProperties);
            DataCreationLogger.getLogger().logStatus("Finished creating geoInfo index files.");
        }
        if (this.processPostInfo(processingProperties)) {
            DataCreationLogger.getLogger().logStatus("Creating postInfo index files.");
            this.createPostInfoIndexes(processingProperties);
            DataCreationLogger.getLogger().logStatus("Finished creating postInfo index files.");
        }
    }

    public static Properties loadPropertiesFile(String propertiesFile) {
        FileInputStream propertiesFileInputStream = null;
        Properties props = new Properties();
        try {
            propertiesFileInputStream = new FileInputStream(propertiesFile);
        }
        catch (FileNotFoundException FNFEx) {
            System.err.println("Unable to find properties file: " + propertiesFile);
            System.err.println(FNFEx.getMessage());
            System.exit(1);
        }
        try {
            props.load(propertiesFileInputStream);
        }
        catch (IOException IOEx) {
            System.err.println("Unable to load properties from properties file: " + propertiesFile);
            System.err.println(IOEx.getMessage());
            System.exit(1);
        }
        try {
            propertiesFileInputStream.close();
        }
        catch (IOException IOEx) {
            System.err.println("IOException occurred on closing properties file. ");
            System.err.println(IOEx.getMessage());
        }
        return props;
    }

    public void runProcess(Properties processingProperties) throws DataCreationException {
        this.setUpLogger(processingProperties);
        this.initializeDataProvider(processingProperties);
        this.createDataFiles(processingProperties);
        this.createIndexFiles(processingProperties);
    }

    protected List getLogFileNames(Properties processingProperties) {
        String containsLogFilesProp = processingProperties.getProperty(CONTAINS_LOG_FILES);
        if (containsLogFilesProp != null && Boolean.valueOf(containsLogFilesProp).booleanValue()) {
            return null;
        }
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add(processingProperties.getProperty(ERROR_LOG_FILE));
        fileNameList.add(processingProperties.getProperty(STATUS_LOG_FILE));
        if (this.m_internalProcess) {
            fileNameList.add(processingProperties.getProperty(INTERNAL_ERROR_LOG_FILE));
        }
        return fileNameList;
    }

    protected boolean logFilesExist(Properties processingProperties) {
        String containsLogFilesProp = processingProperties.getProperty(CONTAINS_LOG_FILES);
        if (containsLogFilesProp != null && Boolean.valueOf(containsLogFilesProp).booleanValue()) {
            return false;
        }
        List logFileNamesList = this.getLogFileNames(processingProperties);
        if (logFileNamesList != null) {
            Iterator logFileNamesIterator = logFileNamesList.iterator();
            while (logFileNamesIterator.hasNext()) {
                File logFile = new File((String)logFileNamesIterator.next());
                if (!logFile.exists()) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: DataCreator <processing properties>");
            System.exit(1);
        }
        Properties processingProperties = DataCreator.loadPropertiesFile(args[0]);
        DataCreator creator = new DataCreator(true);
        try {
            creator.runProcess(processingProperties);
        }
        catch (DataCreationException DCEx) {
            System.err.println("Unable to create data.");
            DataCreationLogger.getLogger().logError("Unable to create data.");
            System.err.println("ERROR: " + DCEx.getMessage());
            DataCreationLogger.getLogger().logInternalError("ERROR: " + DCEx.getMessage());
            DCEx.printStackTrace(System.err);
            DataCreationLogger.getLogger().logStackTrace(DCEx);
            System.exit(-1);
        }
        catch (Throwable t) {
            System.err.println("Unable to create data.");
            DataCreationLogger.getLogger().logError("Unable to create data.");
            System.err.println("ERROR: " + t.getMessage());
            DataCreationLogger.getLogger().logInternalError("ERROR: " + t.getMessage());
            t.printStackTrace(System.err);
            DataCreationLogger.getLogger().logStackTrace(t);
            System.exit(-2);
        }
    }
}

