/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import java.util.Comparator;

public class MMJRangeRecordComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        MMJRangeRecord range1 = (MMJRangeRecord)o1;
        MMJRangeRecord range2 = (MMJRangeRecord)o2;
        int compare = this.compareRanges(range1, range2);
        if (compare == 0) {
            return this.compareIntermediateDataRecords(range1, range2);
        }
        return compare;
    }

    protected int compareRanges(MMJRangeRecord range1, MMJRangeRecord range2) {
        if (range1.isAscending() && range2.isAscending()) {
            return this.compareAscendingRanges(range1, range2);
        }
        if (!range1.isAscending() && !range2.isAscending()) {
            return this.compareDescendingRanges(range1, range2);
        }
        if (range1.isAscending()) {
            return this.compareRanges(range1, range2, true);
        }
        return this.compareRanges(range1, range2, false);
    }

    protected int compareAscendingRanges(MMJRangeRecord range1, MMJRangeRecord range2) {
        if (range1.getFromHouse().equals((Object)range2.getFromHouse())) {
            return range1.getToHouse().compareTo((Object)range2.getToHouse());
        }
        return range1.getFromHouse().compareTo((Object)range2.getFromHouse());
    }

    protected int compareDescendingRanges(MMJRangeRecord range1, MMJRangeRecord range2) {
        if (range1.getToHouse().equals((Object)range2.getToHouse())) {
            return range1.getFromHouse().compareTo((Object)range2.getFromHouse());
        }
        return range1.getToHouse().compareTo((Object)range2.getToHouse());
    }

    protected int compareRanges(MMJRangeRecord range1, MMJRangeRecord range2, boolean range1IsAscending) {
        if (range1IsAscending) {
            if (range1.getFromHouse().equals((Object)range2.getToHouse())) {
                return range1.getToHouse().compareTo((Object)range2.getFromHouse());
            }
            return range1.getFromHouse().compareTo((Object)range2.getToHouse());
        }
        if (range1.getToHouse().equals((Object)range2.getFromHouse())) {
            return range1.getFromHouse().compareTo((Object)range2.getToHouse());
        }
        return range1.getToHouse().compareTo((Object)range2.getFromHouse());
    }

    protected int compareIntermediateDataRecords(MMJRangeRecord range1, MMJRangeRecord range2) {
        IIntermediateDataRecord[] records2;
        IIntermediateDataRecord[] records1 = range1.getIntermediateDataRecordArray();
        if (records1 == (records2 = range2.getIntermediateDataRecordArray())) {
            return 0;
        }
        if (records1 == null) {
            if (records2.length == 0) {
                return 0;
            }
            return -1;
        }
        if (records2 == null) {
            if (records1.length == 0) {
                return 0;
            }
            return 1;
        }
        int recordCount = Math.max(records1.length, records2.length);
        for (int i = 0; i < recordCount; ++i) {
            IIntermediateDataRecord record2;
            IIntermediateDataRecord record1 = i < records1.length ? records1[i] : null;
            IIntermediateDataRecord iIntermediateDataRecord = record2 = i < records2.length ? records2[i] : null;
            if (record1 == record2) continue;
            if (record1 == null) {
                return -1;
            }
            if (record2 == null) {
                return 1;
            }
            int compare = record1.compareTo((Object)record2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

