/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacFileData;
import com.mapinfo.mapmarker.utils.IntObjMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MMJSac2FnCombiner {
    public static RandomAccessFile combinedFile;
    public static RandomAccessFile inputFile;
    private static final String combinedFileName = "sac2fn.mmj";

    public static void createOutputFile() throws IOException {
        File fileRef = new File(combinedFileName);
        if (fileRef.exists() && !fileRef.delete()) {
            System.err.println("FATAL ERROR: Unable to remove old sac2fn file.");
            System.exit(1);
        }
        combinedFile = new RandomAccessFile(combinedFileName, "rw");
    }

    public static void openInputFile(String inputFileName) throws IOException {
        inputFile = new RandomAccessFile(inputFileName, "r");
    }

    public static void usage() {
        System.out.println("MMJSac2FnCombiner <list of sac2fn files>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] args) {
        int numSac2FnFiles = args.length;
        if (numSac2FnFiles == 0) {
            MMJSac2FnCombiner.usage();
            System.exit(1);
        }
        try {
            MMJSac2FnCombiner.createOutputFile();
        }
        catch (IOException IOEx) {
            System.err.println("FATAL ERROR: Unable to create sac2fn.mmj.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        IntObjMap sac2fnMap = new IntObjMap();
        int i = 0;
        while (true) {
            if (i < numSac2FnFiles) {
                try {
                    MMJSac2FnCombiner.openInputFile(args[i]);
                }
                catch (IOException IOEx) {
                    System.err.println("FATAL ERROR: Unable to open input file -- " + args[i]);
                    System.err.println(IOEx.getMessage());
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                }
            } else {
                try {
                    combinedFile.close();
                }
                catch (IOException IOEx) {
                    System.err.println("FATAL ERROR: Unable to close sac2fn.mmj");
                    System.err.println(IOEx.getMessage());
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                }
                System.out.println("Finished creating sac2fn.mmj.");
                return;
            }
            while (true) {
                try {
                    while (true) {
                        MMJSac2FnRecord record;
                        SacFileData previousData;
                        if ((previousData = (SacFileData)sac2fnMap.get((record = MMJSac2FnRecord.read((DataInput)inputFile)).getSac())) != null) {
                            String errorMessage = "SAC: " + record.getSac() + " being added for file: " + record.getData().getStreetFileName() + " was already present for " + previousData.getStreetFileName();
                            System.err.println("ERROR: " + errorMessage);
                        }
                        sac2fnMap.put(record.getSac(), (Object)record.getData());
                        record.write((DataOutput)combinedFile);
                    }
                }
                catch (EOFException EOFEx) {
                    try {
                        System.out.println("Finished reading from: " + args[i]);
                        inputFile.close();
                    }
                    catch (IOException IOEx) {
                        System.err.println("ERROR: Unable to close input file: " + args[i]);
                        System.err.println(IOEx.getMessage());
                        IOEx.printStackTrace(System.err);
                        continue;
                    }
                }
                catch (IOException IOEx) {
                    System.err.println("FATAL ERROR: Error reading or writing sac2fn record from: " + args[i]);
                    System.err.println(IOEx.getMessage());
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                    continue;
                }
                break;
            }
            ++i;
        }
    }
}

