/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.binary.AbstractMMJAlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MMJSegmentRecord
extends AbstractMMJAlternateDataRecord {
    public static final int NO_INTERSECTION = 0;
    public static final int COLINEAR = 1;
    public static final int REVERSE_COLINEAR = 2;
    public static final int CONVERGENT = 3;
    public static final int DIVERGENT = 4;
    public static final int EQUIVALENT = 5;
    private String m_leftPostCode1 = null;
    private String m_rightPostCode1 = null;
    private String m_leftPostCode2 = null;
    private String m_rightPostCode2 = null;
    private String m_leftAreaName1 = null;
    private String m_rightAreaName1 = null;
    private String m_leftAreaName2;
    private String m_rightAreaName2 = null;
    private String m_leftAreaName3 = null;
    private String m_rightAreaName3 = null;
    private String m_leftAreaName4 = null;
    private String m_rightAreaName4 = null;
    private String m_id;
    private ArrayList<DirectPosition> m_points = null;
    private ArrayList m_ranges = null;
    private boolean m_areRangesSorted = true;
    private boolean m_bIsPointHouseSegment = false;

    public MMJSegmentRecord() {
    }

    public MMJSegmentRecord(MMJSegmentRecord that) {
        this();
        this.copy(that);
    }

    public void setLeftPostalCode1(String leftPostalCode1) {
        this.m_leftPostCode1 = leftPostalCode1;
    }

    public String getLeftPostalCode1() {
        return this.m_leftPostCode1;
    }

    public void setRightPostalCode1(String rightPostalCode1) {
        this.m_rightPostCode1 = rightPostalCode1;
    }

    public String getRightPostalCode1() {
        return this.m_rightPostCode1;
    }

    public void setLeftPostalCode2(String leftPostCode2) {
        this.m_leftPostCode2 = leftPostCode2;
    }

    public String getLeftPostalCode2() {
        return this.m_leftPostCode2;
    }

    public void setRightPostalCode2(String rightPostCode2) {
        this.m_rightPostCode2 = rightPostCode2;
    }

    public String getRightPostalCode2() {
        return this.m_rightPostCode2;
    }

    public void setLeftAreaName1(String leftAreaName1) {
        this.m_leftAreaName1 = leftAreaName1;
    }

    public String getLeftAreaName1() {
        return this.m_leftAreaName1;
    }

    public void setRightAreaName1(String rightAreaName1) {
        this.m_rightAreaName1 = rightAreaName1;
    }

    public String getRightAreaName1() {
        return this.m_rightAreaName1;
    }

    public void setLeftAreaName2(String leftAreaName2) {
        this.m_leftAreaName2 = leftAreaName2;
    }

    public String getLeftAreaName2() {
        return this.m_leftAreaName2;
    }

    public void setRightAreaName2(String rightAreaName2) {
        this.m_rightAreaName2 = rightAreaName2;
    }

    public String getRightAreaName2() {
        return this.m_rightAreaName2;
    }

    public void setLeftAreaName3(String leftAreaName3) {
        this.m_leftAreaName3 = leftAreaName3;
    }

    public String getLeftAreaName3() {
        return this.m_leftAreaName3;
    }

    public void setRightAreaName3(String rightAreaName3) {
        this.m_rightAreaName3 = rightAreaName3;
    }

    public String getRightAreaName3() {
        return this.m_rightAreaName3;
    }

    public void setLeftAreaName4(String leftAreaName4) {
        this.m_leftAreaName4 = leftAreaName4;
    }

    public String getLeftAreaName4() {
        return this.m_leftAreaName4;
    }

    public void setRightAreaName4(String rightAreaName4) {
        this.m_rightAreaName4 = rightAreaName4;
    }

    public String getRightAreaName4() {
        return this.m_rightAreaName4;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void addPoint(DirectPosition point) {
        if (this.m_points == null) {
            this.m_points = new ArrayList();
        }
        this.m_points.add(point);
    }

    public List getPoints() {
        return this.m_points;
    }

    public void addRange(MMJRangeRecord range) {
        if (this.m_ranges == null) {
            this.m_ranges = new ArrayList();
            this.m_areRangesSorted = false;
        }
        this.m_ranges.add(range);
    }

    public List getRanges() {
        return this.m_ranges;
    }

    public ParsedNumber getLowestHouse() {
        ParsedNumber lowestHouse = null;
        ParsedNumber lowHouse = null;
        for (MMJRangeRecord range : this.m_ranges) {
            lowHouse = range.isAscending() ? new ParsedNumber(range.getFromHouse()) : new ParsedNumber(range.getToHouse());
            if (lowestHouse == null) {
                lowestHouse = lowHouse;
                continue;
            }
            if (lowestHouse.compareTo((Object)lowHouse) >= 0) continue;
            lowestHouse = lowHouse;
        }
        return lowestHouse;
    }

    public boolean rangesSorted() {
        return this.m_areRangesSorted;
    }

    public void setRangesSorted() {
        this.m_areRangesSorted = true;
    }

    protected void copy(MMJSegmentRecord that) {
        if (that != null) {
            int i;
            this.setLeftAreaName1(that.getLeftAreaName1());
            this.setLeftAreaName2(that.getLeftAreaName2());
            this.setLeftAreaName3(that.getLeftAreaName3());
            this.setLeftAreaName4(that.getLeftAreaName4());
            this.setLeftPostalCode1(that.getLeftPostalCode1());
            this.setLeftPostalCode2(that.getLeftPostalCode2());
            this.setRightAreaName1(that.getRightAreaName1());
            this.setRightAreaName2(that.getRightAreaName2());
            this.setRightAreaName3(that.getRightAreaName3());
            this.setRightAreaName4(that.getRightAreaName4());
            this.setRightPostalCode1(that.getRightPostalCode1());
            this.setRightPostalCode2(that.getRightPostalCode2());
            this.setId(that.getId());
            if (that.m_ranges != null) {
                for (i = 0; i < that.m_ranges.size(); ++i) {
                    MMJRangeRecord range = (MMJRangeRecord)that.m_ranges.get(i);
                    this.addRange(range);
                }
            }
            if (that.m_areRangesSorted) {
                this.setRangesSorted();
            }
            if (that.m_points != null) {
                for (i = 0; i < that.m_points.size(); ++i) {
                    DirectPosition point = that.m_points.get(i);
                    this.addPoint(point);
                }
            }
            this.m_bIsPointHouseSegment = that.m_bIsPointHouseSegment;
            super.copy(that);
        }
    }

    public int getIntersectionCase(MMJSegmentRecord thatSegment) {
        Object[] thisSegmentPoints = this.getPoints().toArray();
        Object[] thatSegmentPoints = thatSegment.getPoints().toArray();
        DirectPosition thisStart = (DirectPosition)thisSegmentPoints[0];
        DirectPosition thisEnd = (DirectPosition)thisSegmentPoints[thisSegmentPoints.length - 1];
        DirectPosition thatStart = (DirectPosition)thatSegmentPoints[0];
        DirectPosition thatEnd = (DirectPosition)thatSegmentPoints[thatSegmentPoints.length - 1];
        if (thisSegmentPoints.length == thatSegmentPoints.length) {
            boolean equivalent = true;
            for (int i = 0; i < thisSegmentPoints.length; ++i) {
                if (((DirectPosition)thisSegmentPoints[i]).equals((Object)((DirectPosition)thatSegmentPoints[i]))) continue;
                equivalent = false;
                break;
            }
            if (equivalent) {
                return 5;
            }
        }
        if (thisStart.equals((Object)thatStart)) {
            return 4;
        }
        if (thisStart.equals((Object)thatEnd)) {
            return 2;
        }
        if (thisEnd.equals((Object)thatStart)) {
            return 1;
        }
        if (thisEnd.equals((Object)thatEnd)) {
            return 3;
        }
        return 0;
    }

    public void reverse() {
        String temp = this.m_leftAreaName1;
        this.m_leftAreaName1 = this.m_rightAreaName1;
        this.m_rightAreaName1 = temp;
        temp = this.m_leftAreaName2;
        this.m_leftAreaName2 = this.m_rightAreaName2;
        this.m_rightAreaName2 = temp;
        temp = this.m_leftAreaName3;
        this.m_leftAreaName3 = this.m_rightAreaName3;
        this.m_rightAreaName3 = temp;
        temp = this.m_leftAreaName4;
        this.m_leftAreaName4 = this.m_rightAreaName4;
        this.m_rightAreaName4 = temp;
        temp = this.m_leftPostCode1;
        this.m_leftPostCode1 = this.m_rightPostCode1;
        this.m_rightPostCode1 = temp;
        temp = this.m_leftPostCode2;
        this.m_leftPostCode2 = this.m_rightPostCode2;
        this.m_rightPostCode2 = temp;
        if (this.m_points != null) {
            Collections.reverse(this.m_points);
        }
    }

    public String toString() {
        return "MMJSegmentRecord: \n\tLeftPostCode1: " + this.m_leftPostCode1 + "\n\tLeftPostCode2: " + this.m_leftPostCode2 + "\n\tLeftAreaName1: " + this.m_leftAreaName1 + "\n\tLeftAreaName2: " + this.m_leftAreaName2 + "\n\tLeftAreaName3: " + this.m_leftAreaName3 + "\n\tLeftAreaName4: " + this.m_leftAreaName4 + "\n\tRightPostCode1: " + this.m_rightPostCode1 + "\n\tRightPostCode2: " + this.m_rightPostCode2 + "\n\tRightAreaName1: " + this.m_rightAreaName1 + "\n\tRightAreaName2: " + this.m_rightAreaName2 + "\n\tRightAreaName3: " + this.m_rightAreaName3 + "\n\tRightAreaName4: " + this.m_rightAreaName4 + "\n\tSegmentId: " + this.m_id;
    }

    public void setIsPointHouseSegment() {
        this.m_bIsPointHouseSegment = true;
        this.m_points = null;
    }

    public boolean isPointHouseSegment() {
        return this.m_bIsPointHouseSegment;
    }

    public List getPointHouseGeometry() {
        if (this.m_ranges != null && !this.m_ranges.isEmpty() && (this.m_areRangesSorted || this.m_ranges.size() == 1)) {
            Iterator rangesIterator = this.m_ranges.iterator();
            LinkedList<DirectPosition> geometry = new LinkedList<DirectPosition>();
            while (rangesIterator.hasNext()) {
                geometry.add(((MMJRangeRecord)rangesIterator.next()).getPoint());
            }
            return geometry;
        }
        if (this.m_ranges == null) {
            DataCreationLogger.getLogger().logInternalError("\tranges are null.");
        } else if (!this.m_areRangesSorted) {
            DataCreationLogger.getLogger().logInternalError("\tranges not sorted.");
        }
        return null;
    }

    public List<SpatialIndexValue> getSpatialIndexValues() {
        List<SpatialIndexValue> spatialValues;
        List points = this.getPoints();
        if (this.isPointHouseSegment()) {
            List ranges = this.getRanges();
            if (ranges == null || ranges.isEmpty()) {
                throw new IllegalStateException("PointHouseSegment must have ranges.");
            }
            if (!this.rangesSorted() && ranges.size() > 1) {
                throw new IllegalStateException("Ranges must be sorted to get the spatial values.");
            }
            spatialValues = new ArrayList<SpatialIndexValue>(ranges.size());
            for (short i = 0; i < ranges.size(); i = (short)((short)(i + 1))) {
                List<SpatialIndexValue> rangeValues = ((MMJRangeRecord)ranges.get(i)).getSpatialIndexValues();
                if (rangeValues.isEmpty()) {
                    throw new IllegalStateException("PointHouseSegment ranges must have spatial index values.");
                }
                for (SpatialIndexValue value : rangeValues) {
                    value.setRangeNumber(i);
                    spatialValues.add(value);
                }
            }
        } else if (points != null && !points.isEmpty()) {
            SpatialIndexValue spatialValue = new SpatialIndexValue();
            for (int i = 0; i < points.size(); ++i) {
                spatialValue.addPoint((DirectPosition)points.get(i));
            }
            spatialValues = Collections.singletonList(spatialValue);
        } else {
            spatialValues = Collections.emptyList();
        }
        return spatialValues;
    }
}

