/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StreetDataGroup {
    private int m_sac;
    private MapMarkerIndexKey m_key;
    private LinkedList m_streets;
    private Iterator m_iterator;
    private LinkedList m_streetBrowseKeys;
    private Iterator m_streetBrowseIterator;
    private LinkedList m_alternateDataItems;
    private Iterator m_alternateDataIterator;
    private List<List<SpatialIndexValue>> m_spatialIndexValues;
    private Iterator<List<SpatialIndexValue>> m_spatialIndexValuesIterator;
    private static List<SpatialIndexValue> EMPTY_SPATIALS = Collections.emptyList();

    public StreetDataGroup(int sac, MapMarkerIndexKey key) {
        this.m_sac = sac;
        this.m_key = key;
        this.m_streets = new LinkedList();
        this.m_iterator = null;
        this.m_streetBrowseKeys = new LinkedList();
        this.m_streetBrowseIterator = null;
        this.m_alternateDataItems = new LinkedList();
        this.m_alternateDataIterator = null;
        this.m_spatialIndexValues = new ArrayList<List<SpatialIndexValue>>();
    }

    public void addStreet(IDataFileDataItem street, List browseKeys) {
        this.addStreet(street, browseKeys, new LinkedList(), EMPTY_SPATIALS);
    }

    public void addStreet(IDataFileDataItem street, List browseKeys, List alternateDataItems) {
        this.addStreet(street, browseKeys, alternateDataItems, EMPTY_SPATIALS);
    }

    public void addStreet(IDataFileDataItem street, List browseKeys, List alternateDataItems, List<SpatialIndexValue> spatialIndexValues) {
        this.m_streets.add(street);
        this.m_streetBrowseKeys.add(browseKeys);
        this.m_alternateDataItems.add(alternateDataItems);
        this.m_spatialIndexValues.add(spatialIndexValues);
    }

    public IDataFileDataItem getNextStreet() {
        if (this.m_iterator == null) {
            this.m_iterator = this.m_streets.iterator();
        }
        if (this.m_iterator.hasNext()) {
            return (IDataFileDataItem)this.m_iterator.next();
        }
        return null;
    }

    public List getNextStreetBrowseKeys() {
        if (this.m_streetBrowseIterator == null) {
            this.m_streetBrowseIterator = this.m_streetBrowseKeys.iterator();
        }
        if (this.m_streetBrowseIterator.hasNext()) {
            return (List)this.m_streetBrowseIterator.next();
        }
        return null;
    }

    public List getNextAlternateDataItems() {
        if (this.m_alternateDataIterator == null) {
            this.m_alternateDataIterator = this.m_alternateDataItems.iterator();
        }
        if (this.m_alternateDataIterator.hasNext()) {
            return (List)this.m_alternateDataIterator.next();
        }
        return null;
    }

    public List<SpatialIndexValue> getNextSpatialIndexValues() {
        if (this.m_spatialIndexValuesIterator == null) {
            this.m_spatialIndexValuesIterator = this.m_spatialIndexValues.iterator();
        }
        if (this.m_spatialIndexValuesIterator.hasNext()) {
            return this.m_spatialIndexValuesIterator.next();
        }
        return null;
    }

    public MapMarkerIndexKey getKey() {
        return this.m_key;
    }

    public int getSac() {
        return this.m_sac;
    }

    public long getNumberOfStreet() {
        if (this.m_streets == null || this.m_streets.isEmpty()) {
            return 0L;
        }
        return this.m_streets.size();
    }
}

